/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.instance.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminSettings;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.CreateInstanceRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceRequest;
import com.google.spanner.admin.instance.v1.GetInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.GetInstanceRequest;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.ProjectName;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceRequest;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InstanceAdminClient
implements BackgroundResource {
    private final InstanceAdminSettings settings;
    private final InstanceAdminStub stub;
    private final OperationsClient operationsClient;

    public static final InstanceAdminClient create() throws IOException {
        return InstanceAdminClient.create(InstanceAdminSettings.newBuilder().build());
    }

    public static final InstanceAdminClient create(InstanceAdminSettings settings) throws IOException {
        return new InstanceAdminClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InstanceAdminClient create(InstanceAdminStub stub) {
        return new InstanceAdminClient(stub);
    }

    protected InstanceAdminClient(InstanceAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InstanceAdminClient(InstanceAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final InstanceAdminSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceAdminStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListInstanceConfigsPagedResponse listInstanceConfigs(ProjectName parent) {
        ListInstanceConfigsRequest request = ListInstanceConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstanceConfigs(request);
    }

    public final ListInstanceConfigsPagedResponse listInstanceConfigs(String parent) {
        ListInstanceConfigsRequest request = ListInstanceConfigsRequest.newBuilder().setParent(parent).build();
        return this.listInstanceConfigs(request);
    }

    public final ListInstanceConfigsPagedResponse listInstanceConfigs(ListInstanceConfigsRequest request) {
        return (ListInstanceConfigsPagedResponse)((Object)this.listInstanceConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstanceConfigsRequest, ListInstanceConfigsPagedResponse> listInstanceConfigsPagedCallable() {
        return this.stub.listInstanceConfigsPagedCallable();
    }

    public final UnaryCallable<ListInstanceConfigsRequest, ListInstanceConfigsResponse> listInstanceConfigsCallable() {
        return this.stub.listInstanceConfigsCallable();
    }

    public final InstanceConfig getInstanceConfig(InstanceConfigName name) {
        GetInstanceConfigRequest request = GetInstanceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstanceConfig(request);
    }

    public final InstanceConfig getInstanceConfig(String name) {
        GetInstanceConfigRequest request = GetInstanceConfigRequest.newBuilder().setName(name).build();
        return this.getInstanceConfig(request);
    }

    public final InstanceConfig getInstanceConfig(GetInstanceConfigRequest request) {
        return (InstanceConfig)this.getInstanceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceConfigRequest, InstanceConfig> getInstanceConfigCallable() {
        return this.stub.getInstanceConfigCallable();
    }

    public final ListInstancesPagedResponse listInstances(ProjectName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(ProjectName parent, String instanceId, Instance instance) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstanceId(instanceId).setInstance(instance).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(String parent, String instanceId, Instance instance) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstanceId(instanceId).setInstance(instance).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Instance, UpdateInstanceMetadata> updateInstanceAsync(Instance instance, FieldMask fieldMask) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setFieldMask(fieldMask).build();
        return this.updateInstanceAsync(request);
    }

    public final OperationFuture<Instance, UpdateInstanceMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceRequest, Instance, UpdateInstanceMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final void deleteInstance(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteInstance(request);
    }

    public final void deleteInstance(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        this.deleteInstance(request);
    }

    public final void deleteInstance(DeleteInstanceRequest request) {
        this.deleteInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstanceRequest, Empty> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstancesPage, ListInstancesPagedResponse>(){

                public ListInstancesPagedResponse apply(ListInstancesPage input) {
                    return new ListInstancesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstanceConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig, ListInstanceConfigsPage, ListInstanceConfigsFixedSizeCollection> {
        private ListInstanceConfigsFixedSizeCollection(List<ListInstanceConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstanceConfigsFixedSizeCollection createEmptyCollection() {
            return new ListInstanceConfigsFixedSizeCollection(null, 0);
        }

        protected ListInstanceConfigsFixedSizeCollection createCollection(List<ListInstanceConfigsPage> pages, int collectionSize) {
            return new ListInstanceConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstanceConfigsPage
    extends AbstractPage<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig, ListInstanceConfigsPage> {
        private ListInstanceConfigsPage(PageContext<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig> context, ListInstanceConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListInstanceConfigsPage createEmptyPage() {
            return new ListInstanceConfigsPage(null, null);
        }

        protected ListInstanceConfigsPage createPage(PageContext<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig> context, ListInstanceConfigsResponse response) {
            return new ListInstanceConfigsPage(context, response);
        }

        public ApiFuture<ListInstanceConfigsPage> createPageAsync(PageContext<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig> context, ApiFuture<ListInstanceConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstanceConfigsPagedResponse
    extends AbstractPagedListResponse<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig, ListInstanceConfigsPage, ListInstanceConfigsFixedSizeCollection> {
        public static ApiFuture<ListInstanceConfigsPagedResponse> createAsync(PageContext<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig> context, ApiFuture<ListInstanceConfigsResponse> futureResponse) {
            ApiFuture<ListInstanceConfigsPage> futurePage = ListInstanceConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstanceConfigsPage, ListInstanceConfigsPagedResponse>(){

                public ListInstanceConfigsPagedResponse apply(ListInstanceConfigsPage input) {
                    return new ListInstanceConfigsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstanceConfigsPagedResponse(ListInstanceConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstanceConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

