/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class CredentialsService {
    static final String GCS_NOT_SUPPORTED_MSG = "Credentials that is stored on Google Cloud Storage is no longer supported. Download the credentials to a local file and reference the local file in the connection URL.";
    static final CredentialsService INSTANCE = new CredentialsService();

    CredentialsService() {
    }

    GoogleCredentials createCredentials(String credentialsUrl) {
        try {
            if (credentialsUrl == null) {
                return this.internalGetApplicationDefault();
            }
            return this.getCredentialsFromUrl(credentialsUrl);
        }
        catch (IOException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid credentials path specified", e);
        }
    }

    @VisibleForTesting
    GoogleCredentials internalGetApplicationDefault() throws IOException {
        return GoogleCredentials.getApplicationDefault();
    }

    private GoogleCredentials getCredentialsFromUrl(String credentialsUrl) throws IOException {
        Preconditions.checkNotNull((Object)credentialsUrl);
        Preconditions.checkArgument((credentialsUrl.length() > 0 ? 1 : 0) != 0, (Object)"credentialsUrl may not be an empty string");
        if (credentialsUrl.startsWith("gs://")) {
            throw new IOException(GCS_NOT_SUPPORTED_MSG);
        }
        return this.getCredentialsFromLocalFile(credentialsUrl);
    }

    private GoogleCredentials getCredentialsFromLocalFile(String filePath) throws IOException {
        File credentialsFile = new File(filePath);
        if (!credentialsFile.isFile()) {
            throw new IOException(String.format("Error reading credential file %s: File does not exist", filePath));
        }
        try (FileInputStream credentialsStream = new FileInputStream(credentialsFile);){
            GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
            return googleCredentials;
        }
    }
}

