/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.spanner.admin.database.v1.DatabaseAdminGrpc;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.v1.SpannerGrpc;
import io.grpc.MethodDescriptor;
import java.util.Collection;
import java.util.concurrent.Callable;

class SingleUseTransaction
extends AbstractBaseUnitOfWork {
    private final boolean readOnly;
    private final DdlClient ddlClient;
    private final DatabaseClient dbClient;
    private final TimestampBound readOnlyStaleness;
    private final AutocommitDmlMode autocommitDmlMode;
    private volatile SettableApiFuture<Timestamp> readTimestamp = null;
    private volatile TransactionManager txManager;
    private volatile TransactionRunner writeTransaction;
    private boolean used = false;
    private volatile UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;
    private final StatementParser.ParsedStatement executeBatchUpdateStatement = StatementParser.INSTANCE.parse(Statement.of("RUN BATCH"));
    private final StatementParser.ParsedStatement commitStatement = StatementParser.INSTANCE.parse(Statement.of("COMMIT"));

    static Builder newBuilder() {
        return new Builder();
    }

    private SingleUseTransaction(Builder builder) {
        super(builder);
        this.ddlClient = builder.ddlClient;
        this.dbClient = builder.dbClient;
        this.readOnly = builder.readOnly;
        this.readOnlyStaleness = builder.readOnlyStaleness;
        this.autocommitDmlMode = builder.autocommitDmlMode;
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.TRANSACTION;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void checkAndMarkUsed() {
        Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"This single-use transaction has already been used");
        this.used = true;
    }

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(final StatementParser.ParsedStatement statement, final AnalyzeMode analyzeMode, final Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkArgument((boolean)statement.isQuery(), (Object)"Statement is not a query");
        this.checkAndMarkUsed();
        final ReadOnlyTransaction currentTransaction = this.dbClient.singleUseReadOnlyTransaction(this.readOnlyStaleness);
        Callable<ResultSet> callable = new Callable<ResultSet>(){

            @Override
            public ResultSet call() throws Exception {
                try {
                    ResultSet rs = analyzeMode == AnalyzeMode.NONE ? currentTransaction.executeQuery(statement.getStatement(), options) : currentTransaction.analyzeQuery(statement.getStatement(), analyzeMode.getQueryAnalyzeMode());
                    DirectExecuteResultSet directRs = DirectExecuteResultSet.ofResultSet(rs);
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    SingleUseTransaction.this.readTimestamp.set((Object)currentTransaction.getReadTimestamp());
                    return directRs;
                }
                catch (Throwable t) {
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    SingleUseTransaction.this.readTimestamp.set(null);
                    currentTransaction.close();
                    throw t;
                }
            }
        };
        this.readTimestamp = SettableApiFuture.create();
        ApiFuture<ResultSet> res = this.executeStatementAsync(statement, callable, SpannerGrpc.getExecuteStreamingSqlMethod());
        return res;
    }

    @Override
    public Timestamp getReadTimestamp() {
        ConnectionPreconditions.checkState(SpannerApiFutures.getOrNull(this.readTimestamp) != null, "There is no read timestamp available for this transaction.");
        return SpannerApiFutures.get(this.readTimestamp);
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return SpannerApiFutures.getOrNull(this.readTimestamp);
    }

    private boolean hasCommitTimestamp() {
        return this.state == UnitOfWork.UnitOfWorkState.COMMITTED && (this.writeTransaction != null || this.txManager != null && this.txManager.getState() == TransactionManager.TransactionState.COMMITTED);
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(this.hasCommitTimestamp(), "There is no commit timestamp available for this transaction.");
        return this.writeTransaction != null ? this.writeTransaction.getCommitTimestamp() : this.txManager.getCommitTimestamp();
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        if (this.hasCommitTimestamp()) {
            try {
                return this.writeTransaction != null ? this.writeTransaction.getCommitTimestamp() : this.txManager.getCommitTimestamp();
            }
            catch (SpannerException spannerException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ApiFuture<Void> executeDdlAsync(final StatementParser.ParsedStatement ddl) {
        Preconditions.checkNotNull((Object)ddl);
        Preconditions.checkArgument((ddl.getType() == StatementParser.StatementType.DDL ? 1 : 0) != 0, (Object)"Statement is not a ddl statement");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "DDL statements are not allowed in read-only mode");
        this.checkAndMarkUsed();
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    OperationFuture<Void, UpdateDatabaseDdlMetadata> operation = SingleUseTransaction.this.ddlClient.executeDdl(ddl.getSqlWithoutComments());
                    Void res = SingleUseTransaction.this.getWithStatementTimeout(operation, ddl);
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    return res;
                }
                catch (Throwable t) {
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    throw t;
                }
            }
        };
        return this.executeStatementAsync(ddl, callable, DatabaseAdminGrpc.getUpdateDatabaseDdlMethod());
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(StatementParser.ParsedStatement update) {
        ApiFuture<Long> res;
        Preconditions.checkNotNull((Object)update);
        Preconditions.checkArgument((boolean)update.isUpdate(), (Object)"Statement is not an update statement");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Update statements are not allowed in read-only mode");
        this.checkAndMarkUsed();
        switch (this.autocommitDmlMode) {
            case TRANSACTIONAL: {
                res = this.executeTransactionalUpdateAsync(update);
                break;
            }
            case PARTITIONED_NON_ATOMIC: {
                res = this.executePartitionedUpdateAsync(update);
                break;
            }
            default: {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Unknown dml mode: " + (Object)((Object)this.autocommitDmlMode));
            }
        }
        return res;
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<StatementParser.ParsedStatement> updates) {
        Preconditions.checkNotNull(updates);
        for (StatementParser.ParsedStatement update : updates) {
            Preconditions.checkArgument((boolean)update.isUpdate(), (Object)("Statement is not an update statement: " + update.getSqlWithoutComments()));
        }
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Batch update statements are not allowed in read-only mode");
        this.checkAndMarkUsed();
        switch (this.autocommitDmlMode) {
            case TRANSACTIONAL: {
                return this.executeTransactionalBatchUpdateAsync(updates);
            }
            case PARTITIONED_NON_ATOMIC: {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Batch updates are not allowed in " + (Object)((Object)this.autocommitDmlMode));
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Unknown dml mode: " + (Object)((Object)this.autocommitDmlMode));
    }

    private ApiFuture<Long> executeTransactionalUpdateAsync(final StatementParser.ParsedStatement update) {
        Callable<Long> callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                try {
                    SingleUseTransaction.this.writeTransaction = SingleUseTransaction.this.dbClient.readWriteTransaction();
                    Long res = SingleUseTransaction.this.writeTransaction.run(new TransactionRunner.TransactionCallable<Long>(){

                        @Override
                        public Long run(TransactionContext transaction) throws Exception {
                            return transaction.executeUpdate(update.getStatement());
                        }
                    });
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    return res;
                }
                catch (Throwable t) {
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    throw t;
                }
            }
        };
        return this.executeStatementAsync(update, callable, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteSqlMethod(), (Object)SpannerGrpc.getCommitMethod()));
    }

    private ApiFuture<Long> executePartitionedUpdateAsync(final StatementParser.ParsedStatement update) {
        Callable<Long> callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                try {
                    Long res = SingleUseTransaction.this.dbClient.executePartitionedUpdate(update.getStatement());
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    return res;
                }
                catch (Throwable t) {
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    throw t;
                }
            }
        };
        return this.executeStatementAsync(update, callable, SpannerGrpc.getExecuteStreamingSqlMethod());
    }

    private ApiFuture<long[]> executeTransactionalBatchUpdateAsync(final Iterable<StatementParser.ParsedStatement> updates) {
        Callable<long[]> callable = new Callable<long[]>(){

            @Override
            public long[] call() throws Exception {
                SingleUseTransaction.this.writeTransaction = SingleUseTransaction.this.dbClient.readWriteTransaction();
                return SingleUseTransaction.this.writeTransaction.run(new TransactionRunner.TransactionCallable<long[]>(){

                    @Override
                    public long[] run(TransactionContext transaction) throws Exception {
                        try {
                            long[] res = transaction.batchUpdate(Iterables.transform((Iterable)updates, (Function)new Function<StatementParser.ParsedStatement, Statement>(){

                                public Statement apply(StatementParser.ParsedStatement input) {
                                    return input.getStatement();
                                }
                            }));
                            SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                            return res;
                        }
                        catch (Throwable t) {
                            if (t instanceof SpannerBatchUpdateException) {
                                SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                            } else {
                                SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                            }
                            throw t;
                        }
                    }
                });
            }
        };
        return this.executeStatementAsync(this.executeBatchUpdateStatement, callable, SpannerGrpc.getExecuteBatchDmlMethod());
    }

    @Override
    public ApiFuture<Void> writeAsync(final Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Update statements are not allowed in read-only mode");
        this.checkAndMarkUsed();
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    SingleUseTransaction.this.writeTransaction = SingleUseTransaction.this.dbClient.readWriteTransaction();
                    Void res = SingleUseTransaction.this.writeTransaction.run(new TransactionRunner.TransactionCallable<Void>(){

                        @Override
                        public Void run(TransactionContext transaction) throws Exception {
                            transaction.buffer(mutations);
                            return null;
                        }
                    });
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    return res;
                }
                catch (Throwable t) {
                    SingleUseTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    throw t;
                }
            }
        };
        return this.executeStatementAsync(this.commitStatement, callable, SpannerGrpc.getCommitMethod());
    }

    @Override
    public ApiFuture<Void> commitAsync() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Commit is not supported for single-use transactions");
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback is not supported for single-use transactions");
    }

    @Override
    public ApiFuture<long[]> runBatchAsync() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for single-use transactions");
    }

    @Override
    public void abortBatch() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for single-use transactions");
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, SingleUseTransaction> {
        private DdlClient ddlClient;
        private DatabaseClient dbClient;
        private boolean readOnly;
        private TimestampBound readOnlyStaleness;
        private AutocommitDmlMode autocommitDmlMode;

        private Builder() {
        }

        Builder setDdlClient(DdlClient ddlClient) {
            Preconditions.checkNotNull((Object)ddlClient);
            this.ddlClient = ddlClient;
            return this;
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        Builder setReadOnlyStaleness(TimestampBound staleness) {
            Preconditions.checkNotNull((Object)staleness);
            this.readOnlyStaleness = staleness;
            return this;
        }

        Builder setAutocommitDmlMode(AutocommitDmlMode dmlMode) {
            Preconditions.checkNotNull((Object)((Object)dmlMode));
            this.autocommitDmlMode = dmlMode;
            return this;
        }

        @Override
        SingleUseTransaction build() {
            Preconditions.checkState((this.ddlClient != null ? 1 : 0) != 0, (Object)"No DDL client specified");
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DatabaseClient client specified");
            Preconditions.checkState((this.readOnlyStaleness != null ? 1 : 0) != 0, (Object)"No read-only staleness specified");
            Preconditions.checkState((this.autocommitDmlMode != null ? 1 : 0) != 0, (Object)"No autocommit dml mode specified");
            return new SingleUseTransaction(this);
        }
    }
}

