/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.Preconditions;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceId;
import java.util.Objects;
import javax.annotation.Nullable;

public class BackupInfo {
    private final BackupId id;
    private final State state;
    private final Timestamp expireTime;
    private final Timestamp versionTime;
    private final DatabaseId database;
    private final long size;
    private final com.google.spanner.admin.database.v1.Backup proto;

    BackupInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.size = builder.size;
        this.expireTime = builder.expireTime;
        this.versionTime = builder.versionTime;
        this.database = builder.database;
        this.proto = builder.proto;
    }

    public BackupId getId() {
        return this.id;
    }

    public InstanceId getInstanceId() {
        return this.id.getInstanceId();
    }

    public State getState() {
        return this.state;
    }

    public long getSize() {
        return this.size;
    }

    public Timestamp getExpireTime() {
        return this.expireTime;
    }

    public Timestamp getVersionTime() {
        return this.versionTime;
    }

    public DatabaseId getDatabase() {
        return this.database;
    }

    @Nullable
    public com.google.spanner.admin.database.v1.Backup getProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupInfo that = (BackupInfo)o;
        return this.id.equals(that.id) && this.state == that.state && this.size == that.size && Objects.equals(this.expireTime, that.expireTime) && Objects.equals(this.versionTime, that.versionTime) && Objects.equals(this.database, that.database);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.size, this.expireTime, this.versionTime, this.database});
    }

    public String toString() {
        return String.format("Backup[%s, %s, %d, %s, %s, %s]", new Object[]{this.id.getName(), this.state, this.size, this.expireTime, this.versionTime, this.database});
    }

    public static enum State {
        UNSPECIFIED,
        CREATING,
        READY;

    }

    static abstract class BuilderImpl
    extends Builder {
        protected final BackupId id;
        private State state = State.UNSPECIFIED;
        private Timestamp expireTime;
        private Timestamp versionTime;
        private DatabaseId database;
        private long size;
        private com.google.spanner.admin.database.v1.Backup proto;

        BuilderImpl(BackupId id) {
            this.id = (BackupId)Preconditions.checkNotNull((Object)id);
        }

        BuilderImpl(BackupInfo other) {
            this.id = other.id;
            this.state = other.state;
            this.expireTime = other.expireTime;
            this.versionTime = other.versionTime;
            this.database = other.database;
            this.size = other.size;
            this.proto = other.proto;
        }

        @Override
        Builder setState(State state) {
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state)));
            return this;
        }

        @Override
        public Builder setExpireTime(Timestamp expireTime) {
            this.expireTime = (Timestamp)Preconditions.checkNotNull((Object)expireTime);
            return this;
        }

        @Override
        public Builder setVersionTime(Timestamp versionTime) {
            this.versionTime = versionTime;
            return this;
        }

        @Override
        public Builder setDatabase(DatabaseId database) {
            Preconditions.checkArgument((boolean)database.getInstanceId().equals(this.id.getInstanceId()), (Object)"The instance of the source database must be equal to the instance of the backup.");
            this.database = (DatabaseId)Preconditions.checkNotNull((Object)database);
            return this;
        }

        @Override
        Builder setSize(long size) {
            this.size = size;
            return this;
        }

        @Override
        Builder setProto(@Nullable com.google.spanner.admin.database.v1.Backup proto) {
            this.proto = proto;
            return this;
        }
    }

    public static abstract class Builder {
        abstract Builder setState(State var1);

        abstract Builder setSize(long var1);

        abstract Builder setProto(com.google.spanner.admin.database.v1.Backup var1);

        public abstract Builder setExpireTime(Timestamp var1);

        public abstract Builder setVersionTime(Timestamp var1);

        public abstract Builder setDatabase(DatabaseId var1);

        public abstract Backup build();
    }
}

