/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationFutureImpl;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

class DatabaseAdminClientImpl
implements DatabaseAdminClient {
    private final String projectId;
    private final SpannerRpc rpc;
    private final PolicyMarshaller policyMarshaller = new PolicyMarshaller();
    private static final String EXPIRE_TIME_MASK = "expire_time";

    DatabaseAdminClientImpl(String projectId, SpannerRpc rpc) {
        this.projectId = projectId;
        this.rpc = rpc;
    }

    private static String randomOperationId() {
        UUID uuid = UUID.randomUUID();
        return ("r" + uuid.toString()).replace("-", "_");
    }

    @Override
    public Backup.Builder newBackupBuilder(BackupId backupId) {
        return new Backup.Builder(this, backupId);
    }

    @Override
    public OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabase(String backupInstanceId, String backupId, String restoreInstanceId, String restoreDatabaseId) throws SpannerException {
        String databaseInstanceName = this.getInstanceName(restoreInstanceId);
        String backupName = this.getBackupName(backupInstanceId, backupId);
        OperationFuture<com.google.spanner.admin.database.v1.Database, RestoreDatabaseMetadata> rawOperationFuture = this.rpc.restoreDatabase(databaseInstanceName, restoreDatabaseId, backupName);
        return new OperationFutureImpl(rawOperationFuture.getPollingFuture(), rawOperationFuture.getInitialFuture(), (ApiFunction)new ApiFunction<OperationSnapshot, Database>(){

            public Database apply(OperationSnapshot snapshot) {
                return Database.fromProto((com.google.spanner.admin.database.v1.Database)ProtoOperationTransformers.ResponseTransformer.create(com.google.spanner.admin.database.v1.Database.class).apply(snapshot), DatabaseAdminClientImpl.this);
            }
        }, (ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RestoreDatabaseMetadata.class), (ApiFunction)new ApiFunction<Exception, Database>(){

            public Database apply(Exception e) {
                throw SpannerExceptionFactory.newSpannerException(e);
            }
        });
    }

    @Override
    public OperationFuture<Backup, CreateBackupMetadata> createBackup(String instanceId, String backupId, String databaseId, Timestamp expireTime) throws SpannerException {
        Backup backup = this.newBackupBuilder(BackupId.of(this.projectId, instanceId, backupId)).setDatabase(DatabaseId.of(this.projectId, instanceId, databaseId)).setExpireTime(expireTime).build();
        return this.createBackup(backup);
    }

    @Override
    public OperationFuture<Backup, CreateBackupMetadata> createBackup(Backup backup) {
        String instanceId = backup.getInstanceId().getInstance();
        String databaseId = backup.getDatabase().getDatabase();
        String backupId = backup.getId().getBackup();
        Backup.Builder backupBuilder = com.google.spanner.admin.database.v1.Backup.newBuilder().setDatabase(this.getDatabaseName(instanceId, databaseId)).setExpireTime(backup.getExpireTime().toProto());
        if (backup.getVersionTime() != null) {
            backupBuilder.setVersionTime(backup.getVersionTime().toProto());
        }
        String instanceName = this.getInstanceName(instanceId);
        OperationFuture<com.google.spanner.admin.database.v1.Backup, CreateBackupMetadata> rawOperationFuture = this.rpc.createBackup(instanceName, backupId, backupBuilder.build());
        return new OperationFutureImpl(rawOperationFuture.getPollingFuture(), rawOperationFuture.getInitialFuture(), (ApiFunction)new ApiFunction<OperationSnapshot, Backup>(){

            public Backup apply(OperationSnapshot snapshot) {
                com.google.spanner.admin.database.v1.Backup proto = (com.google.spanner.admin.database.v1.Backup)ProtoOperationTransformers.ResponseTransformer.create(com.google.spanner.admin.database.v1.Backup.class).apply(snapshot);
                return Backup.fromProto(com.google.spanner.admin.database.v1.Backup.newBuilder((com.google.spanner.admin.database.v1.Backup)proto).setName(proto.getName()).setExpireTime(proto.getExpireTime()).setVersionTime(proto.getVersionTime()).setState(proto.getState()).build(), DatabaseAdminClientImpl.this);
            }
        }, (ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateBackupMetadata.class), (ApiFunction)new ApiFunction<Exception, Backup>(){

            public Backup apply(Exception e) {
                throw SpannerExceptionFactory.newSpannerException(e);
            }
        });
    }

    @Override
    public Backup updateBackup(String instanceId, String backupId, Timestamp expireTime) {
        String backupName = this.getBackupName(instanceId, backupId);
        com.google.spanner.admin.database.v1.Backup backup = com.google.spanner.admin.database.v1.Backup.newBuilder().setName(backupName).setExpireTime(expireTime.toProto()).build();
        FieldMask updateMask = FieldMask.newBuilder().addPaths(EXPIRE_TIME_MASK).build();
        try {
            return Backup.fromProto(this.rpc.updateBackup(backup, updateMask), this);
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
    }

    @Override
    public void deleteBackup(String instanceId, String backupId) {
        String backupName = this.getBackupName(instanceId, backupId);
        try {
            this.rpc.deleteBackup(backupName);
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
    }

    @Override
    public Backup getBackup(String instanceId, String backupId) throws SpannerException {
        String backupName = this.getBackupName(instanceId, backupId);
        return Backup.fromProto(this.rpc.getBackup(backupName), this);
    }

    @Override
    public final Page<Operation> listBackupOperations(String instanceId, Options.ListOption ... options) {
        final String instanceName = this.getInstanceName(instanceId);
        Options listOptions = Options.fromListOptions(options);
        final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
        final String filter = listOptions.hasFilter() ? listOptions.filter() : null;
        final String pageToken = listOptions.hasPageToken() ? listOptions.pageToken() : null;
        SpannerImpl.PageFetcher<Operation, Operation> pageFetcher = new SpannerImpl.PageFetcher<Operation, Operation>(){

            @Override
            public SpannerRpc.Paginated<Operation> getNextPage(String nextPageToken) {
                return DatabaseAdminClientImpl.this.rpc.listBackupOperations(instanceName, pageSize, filter, pageToken);
            }

            @Override
            public Operation fromProto(Operation proto) {
                return proto;
            }
        };
        if (listOptions.hasPageToken()) {
            pageFetcher.setNextPageToken(listOptions.pageToken());
        }
        return pageFetcher.getNextPage();
    }

    @Override
    public final Page<Operation> listDatabaseOperations(String instanceId, Options.ListOption ... options) {
        final String instanceName = this.getInstanceName(instanceId);
        Options listOptions = Options.fromListOptions(options);
        final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
        final String filter = listOptions.hasFilter() ? listOptions.filter() : null;
        final String pageToken = listOptions.hasPageToken() ? listOptions.pageToken() : null;
        SpannerImpl.PageFetcher<Operation, Operation> pageFetcher = new SpannerImpl.PageFetcher<Operation, Operation>(){

            @Override
            public SpannerRpc.Paginated<Operation> getNextPage(String nextPageToken) {
                return DatabaseAdminClientImpl.this.rpc.listDatabaseOperations(instanceName, pageSize, filter, pageToken);
            }

            @Override
            public Operation fromProto(Operation proto) {
                return proto;
            }
        };
        if (listOptions.hasPageToken()) {
            pageFetcher.setNextPageToken(listOptions.pageToken());
        }
        return pageFetcher.getNextPage();
    }

    @Override
    public Page<Backup> listBackups(String instanceId, Options.ListOption ... options) {
        final String instanceName = this.getInstanceName(instanceId);
        Options listOptions = Options.fromListOptions(options);
        final String filter = listOptions.hasFilter() ? listOptions.filter() : null;
        final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
        SpannerImpl.PageFetcher<Backup, com.google.spanner.admin.database.v1.Backup> pageFetcher = new SpannerImpl.PageFetcher<Backup, com.google.spanner.admin.database.v1.Backup>(){

            @Override
            public SpannerRpc.Paginated<com.google.spanner.admin.database.v1.Backup> getNextPage(String nextPageToken) {
                return DatabaseAdminClientImpl.this.rpc.listBackups(instanceName, pageSize, filter, nextPageToken);
            }

            @Override
            public Backup fromProto(com.google.spanner.admin.database.v1.Backup proto) {
                return Backup.fromProto(proto, DatabaseAdminClientImpl.this);
            }
        };
        if (listOptions.hasPageToken()) {
            pageFetcher.setNextPageToken(listOptions.pageToken());
        }
        return pageFetcher.getNextPage();
    }

    @Override
    public OperationFuture<Database, CreateDatabaseMetadata> createDatabase(String instanceId, String databaseId, Iterable<String> statements) throws SpannerException {
        String instanceName = this.getInstanceName(instanceId);
        String createStatement = "CREATE DATABASE `" + databaseId + "`";
        OperationFuture<com.google.spanner.admin.database.v1.Database, CreateDatabaseMetadata> rawOperationFuture = this.rpc.createDatabase(instanceName, createStatement, statements);
        return new OperationFutureImpl(rawOperationFuture.getPollingFuture(), rawOperationFuture.getInitialFuture(), (ApiFunction)new ApiFunction<OperationSnapshot, Database>(){

            public Database apply(OperationSnapshot snapshot) {
                return Database.fromProto((com.google.spanner.admin.database.v1.Database)ProtoOperationTransformers.ResponseTransformer.create(com.google.spanner.admin.database.v1.Database.class).apply(snapshot), DatabaseAdminClientImpl.this);
            }
        }, (ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDatabaseMetadata.class), (ApiFunction)new ApiFunction<Exception, Database>(){

            public Database apply(Exception e) {
                throw SpannerExceptionFactory.newSpannerException(e);
            }
        });
    }

    @Override
    public Database getDatabase(String instanceId, String databaseId) throws SpannerException {
        String dbName = this.getDatabaseName(instanceId, databaseId);
        return Database.fromProto(this.rpc.getDatabase(dbName), this);
    }

    @Override
    public OperationFuture<Void, UpdateDatabaseDdlMetadata> updateDatabaseDdl(String instanceId, String databaseId, Iterable<String> statements, @Nullable String operationId) throws SpannerException {
        String dbName = this.getDatabaseName(instanceId, databaseId);
        String opId = operationId != null ? operationId : DatabaseAdminClientImpl.randomOperationId();
        OperationFuture<Empty, UpdateDatabaseDdlMetadata> rawOperationFuture = this.rpc.updateDatabaseDdl(dbName, statements, opId);
        return new OperationFutureImpl(rawOperationFuture.getPollingFuture(), rawOperationFuture.getInitialFuture(), (ApiFunction)new ApiFunction<OperationSnapshot, Void>(){

            public Void apply(OperationSnapshot snapshot) {
                ProtoOperationTransformers.ResponseTransformer.create(Empty.class).apply(snapshot);
                return null;
            }
        }, (ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateDatabaseDdlMetadata.class), (ApiFunction)new ApiFunction<Exception, Void>(){

            public Void apply(Exception e) {
                throw SpannerExceptionFactory.newSpannerException(e);
            }
        });
    }

    @Override
    public void dropDatabase(String instanceId, String databaseId) throws SpannerException {
        String dbName = this.getDatabaseName(instanceId, databaseId);
        this.rpc.dropDatabase(dbName);
    }

    @Override
    public List<String> getDatabaseDdl(String instanceId, String databaseId) {
        String dbName = this.getDatabaseName(instanceId, databaseId);
        return this.rpc.getDatabaseDdl(dbName);
    }

    @Override
    public Page<Database> listDatabases(String instanceId, Options.ListOption ... options) {
        final String instanceName = this.getInstanceName(instanceId);
        Options listOptions = Options.fromListOptions(options);
        Preconditions.checkArgument((!listOptions.hasFilter() ? 1 : 0) != 0, (Object)"Filter option is not supported by listDatabases");
        final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
        SpannerImpl.PageFetcher<Database, com.google.spanner.admin.database.v1.Database> pageFetcher = new SpannerImpl.PageFetcher<Database, com.google.spanner.admin.database.v1.Database>(){

            @Override
            public SpannerRpc.Paginated<com.google.spanner.admin.database.v1.Database> getNextPage(String nextPageToken) {
                try {
                    return DatabaseAdminClientImpl.this.rpc.listDatabases(instanceName, pageSize, nextPageToken);
                }
                catch (SpannerException e) {
                    throw SpannerExceptionFactory.newSpannerException(e.getErrorCode(), String.format("Failed to list the databases of %s with pageToken %s: %s", instanceName, MoreObjects.firstNonNull((Object)nextPageToken, (Object)"<null>"), e.getMessage()), (Throwable)((Object)e));
                }
            }

            @Override
            public Database fromProto(com.google.spanner.admin.database.v1.Database proto) {
                return Database.fromProto(proto, DatabaseAdminClientImpl.this);
            }
        };
        if (listOptions.hasPageToken()) {
            pageFetcher.setNextPageToken(listOptions.pageToken());
        }
        return pageFetcher.getNextPage();
    }

    @Override
    public void cancelOperation(String name) {
        Preconditions.checkNotNull((Object)name);
        this.rpc.cancelOperation(name);
    }

    @Override
    public Operation getOperation(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.rpc.getOperation(name);
    }

    @Override
    public Policy getDatabaseIAMPolicy(String instanceId, String databaseId) {
        String databaseName = DatabaseId.of(this.projectId, instanceId, databaseId).getName();
        return this.policyMarshaller.fromPb(this.rpc.getDatabaseAdminIAMPolicy(databaseName));
    }

    @Override
    public Policy setDatabaseIAMPolicy(String instanceId, String databaseId, Policy policy) {
        Preconditions.checkNotNull((Object)policy);
        String databaseName = DatabaseId.of(this.projectId, instanceId, databaseId).getName();
        return this.policyMarshaller.fromPb(this.rpc.setDatabaseAdminIAMPolicy(databaseName, this.policyMarshaller.toPb(policy)));
    }

    @Override
    public Iterable<String> testDatabaseIAMPermissions(String instanceId, String databaseId, Iterable<String> permissions) {
        Preconditions.checkNotNull(permissions);
        String databaseName = DatabaseId.of(this.projectId, instanceId, databaseId).getName();
        return this.rpc.testDatabaseAdminIAMPermissions(databaseName, permissions).getPermissionsList();
    }

    @Override
    public Policy getBackupIAMPolicy(String instanceId, String backupId) {
        String databaseName = BackupId.of(this.projectId, instanceId, backupId).getName();
        return this.policyMarshaller.fromPb(this.rpc.getDatabaseAdminIAMPolicy(databaseName));
    }

    @Override
    public Policy setBackupIAMPolicy(String instanceId, String backupId, Policy policy) {
        Preconditions.checkNotNull((Object)policy);
        String databaseName = BackupId.of(this.projectId, instanceId, backupId).getName();
        return this.policyMarshaller.fromPb(this.rpc.setDatabaseAdminIAMPolicy(databaseName, this.policyMarshaller.toPb(policy)));
    }

    @Override
    public Iterable<String> testBackupIAMPermissions(String instanceId, String backupId, Iterable<String> permissions) {
        Preconditions.checkNotNull(permissions);
        String databaseName = BackupId.of(this.projectId, instanceId, backupId).getName();
        return this.rpc.testDatabaseAdminIAMPermissions(databaseName, permissions).getPermissionsList();
    }

    private String getInstanceName(String instanceId) {
        return new InstanceId(this.projectId, instanceId).getName();
    }

    private String getDatabaseName(String instanceId, String databaseId) {
        return new DatabaseId(new InstanceId(this.projectId, instanceId), databaseId).getName();
    }

    private String getBackupName(String instanceId, String backupId) {
        InstanceId instance = new InstanceId(this.projectId, instanceId);
        return new BackupId(instance, backupId).getName();
    }

    private static final class PolicyMarshaller
    extends Policy.DefaultMarshaller {
        private PolicyMarshaller() {
        }

        protected Policy fromPb(com.google.iam.v1.Policy policyPb) {
            return super.fromPb(policyPb);
        }

        protected com.google.iam.v1.Policy toPb(Policy policy) {
            return super.toPb(policy);
        }
    }
}

