/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.InternalApi;
import com.google.cloud.spanner.SpannerOptions;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import java.util.Arrays;
import java.util.List;

@InternalApi
public class SpannerRpcMetrics {
    private final LongHistogram gfeLatencies;
    private final LongCounter gfeHeaderMissingCount;

    public SpannerRpcMetrics(OpenTelemetry openTelemetry) {
        if (!SpannerOptions.isEnabledOpenTelemetryMetrics()) {
            this.gfeLatencies = null;
            this.gfeHeaderMissingCount = null;
            return;
        }
        Meter meter = openTelemetry.getMeter("cloud.google.com/java");
        List<Long> RPC_MILLIS_BUCKET_BOUNDARIES = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 8L, 10L, 13L, 16L, 20L, 25L, 30L, 40L, 50L, 65L, 80L, 100L, 130L, 160L, 200L, 250L, 300L, 400L, 500L, 650L, 800L, 1000L, 2000L, 5000L, 10000L, 20000L, 50000L, 100000L);
        this.gfeLatencies = meter.histogramBuilder("spanner/gfe_latency").ofLongs().setDescription("Latency between Google's network receiving an RPC and reading back the first byte of the response").setUnit("ms").setExplicitBucketBoundariesAdvice(RPC_MILLIS_BUCKET_BOUNDARIES).build();
        this.gfeHeaderMissingCount = meter.counterBuilder("spanner/gfe_header_missing_count").setDescription("Number of RPC responses received without the server-timing header, most likely means that the RPC never reached Google's network").setUnit("1").build();
    }

    @InternalApi
    public void recordGfeLatency(long value, Attributes attributes) {
        if (this.gfeLatencies != null) {
            this.gfeLatencies.record(value, attributes);
        }
    }

    @InternalApi
    public void recordGfeHeaderMissingCount(long value, Attributes attributes) {
        if (this.gfeHeaderMissingCount != null) {
            this.gfeHeaderMissingCount.add(value, attributes);
        }
    }
}

