/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.OpenTelemetryContextKeys;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.PartitionId;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

abstract class AbstractBaseUnitOfWork
implements UnitOfWork {
    static final String DB_STATEMENT = "db.statement";
    static final AttributeKey<String> DB_STATEMENT_KEY = AttributeKey.stringKey((String)"db.statement");
    static final AttributeKey<List<String>> DB_STATEMENT_ARRAY_KEY = AttributeKey.stringArrayKey((String)"db.statement");
    private final StatementExecutor statementExecutor;
    private final StatementExecutor.StatementTimeout statementTimeout;
    protected final String transactionTag;
    protected final List<TransactionRetryListener> transactionRetryListeners;
    protected final boolean excludeTxnFromChangeStreams;
    protected final Options.RpcPriority rpcPriority;
    protected final Span span;
    @GuardedBy(value="this")
    private volatile Future<?> currentlyRunningStatementFuture = null;

    AbstractBaseUnitOfWork(Builder<?, ?> builder) {
        Preconditions.checkState((((Builder)builder).statementExecutor != null ? 1 : 0) != 0, (Object)"No statement executor specified");
        this.statementExecutor = ((Builder)builder).statementExecutor;
        this.statementTimeout = ((Builder)builder).statementTimeout;
        this.transactionTag = ((Builder)builder).transactionTag;
        this.transactionRetryListeners = ((Builder)builder).transactionRetryListeners;
        this.excludeTxnFromChangeStreams = ((Builder)builder).excludeTxnFromChangeStreams;
        this.rpcPriority = ((Builder)builder).rpcPriority;
        this.span = (Span)Preconditions.checkNotNull((Object)((Builder)builder).span);
    }

    @Override
    public Span getSpan() {
        return this.span;
    }

    ApiFuture<Void> asyncEndUnitOfWorkSpan() {
        return this.statementExecutor.submit(this::endUnitOfWorkSpan);
    }

    private Void endUnitOfWorkSpan() {
        if (this.span != null) {
            this.span.end();
        }
        return null;
    }

    abstract String getUnitOfWorkName();

    @Override
    public void savepoint(@Nonnull String name, @Nonnull Dialect dialect) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Savepoint is not supported for " + this.getUnitOfWorkName());
    }

    @Override
    public void releaseSavepoint(@Nonnull String name) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Release savepoint is not supported for " + this.getUnitOfWorkName());
    }

    @Override
    public void rollbackToSavepoint(@Nonnull String name, @Nonnull SavepointSupport savepointSupport) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback to savepoint is not supported for " + this.getUnitOfWorkName());
    }

    @Override
    public ApiFuture<ResultSet> partitionQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement query, PartitionOptions partitionOptions, Options.QueryOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Partition query is not supported for " + this.getUnitOfWorkName());
    }

    ResultSet partitionQuery(BatchReadOnlyTransaction transaction, PartitionOptions partitionOptions, AbstractStatementParser.ParsedStatement query, Options.QueryOption ... options) {
        String partitionColumnName = "PARTITION";
        BatchTransactionId transactionId = transaction.getBatchTransactionId();
        List<Partition> partitions = transaction.partitionQuery(partitionOptions, query.getStatement(), options);
        return ResultSets.forRows(Type.struct(Type.StructField.of("PARTITION", Type.string())), partitions.stream().map(partition -> Struct.newBuilder().set("PARTITION").to(PartitionId.encodeToString(transactionId, partition)).build()).collect(Collectors.toList()));
    }

    StatementExecutor getStatementExecutor() {
        return this.statementExecutor;
    }

    StatementExecutor.StatementTimeout getStatementTimeout() {
        return this.statementTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        AbstractBaseUnitOfWork abstractBaseUnitOfWork = this;
        synchronized (abstractBaseUnitOfWork) {
            if (this.currentlyRunningStatementFuture != null && !this.currentlyRunningStatementFuture.isDone() && !this.currentlyRunningStatementFuture.isCancelled()) {
                this.currentlyRunningStatementFuture.cancel(true);
            }
        }
    }

    <T> ApiFuture<T> executeStatementAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, Callable<T> callable, @Nullable MethodDescriptor<?, ?> applyStatementTimeoutToMethod) {
        return this.executeStatementAsync(callType, statement, callable, InterceptorsUsage.INVOKE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)(applyStatementTimeoutToMethod == null ? Collections.emptySet() : ImmutableList.of(applyStatementTimeoutToMethod)));
    }

    <T> ApiFuture<T> executeStatementAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, Callable<T> callable, Collection<MethodDescriptor<?, ?>> applyStatementTimeoutToMethods) {
        return this.executeStatementAsync(callType, statement, callable, InterceptorsUsage.INVOKE_INTERCEPTORS, applyStatementTimeoutToMethods);
    }

    <ResponseT, MetadataT> ResponseT getWithStatementTimeout(OperationFuture<ResponseT, MetadataT> operation, AbstractStatementParser.ParsedStatement statement) {
        Object res;
        try {
            if (this.statementTimeout.hasTimeout()) {
                TimeUnit unit = this.statementTimeout.getAppropriateTimeUnit();
                res = operation.get(this.statementTimeout.getTimeoutValue(unit), unit);
            } else {
                res = operation.get();
            }
        }
        catch (TimeoutException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Statement execution timeout occurred for " + statement.getSql(), e);
        }
        catch (ExecutionException e) {
            HashSet<Throwable> causes = new HashSet<Throwable>();
            for (Throwable cause = e.getCause(); cause != null && !causes.contains(cause); cause = cause.getCause()) {
                if (cause instanceof SpannerException) {
                    throw (SpannerException)((Object)cause);
                }
                causes.add(cause);
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.fromGrpcStatus(Status.fromThrowable((Throwable)e)), "Statement execution failed for " + statement.getSql(), e);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Statement execution was interrupted", e);
        }
        catch (CancellationException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Statement execution was cancelled", e);
        }
        return (ResponseT)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> ApiFuture<T> executeStatementAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, Callable<T> callable, InterceptorsUsage interceptorUsage, final Collection<MethodDescriptor<?, ?>> applyStatementTimeoutToMethods) {
        Deadline statementDeadline;
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkNotNull(callable);
        if (interceptorUsage == InterceptorsUsage.INVOKE_INTERCEPTORS) {
            this.statementExecutor.invokeInterceptors(statement, StatementExecutionStep.EXECUTE_STATEMENT, this);
        }
        io.grpc.Context context = io.grpc.Context.current();
        Deadline transactionDeadline = this.getTransactionDeadline();
        final Deadline effectiveDeadline = AbstractBaseUnitOfWork.min(transactionDeadline, statementDeadline = this.statementTimeout.hasTimeout() ? Deadline.after((long)this.statementTimeout.getTimeoutValue(TimeUnit.NANOSECONDS), (TimeUnit)TimeUnit.NANOSECONDS) : null);
        if (effectiveDeadline != null && !applyStatementTimeoutToMethods.isEmpty()) {
            context = context.withValue(SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY, (Object)new SpannerOptions.CallContextConfigurator(){

                @Override
                public <ReqT, RespT> ApiCallContext configure(ApiCallContext context, ReqT request, MethodDescriptor<ReqT, RespT> method) {
                    if (applyStatementTimeoutToMethods.contains(method)) {
                        long remainingTimeout = effectiveDeadline.timeRemaining(TimeUnit.NANOSECONDS);
                        if (remainingTimeout <= 0L) {
                            remainingTimeout = 1L;
                        }
                        return GrpcCallContext.createDefault().withTimeoutDuration(Duration.ofNanos(remainingTimeout));
                    }
                    return null;
                }
            });
        }
        try (Scope ignore = Context.current().with(OpenTelemetryContextKeys.THREAD_NAME_KEY, (Object)Thread.currentThread().getName()).makeCurrent();){
            ApiFuture f = this.statementExecutor.submit(context.wrap(callable));
            SpannerAsyncExecutionException caller = callType == UnitOfWork.CallType.ASYNC ? new SpannerAsyncExecutionException(statement.getStatement()) : null;
            final ApiFuture future = ApiFutures.catching(f, Throwable.class, input -> {
                if (caller != null) {
                    input.addSuppressed(caller);
                }
                throw SpannerExceptionFactory.asSpannerException(input);
            }, (Executor)MoreExecutors.directExecutor());
            AbstractBaseUnitOfWork abstractBaseUnitOfWork = this;
            synchronized (abstractBaseUnitOfWork) {
                this.currentlyRunningStatementFuture = future;
            }
            future.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        if (AbstractBaseUnitOfWork.this.currentlyRunningStatementFuture == future) {
                            AbstractBaseUnitOfWork.this.currentlyRunningStatementFuture = null;
                        }
                    }
                    if (AbstractBaseUnitOfWork.this.isSingleUse()) {
                        AbstractBaseUnitOfWork.this.endUnitOfWorkSpan();
                    }
                }
            }, MoreExecutors.directExecutor());
            abstractBaseUnitOfWork = future;
            return abstractBaseUnitOfWork;
        }
    }

    @Nullable
    static Deadline min(@Nullable Deadline a, @Nullable Deadline b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.minimum(b);
    }

    @Nullable
    Deadline getTransactionDeadline() {
        return null;
    }

    static abstract class Builder<B extends Builder<?, T>, T extends AbstractBaseUnitOfWork> {
        private StatementExecutor statementExecutor;
        private StatementExecutor.StatementTimeout statementTimeout = new StatementExecutor.StatementTimeout();
        private String transactionTag;
        private List<TransactionRetryListener> transactionRetryListeners;
        private boolean excludeTxnFromChangeStreams;
        private Options.RpcPriority rpcPriority;
        private Span span;

        Builder() {
        }

        B self() {
            return (B)this;
        }

        B withStatementExecutor(StatementExecutor executor) {
            Preconditions.checkNotNull((Object)executor);
            this.statementExecutor = executor;
            return this.self();
        }

        B setStatementTimeout(StatementExecutor.StatementTimeout timeout) {
            Preconditions.checkNotNull((Object)timeout);
            this.statementTimeout = timeout;
            return this.self();
        }

        B setTransactionRetryListeners(List<TransactionRetryListener> listeners) {
            Preconditions.checkNotNull(listeners);
            this.transactionRetryListeners = listeners;
            return this.self();
        }

        boolean hasTransactionRetryListeners() {
            return this.transactionRetryListeners != null;
        }

        B setTransactionTag(@Nullable String tag) {
            this.transactionTag = tag;
            return this.self();
        }

        B setExcludeTxnFromChangeStreams(boolean excludeTxnFromChangeStreams) {
            this.excludeTxnFromChangeStreams = excludeTxnFromChangeStreams;
            return this.self();
        }

        B setRpcPriority(@Nullable Options.RpcPriority rpcPriority) {
            this.rpcPriority = rpcPriority;
            return this.self();
        }

        B setSpan(@Nullable Span span) {
            this.span = span;
            return this.self();
        }

        abstract T build();
    }

    static enum InterceptorsUsage {
        INVOKE_INTERCEPTORS,
        IGNORE_INTERCEPTORS;

    }

    static final class SpannerAsyncExecutionException
    extends RuntimeException {
        final Statement statement;

        SpannerAsyncExecutionException(Statement statement) {
            this.statement = statement;
        }

        @Override
        public String getMessage() {
            return String.format("Execution failed for statement: %s", this.statement.getSql());
        }
    }
}

