/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.ConnectionState;
import com.google.cloud.spanner.connection.DdlInTransactionMode;
import com.google.cloud.spanner.connection.DirectedReadOptionsUtil;
import com.google.cloud.spanner.connection.PgTransactionMode;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.TransactionOptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ClientSideStatementValueConverters {
    ClientSideStatementValueConverters() {
    }

    static class DialectConverter
    implements ClientSideStatementValueConverter<Dialect> {
        static final DialectConverter INSTANCE = new DialectConverter();
        private final CaseInsensitiveEnumMap<Dialect> values = new CaseInsensitiveEnumMap(Dialect.class);

        private DialectConverter() {
        }

        @Override
        public Class<Dialect> getParameterClass() {
            return Dialect.class;
        }

        @Override
        public Dialect convert(String value) {
            return (Dialect)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class GrpcInterceptorProviderConverter
    implements ClientSideStatementValueConverter<GrpcInterceptorProvider> {
        static final GrpcInterceptorProviderConverter INSTANCE = new GrpcInterceptorProviderConverter();

        private GrpcInterceptorProviderConverter() {
        }

        @Override
        public Class<GrpcInterceptorProvider> getParameterClass() {
            return GrpcInterceptorProvider.class;
        }

        @Override
        public GrpcInterceptorProvider convert(String interceptorProviderName) {
            if (!Strings.isNullOrEmpty((String)interceptorProviderName)) {
                try {
                    Class<?> clazz = Class.forName(interceptorProviderName);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    return (GrpcInterceptorProvider)constructor.newInstance(new Object[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown or invalid GrpcInterceptorProvider class name: " + interceptorProviderName, classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "GrpcInterceptorProvider " + interceptorProviderName + " does not have a public no-arg constructor.", noSuchMethodException);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Failed to create an instance of " + interceptorProviderName + ": " + exception.getMessage(), exception);
                }
            }
            return null;
        }
    }

    static class CredentialsProviderConverter
    implements ClientSideStatementValueConverter<CredentialsProvider> {
        static final CredentialsProviderConverter INSTANCE = new CredentialsProviderConverter();

        private CredentialsProviderConverter() {
        }

        @Override
        public Class<CredentialsProvider> getParameterClass() {
            return CredentialsProvider.class;
        }

        @Override
        public CredentialsProvider convert(String credentialsProviderName) {
            if (!Strings.isNullOrEmpty((String)credentialsProviderName)) {
                try {
                    Class<?> clazz = Class.forName(credentialsProviderName);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    return (CredentialsProvider)constructor.newInstance(new Object[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown or invalid CredentialsProvider class name: " + credentialsProviderName, classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Credentials provider " + credentialsProviderName + " does not have a public no-arg constructor.", noSuchMethodException);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Failed to create an instance of " + credentialsProviderName + ": " + exception.getMessage(), exception);
                }
            }
            return null;
        }
    }

    static class ProtoDescriptorsFileConverter
    implements ClientSideStatementValueConverter<String> {
        public ProtoDescriptorsFileConverter(String allowedValues) {
        }

        @Override
        public Class<String> getParameterClass() {
            return String.class;
        }

        @Override
        public String convert(String filePath) {
            if (Strings.isNullOrEmpty((String)filePath)) {
                return null;
            }
            return filePath;
        }
    }

    static class ProtoDescriptorsConverter
    implements ClientSideStatementValueConverter<byte[]> {
        public ProtoDescriptorsConverter(String allowedValues) {
        }

        @Override
        public Class<byte[]> getParameterClass() {
            return byte[].class;
        }

        @Override
        public byte[] convert(String value) {
            if (value == null || value.length() == 0 || value.equalsIgnoreCase("null")) {
                return null;
            }
            try {
                return Base64.getDecoder().decode(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    static class ExplainCommandConverter
    implements ClientSideStatementValueConverter<String> {
        ExplainCommandConverter() {
        }

        @Override
        public Class<String> getParameterClass() {
            return String.class;
        }

        @Override
        public String convert(String value) {
            if (value.length() <= 7) {
                return null;
            }
            return value.substring(7).trim();
        }
    }

    static class DdlInTransactionModeConverter
    implements ClientSideStatementValueConverter<DdlInTransactionMode> {
        static final DdlInTransactionModeConverter INSTANCE = new DdlInTransactionModeConverter();
        private final CaseInsensitiveEnumMap<DdlInTransactionMode> values = new CaseInsensitiveEnumMap(DdlInTransactionMode.class);

        private DdlInTransactionModeConverter() {
        }

        public DdlInTransactionModeConverter(String allowedValues) {
        }

        @Override
        public Class<DdlInTransactionMode> getParameterClass() {
            return DdlInTransactionMode.class;
        }

        @Override
        public DdlInTransactionMode convert(String value) {
            return (DdlInTransactionMode)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class SavepointSupportConverter
    implements ClientSideStatementValueConverter<SavepointSupport> {
        static final SavepointSupportConverter INSTANCE = new SavepointSupportConverter();
        private final CaseInsensitiveEnumMap<SavepointSupport> values = new CaseInsensitiveEnumMap(SavepointSupport.class);

        private SavepointSupportConverter() {
        }

        public SavepointSupportConverter(String allowedValues) {
        }

        @Override
        public Class<SavepointSupport> getParameterClass() {
            return SavepointSupport.class;
        }

        @Override
        public SavepointSupport convert(String value) {
            return (SavepointSupport)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class RpcPriorityConverter
    implements ClientSideStatementValueConverter<Options.RpcPriority> {
        static final RpcPriorityConverter INSTANCE = new RpcPriorityConverter("(HIGH|MEDIUM|LOW|NULL)");
        private final CaseInsensitiveEnumMap<Options.RpcPriority> values = new CaseInsensitiveEnumMap(Options.RpcPriority.class);
        private final Pattern allowedValues;

        public RpcPriorityConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<Options.RpcPriority> getParameterClass() {
            return Options.RpcPriority.class;
        }

        @Override
        public Options.RpcPriority convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find() && matcher.group(0).equalsIgnoreCase("null")) {
                return Options.RpcPriority.UNSPECIFIED;
            }
            return (Options.RpcPriority)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class PgTransactionModeConverter
    implements ClientSideStatementValueConverter<PgTransactionMode> {
        PgTransactionModeConverter() {
        }

        public PgTransactionModeConverter(String allowedValues) {
        }

        @Override
        public Class<PgTransactionMode> getParameterClass() {
            return PgTransactionMode.class;
        }

        @Override
        public PgTransactionMode convert(String value) {
            PgTransactionMode mode = new PgTransactionMode();
            String valueWithoutDeferrable = value.replaceAll("(?i)(not\\s+deferrable)", " ");
            String valueWithSingleSpaces = valueWithoutDeferrable.replaceAll("\\s+", " ").toLowerCase(Locale.ENGLISH).trim();
            int currentIndex = 0;
            while (currentIndex < valueWithSingleSpaces.length()) {
                if (valueWithSingleSpaces.substring(currentIndex).startsWith("read only")) {
                    currentIndex += "read only".length();
                    mode.setAccessMode(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION);
                } else if (valueWithSingleSpaces.substring(currentIndex).startsWith("read write")) {
                    currentIndex += "read write".length();
                    mode.setAccessMode(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION);
                } else if (valueWithSingleSpaces.substring(currentIndex).startsWith("isolation level repeatable read")) {
                    currentIndex += "isolation level repeatable read".length();
                    mode.setIsolationLevel(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_REPEATABLE_READ);
                } else if (valueWithSingleSpaces.substring(currentIndex).startsWith("isolation level serializable")) {
                    currentIndex += "isolation level serializable".length();
                    mode.setIsolationLevel(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE);
                } else if (valueWithSingleSpaces.substring(currentIndex).startsWith("isolation level default")) {
                    currentIndex += "isolation level default".length();
                    mode.setIsolationLevel(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT);
                } else {
                    return null;
                }
                if (currentIndex < valueWithSingleSpaces.length() && valueWithSingleSpaces.charAt(currentIndex) == ' ') {
                    ++currentIndex;
                }
                if (currentIndex < valueWithSingleSpaces.length() && valueWithSingleSpaces.charAt(currentIndex) == ',') {
                    ++currentIndex;
                }
                if (currentIndex >= valueWithSingleSpaces.length() || valueWithSingleSpaces.charAt(currentIndex) != ' ') continue;
                ++currentIndex;
            }
            return mode;
        }
    }

    static class PgTransactionIsolationConverter
    implements ClientSideStatementValueConverter<PgTransactionMode.IsolationLevel> {
        private final CaseInsensitiveEnumMap<PgTransactionMode.IsolationLevel> values = new CaseInsensitiveEnumMap(PgTransactionMode.IsolationLevel.class, PgTransactionMode.IsolationLevel::getShortStatementString);

        public PgTransactionIsolationConverter(String allowedValues) {
        }

        @Override
        public Class<PgTransactionMode.IsolationLevel> getParameterClass() {
            return PgTransactionMode.IsolationLevel.class;
        }

        @Override
        public PgTransactionMode.IsolationLevel convert(String value) {
            String valueWithSingleSpaces = value.replaceAll("\\s+", " ");
            if (valueWithSingleSpaces.length() > 1 && (valueWithSingleSpaces.startsWith("'") && valueWithSingleSpaces.endsWith("'") || valueWithSingleSpaces.startsWith("\"") && valueWithSingleSpaces.endsWith("\""))) {
                valueWithSingleSpaces = valueWithSingleSpaces.substring(1, valueWithSingleSpaces.length() - 1);
            }
            return (PgTransactionMode.IsolationLevel)((CaseInsensitiveEnumMap)this.values).get(valueWithSingleSpaces);
        }
    }

    static class TransactionModeConverter
    implements ClientSideStatementValueConverter<TransactionMode> {
        private final CaseInsensitiveEnumMap<TransactionMode> values = new CaseInsensitiveEnumMap(TransactionMode.class, TransactionMode::getStatementString);

        public TransactionModeConverter(String allowedValues) {
        }

        @Override
        public Class<TransactionMode> getParameterClass() {
            return TransactionMode.class;
        }

        @Override
        public TransactionMode convert(String value) {
            String valueWithSingleSpaces = value.replaceAll("\\s+", " ");
            return (TransactionMode)((CaseInsensitiveEnumMap)this.values).get(valueWithSingleSpaces);
        }
    }

    static class StringValueConverter
    implements ClientSideStatementValueConverter<String> {
        static final StringValueConverter INSTANCE = new StringValueConverter();

        private StringValueConverter() {
        }

        public StringValueConverter(String allowedValues) {
        }

        @Override
        public Class<String> getParameterClass() {
            return String.class;
        }

        @Override
        public String convert(String value) {
            return value;
        }
    }

    static class ConnectionStateTypeConverter
    implements ClientSideStatementValueConverter<ConnectionState.Type> {
        static final ConnectionStateTypeConverter INSTANCE = new ConnectionStateTypeConverter();
        private final CaseInsensitiveEnumMap<ConnectionState.Type> values = new CaseInsensitiveEnumMap(ConnectionState.Type.class);

        private ConnectionStateTypeConverter() {
        }

        public ConnectionStateTypeConverter(String allowedValues) {
        }

        @Override
        public Class<ConnectionState.Type> getParameterClass() {
            return ConnectionState.Type.class;
        }

        @Override
        public ConnectionState.Type convert(String value) {
            return (ConnectionState.Type)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class AutocommitDmlModeConverter
    implements ClientSideStatementValueConverter<AutocommitDmlMode> {
        static final AutocommitDmlModeConverter INSTANCE = new AutocommitDmlModeConverter();
        private final CaseInsensitiveEnumMap<AutocommitDmlMode> values = new CaseInsensitiveEnumMap(AutocommitDmlMode.class);

        private AutocommitDmlModeConverter() {
        }

        public AutocommitDmlModeConverter(String allowedValues) {
        }

        @Override
        public Class<AutocommitDmlMode> getParameterClass() {
            return AutocommitDmlMode.class;
        }

        @Override
        public AutocommitDmlMode convert(String value) {
            return (AutocommitDmlMode)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class ReadLockModeConverter
    implements ClientSideStatementValueConverter<TransactionOptions.ReadWrite.ReadLockMode> {
        static final ReadLockModeConverter INSTANCE = new ReadLockModeConverter();
        private final CaseInsensitiveEnumMap<TransactionOptions.ReadWrite.ReadLockMode> values = new CaseInsensitiveEnumMap(TransactionOptions.ReadWrite.ReadLockMode.class);

        ReadLockModeConverter() {
        }

        public ReadLockModeConverter(String allowedValues) {
        }

        @Override
        public Class<TransactionOptions.ReadWrite.ReadLockMode> getParameterClass() {
            return TransactionOptions.ReadWrite.ReadLockMode.class;
        }

        @Override
        public TransactionOptions.ReadWrite.ReadLockMode convert(String value) {
            if (value != null && value.equalsIgnoreCase("unspecified")) {
                value = TransactionOptions.ReadWrite.ReadLockMode.READ_LOCK_MODE_UNSPECIFIED.name();
            }
            return (TransactionOptions.ReadWrite.ReadLockMode)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class IsolationLevelConverter
    implements ClientSideStatementValueConverter<TransactionOptions.IsolationLevel> {
        static final IsolationLevelConverter INSTANCE = new IsolationLevelConverter();
        private final CaseInsensitiveEnumMap<TransactionOptions.IsolationLevel> values = new CaseInsensitiveEnumMap(TransactionOptions.IsolationLevel.class);

        IsolationLevelConverter() {
        }

        public IsolationLevelConverter(String allowedValues) {
        }

        @Override
        public Class<TransactionOptions.IsolationLevel> getParameterClass() {
            return TransactionOptions.IsolationLevel.class;
        }

        @Override
        public TransactionOptions.IsolationLevel convert(String value) {
            if (value != null) {
                value = value.trim().replaceFirst("\\s+", "_");
            }
            return (TransactionOptions.IsolationLevel)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class DirectedReadOptionsConverter
    implements ClientSideStatementValueConverter<DirectedReadOptions> {
        private final Pattern allowedValues;

        public DirectedReadOptionsConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<DirectedReadOptions> getParameterClass() {
            return DirectedReadOptions.class;
        }

        @Override
        public DirectedReadOptions convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find()) {
                try {
                    return DirectedReadOptionsUtil.parse(value);
                }
                catch (SpannerException spannerException) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Failed to parse '%s' as a valid value for DIRECTED_READ.\nThe value should be a JSON string like this: '%s'.\nYou can generate a valid JSON string from a DirectedReadOptions instance by calling %s.%s", value, "{\"includeReplicas\":{\"replicaSelections\":[{\"location\":\"eu-west1\",\"type\":\"READ_ONLY\"}]}}", DirectedReadOptionsUtil.class.getName(), "toString(DirectedReadOptions directedReadOptions)"), (Throwable)((Object)spannerException));
                }
            }
            return null;
        }
    }

    static class ReadOnlyStalenessConverter
    implements ClientSideStatementValueConverter<TimestampBound> {
        static final ReadOnlyStalenessConverter INSTANCE = new ReadOnlyStalenessConverter("'((STRONG)|(MIN_READ_TIMESTAMP)[\\t ]+((\\d{4})-(\\d{2})-(\\d{2})([Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.\\d{1,9})?)([Zz]|([+-])(\\d{2}):(\\d{2})))|(READ_TIMESTAMP)[\t ]+((\\d{4})-(\\d{2})-(\\d{2})([Tt](\\d{2}):(\\d{2}):(    \\d{2})(\\.\\d{1,9})?)([Zz]|([+-])(\\d{2}):(\\d{2})))|(MAX_STALENESS)[\t ]+((\\d{1,19})(s|ms|us|ns))|(EXACT_STALENESS)[\\t ]+((\\d{1,19})(s|ms|us|ns)))'");
        private final Pattern allowedValues;
        private final CaseInsensitiveEnumMap<TimestampBound.Mode> values = new CaseInsensitiveEnumMap(TimestampBound.Mode.class);

        public ReadOnlyStalenessConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<TimestampBound> getParameterClass() {
            return TimestampBound.class;
        }

        @Override
        public TimestampBound convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find() && matcher.groupCount() >= 1) {
                Enum mode = null;
                int groupIndex = 0;
                for (int group = 1; group <= matcher.groupCount(); ++group) {
                    if (matcher.group(group) == null || (mode = (TimestampBound.Mode)((CaseInsensitiveEnumMap)this.values).get(matcher.group(group))) == null) continue;
                    groupIndex = group;
                    break;
                }
                switch (1.$SwitchMap$com$google$cloud$spanner$TimestampBound$Mode[mode.ordinal()]) {
                    case 1: {
                        return TimestampBound.strong();
                    }
                    case 2: {
                        return TimestampBound.ofReadTimestamp(ReadOnlyStalenessUtil.parseRfc3339(matcher.group(groupIndex + 1)));
                    }
                    case 3: {
                        return TimestampBound.ofMinReadTimestamp(ReadOnlyStalenessUtil.parseRfc3339(matcher.group(groupIndex + 1)));
                    }
                    case 4: {
                        try {
                            return TimestampBound.ofExactStaleness(Long.parseLong(matcher.group(groupIndex + 2)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(groupIndex + 3)));
                        }
                        catch (IllegalArgumentException e) {
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, e.getMessage());
                        }
                    }
                    case 5: {
                        try {
                            return TimestampBound.ofMaxStaleness(Long.parseLong(matcher.group(groupIndex + 2)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(groupIndex + 3)));
                        }
                        catch (IllegalArgumentException e) {
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, e.getMessage());
                        }
                    }
                }
            }
            return null;
        }
    }

    static class PgDurationConverter
    extends DurationConverter {
        public PgDurationConverter(String allowedValues) {
            super("DEFAULT", allowedValues);
        }
    }

    static class DurationConverter
    implements ClientSideStatementValueConverter<Duration> {
        static final DurationConverter INSTANCE = new DurationConverter("('(\\d{1,19})(s|ms|us|ns)'|\\d{1,19}|NULL)");
        private final String resetValue;
        private final Pattern allowedValues;

        public DurationConverter(String allowedValues) {
            this("NULL", allowedValues);
        }

        DurationConverter(String resetValue, String allowedValues) {
            this.resetValue = (String)Preconditions.checkNotNull((Object)resetValue);
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<Duration> getParameterClass() {
            return Duration.class;
        }

        @Override
        public Duration convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find()) {
                if (value.trim().equalsIgnoreCase(this.resetValue)) {
                    return Duration.ZERO;
                }
                try {
                    Duration duration;
                    if (matcher.group(1) != null && matcher.group(2) != null) {
                        ChronoUnit unit = ReadOnlyStalenessUtil.toChronoUnit(ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(2)));
                        duration = Duration.of(Long.parseLong(matcher.group(1)), unit);
                    } else {
                        duration = Duration.ofMillis(Long.parseLong(value.trim()));
                    }
                    if (duration.isNegative()) {
                        return null;
                    }
                    return duration;
                }
                catch (NumberFormatException exception) {
                    return null;
                }
            }
            return null;
        }
    }

    static class LongConverter
    implements ClientSideStatementValueConverter<Long> {
        static final LongConverter INSTANCE = new LongConverter();

        private LongConverter() {
        }

        public LongConverter(String allowedValues) {
        }

        @Override
        public Class<Long> getParameterClass() {
            return Long.class;
        }

        @Override
        public Long convert(String value) {
            try {
                long res = Long.parseLong(value);
                if (res < 0L) {
                    return null;
                }
                return res;
            }
            catch (Exception ignore) {
                return null;
            }
        }
    }

    static class NonNegativeIntegerConverter
    implements ClientSideStatementValueConverter<Integer> {
        static final NonNegativeIntegerConverter INSTANCE = new NonNegativeIntegerConverter();

        private NonNegativeIntegerConverter() {
        }

        public NonNegativeIntegerConverter(String allowedValues) {
        }

        @Override
        public Class<Integer> getParameterClass() {
            return Integer.class;
        }

        @Override
        public Integer convert(String value) {
            try {
                int res = Integer.parseInt(value);
                if (res < 0) {
                    return null;
                }
                return res;
            }
            catch (Exception ignore) {
                return null;
            }
        }
    }

    static class PgBooleanConverter
    implements ClientSideStatementValueConverter<Boolean> {
        public PgBooleanConverter(String allowedValues) {
        }

        @Override
        public Class<Boolean> getParameterClass() {
            return Boolean.class;
        }

        @Override
        public Boolean convert(String value) {
            if (value == null) {
                return null;
            }
            if (value.length() > 1 && (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\""))) {
                value = value.substring(1, value.length() - 1);
            }
            if ("true".equalsIgnoreCase(value) || "tru".equalsIgnoreCase(value) || "tr".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "ye".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value) || "fals".equalsIgnoreCase(value) || "fal".equalsIgnoreCase(value) || "fa".equalsIgnoreCase(value) || "f".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value) || "of".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "n".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    static class BooleanConverter
    implements ClientSideStatementValueConverter<Boolean> {
        static final BooleanConverter INSTANCE = new BooleanConverter();

        private BooleanConverter() {
        }

        public BooleanConverter(String allowedValues) {
        }

        @Override
        public Class<Boolean> getParameterClass() {
            return Boolean.class;
        }

        @Override
        public Boolean convert(String value) {
            if ("true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static final class CaseInsensitiveEnumMap<E extends Enum<E>> {
        private final Map<String, E> map = new HashMap<String, E>();

        private CaseInsensitiveEnumMap(Class<E> elementType) {
            this(elementType, Enum::name);
        }

        private CaseInsensitiveEnumMap(Class<E> elementType, Function<E, String> keyFunction) {
            Preconditions.checkNotNull(elementType);
            Preconditions.checkNotNull(keyFunction);
            EnumSet<Enum> set = EnumSet.allOf(elementType);
            for (Enum e : set) {
                if (this.map.put(((String)keyFunction.apply((Object)e)).toUpperCase(), e) == null) continue;
                throw new IllegalArgumentException("Enum contains multiple elements with the same case-insensitive key");
            }
        }

        private E get(String value) {
            Preconditions.checkNotNull((Object)value);
            return (E)((Enum)this.map.get(value.toUpperCase()));
        }
    }
}

