/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.testing;

import com.google.api.core.ApiFunction;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.base.Strings;
import io.grpc.ManagedChannelBuilder;

public class ExperimentalHostHelper {
    private static final String EXPERIMENTAL_HOST = "spanner.experimental_host";
    private static final String USE_PLAIN_TEXT = "spanner.use_plain_text";
    private static final String USE_MTLS = "spanner.mtls";
    private static final String CLIENT_CERT_PATH = "spanner.client_cert_path";
    private static final String CLIENT_CERT_KEY_PATH = "spanner.client_cert_key_path";

    public static boolean isExperimentalHost() {
        return !Strings.isNullOrEmpty((String)System.getProperty(EXPERIMENTAL_HOST));
    }

    public static void appendExperimentalHost(StringBuilder uri) {
        uri.append(";isExperimentalHost=true");
        if (ExperimentalHostHelper.isMtlsSetup()) {
            String clientCertificate = System.getProperty(CLIENT_CERT_PATH, "");
            String clientKey = System.getProperty(CLIENT_CERT_KEY_PATH, "");
            uri.append(";clientCertificate=").append(clientCertificate);
            uri.append(";clientKey=").append(clientKey);
        }
    }

    public static boolean isMtlsSetup() {
        return Boolean.getBoolean(USE_MTLS);
    }

    public static void setExperimentalHostSpannerOptions(SpannerOptions.Builder builder) {
        String experimentalHost = System.getProperty(EXPERIMENTAL_HOST, "");
        boolean usePlainText = Boolean.getBoolean(USE_PLAIN_TEXT);
        builder.setExperimentalHost(experimentalHost);
        builder.setBuiltInMetricsEnabled(false);
        if (usePlainText) {
            builder.setChannelConfigurator((ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>)((ApiFunction)ManagedChannelBuilder::usePlaintext)).setCredentials((Credentials)NoCredentials.getInstance());
        }
        if (ExperimentalHostHelper.isMtlsSetup()) {
            String clientCertificate = System.getProperty(CLIENT_CERT_PATH, "");
            String clientKey = System.getProperty(CLIENT_CERT_KEY_PATH, "");
            builder.useClientCert(clientCertificate, clientKey);
        }
    }
}

