/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.cloud.spanner.BuiltInMetricsView;
import com.google.cloud.spanner.SpannerCloudMonitoringExporter;
import com.google.common.base.Strings;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.grpc.ManagedChannelBuilder;
import io.grpc.opentelemetry.GrpcOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class BuiltInMetricsProvider {
    static BuiltInMetricsProvider INSTANCE = new BuiltInMetricsProvider();
    private static final Logger logger = Logger.getLogger(BuiltInMetricsProvider.class.getName());
    private static String taskId;
    private static String location;
    private static final String default_location = "global";
    private OpenTelemetry openTelemetry;

    private BuiltInMetricsProvider() {
    }

    OpenTelemetry getOrCreateOpenTelemetry(String projectId, @Nullable Credentials credentials, @Nullable String monitoringHost, String universeDomain) {
        try {
            if (this.openTelemetry == null) {
                SdkMeterProviderBuilder sdkMeterProviderBuilder = SdkMeterProvider.builder();
                BuiltInMetricsView.registerBuiltinMetrics(SpannerCloudMonitoringExporter.create(projectId, credentials, monitoringHost, universeDomain), sdkMeterProviderBuilder);
                sdkMeterProviderBuilder.setResource(Resource.create((Attributes)this.createResourceAttributes(projectId)));
                SdkMeterProvider sdkMeterProvider = sdkMeterProviderBuilder.build();
                this.openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProvider).build();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkMeterProvider)sdkMeterProvider).close()));
            }
            return this.openTelemetry;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Unable to get OpenTelemetry object for client side metrics, will skip exporting client side metrics", ex);
            return null;
        }
    }

    static boolean quickCheckIsRunningOnGcp() {
        block9: {
            boolean bl;
            int timeout = 5000;
            try {
                timeout = Integer.parseInt(System.getProperty("spanner.check_is_running_on_gcp_timeout", "5000"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            URL url = new URL("http://metadata.google.internal/computeMetadata/v1/project/project-id");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setRequestProperty("Metadata-Flavor", "Google");
            if (connection.getResponseCode() != 200 || !"Google".equals(connection.getHeaderField("Metadata-Flavor"))) break block9;
            InputStream input = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            try {
                bl = !Strings.isNullOrEmpty((String)reader.readLine());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            reader.close();
            return bl;
        }
        return false;
    }

    void enableGrpcMetrics(InstantiatingGrpcChannelProvider.Builder channelProviderBuilder, String projectId, @Nullable Credentials credentials, @Nullable String monitoringHost, String universeDomain) {
        GrpcOpenTelemetry grpcOpenTelemetry = GrpcOpenTelemetry.newBuilder().sdk(this.getOrCreateOpenTelemetry(projectId, credentials, monitoringHost, universeDomain)).enableMetrics(BuiltInMetricsConstant.GRPC_METRICS_TO_ENABLE).disableMetrics(BuiltInMetricsConstant.GRPC_METRICS_ENABLED_BY_DEFAULT).build();
        ApiFunction channelConfigurator = channelProviderBuilder.getChannelConfigurator();
        channelProviderBuilder.setChannelConfigurator(b -> {
            grpcOpenTelemetry.configureChannelBuilder(b);
            if (channelConfigurator != null) {
                return (ManagedChannelBuilder)channelConfigurator.apply(b);
            }
            return b;
        });
    }

    Attributes createResourceAttributes(String projectId) {
        AttributesBuilder attributesBuilder = Attributes.builder().put(BuiltInMetricsConstant.PROJECT_ID_KEY.getKey(), projectId).put(BuiltInMetricsConstant.INSTANCE_CONFIG_ID_KEY.getKey(), "unknown").put(BuiltInMetricsConstant.CLIENT_HASH_KEY.getKey(), BuiltInMetricsProvider.generateClientHash(BuiltInMetricsProvider.getDefaultTaskValue())).put(BuiltInMetricsConstant.INSTANCE_ID_KEY.getKey(), "unknown").put(BuiltInMetricsConstant.LOCATION_ID_KEY.getKey(), BuiltInMetricsProvider.detectClientLocation());
        return attributesBuilder.build();
    }

    Map<String, String> createClientAttributes() {
        HashMap<String, String> clientAttributes = new HashMap<String, String>();
        clientAttributes.put(BuiltInMetricsConstant.CLIENT_NAME_KEY.getKey(), "spanner-java/" + GaxProperties.getLibraryVersion(this.getClass()));
        clientAttributes.put(BuiltInMetricsConstant.CLIENT_UID_KEY.getKey(), BuiltInMetricsProvider.getDefaultTaskValue());
        return clientAttributes;
    }

    static String generateClientHash(String clientUid) {
        if (clientUid == null) {
            return "000000";
        }
        HashFunction hashFunction = Hashing.goodFastHash((int)64);
        Long hash = hashFunction.hashBytes(clientUid.getBytes()).asLong();
        int kPrefixLength = 10;
        long shiftedValue = hash >>> 64 - kPrefixLength;
        return String.format("%06x", shiftedValue);
    }

    static String detectClientLocation() {
        if (location == null) {
            location = default_location;
            if (BuiltInMetricsProvider.quickCheckIsRunningOnGcp()) {
                GCPPlatformDetector detector = GCPPlatformDetector.DEFAULT_INSTANCE;
                DetectedPlatform detectedPlatform = detector.detectPlatform();
                String region = (String)detectedPlatform.getAttributes().get("cloud_region");
                if (detectedPlatform.getSupportedPlatform() == GCPPlatformDetector.SupportedPlatform.GOOGLE_KUBERNETES_ENGINE) {
                    region = (String)detectedPlatform.getAttributes().get("gke_cluster_location");
                }
                location = region == null ? location : region;
            }
        }
        return location;
    }

    private static String getDefaultTaskValue() {
        if (taskId == null) {
            String identifier = UUID.randomUUID().toString();
            String pid = BuiltInMetricsProvider.getProcessId();
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                taskId = identifier + "@" + pid + "@" + hostname;
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
                taskId = identifier + "@" + pid + "@localhost";
            }
        }
        return taskId;
    }

    private static String getProcessId() {
        try {
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
            Object processHandleInstance = currentMethod.invoke(null, new Object[0]);
            Method pidMethod = processHandleClass.getMethod("pid", new Class[0]);
            long pid = (Long)pidMethod.invoke(processHandleInstance, new Object[0]);
            return Long.toString(pid);
        }
        catch (Exception e) {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            if (jvmName != null && jvmName.contains("@")) {
                return jvmName.split("@")[0];
            }
            return "unknown";
        }
    }
}

