/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.paging.Page;
import com.google.cloud.BaseService;
import com.google.cloud.PageImpl;
import com.google.cloud.ServiceOptions;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchClientImpl;
import com.google.cloud.spanner.DatabaseAdminClientImpl;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DecodeMode;
import com.google.cloud.spanner.InstanceAdminClientImpl;
import com.google.cloud.spanner.MultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminClient;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminClient;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.opencensus.metrics.LabelValue;
import io.opencensus.trace.Tracing;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class SpannerImpl
extends BaseService<SpannerOptions>
implements Spanner {
    private static final Logger logger = Logger.getLogger(SpannerImpl.class.getName());
    final TraceWrapper tracer = new TraceWrapper(Tracing.getTracer(), ((SpannerOptions)this.getOptions()).getOpenTelemetry().getTracer("cloud.google.com/java", GaxProperties.getLibraryVersion(((Object)((Object)((SpannerOptions)this.getOptions()))).getClass())), ((SpannerOptions)this.getOptions()).isEnableExtendedTracing());
    static final String CREATE_MULTIPLEXED_SESSION = "CloudSpannerOperation.CreateMultiplexedSession";
    static final String CREATE_SESSION = "CloudSpannerOperation.CreateSession";
    static final String BATCH_CREATE_SESSIONS = "CloudSpannerOperation.BatchCreateSessions";
    static final String BATCH_CREATE_SESSIONS_REQUEST = "CloudSpannerOperation.BatchCreateSessionsRequest";
    static final String DELETE_SESSION = "CloudSpannerOperation.DeleteSession";
    static final String BEGIN_TRANSACTION = "CloudSpannerOperation.BeginTransaction";
    static final String COMMIT = "CloudSpannerOperation.Commit";
    static final String QUERY = "CloudSpannerOperation.ExecuteStreamingQuery";
    static final String READ = "CloudSpannerOperation.ExecuteStreamingRead";
    static final String BATCH_WRITE = "CloudSpannerOperation.BatchWrite";
    static final String UPDATE = "CloudSpannerOperation.ExecuteUpdate";
    static final String BATCH_UPDATE = "CloudSpannerOperation.BatchUpdate";
    private static final Object CLIENT_ID_LOCK = new Object();
    @GuardedBy(value="CLIENT_ID_LOCK")
    private static final Map<DatabaseId, Long> CLIENT_IDS = new HashMap<DatabaseId, Long>();
    private final SpannerRpc gapicRpc;
    @GuardedBy(value="this")
    private final Map<DatabaseId, DatabaseClientImpl> dbClients = new HashMap<DatabaseId, DatabaseClientImpl>();
    @GuardedBy(value="dbBatchClientLock")
    private final Map<DatabaseId, BatchClientImpl> dbBatchClients = new HashMap<DatabaseId, BatchClientImpl>();
    private final ReentrantLock dbBatchClientLock = new ReentrantLock();
    private final SpannerOptions.CloseableExecutorProvider asyncExecutorProvider;
    @GuardedBy(value="this")
    private final Map<DatabaseId, SessionClient> sessionClients = new HashMap<DatabaseId, SessionClient>();
    private final com.google.cloud.spanner.DatabaseAdminClient dbAdminClient;
    private final com.google.cloud.spanner.InstanceAdminClient instanceClient;
    @GuardedBy(value="this")
    private ClosedException closedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String nextDatabaseClientId(DatabaseId databaseId) {
        Object object = CLIENT_ID_LOCK;
        synchronized (object) {
            Long id = CLIENT_IDS.get(databaseId);
            if (id == null) {
                id = 1L;
            } else {
                Long l = id;
                id = id + 1L;
            }
            CLIENT_IDS.put(databaseId, id);
            return String.format("client-%d", id);
        }
    }

    @VisibleForTesting
    SpannerImpl(SpannerRpc gapicRpc, SpannerOptions options) {
        super((ServiceOptions)options);
        this.gapicRpc = gapicRpc;
        this.asyncExecutorProvider = (SpannerOptions.CloseableExecutorProvider)MoreObjects.firstNonNull((Object)options.getAsyncExecutorProvider(), (Object)SpannerOptions.createDefaultAsyncExecutorProvider());
        this.dbAdminClient = new DatabaseAdminClientImpl(options.getProjectId(), gapicRpc);
        this.instanceClient = new InstanceAdminClientImpl(options.getProjectId(), gapicRpc, this.dbAdminClient);
        this.logSpannerOptions(options);
    }

    SpannerImpl(SpannerOptions options) {
        this(options.getSpannerRpcV1(), options);
    }

    private void logSpannerOptions(SpannerOptions options) {
        logger.log(Level.INFO, "Spanner options: \nProject ID: " + options.getProjectId() + "\nHost: " + options.getHost() + "\nNum gRPC channels: " + options.getNumChannels() + "\nLeader aware routing enabled: " + options.isLeaderAwareRoutingEnabled() + "\nDirect access enabled: " + options.isEnableDirectAccess() + "\nActive Tracing Framework: " + (Object)((Object)SpannerOptions.getActiveTracingFramework()) + "\nAPI tracing enabled: " + options.isEnableApiTracing() + "\nExtended tracing enabled: " + options.isEnableExtendedTracing() + "\nEnd to end tracing enabled: " + options.isEndToEndTracingEnabled() + "\nBuilt-in metrics enabled: " + options.isEnableBuiltInMetrics());
        if (options.getSessionPoolOptions() != null) {
            logger.log(Level.INFO, "Session pool options: \nSession pool min sessions: " + options.getSessionPoolOptions().getMinSessions() + "\nSession pool max sessions: " + options.getSessionPoolOptions().getMaxSessions() + "\nMultiplexed sessions enabled: " + options.getSessionPoolOptions().getUseMultiplexedSession() + "\nMultiplexed sessions enabled for RW: " + options.getSessionPoolOptions().getUseMultiplexedSessionForRW() + "\nMultiplexed sessions enabled for blind write: " + options.getSessionPoolOptions().getUseMultiplexedSessionBlindWrite() + "\nMultiplexed sessions enabled for partitioned ops: " + options.getSessionPoolOptions().getUseMultiplexedSessionPartitionedOps());
        }
    }

    SpannerRpc getRpc() {
        return this.gapicRpc;
    }

    int getDefaultPrefetchChunks() {
        return ((SpannerOptions)this.getOptions()).getPrefetchChunks();
    }

    DecodeMode getDefaultDecodeMode() {
        return ((SpannerOptions)this.getOptions()).getDecodeMode();
    }

    ExecuteSqlRequest.QueryOptions getDefaultQueryOptions(DatabaseId databaseId) {
        return ((SpannerOptions)this.getOptions()).getDefaultQueryOptions(databaseId);
    }

    TraceWrapper getTracer() {
        return this.tracer;
    }

    @Override
    public ExecutorProvider getAsyncExecutorProvider() {
        return this.asyncExecutorProvider;
    }

    SessionImpl sessionWithId(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        SessionClient.SessionId id = SessionClient.SessionId.of(name);
        return this.getSessionClient(id.getDatabaseId()).sessionWithId(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClosed() {
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            if (this.closedException != null) {
                throw new IllegalStateException("Cloud Spanner client has been closed", this.closedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionClient getSessionClient(DatabaseId db) {
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            this.checkClosed();
            if (this.sessionClients.containsKey(db)) {
                return this.sessionClients.get(db);
            }
            SessionClient client = new SessionClient(this, db, (GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService>)((GrpcTransportOptions)((SpannerOptions)this.getOptions()).getTransportOptions()).getExecutorFactory());
            this.sessionClients.put(db, client);
            return client;
        }
    }

    @Override
    public com.google.cloud.spanner.DatabaseAdminClient getDatabaseAdminClient() {
        return this.dbAdminClient;
    }

    @Override
    public DatabaseAdminClient createDatabaseAdminClient() {
        try {
            DatabaseAdminStubSettings settings = (DatabaseAdminStubSettings)((Object)Preconditions.checkNotNull((Object)((Object)this.gapicRpc.getDatabaseAdminStubSettings())));
            return DatabaseAdminClient.create(settings.createStub());
        }
        catch (IOException ex) {
            throw SpannerExceptionFactory.newSpannerException(ex);
        }
    }

    @Override
    public com.google.cloud.spanner.InstanceAdminClient getInstanceAdminClient() {
        return this.instanceClient;
    }

    @Override
    public InstanceAdminClient createInstanceAdminClient() {
        try {
            InstanceAdminStubSettings settings = (InstanceAdminStubSettings)((Object)Preconditions.checkNotNull((Object)((Object)this.gapicRpc.getInstanceAdminStubSettings())));
            return InstanceAdminClient.create(settings.createStub());
        }
        catch (IOException ex) {
            throw SpannerExceptionFactory.newSpannerException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseClient getDatabaseClient(DatabaseId db) {
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            this.checkClosed();
            String clientId = null;
            if (this.dbClients.containsKey(db) && !this.dbClients.get(db).isValid()) {
                this.dbClients.get(db).closeAsync(new ClosedException());
                clientId = this.dbClients.get((Object)db).clientId;
                this.dbClients.remove(db);
            }
            if (this.dbClients.containsKey(db)) {
                return this.dbClients.get(db);
            }
            if (clientId == null) {
                clientId = SpannerImpl.nextDatabaseClientId(db);
            }
            ImmutableList labelValues = ImmutableList.of((Object)LabelValue.create(clientId), (Object)LabelValue.create((String)db.getDatabase()), (Object)LabelValue.create((String)db.getInstanceId().getName()), (Object)LabelValue.create((String)GaxProperties.getLibraryVersion(((Object)((Object)((SpannerOptions)this.getOptions()))).getClass())));
            AttributesBuilder attributesBuilder = Attributes.builder();
            attributesBuilder.put("client_id", clientId);
            attributesBuilder.put("database", db.getDatabase());
            attributesBuilder.put("instance_id", db.getInstanceId().getName());
            boolean useMultiplexedSession = ((SpannerOptions)this.getOptions()).getSessionPoolOptions().getUseMultiplexedSession();
            boolean useMultiplexedSessionForRW = ((SpannerOptions)this.getOptions()).getSessionPoolOptions().getUseMultiplexedSessionForRW();
            MultiplexedSessionDatabaseClient multiplexedSessionDatabaseClient = useMultiplexedSession ? new MultiplexedSessionDatabaseClient(this.getSessionClient(db)) : null;
            AtomicLong numMultiplexedSessionsAcquired = useMultiplexedSession ? multiplexedSessionDatabaseClient.getNumSessionsAcquired() : new AtomicLong();
            AtomicLong numMultiplexedSessionsReleased = useMultiplexedSession ? multiplexedSessionDatabaseClient.getNumSessionsReleased() : new AtomicLong();
            SessionPool pool = SessionPool.createPool((SpannerOptions)this.getOptions(), this.getSessionClient(db), this.tracer, (List<LabelValue>)labelValues, attributesBuilder.build(), numMultiplexedSessionsAcquired, numMultiplexedSessionsReleased);
            pool.maybeWaitOnMinSessions();
            DatabaseClientImpl dbClient = this.createDatabaseClient(clientId, pool, ((SpannerOptions)this.getOptions()).getSessionPoolOptions().getUseMultiplexedSessionBlindWrite(), multiplexedSessionDatabaseClient, ((SpannerOptions)this.getOptions()).getSessionPoolOptions().getUseMultiplexedSessionPartitionedOps(), useMultiplexedSessionForRW, this.tracer.createCommonAttributes(db));
            this.dbClients.put(db, dbClient);
            return dbClient;
        }
    }

    @VisibleForTesting
    DatabaseClientImpl createDatabaseClient(String clientId, SessionPool pool, boolean useMultiplexedSessionBlindWrite, @Nullable MultiplexedSessionDatabaseClient multiplexedSessionClient, boolean useMultiplexedSessionPartitionedOps, boolean useMultiplexedSessionForRW, Attributes commonAttributes) {
        if (multiplexedSessionClient != null) {
            multiplexedSessionClient.setPool(pool);
        }
        return new DatabaseClientImpl(clientId, pool, useMultiplexedSessionBlindWrite, multiplexedSessionClient, useMultiplexedSessionPartitionedOps, this.tracer, useMultiplexedSessionForRW, commonAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchClient getBatchClient(DatabaseId db) {
        if (((SpannerOptions)this.getOptions()).getSessionPoolOptions().getUseMultiplexedSessionPartitionedOps()) {
            this.dbBatchClientLock.lock();
            try {
                if (this.dbBatchClients.containsKey(db)) {
                    BatchClient batchClient = this.dbBatchClients.get(db);
                    return batchClient;
                }
                BatchClientImpl batchClient = new BatchClientImpl(this.getSessionClient(db), true);
                this.dbBatchClients.put(db, batchClient);
                BatchClientImpl batchClientImpl = batchClient;
                return batchClientImpl;
            }
            finally {
                this.dbBatchClientLock.unlock();
            }
        }
        return new BatchClientImpl(this.getSessionClient(db), false);
    }

    @Override
    public void close() {
        this.close(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(long timeout, TimeUnit unit) {
        Iterator<SessionClient> iterator = this;
        synchronized (iterator) {
            this.checkClosed();
            this.closedException = new ClosedException();
        }
        try {
            ArrayList<ListenableFuture<Void>> closureFutures = new ArrayList<ListenableFuture<Void>>();
            for (DatabaseClientImpl dbClient : this.dbClients.values()) {
                closureFutures.add(dbClient.closeAsync(this.closedException));
            }
            this.dbClients.clear();
            Futures.successfulAsList(closureFutures).get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
        finally {
            for (SessionClient sessionClient : this.sessionClients.values()) {
                sessionClient.close();
            }
            this.sessionClients.clear();
            this.asyncExecutorProvider.close();
            try {
                if (timeout == Long.MAX_VALUE || !(this.gapicRpc instanceof GapicSpannerRpc)) {
                    this.gapicRpc.shutdown();
                } else {
                    ((GapicSpannerRpc)this.gapicRpc).shutdownNow();
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Failed to close channels", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            return this.closedException != null;
        }
    }

    static final class ClosedException
    extends RuntimeException {
        private static final long serialVersionUID = 1451131180314064914L;

        ClosedException() {
            super("Spanner client was closed at " + Instant.now());
        }
    }

    static abstract class PageFetcher<S, T>
    implements PageImpl.NextPageFetcher<S> {
        private String nextPageToken;

        PageFetcher() {
        }

        public Page<S> getNextPage() {
            SpannerRpc.Paginated<T> nextPage = this.getNextPage(this.nextPageToken);
            this.nextPageToken = nextPage.getNextPageToken();
            ArrayList<S> results = new ArrayList<S>();
            for (T proto : nextPage.getResults()) {
                results.add(this.fromProto(proto));
            }
            return new PageImpl((PageImpl.NextPageFetcher)this, this.nextPageToken, results);
        }

        void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        abstract SpannerRpc.Paginated<T> getNextPage(@Nullable String var1);

        abstract S fromProto(T var1);
    }
}

