/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.GaxProperties;
import com.google.cloud.ByteArray;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.AsyncStatementResult;
import com.google.cloud.spanner.connection.AsyncStatementResultImpl;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ConnectionProperties;
import com.google.cloud.spanner.connection.ConnectionProperty;
import com.google.cloud.spanner.connection.ConnectionState;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.DdlBatch;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.DdlInTransactionMode;
import com.google.cloud.spanner.connection.DmlBatch;
import com.google.cloud.spanner.connection.EmulatorUtil;
import com.google.cloud.spanner.connection.MergedResultSet;
import com.google.cloud.spanner.connection.PartitionId;
import com.google.cloud.spanner.connection.PartitionedQueryResultSet;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.ReadOnlyTransaction;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.SingleUseTransaction;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.StatementResultImpl;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.TransactionRunnerImpl;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Duration;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.TransactionOptions;
import io.grpc.Deadline;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ConnectionImpl
implements Connection {
    private static final String INSTRUMENTATION_SCOPE = "cloud.google.com/java";
    private static final String SINGLE_USE_TRANSACTION = "SingleUseTransaction";
    private static final String READ_ONLY_TRANSACTION = "ReadOnlyTransaction";
    private static final String READ_WRITE_TRANSACTION = "ReadWriteTransaction";
    private static final String DDL_BATCH = "DdlBatch";
    private static final String DDL_STATEMENT = "DdlStatement";
    private static final String CLOSED_ERROR_MSG = "This connection is closed";
    private static final String ONLY_ALLOWED_IN_AUTOCOMMIT = "This method may only be called while in autocommit mode";
    private static final String NOT_ALLOWED_IN_AUTOCOMMIT = "This method may not be called while in autocommit mode";
    private static final AbstractStatementParser.ParsedStatement COMMIT_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("COMMIT"));
    private static final AbstractStatementParser.ParsedStatement ROLLBACK_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("ROLLBACK"));
    private static final AbstractStatementParser.ParsedStatement START_BATCH_DDL_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("START BATCH DDL"));
    private static final AbstractStatementParser.ParsedStatement START_BATCH_DML_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("START BATCH DML"));
    private static final AbstractStatementParser.ParsedStatement SAVEPOINT_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("SAVEPOINT s1"));
    private static final AbstractStatementParser.ParsedStatement ROLLBACK_TO_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("ROLLBACK TO s1"));
    private static final AbstractStatementParser.ParsedStatement RELEASE_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("RELEASE s1"));
    private volatile LeakedConnectionException leakedException;
    private final SpannerPool spannerPool;
    private AbstractStatementParser statementParser;
    private final ConnectionStatementExecutor connectionStatementExecutor = new ConnectionStatementExecutorImpl(this);
    private final StatementExecutor statementExecutor;
    private final ConnectionOptions options;
    private final Deadline.Ticker ticker;
    private StatementExecutor.StatementTimeout statementTimeout = new StatementExecutor.StatementTimeout();
    private boolean closed = false;
    private final Spanner spanner;
    private final Tracer tracer;
    private final Attributes openTelemetryAttributes;
    private final DdlClient ddlClient;
    private final DatabaseClient dbClient;
    private final BatchClient batchClient;
    private final ConnectionState connectionState;
    private UnitOfWork currentUnitOfWork = null;
    private boolean inTransaction = false;
    private boolean transactionBeginMarked = false;
    private boolean transactionRunnerActive = false;
    private BatchMode batchMode;
    private UnitOfWorkType unitOfWorkType;
    private final Stack<UnitOfWork> transactionStack = new Stack();
    private final List<TransactionRetryListener> transactionRetryListeners = new ArrayList<TransactionRetryListener>();
    private TransactionOptions.IsolationLevel transactionIsolationLevel;
    private String transactionTag;
    private String statementTag;
    private boolean excludeTxnFromChangeStreams;
    private byte[] protoDescriptors;
    private String protoDescriptorsFilePath;
    private final Commit commit = new Commit();
    private final Rollback rollback = new Rollback();

    ConnectionImpl(ConnectionOptions options) {
        Preconditions.checkNotNull((Object)options);
        LeakedConnectionException leakedConnectionException = this.leakedException = options.isTrackConnectionLeaks() ? new LeakedConnectionException() : null;
        StatementExecutor.StatementExecutorType statementExecutorType = options.getStatementExecutorType() != null ? options.getStatementExecutorType() : (options.isUseVirtualThreads() ? StatementExecutor.StatementExecutorType.VIRTUAL_THREAD : StatementExecutor.StatementExecutorType.PLATFORM_THREAD);
        this.ticker = options.getTicker();
        this.statementExecutor = new StatementExecutor(statementExecutorType, options.getStatementExecutionInterceptors());
        this.spannerPool = SpannerPool.INSTANCE;
        this.options = options;
        this.spanner = this.spannerPool.getSpanner(options, this);
        this.tracer = ((SpannerOptions)this.spanner.getOptions()).getOpenTelemetry().getTracer(INSTRUMENTATION_SCOPE, GaxProperties.getLibraryVersion(((Object)((Object)((SpannerOptions)this.spanner.getOptions()))).getClass()));
        this.openTelemetryAttributes = ConnectionImpl.createOpenTelemetryAttributes(options.getDatabaseId());
        if (options.isAutoConfigEmulator()) {
            EmulatorUtil.maybeCreateInstanceAndDatabase(this.spanner, options.getDatabaseId(), options.getDialect());
        }
        this.dbClient = this.spanner.getDatabaseClient(options.getDatabaseId());
        this.batchClient = this.spanner.getBatchClient(options.getDatabaseId());
        this.ddlClient = this.createDdlClient();
        this.connectionState = new ConnectionState(options.getInitialConnectionPropertyValues(), (Supplier<ConnectionState.Type>)Suppliers.memoize(() -> ConnectionOptions.isEnableTransactionalConnectionStateForPostgreSQL() && this.getDialect() == Dialect.POSTGRESQL ? ConnectionState.Type.TRANSACTIONAL : ConnectionState.Type.NON_TRANSACTIONAL));
        this.setInitialStatementTimeout(options.getInitialConnectionPropertyValue(ConnectionProperties.STATEMENT_TIMEOUT));
        this.setDefaultTransactionOptions(this.getDefaultIsolationLevel());
    }

    @VisibleForTesting
    ConnectionImpl(ConnectionOptions options, SpannerPool spannerPool, DdlClient ddlClient, DatabaseClient dbClient, BatchClient batchClient) {
        this.leakedException = options.isTrackConnectionLeaks() ? new LeakedConnectionException() : null;
        this.statementExecutor = new StatementExecutor(options.isUseVirtualThreads() ? StatementExecutor.StatementExecutorType.VIRTUAL_THREAD : StatementExecutor.StatementExecutorType.PLATFORM_THREAD, Collections.emptyList());
        this.ticker = options.getTicker();
        this.spannerPool = (SpannerPool)Preconditions.checkNotNull((Object)spannerPool);
        this.options = (ConnectionOptions)Preconditions.checkNotNull((Object)options);
        this.spanner = spannerPool.getSpanner(options, this);
        this.tracer = OpenTelemetry.noop().getTracer(INSTRUMENTATION_SCOPE);
        this.openTelemetryAttributes = Attributes.empty();
        this.ddlClient = (DdlClient)Preconditions.checkNotNull((Object)ddlClient);
        this.dbClient = (DatabaseClient)Preconditions.checkNotNull((Object)dbClient);
        this.batchClient = (BatchClient)Preconditions.checkNotNull((Object)batchClient);
        this.connectionState = new ConnectionState(options.getInitialConnectionPropertyValues(), (Supplier<ConnectionState.Type>)Suppliers.ofInstance((Object)((Object)ConnectionState.Type.NON_TRANSACTIONAL)));
        this.setInitialStatementTimeout(options.getInitialConnectionPropertyValue(ConnectionProperties.STATEMENT_TIMEOUT));
        this.setReadOnly(options.isReadOnly());
        this.setAutocommit(options.isAutocommit());
        this.setReturnCommitStats(options.isReturnCommitStats());
        this.setDefaultTransactionOptions(this.getDefaultIsolationLevel());
    }

    @Override
    public Spanner getSpanner() {
        return this.spanner;
    }

    private void setInitialStatementTimeout(java.time.Duration duration) {
        if (duration == null || duration.isZero()) {
            return;
        }
        Duration protoDuration = Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano()).build();
        TimeUnit unit = ReadOnlyStalenessUtil.getAppropriateTimeUnit(new ReadOnlyStalenessUtil.DurationGetter(protoDuration));
        this.setStatementTimeout(ReadOnlyStalenessUtil.durationToUnits(protoDuration, unit), unit);
    }

    private DdlClient createDdlClient() {
        return DdlClient.newBuilder().setDatabaseAdminClient(this.spanner.getDatabaseAdminClient()).setDialectSupplier(this::getDialect).setProjectId(this.options.getProjectId()).setInstanceId(this.options.getInstanceId()).setDatabaseName(this.options.getDatabaseName()).build();
    }

    private AbstractStatementParser getStatementParser() {
        if (this.statementParser == null) {
            this.statementParser = AbstractStatementParser.getInstance(this.dbClient.getDialect());
        }
        return this.statementParser;
    }

    Attributes getOpenTelemetryAttributes() {
        return this.openTelemetryAttributes;
    }

    @VisibleForTesting
    static Attributes createOpenTelemetryAttributes(DatabaseId databaseId) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put("connection_id", UUID.randomUUID().toString());
        attributesBuilder.put("database", databaseId.getDatabase());
        attributesBuilder.put("instance_id", databaseId.getInstanceId().getInstance());
        attributesBuilder.put("project_id", databaseId.getInstanceId().getProject());
        return attributesBuilder.build();
    }

    @VisibleForTesting
    ConnectionState.Type getConnectionStateType() {
        return this.connectionState.getType();
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get(10L, TimeUnit.SECONDS);
        }
        catch (SpannerException | InterruptedException | ExecutionException | TimeoutException object) {
        }
        finally {
            this.statementExecutor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Void> closeAsync() {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed()) {
                ArrayList<ApiFuture<Void>> futures = new ArrayList<ApiFuture<Void>>();
                if (this.isBatchActive()) {
                    this.abortBatch();
                }
                if (this.isTransactionStarted()) {
                    try {
                        futures.add(this.rollbackAsync());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.closed = true;
                try {
                    futures.add(this.statementExecutor.submit(() -> null));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
                this.statementExecutor.shutdown();
                this.leakedException = null;
                this.spannerPool.removeConnection(this.options, this);
                return ApiFutures.transform((ApiFuture)ApiFutures.allAsList(futures), ignored -> null, (Executor)MoreExecutors.directExecutor());
            }
        }
        return ApiFutures.immediateFuture(null);
    }

    private ConnectionProperty.Context getCurrentContext() {
        return ConnectionProperty.Context.USER;
    }

    @Override
    public void reset() {
        this.reset(this.getCurrentContext(), this.isInTransaction());
    }

    private void reset(ConnectionProperty.Context context, boolean inTransaction) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.connectionState.resetValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.AUTOCOMMIT, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.READONLY, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.DEFAULT_ISOLATION_LEVEL, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.READ_LOCK_MODE, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.TRANSACTION_TIMEOUT, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.READ_ONLY_STALENESS, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.OPTIMIZER_VERSION, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.OPTIMIZER_STATISTICS_PACKAGE, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.RPC_PRIORITY, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.DDL_IN_TRANSACTION_MODE, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.RETURN_COMMIT_STATS, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.KEEP_TRANSACTION_ALIVE, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.AUTO_PARTITION_MODE, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.DATA_BOOST_ENABLED, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.MAX_PARTITIONS, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.MAX_PARTITIONED_PARALLELISM, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.MAX_COMMIT_DELAY, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.AUTOCOMMIT_DML_MODE, context, inTransaction);
        this.statementTag = null;
        this.statementTimeout = new StatementExecutor.StatementTimeout();
        this.connectionState.resetValue(ConnectionProperties.DIRECTED_READ, context, inTransaction);
        this.connectionState.resetValue(ConnectionProperties.SAVEPOINT_SUPPORT, context, inTransaction);
        this.protoDescriptors = null;
        this.protoDescriptorsFilePath = null;
        if (!this.isTransactionStarted()) {
            this.setDefaultTransactionOptions(this.getDefaultIsolationLevel());
        }
    }

    UnitOfWorkType getUnitOfWorkType() {
        return this.unitOfWorkType;
    }

    boolean isInBatch() {
        return this.batchMode != BatchMode.NONE;
    }

    LeakedConnectionException getLeakedException() {
        return this.leakedException;
    }

    @Override
    public Dialect getDialect() {
        return this.dbClient.getDialect();
    }

    @Override
    public DatabaseClient getDatabaseClient() {
        return this.dbClient;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private <T> T getConnectionPropertyValue(ConnectionProperty<T> property) {
        return this.connectionState.getValue(property).getValue();
    }

    private <T> void setConnectionPropertyValue(ConnectionProperty<T> property, T value) {
        this.setConnectionPropertyValue(property, value, false);
    }

    private <T> void setConnectionPropertyValue(ConnectionProperty<T> property, T value, boolean local) {
        if (local) {
            this.setLocalConnectionPropertyValue(property, value);
        } else {
            this.connectionState.setValue(property, value, this.getCurrentContext(), this.isInTransaction());
        }
    }

    private <T> void setLocalConnectionPropertyValue(ConnectionProperty<T> property, T value) {
        ConnectionPreconditions.checkState(this.isInTransaction(), "SET LOCAL statements are only supported in transactions");
        this.connectionState.setLocalValue(property, value);
    }

    @Override
    public void setAutocommit(boolean autocommit) {
        TimestampBound readOnlyStaleness;
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        if (this.isAutocommit() == autocommit) {
            return;
        }
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set autocommit while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set autocommit while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot set autocommit while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot set autocommit when a transaction has begun");
        this.setConnectionPropertyValue(ConnectionProperties.AUTOCOMMIT, autocommit);
        if (autocommit) {
            this.connectionState.commit();
        }
        this.clearLastTransactionAndSetDefaultTransactionOptions(this.getDefaultIsolationLevel());
        if (!(autocommit || (readOnlyStaleness = this.getReadOnlyStaleness()).getMode() != TimestampBound.Mode.MAX_STALENESS && readOnlyStaleness.getMode() != TimestampBound.Mode.MIN_READ_TIMESTAMP)) {
            this.setConnectionPropertyValue(ConnectionProperties.READ_ONLY_STALENESS, TimestampBound.strong());
        }
    }

    @Override
    public boolean isAutocommit() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsAutocommit();
    }

    private boolean internalIsAutocommit() {
        return this.getConnectionPropertyValue(ConnectionProperties.AUTOCOMMIT);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set read-only while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set read-only while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot set read-only while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot set read-only when a transaction has begun");
        this.setConnectionPropertyValue(ConnectionProperties.READONLY, readOnly);
        this.clearLastTransactionAndSetDefaultTransactionOptions(this.getDefaultIsolationLevel());
    }

    @Override
    public boolean isReadOnly() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.READONLY);
    }

    @Override
    public void setDefaultIsolationLevel(TransactionOptions.IsolationLevel isolationLevel) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot default isolation level while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set default isolation level while a transaction is active");
        this.setConnectionPropertyValue(ConnectionProperties.DEFAULT_ISOLATION_LEVEL, isolationLevel);
        this.clearLastTransactionAndSetDefaultTransactionOptions(isolationLevel);
    }

    @Override
    public TransactionOptions.IsolationLevel getDefaultIsolationLevel() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.DEFAULT_ISOLATION_LEVEL);
    }

    private void clearLastTransactionAndSetDefaultTransactionOptions(TransactionOptions.IsolationLevel isolationLevel) {
        this.setDefaultTransactionOptions(isolationLevel);
        this.currentUnitOfWork = null;
    }

    @Override
    public void setReadLockMode(TransactionOptions.ReadWrite.ReadLockMode readLockMode) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.setConnectionPropertyValue(ConnectionProperties.READ_LOCK_MODE, readLockMode);
    }

    @Override
    public TransactionOptions.ReadWrite.ReadLockMode getReadLockMode() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.READ_LOCK_MODE);
    }

    @Override
    public void setTransactionTimeout(java.time.Duration timeout) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.setConnectionPropertyValue(ConnectionProperties.TRANSACTION_TIMEOUT, timeout);
    }

    @Override
    public java.time.Duration getTransactionTimeout() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.TRANSACTION_TIMEOUT);
    }

    @Nullable
    Deadline getTransactionDeadline() {
        java.time.Duration timeout = this.getTransactionTimeout();
        return timeout == null ? null : Deadline.after((long)timeout.toNanos(), (TimeUnit)TimeUnit.NANOSECONDS, (Deadline.Ticker)this.ticker);
    }

    @Override
    public void setAutocommitDmlMode(AutocommitDmlMode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set autocommit DML mode while in a batch");
        ConnectionPreconditions.checkState(!this.isInTransaction() && this.isAutocommit(), "Cannot set autocommit DML mode while not in autocommit mode or while a transaction is active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot set autocommit DML mode for a read-only connection");
        this.setConnectionPropertyValue(ConnectionProperties.AUTOCOMMIT_DML_MODE, mode);
    }

    @Override
    public AutocommitDmlMode getAutocommitDmlMode() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot get autocommit DML mode while in a batch");
        return this.getConnectionPropertyValue(ConnectionProperties.AUTOCOMMIT_DML_MODE);
    }

    @Override
    public void setReadOnlyStaleness(TimestampBound staleness) {
        Preconditions.checkNotNull((Object)staleness);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set read-only while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set read-only staleness when a transaction has been started");
        if (staleness.getMode() == TimestampBound.Mode.MAX_STALENESS || staleness.getMode() == TimestampBound.Mode.MIN_READ_TIMESTAMP) {
            ConnectionPreconditions.checkState(this.isAutocommit() && !this.inTransaction, "MAX_STALENESS and MIN_READ_TIMESTAMP are only allowed in autocommit mode");
        }
        this.setConnectionPropertyValue(ConnectionProperties.READ_ONLY_STALENESS, staleness);
    }

    @Override
    public TimestampBound getReadOnlyStaleness() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot get read-only while in a batch");
        return this.getConnectionPropertyValue(ConnectionProperties.READ_ONLY_STALENESS);
    }

    @Override
    public void setDirectedRead(DirectedReadOptions directedReadOptions) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set directed read options when a transaction has been started");
        this.setConnectionPropertyValue(ConnectionProperties.DIRECTED_READ, directedReadOptions);
    }

    @Override
    public DirectedReadOptions getDirectedRead() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.DIRECTED_READ);
    }

    @Override
    public void setOptimizerVersion(String optimizerVersion) {
        Preconditions.checkNotNull((Object)optimizerVersion);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.setConnectionPropertyValue(ConnectionProperties.OPTIMIZER_VERSION, optimizerVersion);
    }

    @Override
    public String getOptimizerVersion() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.OPTIMIZER_VERSION);
    }

    @Override
    public void setOptimizerStatisticsPackage(String optimizerStatisticsPackage) {
        Preconditions.checkNotNull((Object)optimizerStatisticsPackage);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.setConnectionPropertyValue(ConnectionProperties.OPTIMIZER_STATISTICS_PACKAGE, optimizerStatisticsPackage);
    }

    @Override
    public String getOptimizerStatisticsPackage() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.OPTIMIZER_STATISTICS_PACKAGE);
    }

    private ExecuteSqlRequest.QueryOptions buildQueryOptions() {
        return ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion(this.getConnectionPropertyValue(ConnectionProperties.OPTIMIZER_VERSION)).setOptimizerStatisticsPackage(this.getConnectionPropertyValue(ConnectionProperties.OPTIMIZER_STATISTICS_PACKAGE)).build();
    }

    @Override
    public void setRPCPriority(Options.RpcPriority rpcPriority) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.setConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY, rpcPriority);
    }

    @Override
    public Options.RpcPriority getRPCPriority() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY);
    }

    @Override
    public DdlInTransactionMode getDdlInTransactionMode() {
        return this.getConnectionPropertyValue(ConnectionProperties.DDL_IN_TRANSACTION_MODE);
    }

    @Override
    public void setDdlInTransactionMode(DdlInTransactionMode ddlInTransactionMode) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set DdlInTransactionMode while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set DdlInTransactionMode while a transaction is active");
        this.setConnectionPropertyValue(ConnectionProperties.DDL_IN_TRANSACTION_MODE, ddlInTransactionMode);
    }

    @Override
    public String getDefaultSequenceKind() {
        return this.getConnectionPropertyValue(ConnectionProperties.DEFAULT_SEQUENCE_KIND);
    }

    @Override
    public void setDefaultSequenceKind(String defaultSequenceKind) {
        this.setConnectionPropertyValue(ConnectionProperties.DEFAULT_SEQUENCE_KIND, defaultSequenceKind);
    }

    @Override
    public void setStatementTimeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"Zero or negative timeout values are not allowed");
        Preconditions.checkArgument((boolean)StatementExecutor.StatementTimeout.isValidTimeoutUnit(unit), (Object)"Time unit must be one of NANOSECONDS, MICROSECONDS, MILLISECONDS or SECONDS");
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.statementTimeout.setTimeoutValue(timeout, unit);
    }

    @Override
    public void clearStatementTimeout() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.statementTimeout.clearTimeoutValue();
    }

    @Override
    public long getStatementTimeout(TimeUnit unit) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        Preconditions.checkArgument((boolean)StatementExecutor.StatementTimeout.isValidTimeoutUnit(unit), (Object)"Time unit must be one of NANOSECONDS, MICROSECONDS, MILLISECONDS or SECONDS");
        return this.statementTimeout.getTimeoutValue(unit);
    }

    @Override
    public boolean hasStatementTimeout() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.statementTimeout.hasTimeout();
    }

    @Override
    public void cancel() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        if (this.currentUnitOfWork != null) {
            this.currentUnitOfWork.cancel();
        }
    }

    @Override
    public TransactionMode getTransactionMode() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isDdlBatchActive(), "This connection is in a DDL batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        return this.unitOfWorkType.getTransactionMode();
    }

    @Override
    public void setTransactionMode(TransactionMode transactionMode) {
        Preconditions.checkNotNull((Object)((Object)transactionMode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set transaction mode while in a batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "The transaction mode cannot be set after the transaction has started");
        ConnectionPreconditions.checkState(!this.isReadOnly() || transactionMode == TransactionMode.READ_ONLY_TRANSACTION, "The transaction mode can only be READ_ONLY when the connection is in read_only mode");
        this.transactionBeginMarked = true;
        this.unitOfWorkType = UnitOfWorkType.of(transactionMode);
    }

    TransactionOptions.IsolationLevel getTransactionIsolationLevel() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isDdlBatchActive(), "This connection is in a DDL batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        return this.transactionIsolationLevel;
    }

    void setTransactionIsolationLevel(TransactionOptions.IsolationLevel isolationLevel) {
        Preconditions.checkNotNull((Object)isolationLevel);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set transaction isolation level while in a batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "The transaction isolation level cannot be set after the transaction has started");
        this.transactionBeginMarked = true;
        this.transactionIsolationLevel = isolationLevel;
    }

    @Override
    public String getTransactionTag() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isDdlBatchActive(), "This connection is in a DDL batch");
        return this.transactionTag;
    }

    @Override
    public void setTransactionTag(String tag) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set transaction tag while in a batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "The transaction tag cannot be set after the transaction has started");
        ConnectionPreconditions.checkState(this.getTransactionMode() == TransactionMode.READ_WRITE_TRANSACTION, "Transaction tag can only be set for a read/write transaction");
        this.transactionBeginMarked = true;
        this.transactionTag = tag;
    }

    @Override
    public String getStatementTag() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Statement tags are not allowed inside a batch");
        return this.statementTag;
    }

    @Override
    public void setStatementTag(String tag) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Statement tags are not allowed inside a batch");
        this.statementTag = tag;
    }

    @Override
    public boolean isExcludeTxnFromChangeStreams() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isDdlBatchActive(), "This connection is in a DDL batch");
        return this.excludeTxnFromChangeStreams;
    }

    @Override
    public void setExcludeTxnFromChangeStreams(boolean excludeTxnFromChangeStreams) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set exclude_txn_from_change_streams while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "exclude_txn_from_change_streams cannot be set after the transaction has started");
        this.excludeTxnFromChangeStreams = excludeTxnFromChangeStreams;
    }

    @Override
    public byte[] getProtoDescriptors() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        if (this.protoDescriptors == null && this.protoDescriptorsFilePath != null) {
            try {
                File protoDescriptorsFile = new File(this.protoDescriptorsFilePath);
                if (!protoDescriptorsFile.isFile()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("File %s is not a valid proto descriptors file", this.protoDescriptorsFilePath));
                }
                InputStream pdStream = Files.newInputStream(protoDescriptorsFile.toPath(), new OpenOption[0]);
                this.protoDescriptors = ByteArray.copyFrom((InputStream)pdStream).toByteArray();
            }
            catch (Exception exception) {
                throw SpannerExceptionFactory.newSpannerException(exception);
            }
        }
        return this.protoDescriptors;
    }

    @Override
    public void setProtoDescriptors(@Nonnull byte[] protoDescriptors) {
        Preconditions.checkNotNull((Object)protoDescriptors);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Proto descriptors cannot be set when a batch is active");
        this.protoDescriptors = protoDescriptors;
        this.protoDescriptorsFilePath = null;
    }

    void setProtoDescriptorsFilePath(@Nonnull String protoDescriptorsFilePath) {
        Preconditions.checkNotNull((Object)protoDescriptorsFilePath);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Proto descriptors file path cannot be set when a batch is active");
        this.protoDescriptorsFilePath = protoDescriptorsFilePath;
        this.protoDescriptors = null;
    }

    String getProtoDescriptorsFilePath() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.protoDescriptorsFilePath;
    }

    private void checkSetRetryAbortsInternallyAvailable() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "RetryAbortsInternally cannot be set after the transaction has started");
    }

    @Override
    public boolean isRetryAbortsInternally() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY);
    }

    @Override
    public void setRetryAbortsInternally(boolean retryAbortsInternally) {
        this.setRetryAbortsInternally(retryAbortsInternally, false);
    }

    void setRetryAbortsInternally(boolean retryAbortsInternally, boolean local) {
        this.checkSetRetryAbortsInternallyAvailable();
        this.setConnectionPropertyValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, retryAbortsInternally, local);
    }

    @Override
    public void addTransactionRetryListener(TransactionRetryListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.transactionRetryListeners.add(listener);
    }

    @Override
    public boolean removeTransactionRetryListener(TransactionRetryListener listener) {
        Preconditions.checkNotNull((Object)listener);
        return this.transactionRetryListeners.remove(listener);
    }

    @Override
    public Iterator<TransactionRetryListener> getTransactionRetryListeners() {
        return Collections.unmodifiableList(this.transactionRetryListeners).iterator();
    }

    @Override
    public boolean isInTransaction() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsInTransaction();
    }

    private boolean internalIsInTransaction() {
        return !this.isDdlBatchActive() && (!this.internalIsAutocommit() || this.inTransaction);
    }

    @Override
    public boolean isTransactionStarted() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsTransactionStarted();
    }

    private boolean internalIsTransactionStarted() {
        if (this.internalIsAutocommit() && !this.inTransaction) {
            return false;
        }
        return this.internalIsInTransaction() && this.currentUnitOfWork != null && this.currentUnitOfWork.getState() == UnitOfWork.UnitOfWorkState.STARTED;
    }

    private boolean hasTransactionalChanges() {
        return this.internalIsTransactionStarted() || this.connectionState.hasTransactionalChanges();
    }

    @Override
    public Timestamp getReadTimestamp() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getReadTimestamp();
    }

    Timestamp getReadTimestampOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getReadTimestampOrNull();
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getCommitTimestamp();
    }

    Timestamp getCommitTimestampOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getCommitTimestampOrNull();
    }

    @Override
    public CommitResponse getCommitResponse() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getCommitResponse();
    }

    CommitResponse getCommitResponseOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getCommitResponseOrNull();
    }

    @Override
    public void setReturnCommitStats(boolean returnCommitStats) {
        this.setReturnCommitStats(returnCommitStats, false);
    }

    @VisibleForTesting
    void setReturnCommitStats(boolean returnCommitStats, boolean local) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.setConnectionPropertyValue(ConnectionProperties.RETURN_COMMIT_STATS, returnCommitStats, local);
    }

    @Override
    public boolean isReturnCommitStats() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.RETURN_COMMIT_STATS);
    }

    @Override
    public void setMaxCommitDelay(java.time.Duration maxCommitDelay) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.setConnectionPropertyValue(ConnectionProperties.MAX_COMMIT_DELAY, maxCommitDelay);
    }

    @Override
    public java.time.Duration getMaxCommitDelay() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.MAX_COMMIT_DELAY);
    }

    @Override
    public void setDelayTransactionStartUntilFirstWrite(boolean delayTransactionStartUntilFirstWrite) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set DelayTransactionStartUntilFirstWrite while a transaction is active");
        this.setConnectionPropertyValue(ConnectionProperties.DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE, delayTransactionStartUntilFirstWrite);
    }

    @Override
    public boolean isDelayTransactionStartUntilFirstWrite() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE);
    }

    @Override
    public void setKeepTransactionAlive(boolean keepTransactionAlive) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set KeepTransactionAlive while a transaction is active");
        this.setConnectionPropertyValue(ConnectionProperties.KEEP_TRANSACTION_ALIVE, keepTransactionAlive);
    }

    @Override
    public boolean isKeepTransactionAlive() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.getConnectionPropertyValue(ConnectionProperties.KEEP_TRANSACTION_ALIVE);
    }

    private void setDefaultTransactionOptions(TransactionOptions.IsolationLevel isolationLevel) {
        if (this.transactionStack.isEmpty()) {
            this.unitOfWorkType = this.isReadOnly() ? UnitOfWorkType.READ_ONLY_TRANSACTION : UnitOfWorkType.READ_WRITE_TRANSACTION;
            this.batchMode = BatchMode.NONE;
            this.transactionIsolationLevel = isolationLevel;
            this.transactionTag = null;
            this.excludeTxnFromChangeStreams = false;
        } else {
            this.popUnitOfWorkFromTransactionStack();
        }
    }

    @Override
    public void beginTransaction() {
        SpannerApiFutures.get(this.beginTransactionAsync(this.getConnectionPropertyValue(ConnectionProperties.DEFAULT_ISOLATION_LEVEL)));
    }

    @Override
    public void beginTransaction(TransactionOptions.IsolationLevel isolationLevel) {
        SpannerApiFutures.get(this.beginTransactionAsync(isolationLevel));
    }

    @Override
    public ApiFuture<Void> beginTransactionAsync() {
        return this.beginTransactionAsync(this.getConnectionPropertyValue(ConnectionProperties.DEFAULT_ISOLATION_LEVEL));
    }

    @Override
    public ApiFuture<Void> beginTransactionAsync(TransactionOptions.IsolationLevel isolationLevel) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "This connection has an active batch and cannot begin a transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Beginning a new transaction is not allowed when a transaction is already running");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "A transaction has already begun");
        this.transactionBeginMarked = true;
        this.clearLastTransactionAndSetDefaultTransactionOptions(isolationLevel);
        if (this.isAutocommit()) {
            this.inTransaction = true;
        }
        return ApiFutures.immediateFuture(null);
    }

    @Override
    public void commit() {
        SpannerApiFutures.get(this.commitAsync(UnitOfWork.CallType.SYNC, Caller.APPLICATION));
    }

    @Override
    public ApiFuture<Void> commitAsync() {
        return this.commitAsync(UnitOfWork.CallType.ASYNC, Caller.APPLICATION);
    }

    ApiFuture<Void> commitAsync(UnitOfWork.CallType callType, Caller caller) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.transactionRunnerActive || caller == Caller.TRANSACTION_RUNNER, "Cannot call commit when a transaction runner is active");
        this.maybeAutoCommitOrFlushCurrentUnitOfWork(COMMIT_STATEMENT.getType(), COMMIT_STATEMENT);
        return this.endCurrentTransactionAsync(callType, this.commit, COMMIT_STATEMENT);
    }

    @Override
    public void rollback() {
        SpannerApiFutures.get(this.rollbackAsync(UnitOfWork.CallType.SYNC, Caller.APPLICATION));
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        return this.rollbackAsync(UnitOfWork.CallType.ASYNC, Caller.APPLICATION);
    }

    ApiFuture<Void> rollbackAsync(UnitOfWork.CallType callType, Caller caller) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.transactionRunnerActive || caller == Caller.TRANSACTION_RUNNER, "Cannot call rollback when a transaction runner is active");
        this.maybeAutoCommitOrFlushCurrentUnitOfWork(ROLLBACK_STATEMENT.getType(), ROLLBACK_STATEMENT);
        return this.endCurrentTransactionAsync(callType, this.rollback, ROLLBACK_STATEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiFuture<Void> endCurrentTransactionAsync(UnitOfWork.CallType callType, EndTransactionMethod endTransactionMethod, AbstractStatementParser.ParsedStatement parsedStatement) {
        ApiFuture<Void> res;
        ConnectionPreconditions.checkState(!this.isBatchActive(), "This connection has an active batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(this.statementTag == null, "Statement tags are not supported for COMMIT or ROLLBACK");
        try {
            if (this.hasTransactionalChanges()) {
                res = endTransactionMethod.endAsync(callType, this.getCurrentUnitOfWorkOrStartNewUnitOfWork(parsedStatement));
            } else {
                this.currentUnitOfWork = null;
                res = ApiFutures.immediateFuture(null);
            }
        }
        finally {
            this.transactionBeginMarked = false;
            if (this.isAutocommit()) {
                this.inTransaction = false;
            }
            this.setDefaultTransactionOptions(this.getDefaultIsolationLevel());
        }
        return res;
    }

    @Override
    public <T> T runTransaction(Connection.TransactionCallable<T> callable) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot run transaction while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot run transaction when a transaction is already active");
        ConnectionPreconditions.checkState(!this.transactionRunnerActive, "A transaction runner is already active for this connection");
        this.transactionRunnerActive = true;
        try {
            T t = new TransactionRunnerImpl(this).run(callable);
            return t;
        }
        finally {
            this.transactionRunnerActive = false;
        }
    }

    void resetForRetry(UnitOfWork retryUnitOfWork) {
        retryUnitOfWork.resetForRetry();
        this.currentUnitOfWork = retryUnitOfWork;
    }

    @Override
    public SavepointSupport getSavepointSupport() {
        return this.getConnectionPropertyValue(ConnectionProperties.SAVEPOINT_SUPPORT);
    }

    @Override
    public void setSavepointSupport(SavepointSupport savepointSupport) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set SavepointSupport while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set SavepointSupport while a transaction is active");
        this.setConnectionPropertyValue(ConnectionProperties.SAVEPOINT_SUPPORT, savepointSupport);
    }

    @Override
    public void savepoint(String name) {
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        SavepointSupport savepointSupport = this.getSavepointSupport();
        ConnectionPreconditions.checkState(savepointSupport.isSavepointCreationAllowed(), "This connection does not allow the creation of savepoints. Current value of SavepointSupport: " + (Object)((Object)savepointSupport));
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork(SAVEPOINT_STATEMENT).savepoint(ConnectionPreconditions.checkValidIdentifier(name), this.getDialect());
    }

    @Override
    public void releaseSavepoint(String name) {
        ConnectionPreconditions.checkState(this.isTransactionStarted(), "This connection has no active transaction");
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork(RELEASE_STATEMENT).releaseSavepoint(ConnectionPreconditions.checkValidIdentifier(name));
    }

    @Override
    public void rollbackToSavepoint(String name) {
        ConnectionPreconditions.checkState(this.isTransactionStarted(), "This connection has no active transaction");
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork(ROLLBACK_TO_STATEMENT).rollbackToSavepoint(ConnectionPreconditions.checkValidIdentifier(name), this.getSavepointSupport());
    }

    @Override
    public StatementResult execute(Statement statement) {
        return this.internalExecute((Statement)Preconditions.checkNotNull((Object)statement), null);
    }

    @Override
    public StatementResult execute(Statement statement, Set<StatementResult.ResultType> allowedResultTypes) {
        return this.internalExecute((Statement)Preconditions.checkNotNull((Object)statement), (Set)Preconditions.checkNotNull(allowedResultTypes));
    }

    private StatementResult internalExecute(Statement statement, @Nullable Set<StatementResult.ResultType> allowedResultTypes) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(statement, this.buildQueryOptions());
        ConnectionImpl.checkResultTypeAllowed(parsedStatement, allowedResultTypes);
        switch (parsedStatement.getType()) {
            case CLIENT_SIDE: {
                return parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement);
            }
            case QUERY: {
                return StatementResultImpl.of(this.internalExecuteQuery(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
            }
            case UPDATE: {
                if (parsedStatement.hasReturningClause()) {
                    return StatementResultImpl.of(this.internalExecuteQuery(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
                }
                return StatementResultImpl.of(SpannerApiFutures.get(this.internalExecuteUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0])));
            }
            case DDL: {
                SpannerApiFutures.get(this.executeDdlAsync(UnitOfWork.CallType.SYNC, parsedStatement));
                return StatementResultImpl.noResult();
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown statement: " + parsedStatement.getSql());
    }

    @VisibleForTesting
    static void checkResultTypeAllowed(AbstractStatementParser.ParsedStatement parsedStatement, @Nullable Set<StatementResult.ResultType> allowedResultTypes) {
        if (allowedResultTypes == null) {
            return;
        }
        StatementResult.ResultType resultType = ConnectionImpl.getResultType(parsedStatement);
        if (!allowedResultTypes.contains((Object)resultType)) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "This statement returns a result of type " + (Object)((Object)resultType) + ". Only statements that return a result of one of the following types are allowed: " + allowedResultTypes.stream().map(Enum::toString).collect(Collectors.joining(", ")));
        }
    }

    private static StatementResult.ResultType getResultType(AbstractStatementParser.ParsedStatement parsedStatement) {
        switch (parsedStatement.getType()) {
            case CLIENT_SIDE: {
                if (parsedStatement.getClientSideStatement().isQuery()) {
                    return StatementResult.ResultType.RESULT_SET;
                }
                if (parsedStatement.getClientSideStatement().isUpdate()) {
                    return StatementResult.ResultType.UPDATE_COUNT;
                }
                return StatementResult.ResultType.NO_RESULT;
            }
            case QUERY: {
                return StatementResult.ResultType.RESULT_SET;
            }
            case UPDATE: {
                if (parsedStatement.hasReturningClause()) {
                    return StatementResult.ResultType.RESULT_SET;
                }
                return StatementResult.ResultType.UPDATE_COUNT;
            }
            case DDL: {
                return StatementResult.ResultType.NO_RESULT;
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown statement: " + parsedStatement.getSql());
    }

    @Override
    public AsyncStatementResult executeAsync(Statement statement) {
        Preconditions.checkNotNull((Object)statement);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(statement, this.buildQueryOptions());
        switch (parsedStatement.getType()) {
            case CLIENT_SIDE: {
                return AsyncStatementResultImpl.of(parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement), this.spanner.getAsyncExecutorProvider());
            }
            case QUERY: {
                return AsyncStatementResultImpl.of(this.internalExecuteQueryAsync(UnitOfWork.CallType.ASYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
            }
            case UPDATE: {
                if (parsedStatement.hasReturningClause()) {
                    return AsyncStatementResultImpl.of(this.internalExecuteQueryAsync(UnitOfWork.CallType.ASYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
                }
                return AsyncStatementResultImpl.of(this.internalExecuteUpdateAsync(UnitOfWork.CallType.ASYNC, parsedStatement, new Options.UpdateOption[0]));
            }
            case DDL: {
                return AsyncStatementResultImpl.noResult(this.executeDdlAsync(UnitOfWork.CallType.ASYNC, parsedStatement));
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown statement: " + parsedStatement.getSql());
    }

    @Override
    public ResultSet executeQuery(Statement query, Options.QueryOption ... options) {
        return this.parseAndExecuteQuery(UnitOfWork.CallType.SYNC, query, AnalyzeMode.NONE, options);
    }

    @Override
    public AsyncResultSet executeQueryAsync(Statement query, Options.QueryOption ... options) {
        return this.parseAndExecuteQueryAsync(query, options);
    }

    @Override
    public ResultSet analyzeQuery(Statement query, ReadContext.QueryAnalyzeMode queryMode) {
        Preconditions.checkNotNull((Object)((Object)queryMode));
        return this.parseAndExecuteQuery(UnitOfWork.CallType.SYNC, query, AnalyzeMode.of(queryMode), new Options.QueryOption[0]);
    }

    @Override
    public void setAutoBatchDml(boolean autoBatchDml) {
        this.setConnectionPropertyValue(ConnectionProperties.AUTO_BATCH_DML, autoBatchDml);
    }

    @Override
    public boolean isAutoBatchDml() {
        return this.getConnectionPropertyValue(ConnectionProperties.AUTO_BATCH_DML);
    }

    @Override
    public void setAutoBatchDmlUpdateCount(long updateCount) {
        this.setConnectionPropertyValue(ConnectionProperties.AUTO_BATCH_DML_UPDATE_COUNT, updateCount);
    }

    @Override
    public long getAutoBatchDmlUpdateCount() {
        return this.getConnectionPropertyValue(ConnectionProperties.AUTO_BATCH_DML_UPDATE_COUNT);
    }

    long getDmlBatchUpdateCount() {
        return this.getConnectionPropertyValue(ConnectionProperties.BATCH_DML_UPDATE_COUNT);
    }

    @Override
    public void setAutoBatchDmlUpdateCountVerification(boolean verification) {
        this.setConnectionPropertyValue(ConnectionProperties.AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION, verification);
    }

    @Override
    public boolean isAutoBatchDmlUpdateCountVerification() {
        return this.getConnectionPropertyValue(ConnectionProperties.AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION);
    }

    void setBatchDmlUpdateCount(long updateCount, boolean local) {
        this.setConnectionPropertyValue(ConnectionProperties.BATCH_DML_UPDATE_COUNT, updateCount, local);
    }

    @Override
    public void setDataBoostEnabled(boolean dataBoostEnabled) {
        this.setConnectionPropertyValue(ConnectionProperties.DATA_BOOST_ENABLED, dataBoostEnabled);
    }

    @Override
    public boolean isDataBoostEnabled() {
        return this.getConnectionPropertyValue(ConnectionProperties.DATA_BOOST_ENABLED);
    }

    @Override
    public void setAutoPartitionMode(boolean autoPartitionMode) {
        this.setConnectionPropertyValue(ConnectionProperties.AUTO_PARTITION_MODE, autoPartitionMode);
    }

    @Override
    public boolean isAutoPartitionMode() {
        return this.getConnectionPropertyValue(ConnectionProperties.AUTO_PARTITION_MODE);
    }

    @Override
    public void setMaxPartitions(int maxPartitions) {
        this.setConnectionPropertyValue(ConnectionProperties.MAX_PARTITIONS, maxPartitions);
    }

    @Override
    public int getMaxPartitions() {
        return this.getConnectionPropertyValue(ConnectionProperties.MAX_PARTITIONS);
    }

    @Override
    public ResultSet partitionQuery(Statement query, PartitionOptions partitionOptions, Options.QueryOption ... options) {
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(query, this.buildQueryOptions());
        if (parsedStatement.getType() != AbstractStatementParser.StatementType.QUERY) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Only queries can be partitioned. Invalid statement: " + query.getSql());
        }
        Options.QueryOption[] combinedOptions = this.concat(parsedStatement.getOptionsFromHints(), options);
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork(parsedStatement);
        return SpannerApiFutures.get(transaction.partitionQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, this.getEffectivePartitionOptions(partitionOptions), this.mergeDataBoost(this.mergeQueryRequestOptions(parsedStatement, this.mergeQueryStatementTag(combinedOptions)))));
    }

    private PartitionOptions getEffectivePartitionOptions(PartitionOptions callSpecificPartitionOptions) {
        if (this.getMaxPartitions() == 0) {
            if (callSpecificPartitionOptions == null) {
                return PartitionOptions.newBuilder().build();
            }
            return callSpecificPartitionOptions;
        }
        if (callSpecificPartitionOptions != null && callSpecificPartitionOptions.getMaxPartitions() > 0L) {
            return callSpecificPartitionOptions;
        }
        if (callSpecificPartitionOptions != null && callSpecificPartitionOptions.getPartitionSizeBytes() > 0L) {
            return PartitionOptions.newBuilder().setMaxPartitions(this.getMaxPartitions()).setPartitionSizeBytes(callSpecificPartitionOptions.getPartitionSizeBytes()).build();
        }
        return PartitionOptions.newBuilder().setMaxPartitions(this.getMaxPartitions()).build();
    }

    @Override
    public ResultSet runPartition(String encodedPartitionId) {
        PartitionId id = PartitionId.decodeFromString(encodedPartitionId);
        try (BatchReadOnlyTransaction transaction = this.batchClient.batchReadOnlyTransaction(id.getTransactionId());){
            ResultSet resultSet = transaction.execute(id.getPartition());
            return resultSet;
        }
    }

    @Override
    public void setMaxPartitionedParallelism(int maxThreads) {
        Preconditions.checkArgument((maxThreads >= 0 ? 1 : 0) != 0, (Object)"maxThreads must be >=0");
        this.setConnectionPropertyValue(ConnectionProperties.MAX_PARTITIONED_PARALLELISM, maxThreads);
    }

    @Override
    public int getMaxPartitionedParallelism() {
        return this.getConnectionPropertyValue(ConnectionProperties.MAX_PARTITIONED_PARALLELISM);
    }

    @Override
    public PartitionedQueryResultSet runPartitionedQuery(Statement query, PartitionOptions partitionOptions, Options.QueryOption ... options) {
        ArrayList<String> partitionIds = new ArrayList<String>();
        try (ResultSet partitions = this.partitionQuery(query, partitionOptions, options);){
            while (partitions.next()) {
                partitionIds.add(partitions.getString(0));
            }
        }
        return new MergedResultSet(this, partitionIds, this.getMaxPartitionedParallelism());
    }

    private ResultSet parseAndExecuteQuery(UnitOfWork.CallType callType, Statement query, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)((Object)analyzeMode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(query, this.buildQueryOptions());
        if (parsedStatement.isQuery() || parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case CLIENT_SIDE: {
                    return parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement).getResultSet();
                }
                case QUERY: {
                    return this.internalExecuteQuery(callType, parsedStatement, analyzeMode, options);
                }
                case UPDATE: {
                    if (!parsedStatement.hasReturningClause()) break;
                    if (this.isReadOnly() || this.isInTransaction() && this.getTransactionMode() == TransactionMode.READ_ONLY_TRANSACTION) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DML statement with returning clause cannot be executed in read-only mode: " + parsedStatement.getSql());
                    }
                    return this.internalExecuteQuery(callType, parsedStatement, analyzeMode, options);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not a query or DML with returning clause: " + parsedStatement.getSql());
    }

    private AsyncResultSet parseAndExecuteQueryAsync(Statement query, Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)query);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(query, this.buildQueryOptions());
        if (parsedStatement.isQuery() || parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case CLIENT_SIDE: {
                    return ResultSets.toAsyncResultSet(parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement).getResultSet(), this.spanner.getAsyncExecutorProvider(), options);
                }
                case QUERY: {
                    return this.internalExecuteQueryAsync(UnitOfWork.CallType.ASYNC, parsedStatement, AnalyzeMode.NONE, options);
                }
                case UPDATE: {
                    if (!parsedStatement.hasReturningClause()) break;
                    if (this.isReadOnly() || this.isInTransaction() && this.getTransactionMode() == TransactionMode.READ_ONLY_TRANSACTION) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DML statement with returning clause cannot be executed in read-only mode: " + parsedStatement.getSql());
                    }
                    return this.internalExecuteQueryAsync(UnitOfWork.CallType.ASYNC, parsedStatement, AnalyzeMode.NONE, options);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not a query or DML with returning clause: " + parsedStatement.getSql());
    }

    private boolean isInternalMetadataQuery(Options.QueryOption ... options) {
        if (options == null) {
            return false;
        }
        for (Options.QueryOption option : options) {
            if (!(option instanceof Connection.InternalMetadataQuery)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long executeUpdate(Statement update) {
        Preconditions.checkNotNull((Object)update);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(update);
        if (parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    if (parsedStatement.hasReturningClause()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DML statement with returning clause cannot be executed using executeUpdate: " + parsedStatement.getSql() + ". Please use executeQuery instead.");
                    }
                    return SpannerApiFutures.get(this.internalExecuteUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0]));
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSql());
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(Statement update) {
        Preconditions.checkNotNull((Object)update);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(update);
        if (parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    if (parsedStatement.hasReturningClause()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DML statement with returning clause cannot be executed using executeUpdateAsync: " + parsedStatement.getSql() + ". Please use executeQueryAsync instead.");
                    }
                    return this.internalExecuteUpdateAsync(UnitOfWork.CallType.ASYNC, parsedStatement, new Options.UpdateOption[0]);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSql());
    }

    @Override
    public ResultSetStats analyzeUpdate(Statement update, ReadContext.QueryAnalyzeMode analyzeMode) {
        Preconditions.checkNotNull((Object)update);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(update);
        if (parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    return SpannerApiFutures.get(this.internalAnalyzeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.of(analyzeMode), new Options.UpdateOption[0])).getStats();
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSql());
    }

    @Override
    public ResultSet analyzeUpdateStatement(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        Preconditions.checkNotNull((Object)statement);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(statement);
        switch (parsedStatement.getType()) {
            case UPDATE: {
                return SpannerApiFutures.get(this.internalAnalyzeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.of(analyzeMode), options));
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSql());
    }

    @Override
    public long[] executeBatchUpdate(Iterable<Statement> updates) {
        return SpannerApiFutures.get(this.internalExecuteBatchUpdateAsync(UnitOfWork.CallType.SYNC, this.parseUpdateStatements(updates), new Options.UpdateOption[0]));
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<Statement> updates) {
        return this.internalExecuteBatchUpdateAsync(UnitOfWork.CallType.ASYNC, this.parseUpdateStatements(updates), new Options.UpdateOption[0]);
    }

    private List<AbstractStatementParser.ParsedStatement> parseUpdateStatements(Iterable<Statement> updates) {
        Preconditions.checkNotNull(updates);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        LinkedList<AbstractStatementParser.ParsedStatement> parsedStatements = new LinkedList<AbstractStatementParser.ParsedStatement>();
        block3: for (Statement update : updates) {
            AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(update);
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    parsedStatements.add(parsedStatement);
                    continue block3;
                }
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "The batch update list contains a statement that is not an update statement: " + parsedStatement.getSql());
        }
        return parsedStatements;
    }

    private Options.UpdateOption[] concat(Options.ReadQueryUpdateTransactionOption[] statementOptions, Options.UpdateOption[] argumentOptions) {
        if (statementOptions == null || statementOptions.length == 0) {
            return argumentOptions;
        }
        if (argumentOptions == null || argumentOptions.length == 0) {
            return statementOptions;
        }
        Options.UpdateOption[] result = Arrays.copyOf(statementOptions, statementOptions.length + argumentOptions.length);
        System.arraycopy(argumentOptions, 0, result, statementOptions.length, argumentOptions.length);
        return result;
    }

    private Options.QueryOption[] concat(Options.ReadQueryUpdateTransactionOption[] statementOptions, Options.QueryOption[] argumentOptions) {
        if (statementOptions == null || statementOptions.length == 0) {
            return argumentOptions;
        }
        if (argumentOptions == null || argumentOptions.length == 0) {
            return statementOptions;
        }
        Options.QueryOption[] result = Arrays.copyOf(statementOptions, statementOptions.length + argumentOptions.length);
        System.arraycopy(argumentOptions, 0, result, statementOptions.length, argumentOptions.length);
        return result;
    }

    private Options.QueryOption[] mergeDataBoost(Options.QueryOption ... options) {
        if (this.isDataBoostEnabled()) {
            options = this.appendQueryOption(options, Options.dataBoostEnabled(true));
        }
        return options;
    }

    private Options.QueryOption[] mergeQueryStatementTag(Options.QueryOption ... options) {
        if (this.statementTag != null) {
            options = this.appendQueryOption(options, Options.tag(this.statementTag));
            this.statementTag = null;
        }
        return options;
    }

    private Options.QueryOption[] mergeQueryRequestOptions(AbstractStatementParser.ParsedStatement parsedStatement, Options.QueryOption ... options) {
        if (this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY) != null) {
            options = this.appendQueryOption(options, Options.priority(this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY)));
        }
        if (this.currentUnitOfWork != null && this.currentUnitOfWork.supportsDirectedReads(parsedStatement) && this.getConnectionPropertyValue(ConnectionProperties.DIRECTED_READ) != null) {
            options = this.appendQueryOption(options, Options.directedRead(this.getConnectionPropertyValue(ConnectionProperties.DIRECTED_READ)));
        }
        return options;
    }

    private Options.QueryOption[] appendQueryOption(Options.QueryOption[] options, Options.QueryOption append) {
        if (options == null || options.length == 0) {
            options = new Options.QueryOption[]{append};
        } else {
            options = Arrays.copyOf(options, options.length + 1);
            options[options.length - 1] = append;
        }
        return options;
    }

    private Options.UpdateOption[] mergeUpdateStatementTag(Options.UpdateOption ... options) {
        if (this.statementTag != null) {
            if (options == null || options.length == 0) {
                options = new Options.UpdateOption[]{Options.tag(this.statementTag)};
            } else {
                options = Arrays.copyOf(options, options.length + 1);
                options[options.length - 1] = Options.tag(this.statementTag);
            }
            this.statementTag = null;
        }
        return options;
    }

    private Options.UpdateOption[] mergeUpdateRequestOptions(Options.UpdateOption ... options) {
        if (this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY) != null) {
            if (options == null || options.length == 0) {
                options = new Options.UpdateOption[]{Options.priority(this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY))};
            } else {
                options = Arrays.copyOf(options, options.length + 1);
                options[options.length - 1] = Options.priority(this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY));
            }
        }
        return options;
    }

    private ResultSet internalExecuteQuery(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((statement.getType() == AbstractStatementParser.StatementType.QUERY || statement.getType() == AbstractStatementParser.StatementType.UPDATE && (analyzeMode != AnalyzeMode.NONE || statement.hasReturningClause()) ? 1 : 0) != 0, (Object)"Statement must either be a query or a DML mode with analyzeMode!=NONE or returning clause");
        boolean isInternalMetadataQuery = this.isInternalMetadataQuery(options);
        Options.QueryOption[] combinedOptions = this.concat(statement.getOptionsFromHints(), options);
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork(statement, isInternalMetadataQuery);
        if (this.isAutoPartitionMode() && statement.getType() == AbstractStatementParser.StatementType.QUERY && !isInternalMetadataQuery) {
            return this.runPartitionedQuery(statement.getStatement(), PartitionOptions.getDefaultInstance(), combinedOptions);
        }
        return SpannerApiFutures.get(transaction.executeQueryAsync(callType, statement, analyzeMode, this.mergeQueryRequestOptions(statement, this.mergeQueryStatementTag(combinedOptions))));
    }

    private AsyncResultSet internalExecuteQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((statement.getType() == AbstractStatementParser.StatementType.QUERY || statement.getType() == AbstractStatementParser.StatementType.UPDATE && statement.hasReturningClause() ? 1 : 0) != 0, (Object)"Statement must be a query or DML with returning clause.");
        ConnectionPreconditions.checkState(!this.isAutoPartitionMode() || statement.getType() != AbstractStatementParser.StatementType.QUERY, "Partitioned queries cannot be executed asynchronously");
        boolean isInternalMetadataQuery = this.isInternalMetadataQuery(options);
        Options.QueryOption[] combinedOptions = this.concat(statement.getOptionsFromHints(), options);
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork(statement, isInternalMetadataQuery);
        return ResultSets.toAsyncResultSet(transaction.executeQueryAsync(callType, statement, analyzeMode, this.mergeQueryRequestOptions(statement, this.mergeQueryStatementTag(combinedOptions))), this.spanner.getAsyncExecutorProvider(), combinedOptions);
    }

    private ApiFuture<Long> internalExecuteUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        Preconditions.checkArgument((update.getType() == AbstractStatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)"Statement must be an update");
        Options.UpdateOption[] combinedOptions = this.concat(update.getOptionsFromHints(), options);
        UnitOfWork transaction = this.maybeStartAutoDmlBatch(this.getCurrentUnitOfWorkOrStartNewUnitOfWork(update));
        return transaction.executeUpdateAsync(callType, update, this.mergeUpdateRequestOptions(this.mergeUpdateStatementTag(combinedOptions)));
    }

    private ApiFuture<ResultSet> internalAnalyzeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        Preconditions.checkArgument((update.getType() == AbstractStatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)"Statement must be an update");
        Options.UpdateOption[] combinedOptions = this.concat(update.getOptionsFromHints(), options);
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork(update);
        return transaction.analyzeUpdateAsync(callType, update, analyzeMode, this.mergeUpdateRequestOptions(this.mergeUpdateStatementTag(combinedOptions)));
    }

    private ApiFuture<long[]> internalExecuteBatchUpdateAsync(UnitOfWork.CallType callType, List<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        Options.UpdateOption[] combinedOptions = updates.isEmpty() ? options : this.concat(updates.get(0).getOptionsFromHints(), options);
        UnitOfWork transaction = this.maybeStartAutoDmlBatch(this.getCurrentUnitOfWorkOrStartNewUnitOfWork(updates.get(0)));
        return transaction.executeBatchUpdateAsync(callType, updates, this.mergeUpdateRequestOptions(this.mergeUpdateStatementTag(combinedOptions)));
    }

    private UnitOfWork maybeStartAutoDmlBatch(UnitOfWork transaction) {
        if (this.isInTransaction() && this.isAutoBatchDml() && !(transaction instanceof DmlBatch)) {
            return this.startBatchDml(true);
        }
        return transaction;
    }

    UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork() {
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork(AbstractStatementParser.StatementType.UNKNOWN, null, false);
    }

    private UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork(@Nonnull AbstractStatementParser.ParsedStatement parsedStatement) {
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork(parsedStatement.getType(), parsedStatement, false);
    }

    @VisibleForTesting
    UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork(@Nonnull AbstractStatementParser.ParsedStatement parsedStatement, boolean isInternalMetadataQuery) {
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork(parsedStatement.getType(), parsedStatement, isInternalMetadataQuery);
    }

    private UnitOfWork getOrStartDdlUnitOfWork(AbstractStatementParser.ParsedStatement parsedStatement) {
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork(AbstractStatementParser.StatementType.DDL, parsedStatement, false);
    }

    @VisibleForTesting
    UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork(AbstractStatementParser.StatementType statementType, @Nullable AbstractStatementParser.ParsedStatement parsedStatement, boolean isInternalMetadataQuery) {
        if (isInternalMetadataQuery) {
            return this.createNewUnitOfWork(true, true, false);
        }
        this.maybeAutoCommitOrFlushCurrentUnitOfWork(statementType, parsedStatement);
        if (this.currentUnitOfWork == null || !this.currentUnitOfWork.isActive()) {
            this.currentUnitOfWork = this.createNewUnitOfWork(false, statementType == AbstractStatementParser.StatementType.DDL && this.getDdlInTransactionMode() != DdlInTransactionMode.FAIL && !this.transactionBeginMarked, false, statementType);
        }
        return this.currentUnitOfWork;
    }

    private Span createSpanForUnitOfWork(String name) {
        return this.tracer.spanBuilder((String)Suppliers.memoize(() -> this.connectionState.getValue(ConnectionProperties.TRACING_PREFIX).getValue()).get() + "." + name).setAllAttributes(this.getOpenTelemetryAttributes()).startSpan();
    }

    void maybeAutoCommitOrFlushCurrentUnitOfWork(AbstractStatementParser.StatementType statementType, @Nullable AbstractStatementParser.ParsedStatement parsedStatement) {
        if (this.currentUnitOfWork instanceof ReadWriteTransaction && this.currentUnitOfWork.isActive() && statementType == AbstractStatementParser.StatementType.DDL && this.getDdlInTransactionMode() == DdlInTransactionMode.AUTO_COMMIT_TRANSACTION) {
            this.commit();
        } else {
            this.maybeFlushAutoDmlBatch(parsedStatement);
        }
    }

    private void maybeFlushAutoDmlBatch(@Nullable AbstractStatementParser.ParsedStatement parsedStatement) {
        DmlBatch batch;
        if (parsedStatement == null) {
            return;
        }
        if (this.currentUnitOfWork instanceof DmlBatch && this.currentUnitOfWork.isActive() && (batch = (DmlBatch)this.currentUnitOfWork).isAutoBatch()) {
            if (parsedStatement == ROLLBACK_STATEMENT || parsedStatement == ROLLBACK_TO_STATEMENT && this.getSavepointSupport() == SavepointSupport.ENABLED) {
                this.abortBatch();
            } else if (!parsedStatement.isUpdate() || parsedStatement.hasReturningClause()) {
                this.runBatch();
            }
        }
    }

    @VisibleForTesting
    UnitOfWork createNewUnitOfWork(boolean isInternalMetadataQuery, boolean forceSingleUse, boolean autoBatchDml) {
        return this.createNewUnitOfWork(isInternalMetadataQuery, forceSingleUse, autoBatchDml, null);
    }

    @VisibleForTesting
    UnitOfWork createNewUnitOfWork(boolean isInternalMetadataQuery, boolean forceSingleUse, boolean autoBatchDml, AbstractStatementParser.StatementType statementType) {
        if (isInternalMetadataQuery || this.isAutocommit() && !this.isInTransaction() && !this.isInBatch() || forceSingleUse) {
            SingleUseTransaction singleUseTransaction = ((SingleUseTransaction.Builder)((SingleUseTransaction.Builder)((SingleUseTransaction.Builder)((SingleUseTransaction.Builder)((SingleUseTransaction.Builder)SingleUseTransaction.newBuilder().setInternalMetadataQuery(isInternalMetadataQuery).setDdlClient(this.ddlClient).setDatabaseClient(this.dbClient).setBatchClient(this.batchClient).setConnectionState(this.connectionState).setTransactionRetryListeners(this.transactionRetryListeners)).setExcludeTxnFromChangeStreams(this.excludeTxnFromChangeStreams)).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setSpan(this.createSpanForUnitOfWork(statementType == AbstractStatementParser.StatementType.DDL ? DDL_STATEMENT : SINGLE_USE_TRANSACTION))).setProtoDescriptors(this.getProtoDescriptors()).build();
            if (!isInternalMetadataQuery && !forceSingleUse) {
                this.setDefaultTransactionOptions(this.getDefaultIsolationLevel());
            }
            return singleUseTransaction;
        }
        switch (this.getUnitOfWorkType()) {
            case READ_ONLY_TRANSACTION: {
                return ((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)ReadOnlyTransaction.newBuilder().setDatabaseClient(this.dbClient).setBatchClient(this.batchClient).setReadOnlyStaleness(this.getConnectionPropertyValue(ConnectionProperties.READ_ONLY_STALENESS)).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setTransactionTag(this.transactionTag)).setRpcPriority(this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY))).setSpan(this.createSpanForUnitOfWork(READ_ONLY_TRANSACTION))).build();
            }
            case READ_WRITE_TRANSACTION: {
                return ((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)ReadWriteTransaction.newBuilder().setUsesEmulator(this.options.usesEmulator()).setUseAutoSavepointsForEmulator(this.options.useAutoSavepointsForEmulator()).setDatabaseClient(this.dbClient).setIsolationLevel(this.transactionIsolationLevel).setReadLockMode(this.getConnectionPropertyValue(ConnectionProperties.READ_LOCK_MODE)).setDeadline(this.getTransactionDeadline()).setDelayTransactionStartUntilFirstWrite(this.getConnectionPropertyValue(ConnectionProperties.DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE)).setKeepTransactionAlive(this.getConnectionPropertyValue(ConnectionProperties.KEEP_TRANSACTION_ALIVE)).setRetryAbortsInternally(this.getConnectionPropertyValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY)).setSavepointSupport(this.getConnectionPropertyValue(ConnectionProperties.SAVEPOINT_SUPPORT)).setReturnCommitStats(this.getConnectionPropertyValue(ConnectionProperties.RETURN_COMMIT_STATS)).setMaxCommitDelay(this.getConnectionPropertyValue(ConnectionProperties.MAX_COMMIT_DELAY)).setTransactionRetryListeners(this.transactionRetryListeners)).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setTransactionTag(this.transactionTag)).setExcludeTxnFromChangeStreams(this.excludeTxnFromChangeStreams)).setRpcPriority(this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY))).setSpan(this.createSpanForUnitOfWork(READ_WRITE_TRANSACTION))).build();
            }
            case DML_BATCH: {
                this.pushCurrentUnitOfWorkToTransactionStack();
                return ((DmlBatch.Builder)((DmlBatch.Builder)((DmlBatch.Builder)((DmlBatch.Builder)((DmlBatch.Builder)DmlBatch.newBuilder().setAutoBatch(autoBatchDml).setAutoBatchUpdateCountSupplier(this::getAutoBatchDmlUpdateCount).setAutoBatchUpdateCountVerificationSupplier(this::isAutoBatchDmlUpdateCountVerification).setDmlBatchUpdateCountSupplier(this::getDmlBatchUpdateCount).setTransaction(this.currentUnitOfWork).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setStatementTag(this.statementTag).setExcludeTxnFromChangeStreams(this.excludeTxnFromChangeStreams)).setRpcPriority(this.getConnectionPropertyValue(ConnectionProperties.RPC_PRIORITY))).setSpan(this.transactionStack.peek().getSpan())).build();
            }
            case DDL_BATCH: {
                return ((DdlBatch.Builder)((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().setDdlClient(this.ddlClient).setDatabaseClient(this.dbClient).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setSpan(this.createSpanForUnitOfWork(DDL_BATCH))).setProtoDescriptors(this.getProtoDescriptors()).setConnectionState(this.connectionState).build();
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "This connection does not have an active transaction and the state of this connection does not allow any new transactions to be started");
    }

    private void pushCurrentUnitOfWorkToTransactionStack() {
        Preconditions.checkState((this.currentUnitOfWork != null ? 1 : 0) != 0, (Object)"There is no current transaction");
        this.transactionStack.push(this.currentUnitOfWork);
    }

    private void popUnitOfWorkFromTransactionStack() {
        Preconditions.checkState((!this.transactionStack.isEmpty() ? 1 : 0) != 0, (Object)"There is no unit of work in the transaction stack");
        this.currentUnitOfWork = this.transactionStack.pop();
    }

    private ApiFuture<Void> executeDdlAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement ddl) {
        ApiFuture<Void> result = this.getOrStartDdlUnitOfWork(ddl).executeDdlAsync(callType, ddl);
        this.protoDescriptors = null;
        this.protoDescriptorsFilePath = null;
        return result;
    }

    @Override
    public void write(Mutation mutation) {
        SpannerApiFutures.get(this.writeAsync(Collections.singleton((Mutation)Preconditions.checkNotNull((Object)mutation))));
    }

    @Override
    public ApiFuture<Void> writeAsync(Mutation mutation) {
        return this.writeAsync(Collections.singleton((Mutation)Preconditions.checkNotNull((Object)mutation)));
    }

    @Override
    public void write(Iterable<Mutation> mutations) {
        SpannerApiFutures.get(this.writeAsync((Iterable)Preconditions.checkNotNull(mutations)));
    }

    @Override
    public ApiFuture<Void> writeAsync(Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isAutocommit(), ONLY_ALLOWED_IN_AUTOCOMMIT);
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork().writeAsync(UnitOfWork.CallType.ASYNC, mutations);
    }

    @Override
    public void bufferedWrite(Mutation mutation) {
        this.bufferedWrite((Iterable)Preconditions.checkNotNull(Collections.singleton(mutation)));
    }

    @Override
    public void bufferedWrite(Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isAutocommit(), NOT_ALLOWED_IN_AUTOCOMMIT);
        SpannerApiFutures.get(this.getCurrentUnitOfWorkOrStartNewUnitOfWork().writeAsync(UnitOfWork.CallType.SYNC, mutations));
    }

    @Override
    public void startBatchDdl() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot start a DDL batch when a batch is already active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot start a DDL batch when the connection is in read-only mode");
        ConnectionPreconditions.checkState(!this.isTransactionStarted() || this.getDdlInTransactionMode() == DdlInTransactionMode.AUTO_COMMIT_TRANSACTION, "Cannot start a DDL batch while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot start a DDL batch while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot start a DDL batch when a transaction has begun");
        ConnectionPreconditions.checkState(this.isAutocommit() || this.getDdlInTransactionMode() != DdlInTransactionMode.FAIL, "Cannot start a DDL batch when autocommit=false and ddlInTransactionMode=FAIL");
        this.maybeAutoCommitOrFlushCurrentUnitOfWork(AbstractStatementParser.StatementType.DDL, START_BATCH_DDL_STATEMENT);
        this.batchMode = BatchMode.DDL;
        this.unitOfWorkType = UnitOfWorkType.DDL_BATCH;
        this.currentUnitOfWork = this.createNewUnitOfWork(false, false, false);
    }

    @Override
    public void startBatchDml() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot start a DML batch when a batch is already active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot start a DML batch when the connection is in read-only mode");
        ConnectionPreconditions.checkState(!this.isInTransaction() || this.getTransactionMode() != TransactionMode.READ_ONLY_TRANSACTION, "Cannot start a DML batch when a read-only transaction is in progress");
        this.startBatchDml(false);
    }

    private UnitOfWork startBatchDml(boolean autoBatch) {
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork(START_BATCH_DML_STATEMENT);
        this.batchMode = BatchMode.DML;
        this.unitOfWorkType = UnitOfWorkType.DML_BATCH;
        this.currentUnitOfWork = this.createNewUnitOfWork(false, false, autoBatch);
        return this.currentUnitOfWork;
    }

    @Override
    public long[] runBatch() {
        return SpannerApiFutures.get(this.runBatchAsync());
    }

    @Override
    public ApiFuture<long[]> runBatchAsync() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isBatchActive(), "This connection has no active batch");
        try {
            if (this.currentUnitOfWork != null) {
                ApiFuture<long[]> apiFuture = this.currentUnitOfWork.runBatchAsync(UnitOfWork.CallType.ASYNC);
                return apiFuture;
            }
            ApiFuture apiFuture = ApiFutures.immediateFuture((Object)new long[0]);
            return apiFuture;
        }
        finally {
            if (this.isDdlBatchActive()) {
                this.protoDescriptors = null;
                this.protoDescriptorsFilePath = null;
            }
            this.batchMode = BatchMode.NONE;
            this.setDefaultTransactionOptions(this.getDefaultIsolationLevel());
        }
    }

    @Override
    public void abortBatch() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isBatchActive(), "This connection has no active batch");
        try {
            if (this.currentUnitOfWork != null) {
                this.currentUnitOfWork.abortBatch();
            }
        }
        finally {
            this.batchMode = BatchMode.NONE;
            this.setDefaultTransactionOptions(this.getDefaultIsolationLevel());
        }
    }

    private boolean isBatchActive() {
        return this.isDdlBatchActive() || this.isDmlBatchActive();
    }

    @Override
    public boolean isDdlBatchActive() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.batchMode == BatchMode.DDL;
    }

    @Override
    public boolean isDmlBatchActive() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.batchMode == BatchMode.DML;
    }

    private final class Commit
    implements EndTransactionMethod {
        private Commit() {
        }

        @Override
        public ApiFuture<Void> endAsync(UnitOfWork.CallType callType, UnitOfWork t) {
            return t.commitAsync(callType, new UnitOfWork.EndTransactionCallback(){

                @Override
                public void onSuccess() {
                    ConnectionImpl.this.connectionState.commit();
                }

                @Override
                public void onFailure() {
                    ConnectionImpl.this.connectionState.rollback();
                }
            });
        }
    }

    private final class Rollback
    implements EndTransactionMethod {
        private Rollback() {
        }

        @Override
        public ApiFuture<Void> endAsync(UnitOfWork.CallType callType, UnitOfWork t) {
            return t.rollbackAsync(callType, new UnitOfWork.EndTransactionCallback(){

                @Override
                public void onSuccess() {
                    ConnectionImpl.this.connectionState.rollback();
                }

                @Override
                public void onFailure() {
                    ConnectionImpl.this.connectionState.rollback();
                }
            });
        }
    }

    static class LeakedConnectionException
    extends RuntimeException {
        private static final long serialVersionUID = 7119433786832158700L;

        private LeakedConnectionException() {
            super("Connection was opened at " + Instant.now());
        }
    }

    static enum UnitOfWorkType {
        READ_ONLY_TRANSACTION{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_ONLY_TRANSACTION;
            }
        }
        ,
        READ_WRITE_TRANSACTION{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_WRITE_TRANSACTION;
            }
        }
        ,
        DML_BATCH{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_WRITE_TRANSACTION;
            }
        }
        ,
        DDL_BATCH{

            @Override
            TransactionMode getTransactionMode() {
                return null;
            }
        };


        abstract TransactionMode getTransactionMode();

        static UnitOfWorkType of(TransactionMode transactionMode) {
            switch (transactionMode) {
                case READ_ONLY_TRANSACTION: {
                    return READ_ONLY_TRANSACTION;
                }
                case READ_WRITE_TRANSACTION: {
                    return READ_WRITE_TRANSACTION;
                }
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown transaction mode: " + (Object)((Object)transactionMode));
        }
    }

    static enum BatchMode {
        NONE,
        DDL,
        DML;

    }

    static enum Caller {
        APPLICATION,
        TRANSACTION_RUNNER;

    }

    private static interface EndTransactionMethod {
        public ApiFuture<Void> endAsync(UnitOfWork.CallType var1, UnitOfWork var2);
    }
}

