/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractMultiUseTransaction;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.SpannerGrpc;
import io.grpc.MethodDescriptor;
import io.opentelemetry.context.Scope;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

class ReadOnlyTransaction
extends AbstractMultiUseTransaction {
    private final DatabaseClient dbClient;
    private final BatchClient batchClient;
    private final TimestampBound readOnlyStaleness;
    private com.google.cloud.spanner.ReadOnlyTransaction transaction;
    private BatchReadOnlyTransaction batchReadOnlyTransaction;
    private UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;

    static Builder newBuilder() {
        return new Builder();
    }

    @VisibleForTesting
    ReadOnlyTransaction(Builder builder) {
        super(builder);
        this.dbClient = builder.dbClient;
        this.batchClient = builder.batchClient;
        this.readOnlyStaleness = builder.readOnlyStaleness;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean supportsDirectedReads(AbstractStatementParser.ParsedStatement ignore) {
        return true;
    }

    @Override
    void checkAborted() {
    }

    @Override
    void checkOrCreateValidTransaction(AbstractStatementParser.ParsedStatement statement, UnitOfWork.CallType callType) {
        if (this.transaction == null) {
            this.transaction = this.dbClient.readOnlyTransaction(this.readOnlyStaleness);
        }
    }

    @Override
    ReadContext getReadContext() {
        ConnectionPreconditions.checkState(this.transaction != null, "Missing read-only transaction");
        return this.transaction;
    }

    @Override
    public Timestamp getReadTimestamp() {
        ConnectionPreconditions.checkState(this.transaction != null, "There is no read timestamp available for this transaction.");
        ConnectionPreconditions.checkState(this.state != UnitOfWork.UnitOfWorkState.ROLLED_BACK, "This transaction was rolled back");
        return this.transaction.getReadTimestamp();
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        if (this.transaction != null && this.state != UnitOfWork.UnitOfWorkState.ROLLED_BACK) {
            try {
                return this.transaction.getReadTimestamp();
            }
            catch (SpannerException spannerException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit timestamp available for this transaction.");
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return null;
    }

    @Override
    public CommitResponse getCommitResponse() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit response available for read-only transactions.");
    }

    @Override
    public CommitResponse getCommitResponseOrNull() {
        return null;
    }

    @Override
    public ApiFuture<ResultSet> partitionQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement query, PartitionOptions partitionOptions, Options.QueryOption ... options) {
        try (Scope ignore = this.span.makeCurrent();){
            if (this.transaction == null) {
                this.batchReadOnlyTransaction = this.batchClient.batchReadOnlyTransaction(this.readOnlyStaleness);
                this.transaction = this.batchReadOnlyTransaction;
            } else if (this.batchReadOnlyTransaction == null) {
                this.batchReadOnlyTransaction = this.batchClient.batchReadOnlyTransaction(TimestampBound.ofReadTimestamp(this.transaction.getReadTimestamp()));
            }
            Callable<ResultSet> callable = () -> this.partitionQuery(this.batchReadOnlyTransaction, partitionOptions, query, options);
            ApiFuture<ResultSet> apiFuture = this.executeStatementAsync(callType, query, callable, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteSqlMethod(), (Object)SpannerGrpc.getCommitMethod()));
            return apiFuture;
        }
    }

    @Override
    public ApiFuture<Void> executeDdlAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement ddl) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DDL statements are not allowed for read-only transactions");
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Update statements are not allowed for read-only transactions");
    }

    @Override
    public ApiFuture<ResultSet> analyzeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Analyzing updates is not allowed for read-only transactions");
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(UnitOfWork.CallType callType, Iterable<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Batch updates are not allowed for read-only transactions.");
    }

    @Override
    public ApiFuture<Void> writeAsync(UnitOfWork.CallType callType, Iterable<Mutation> mutations) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Mutations are not allowed for read-only transactions");
    }

    @Override
    public ApiFuture<Void> commitAsync(@Nonnull UnitOfWork.CallType callType, @Nonnull UnitOfWork.EndTransactionCallback callback) {
        ApiFuture<Void> apiFuture;
        block8: {
            Scope ignore = this.span.makeCurrent();
            try {
                ApiFuture<Void> result = this.closeTransactions();
                callback.onSuccess();
                this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                apiFuture = result;
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    callback.onFailure();
                    throw throwable3;
                }
            }
            ignore.close();
        }
        return apiFuture;
    }

    @Override
    public ApiFuture<Void> rollbackAsync(@Nonnull UnitOfWork.CallType callType, @Nonnull UnitOfWork.EndTransactionCallback callback) {
        ApiFuture<Void> apiFuture;
        block8: {
            Scope ignore = this.span.makeCurrent();
            try {
                ApiFuture<Void> result = this.closeTransactions();
                callback.onSuccess();
                this.state = UnitOfWork.UnitOfWorkState.ROLLED_BACK;
                apiFuture = result;
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    callback.onFailure();
                    throw throwable3;
                }
            }
            ignore.close();
        }
        return apiFuture;
    }

    private ApiFuture<Void> closeTransactions() {
        if (this.transaction != null) {
            this.transaction.close();
        }
        if (this.batchReadOnlyTransaction != null) {
            this.batchReadOnlyTransaction.close();
        }
        return this.asyncEndUnitOfWorkSpan();
    }

    @Override
    String getUnitOfWorkName() {
        return "read-only transaction";
    }

    @Override
    AbstractMultiUseTransaction.Savepoint savepoint(String name) {
        return AbstractMultiUseTransaction.Savepoint.of(name);
    }

    @Override
    void rollbackToSavepoint(AbstractMultiUseTransaction.Savepoint savepoint) {
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, ReadOnlyTransaction> {
        private DatabaseClient dbClient;
        private BatchClient batchClient;
        private TimestampBound readOnlyStaleness;

        private Builder() {
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        Builder setBatchClient(BatchClient batchClient) {
            this.batchClient = (BatchClient)Preconditions.checkNotNull((Object)batchClient);
            return this;
        }

        Builder setReadOnlyStaleness(TimestampBound staleness) {
            Preconditions.checkNotNull((Object)staleness);
            this.readOnlyStaleness = staleness;
            return this;
        }

        @Override
        ReadOnlyTransaction build() {
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DatabaseClient client specified");
            Preconditions.checkState((this.batchClient != null ? 1 : 0) != 0, (Object)"No BatchClient client specified");
            Preconditions.checkState((this.readOnlyStaleness != null ? 1 : 0) != 0, (Object)"No ReadOnlyStaleness specified");
            return new ReadOnlyTransaction(this);
        }
    }
}

