/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncResultSetImpl;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingResultSet;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.Type;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AsyncResultSetImplStressTest {
    private static final int TEST_RUNS = 25;
    @Rule
    public Timeout timeout = new Timeout(240L, TimeUnit.SECONDS);
    @Parameterized.Parameter(value=0)
    public int resultSetSize;

    @Parameterized.Parameters(name="rows = {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int rows : new int[]{0, 1, 5, 10}) {
            params.add(new Object[]{rows});
        }
        return params;
    }

    private ResultSet createResultSet() {
        ArrayList<Struct> rows = new ArrayList<Struct>(this.resultSetSize);
        for (int i = 0; i < this.resultSetSize; ++i) {
            rows.add(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to((long)(i + 1))).set("NAME").to(String.format("Row %d", i + 1))).build());
        }
        return ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"ID", (Type)Type.int64()), Type.StructField.of((String)"NAME", (Type)Type.string())}), rows);
    }

    private ResultSet createResultSetWithErrors(double errorFraction) {
        return new ResultSetWithRandomErrors(this.createResultSet(), errorFraction);
    }

    private List<Row> createExpectedRows() {
        ArrayList<Row> rows = new ArrayList<Row>(this.resultSetSize);
        for (int i = 0; i < this.resultSetSize; ++i) {
            rows.add(new Row((long)i + 1L, String.format("Row %d", i + 1)));
        }
        return rows;
    }

    private static ScheduledExecutorService createExecService() {
        return AsyncResultSetImplStressTest.createExecService(1);
    }

    private static ScheduledExecutorService createExecService(int threadCount) {
        return Executors.newScheduledThreadPool(threadCount, new ThreadFactoryBuilder().setDaemon(true).build());
    }

    @Test
    public void toList() {
        SpannerOptions.CloseableExecutorProvider executorProvider = SpannerOptions.createDefaultAsyncExecutorProvider();
        for (int bufferSize = 1; bufferSize < this.resultSetSize * 2; bufferSize *= 2) {
            for (int i = 0; i < 25; ++i) {
                try (AsyncResultSetImpl impl = new AsyncResultSetImpl((ExecutorProvider)executorProvider, this.createResultSet(), bufferSize);){
                    List list = impl.toList(Row::create);
                    Truth.assertThat((Iterable)list).containsExactlyElementsIn(this.createExpectedRows());
                    continue;
                }
            }
        }
    }

    @Test
    public void toListWithErrors() {
        SpannerOptions.CloseableExecutorProvider executorProvider = SpannerOptions.createDefaultAsyncExecutorProvider();
        for (int bufferSize = 1; bufferSize < this.resultSetSize * 2; bufferSize *= 2) {
            for (int i = 0; i < 25; ++i) {
                try (AsyncResultSetImpl impl = new AsyncResultSetImpl((ExecutorProvider)executorProvider, this.createResultSetWithErrors(1.0 / (double)this.resultSetSize), bufferSize);){
                    List list = impl.toList(Row::create);
                    Truth.assertThat((Iterable)list).containsExactlyElementsIn(this.createExpectedRows());
                    continue;
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                    Truth.assertThat((String)e.getMessage()).contains((CharSequence)"random error");
                }
            }
        }
    }

    @Test
    public void asyncToList() throws Exception {
        SpannerOptions.CloseableExecutorProvider executorProvider = SpannerOptions.createDefaultAsyncExecutorProvider();
        for (int bufferSize = 1; bufferSize < this.resultSetSize * 2; bufferSize *= 2) {
            ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>(25);
            ScheduledExecutorService executor = AsyncResultSetImplStressTest.createExecService(32);
            for (int i = 0; i < 25; ++i) {
                try (AsyncResultSetImpl impl = new AsyncResultSetImpl((ExecutorProvider)executorProvider, this.createResultSet(), bufferSize);){
                    futures.add(impl.toListAsync(Row::create, (Executor)executor));
                    continue;
                }
            }
            List lists = (List)ApiFutures.allAsList(futures).get();
            for (List list : lists) {
                Truth.assertThat((Iterable)list).containsExactlyElementsIn(this.createExpectedRows());
            }
            executor.shutdown();
        }
    }

    @Test
    public void consume() throws Exception {
        SpannerOptions.CloseableExecutorProvider executorProvider = SpannerOptions.createDefaultAsyncExecutorProvider();
        Random random = new Random();
        for (Executor executor : new Executor[]{MoreExecutors.directExecutor(), AsyncResultSetImplStressTest.createExecService(), AsyncResultSetImplStressTest.createExecService(32)}) {
            for (int bufferSize = 1; bufferSize < this.resultSetSize * 2; bufferSize *= 2) {
                for (int i = 0; i < 25; ++i) {
                    SettableApiFuture future = SettableApiFuture.create();
                    try (AsyncResultSetImpl impl = new AsyncResultSetImpl((ExecutorProvider)executorProvider, this.createResultSet(), bufferSize);){
                        ImmutableList.Builder builder = ImmutableList.builder();
                        impl.setCallback(executor, resultSet -> {
                            if (random.nextBoolean()) {
                                AsyncResultSet.CursorState state;
                                while ((state = resultSet.tryNext()) == AsyncResultSet.CursorState.OK) {
                                    builder.add((Object)Row.create((StructReader)resultSet));
                                }
                                if (state == AsyncResultSet.CursorState.DONE) {
                                    future.set((Object)builder.build());
                                }
                            }
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        });
                        Truth.assertThat((Iterable)((Iterable)future.get())).containsExactlyElementsIn(this.createExpectedRows());
                        continue;
                    }
                }
            }
        }
    }

    @Test
    public void returnDoneBeforeEnd() throws Exception {
        SpannerOptions.CloseableExecutorProvider executorProvider = SpannerOptions.createDefaultAsyncExecutorProvider();
        Random random = new Random();
        for (Executor executor : new Executor[]{MoreExecutors.directExecutor(), AsyncResultSetImplStressTest.createExecService(), AsyncResultSetImplStressTest.createExecService(32)}) {
            for (int bufferSize = 1; bufferSize < this.resultSetSize * 2; bufferSize *= 2) {
                for (int i = 0; i < 25; ++i) {
                    try (AsyncResultSetImpl impl = new AsyncResultSetImpl((ExecutorProvider)executorProvider, this.createResultSet(), bufferSize);){
                        ApiFuture res = impl.setCallback(executor, resultSet -> {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return random.nextBoolean() ? AsyncResultSet.CallbackResponse.DONE : AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    return random.nextInt(this.resultSetSize) <= 2 ? AsyncResultSet.CallbackResponse.DONE : AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                            }
                            throw new IllegalStateException();
                        });
                        Truth.assertThat((Object)res.get(10L, TimeUnit.SECONDS)).isNull();
                        continue;
                    }
                }
            }
        }
    }

    @Test
    public void pauseResume() throws Exception {
        SpannerOptions.CloseableExecutorProvider executorProvider = SpannerOptions.createDefaultAsyncExecutorProvider();
        Random random = new Random();
        ArrayList<SettableApiFuture> futures = new ArrayList<SettableApiFuture>();
        for (Executor executor : new Executor[]{MoreExecutors.directExecutor(), AsyncResultSetImplStressTest.createExecService(), AsyncResultSetImplStressTest.createExecService(32)}) {
            List<AsyncResultSetImpl> resultSets = Collections.synchronizedList(new ArrayList());
            for (int bufferSize = 1; bufferSize < this.resultSetSize * 2; bufferSize *= 2) {
                for (int i = 0; i < 25; ++i) {
                    SettableApiFuture future = SettableApiFuture.create();
                    futures.add(future);
                    try (AsyncResultSetImpl impl = new AsyncResultSetImpl((ExecutorProvider)executorProvider, this.createResultSet(), bufferSize);){
                        resultSets.add(impl);
                        ImmutableList.Builder builder = ImmutableList.builder();
                        impl.setCallback(executor, resultSet -> {
                            AsyncResultSet.CursorState state;
                            while ((state = resultSet.tryNext()) == AsyncResultSet.CursorState.OK) {
                                builder.add((Object)Row.create((StructReader)resultSet));
                                if (!random.nextBoolean()) continue;
                                return AsyncResultSet.CallbackResponse.PAUSE;
                            }
                            if (state == AsyncResultSet.CursorState.DONE) {
                                future.set((Object)builder.build());
                            }
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        });
                        continue;
                    }
                }
            }
            AtomicBoolean finished = new AtomicBoolean(false);
            ScheduledExecutorService resumeService = AsyncResultSetImplStressTest.createExecService();
            resumeService.execute(() -> {
                while (!finished.get()) {
                    ((AsyncResultSet)resultSets.get(random.nextInt(resultSets.size()))).resume();
                }
            });
            List lists = (List)ApiFutures.allAsList(futures).get();
            for (ImmutableList list : lists) {
                Truth.assertThat((Iterable)list).containsExactlyElementsIn(this.createExpectedRows());
            }
            if (executor instanceof ExecutorService) {
                ((ExecutorService)executor).shutdown();
            }
            finished.set(true);
            resumeService.shutdown();
        }
    }

    @Test
    public void cancel() throws Exception {
        SpannerOptions.CloseableExecutorProvider executorProvider = SpannerOptions.createDefaultAsyncExecutorProvider();
        Random random = new Random();
        for (Executor executor : new Executor[]{MoreExecutors.directExecutor(), AsyncResultSetImplStressTest.createExecService(), AsyncResultSetImplStressTest.createExecService(32)}) {
            ArrayList<SettableApiFuture> futures = new ArrayList<SettableApiFuture>();
            List<AsyncResultSetImpl> resultSets = Collections.synchronizedList(new ArrayList());
            HashSet cancelledIndexes = new HashSet();
            for (int bufferSize = 1; bufferSize < this.resultSetSize * 2; bufferSize *= 2) {
                for (int i = 0; i < 25; ++i) {
                    SettableApiFuture future = SettableApiFuture.create();
                    futures.add(future);
                    Throwable throwable = null;
                    try (AsyncResultSetImpl impl = new AsyncResultSetImpl((ExecutorProvider)executorProvider, this.createResultSet(), bufferSize);){
                        resultSets.add(impl);
                        ImmutableList.Builder builder = ImmutableList.builder();
                        impl.setCallback(executor, resultSet -> {
                            try {
                                AsyncResultSet.CursorState state;
                                while ((state = resultSet.tryNext()) == AsyncResultSet.CursorState.OK) {
                                    builder.add((Object)Row.create((StructReader)resultSet));
                                    if (!random.nextBoolean()) continue;
                                    return AsyncResultSet.CallbackResponse.PAUSE;
                                }
                                if (state == AsyncResultSet.CursorState.DONE) {
                                    future.set((Object)builder.build());
                                }
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                            catch (SpannerException e) {
                                future.setException((Throwable)e);
                                throw e;
                            }
                        });
                        continue;
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
            }
            AtomicBoolean finished = new AtomicBoolean(false);
            ScheduledExecutorService resumeService = AsyncResultSetImplStressTest.createExecService();
            resumeService.execute(() -> {
                while (!finished.get()) {
                    ((AsyncResultSet)resultSets.get(random.nextInt(resultSets.size()))).resume();
                }
                for (AsyncResultSet rs : resultSets) {
                    rs.resume();
                }
            });
            ScheduledExecutorService cancelService = AsyncResultSetImplStressTest.createExecService();
            cancelService.execute(() -> {
                while (!finished.get()) {
                    int index = random.nextInt(resultSets.size());
                    ((AsyncResultSet)resultSets.get(index)).cancel();
                    cancelledIndexes.add(index);
                }
            });
            for (ApiFuture apiFuture : futures) {
                try {
                    apiFuture.get();
                }
                catch (Throwable throwable) {}
            }
            finished.set(true);
            cancelService.shutdown();
            cancelService.awaitTermination(10L, TimeUnit.SECONDS);
            int index = 0;
            for (ApiFuture apiFuture : futures) {
                try {
                    ImmutableList list = (ImmutableList)apiFuture.get(30L, TimeUnit.SECONDS);
                    Truth.assertThat((Iterable)list).containsExactlyElementsIn(this.createExpectedRows());
                }
                catch (ExecutionException e) {
                    Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
                    SpannerException se = (SpannerException)e.getCause();
                    Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.CANCELLED);
                    Truth.assertThat(cancelledIndexes).contains((Object)index);
                }
                ++index;
            }
            if (!(executor instanceof ExecutorService)) continue;
            ((ExecutorService)executor).shutdown();
        }
    }

    private static final class ResultSetWithRandomErrors
    extends ForwardingResultSet {
        private final Random random = new Random();
        private final double errorFraction;

        private ResultSetWithRandomErrors(ResultSet delegate, double errorFraction) {
            super(delegate);
            this.errorFraction = errorFraction;
        }

        public boolean next() {
            if (this.random.nextDouble() < this.errorFraction) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"random error");
            }
            return super.next();
        }
    }

    private static final class Row {
        private final Long id;
        private final String name;

        static Row create(StructReader reader) {
            return new Row(reader.getLong("ID"), reader.getString("NAME"));
        }

        private Row(Long id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return String.format("ID: %d, NAME: %s", this.id, this.name);
        }
    }
}

