/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.Identity;
import com.google.cloud.NoCredentials;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.BackupInfo;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseInfo;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.MockDatabaseAdminServiceImpl;
import com.google.cloud.spanner.MockOperationsServiceImpl;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.testing.TimestampHelper;
import com.google.common.truth.Truth;
import com.google.longrunning.Operation;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.rpc.ErrorInfo;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateBackupRequest;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseRequest;
import io.grpc.BindableService;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class DatabaseAdminClientTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String DB_ID = "test-db";
    private static final String BCK_ID = "test-bck";
    private static final String RESTORED_ID = "restored-test-db";
    private static final String TEST_PARENT = "projects/my-project/instances/my-instance";
    private static final String TEST_BCK_NAME = String.format("%s/backups/test-bck", "projects/my-project/instances/my-instance");
    private static final List<String> INITIAL_STATEMENTS = Arrays.asList("CREATE TABLE FOO", "CREATE TABLE BAR");
    private static MockOperationsServiceImpl mockOperations;
    private static MockDatabaseAdminServiceImpl mockDatabaseAdmin;
    private static Server server;
    private static InetSocketAddress address;
    private static Spanner spanner;
    private static DatabaseAdminClient client;
    private OperationFuture<Database, CreateDatabaseMetadata> createDatabaseOperation;
    private OperationFuture<Backup, CreateBackupMetadata> createBackupOperation;
    private OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabaseOperation;

    @BeforeClass
    public static void startStaticServer() throws Exception {
        mockOperations = new MockOperationsServiceImpl();
        mockDatabaseAdmin = new MockDatabaseAdminServiceImpl(mockOperations);
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockOperations)).addService((BindableService)mockDatabaseAdmin)).build().start();
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        RetrySettings longRunningInitialRetrySettings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600L)).setMaxRpcTimeout(Duration.ofMillis((long)6000L)).setInitialRetryDelay(Duration.ofMillis((long)20L)).setMaxRetryDelay(Duration.ofMillis((long)45L)).setRetryDelayMultiplier(1.5).setRpcTimeoutMultiplier(1.5).setTotalTimeout(Duration.ofMinutes((long)48L)).build();
        builder.getDatabaseAdminStubSettingsBuilder().createBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetrySettings(longRunningInitialRetrySettings).build());
        builder.getDatabaseAdminStubSettingsBuilder().createBackupOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)20L)).setInitialRetryDelay(Duration.ofMillis((long)10L)).setMaxRetryDelay(Duration.ofMillis((long)150L)).setMaxRpcTimeout(Duration.ofMillis((long)150L)).setMaxAttempts(10).setTotalTimeout(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setRpcTimeoutMultiplier(1.3).build()));
        builder.getDatabaseAdminStubSettingsBuilder().createDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetrySettings(longRunningInitialRetrySettings).build());
        builder.getDatabaseAdminStubSettingsBuilder().createDatabaseOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)20L)).setInitialRetryDelay(Duration.ofMillis((long)10L)).setMaxRetryDelay(Duration.ofMillis((long)150L)).setMaxRpcTimeout(Duration.ofMillis((long)150L)).setMaxAttempts(10).setTotalTimeout(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setRpcTimeoutMultiplier(1.3).build()));
        builder.getDatabaseAdminStubSettingsBuilder().restoreDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetrySettings(longRunningInitialRetrySettings).build());
        builder.getDatabaseAdminStubSettingsBuilder().restoreDatabaseOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)20L)).setInitialRetryDelay(Duration.ofMillis((long)10L)).setMaxRetryDelay(Duration.ofMillis((long)150L)).setMaxRpcTimeout(Duration.ofMillis((long)150L)).setMaxAttempts(10).setTotalTimeout(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setRpcTimeoutMultiplier(1.3).build()));
        builder.setRetryAdministrativeRequestsSettings(SpannerOptions.Builder.DEFAULT_ADMIN_REQUESTS_LIMIT_EXCEEDED_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofNanos((long)1L)).build());
        spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)builder.setHost("http://localhost:" + server.getPort()).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setCredentials((Credentials)NoCredentials.getInstance())).setProjectId(PROJECT_ID)).build().getService();
        client = spanner.getDatabaseAdminClient();
    }

    @AfterClass
    public static void stopServer() throws Exception {
        spanner.close();
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() {
        mockDatabaseAdmin.reset();
        mockOperations.reset();
        this.createTestDatabase();
        this.createTestBackup();
        this.restoreTestBackup();
    }

    @After
    public void tearDown() {
        mockDatabaseAdmin.reset();
        mockDatabaseAdmin.removeAllExecutionTimes();
        mockOperations.reset();
    }

    @Test
    public void dbAdminCreateBackup() throws InterruptedException, ExecutionException {
        String backupId = "other-backup-id";
        OperationFuture op = client.createBackup(INSTANCE_ID, "other-backup-id", DB_ID, TimestampHelper.afterDays((int)7));
        Backup backup = (Backup)op.get();
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/backups/%s", PROJECT_ID, INSTANCE_ID, "other-backup-id"));
        Truth.assertThat((Object)client.getBackup(INSTANCE_ID, "other-backup-id")).isEqualTo((Object)backup);
    }

    @Test
    public void backupCreate() throws InterruptedException, ExecutionException {
        String backupId = "other-backup-id";
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"other-backup-id")).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).setExpireTime(TimestampHelper.afterDays((int)7)).setVersionTime(this.sevenDaysAgo()).build();
        OperationFuture op = backup.create();
        backup = (Backup)op.get();
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/backups/%s", PROJECT_ID, INSTANCE_ID, "other-backup-id"));
        Truth.assertThat((Object)client.getBackup(INSTANCE_ID, "other-backup-id")).isEqualTo((Object)backup);
    }

    @Test
    public void databaseAdminBackupCreate() throws ExecutionException, InterruptedException {
        String backupId = "other-backup-id";
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"other-backup-id")).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).setExpireTime(TimestampHelper.afterDays((int)7)).setVersionTime(this.sevenDaysAgo()).build();
        OperationFuture op = client.createBackup(backup);
        backup = (Backup)op.get();
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/backups/%s", PROJECT_ID, INSTANCE_ID, "other-backup-id"));
        Truth.assertThat((Object)client.getBackup(INSTANCE_ID, "other-backup-id")).isEqualTo((Object)backup);
    }

    @Test
    public void backupCreateCancel() {
        String backupId = "other-backup-id";
        long currentTimeInMicroSeconds = TimeUnit.MICROSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        long deltaTimeInMicroseconds = TimeUnit.MICROSECONDS.convert(14L, TimeUnit.DAYS);
        Timestamp expireTime = Timestamp.ofTimeMicroseconds((long)(currentTimeInMicroSeconds + deltaTimeInMicroseconds));
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"other-backup-id")).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).setExpireTime(expireTime).build();
        OperationFuture op = backup.create();
        try {
            client.cancelOperation(op.getName());
            RetryingFuture pollingFuture = op.getPollingFuture();
            while (!((OperationSnapshot)pollingFuture.get()).isDone()) {
                Thread.sleep(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
            }
        }
        catch (CancellationException pollingFuture) {
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
        finally {
            backup.delete();
        }
    }

    @Test
    public void databaseBackup() throws InterruptedException, ExecutionException {
        String backupId = "other-backup-id";
        Database db = client.getDatabase(INSTANCE_ID, DB_ID);
        Backup backup = (Backup)db.backup(client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"other-backup-id")).setExpireTime(TimestampHelper.afterDays((int)7)).build()).get();
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/backups/%s", PROJECT_ID, INSTANCE_ID, "other-backup-id"));
        Truth.assertThat((Object)client.getBackup(INSTANCE_ID, "other-backup-id")).isEqualTo((Object)backup);
    }

    @Test
    public void dbAdminCreateBackupAlreadyExists() {
        OperationFuture op = client.createBackup(INSTANCE_ID, BCK_ID, DB_ID, TimestampHelper.afterDays((int)7));
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
            Backup cfr_ignored_0 = (Backup)SpannerApiFutures.get((ApiFuture)op);
        });
        Assert.assertEquals((Object)ErrorCode.ALREADY_EXISTS, (Object)e.getErrorCode());
    }

    @Test
    public void backupCreateAlreadyExists() {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).setExpireTime(TimestampHelper.afterDays((int)7)).build();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
            Backup cfr_ignored_0 = (Backup)SpannerApiFutures.get((ApiFuture)backup.create());
        });
        Assert.assertEquals((Object)ErrorCode.ALREADY_EXISTS, (Object)e.getErrorCode());
    }

    @Test
    public void databaseBackupAlreadyExists() {
        Database db = client.getDatabase(INSTANCE_ID, DB_ID);
        OperationFuture op = db.backup(client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).setExpireTime(TimestampHelper.afterDays((int)7)).build());
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
            Backup cfr_ignored_0 = (Backup)SpannerApiFutures.get((ApiFuture)op);
        });
        Assert.assertEquals((Object)ErrorCode.ALREADY_EXISTS, (Object)e.getErrorCode());
    }

    @Test
    public void dbAdminCreateBackupDbNotFound() {
        String backupId = "other-backup-id";
        OperationFuture op = client.createBackup(INSTANCE_ID, "other-backup-id", "does-not-exist", TimestampHelper.afterDays((int)7));
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
            Backup cfr_ignored_0 = (Backup)SpannerApiFutures.get((ApiFuture)op);
        });
        Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)e.getErrorCode());
    }

    @Test
    public void backupCreateDbNotFound() {
        String backupId = "other-backup-id";
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"other-backup-id")).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"does-not-exist")).setExpireTime(TimestampHelper.afterDays((int)7)).build();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
            Backup cfr_ignored_0 = (Backup)SpannerApiFutures.get((ApiFuture)backup.create());
        });
        Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)e.getErrorCode());
    }

    @Test
    public void databaseBackupDbNotFound() throws InterruptedException {
        String backupId = "other-backup-id";
        Database db = new Database(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"does-not-exist"), DatabaseInfo.State.UNSPECIFIED, client);
        OperationFuture op = db.backup(client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"other-backup-id")).setExpireTime(TimestampHelper.afterDays((int)7)).build());
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
            Backup cfr_ignored_0 = (Backup)SpannerApiFutures.get((ApiFuture)op);
        });
        Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)e.getErrorCode());
    }

    @Test
    public void dbAdminDeleteBackup() {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).build();
        Truth.assertThat((Boolean)backup.exists()).isTrue();
        client.deleteBackup(INSTANCE_ID, BCK_ID);
        Truth.assertThat((Boolean)backup.exists()).isFalse();
    }

    @Test
    public void backupDelete() {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).build();
        Truth.assertThat((Boolean)backup.exists()).isTrue();
        backup.delete();
        Truth.assertThat((Boolean)backup.exists()).isFalse();
    }

    @Test
    public void dbAdminDeleteBackupNotFound() {
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.deleteBackup(INSTANCE_ID, "does-not-exist"));
        Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)e.getErrorCode());
    }

    @Test
    public void backupDeleteNotFound() {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"does-not-exist")).build();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> backup.delete());
        Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)e.getErrorCode());
    }

    @Test
    public void dbAdminGetBackup() {
        Backup backup = client.getBackup(INSTANCE_ID, BCK_ID);
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)TEST_BCK_NAME);
    }

    @Test
    public void backupReload() {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).build();
        Truth.assertThat((Comparable)backup.getState()).isEqualTo((Object)BackupInfo.State.UNSPECIFIED);
        backup.reload();
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)TEST_BCK_NAME);
    }

    @Test
    public void dbAdminGetBackupNotFound() {
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.getBackup(INSTANCE_ID, "does-not-exist"));
        Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)e.getErrorCode());
    }

    @Test
    public void backupReloadNotFound() {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"does-not-exist")).build();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> backup.reload());
        Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)e.getErrorCode());
    }

    @Test
    public void backupExists() {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"does-not-exist")).build();
        Truth.assertThat((Boolean)backup.exists()).isFalse();
        backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).build();
        Truth.assertThat((Boolean)backup.exists()).isTrue();
    }

    @Test
    public void dbClientListBackups() throws SpannerException, InterruptedException, ExecutionException {
        Backup backup = client.getBackup(INSTANCE_ID, BCK_ID);
        Truth.assertThat((Iterable)client.listBackups(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).containsExactly(new Object[]{backup});
        Backup backup2 = (Backup)client.createBackup(INSTANCE_ID, "backup2", DB_ID, TimestampHelper.afterDays((int)7)).get();
        Truth.assertThat((Iterable)client.listBackups(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).containsExactly(new Object[]{backup, backup2});
        backup2.delete();
        Truth.assertThat((Iterable)client.listBackups(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).containsExactly(new Object[]{backup});
    }

    @Test
    public void instanceListBackups() throws SpannerException, InterruptedException, ExecutionException {
        Instance instance = spanner.getInstanceAdminClient().newInstanceBuilder(InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        Backup backup = client.getBackup(INSTANCE_ID, BCK_ID);
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[0]).iterateAll()).containsExactly(new Object[]{backup});
        Backup backup2 = (Backup)client.createBackup(INSTANCE_ID, "backup2", DB_ID, TimestampHelper.afterDays((int)7)).get();
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[0]).iterateAll()).containsExactly(new Object[]{backup, backup2});
        backup2.delete();
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[0]).iterateAll()).containsExactly(new Object[]{backup});
    }

    @Test
    public void instanceListBackupsWithFilter() throws SpannerException, InterruptedException, ExecutionException {
        Instance instance = spanner.getInstanceAdminClient().newInstanceBuilder(InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        Backup backup = client.getBackup(INSTANCE_ID, BCK_ID);
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[0]).iterateAll()).containsExactly(new Object[]{backup});
        Backup backup2 = (Backup)client.createBackup(INSTANCE_ID, "backup2", DB_ID, TimestampHelper.afterDays((int)7)).get();
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[0]).iterateAll()).containsExactly(new Object[]{backup, backup2});
        String filter = "name:backup2";
        mockDatabaseAdmin.addFilterMatches(filter, backup2.getId().getName());
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[]{Options.filter((String)filter)}).iterateAll()).containsExactly(new Object[]{backup2});
        filter = String.format("database:%s", DB_ID);
        mockDatabaseAdmin.addFilterMatches(filter, backup.getId().getName(), backup2.getId().getName());
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[]{Options.filter((String)filter)}).iterateAll()).containsExactly(new Object[]{backup, backup2});
        String ts = TimestampHelper.afterDays((int)14).toString();
        filter = String.format("expire_time < \"%s\"", ts);
        mockDatabaseAdmin.addFilterMatches(filter, backup.getId().getName(), backup2.getId().getName());
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[]{Options.filter((String)filter)}).iterateAll()).containsExactly(new Object[]{backup, backup2});
        long minBytes = Math.min(backup.getSize(), backup2.getSize());
        filter = String.format("size_bytes > %d", minBytes);
        Backup backupWithLargestSize = backup.getSize() == minBytes ? backup2 : backup;
        mockDatabaseAdmin.addFilterMatches(filter, backupWithLargestSize.getId().getName());
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[]{Options.filter((String)filter)}).iterateAll()).containsExactly(new Object[]{backupWithLargestSize});
        ts = backup2.getProto().getCreateTime().toString();
        filter = String.format("create_time >= \"%s\" AND state:READY", ts);
        mockDatabaseAdmin.addFilterMatches(filter, backup2.getId().getName());
        Truth.assertThat((Iterable)instance.listBackups(new Options.ListOption[]{Options.filter((String)filter)}).iterateAll()).containsExactly(new Object[]{backup2});
    }

    @Test
    public void dbClientUpdateBackup() {
        Timestamp oldExpireTime = client.getBackup(INSTANCE_ID, BCK_ID).getExpireTime();
        Timestamp newExpireTime = Timestamp.ofTimeSecondsAndNanos((long)(Timestamp.now().getSeconds() + TimeUnit.SECONDS.convert(1L, TimeUnit.DAYS)), (int)0);
        Truth.assertThat((Comparable)oldExpireTime).isNotEqualTo((Object)newExpireTime);
        Backup backup = client.updateBackup(INSTANCE_ID, BCK_ID, newExpireTime);
        Truth.assertThat((Comparable)backup.getExpireTime()).isEqualTo((Object)newExpireTime);
        Truth.assertThat((Object)client.getBackup(INSTANCE_ID, BCK_ID)).isEqualTo((Object)backup);
    }

    @Test
    public void backupUpdate() {
        Timestamp newExpireTime = Timestamp.ofTimeSecondsAndNanos((long)(Timestamp.now().getSeconds() + TimeUnit.SECONDS.convert(1L, TimeUnit.DAYS)), (int)0);
        Backup backup = client.getBackup(INSTANCE_ID, BCK_ID);
        Truth.assertThat((Comparable)backup.getExpireTime()).isNotEqualTo((Object)newExpireTime);
        backup.toBuilder().setExpireTime(newExpireTime).build().updateExpireTime();
        Backup updated = client.getBackup(INSTANCE_ID, BCK_ID);
        Truth.assertThat((Comparable)updated.getExpireTime()).isEqualTo((Object)newExpireTime);
        Truth.assertThat((Object)updated).isNotEqualTo((Object)backup);
        Truth.assertThat((Object)backup.reload()).isEqualTo((Object)updated);
    }

    @Test
    public void dbClientRestoreDatabase() throws InterruptedException, ExecutionException {
        OperationFuture op = client.restoreDatabase(INSTANCE_ID, BCK_ID, "other-instance-id", "restored-db");
        Database restored = (Database)op.get();
        Truth.assertThat((String)restored.getId().getDatabase()).isEqualTo((Object)"restored-db");
        Truth.assertThat((String)restored.getId().getInstanceId().getInstance()).isEqualTo((Object)"other-instance-id");
    }

    @Test
    public void backupRestoreDatabase() throws InterruptedException, ExecutionException {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).build();
        Database restored = (Database)backup.restore(DatabaseId.of((String)PROJECT_ID, (String)"other-instance-id", (String)"restored-db")).get();
        Truth.assertThat((String)restored.getId().getDatabase()).isEqualTo((Object)"restored-db");
        Truth.assertThat((String)restored.getId().getInstanceId().getInstance()).isEqualTo((Object)"other-instance-id");
    }

    @Test
    public void dbClientListDatabaseOperations() throws SpannerException, InterruptedException, ExecutionException {
        Truth.assertThat((Iterable)client.listDatabaseOperations(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).hasSize(3);
        client.createDatabase(INSTANCE_ID, "other-database", Collections.emptyList()).get();
        Truth.assertThat((Iterable)client.listDatabaseOperations(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).hasSize(4);
        client.restoreDatabase(INSTANCE_ID, BCK_ID, INSTANCE_ID, "restored-db").get();
        Truth.assertThat((Iterable)client.listDatabaseOperations(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).hasSize(6);
    }

    @Test
    public void instanceListDatabaseOperations() throws SpannerException, InterruptedException, ExecutionException {
        Instance instance = spanner.getInstanceAdminClient().newInstanceBuilder(InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        Truth.assertThat((Iterable)instance.listDatabaseOperations(new Options.ListOption[0]).iterateAll()).hasSize(3);
        instance.createDatabase("other-database", Collections.emptyList()).get();
        Truth.assertThat((Iterable)instance.listDatabaseOperations(new Options.ListOption[0]).iterateAll()).hasSize(4);
        client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).build().restore(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"restored-db")).get();
        Truth.assertThat((Iterable)instance.listDatabaseOperations(new Options.ListOption[0]).iterateAll()).hasSize(6);
    }

    @Test
    public void instanceListDatabaseOperationsWithMetadata() throws Exception {
        Instance instance = spanner.getInstanceAdminClient().newInstanceBuilder(InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        String filter = "(metadata.@type:type.googleapis.com/google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata)";
        mockDatabaseAdmin.addFilterMatches(filter, ((RestoreDatabaseMetadata)this.restoreDatabaseOperation.getMetadata().get()).getOptimizeDatabaseOperationName());
        Iterable operations = instance.listDatabaseOperations(new Options.ListOption[]{Options.filter((String)filter)}).iterateAll();
        Truth.assertThat((Iterable)operations).hasSize(1);
        for (Operation op : operations) {
            OptimizeRestoredDatabaseMetadata metadata = (OptimizeRestoredDatabaseMetadata)op.getMetadata().unpack(OptimizeRestoredDatabaseMetadata.class);
            String progress = String.format("Restored database %s is optimized %d%%", metadata.getName(), metadata.getProgress().getProgressPercent());
            Truth.assertThat((Boolean)progress.contains("100%"));
        }
    }

    @Test
    public void databaseListDatabaseOperations() throws SpannerException, InterruptedException, ExecutionException {
        Database database = client.getDatabase(INSTANCE_ID, DB_ID);
        mockDatabaseAdmin.addFilterMatches("name:databases/test-db", this.createDatabaseOperation.getName());
        Truth.assertThat((Iterable)database.listDatabaseOperations().iterateAll()).hasSize(1);
        client.createDatabase(INSTANCE_ID, "other-database", Collections.emptyList()).get();
        Truth.assertThat((Iterable)database.listDatabaseOperations().iterateAll()).hasSize(1);
        OperationFuture op = database.updateDdl(Collections.singletonList("DROP TABLE FOO"), null);
        mockDatabaseAdmin.addFilterMatches("name:databases/test-db", op.getName());
        Truth.assertThat((Iterable)database.listDatabaseOperations().iterateAll()).hasSize(2);
    }

    @Test
    public void dbClientListBackupOperations() throws SpannerException, InterruptedException, ExecutionException {
        Truth.assertThat((Iterable)client.listBackupOperations(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).hasSize(1);
        client.createBackup(INSTANCE_ID, "other-backup", DB_ID, TimestampHelper.afterDays((int)7)).get();
        Truth.assertThat((Iterable)client.listBackupOperations(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).hasSize(2);
        client.restoreDatabase(INSTANCE_ID, BCK_ID, INSTANCE_ID, "restored-db").get();
        Truth.assertThat((Iterable)client.listBackupOperations(INSTANCE_ID, new Options.ListOption[0]).iterateAll()).hasSize(2);
    }

    @Test
    public void instanceListBackupOperations() throws SpannerException, InterruptedException, ExecutionException {
        Instance instance = spanner.getInstanceAdminClient().newInstanceBuilder(InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        Truth.assertThat((Iterable)instance.listBackupOperations(new Options.ListOption[0]).iterateAll()).hasSize(1);
        instance.getDatabase(DB_ID).backup(client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"other-backup")).setExpireTime(TimestampHelper.afterDays((int)7)).build()).get();
        Truth.assertThat((Iterable)instance.listBackupOperations(new Options.ListOption[0]).iterateAll()).hasSize(2);
        client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).build().restore(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)"restored-db")).get();
        Truth.assertThat((Iterable)instance.listBackupOperations(new Options.ListOption[0]).iterateAll()).hasSize(2);
    }

    @Test
    public void instanceListBackupOperationsWithProgress() throws InvalidProtocolBufferException {
        Instance instance = spanner.getInstanceAdminClient().newInstanceBuilder(InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        String database = String.format("%s/databases/%s", TEST_PARENT, DB_ID);
        String filter = String.format("(metadata.database:%s) AND (metadata.@type:type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata)", database);
        Page operations = instance.listBackupOperations(new Options.ListOption[]{Options.filter((String)filter)});
        for (Operation op : operations.iterateAll()) {
            CreateBackupMetadata metadata = (CreateBackupMetadata)op.getMetadata().unpack(CreateBackupMetadata.class);
            String progress = String.format("Backup %s on database %s pending: %d%% complete", metadata.getName(), metadata.getDatabase(), metadata.getProgress().getProgressPercent());
            Truth.assertThat((Boolean)progress.contains("100%"));
        }
    }

    @Test
    public void backupListBackupOperations() throws SpannerException, InterruptedException, ExecutionException {
        Backup backup = client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BCK_ID)).build();
        mockDatabaseAdmin.addFilterMatches("name:backups/test-bck", this.createBackupOperation.getName());
        Truth.assertThat((Iterable)backup.listBackupOperations().iterateAll()).hasSize(1);
        client.createBackup(INSTANCE_ID, "other-backup", DB_ID, TimestampHelper.afterDays((int)7)).get();
        Truth.assertThat((Iterable)backup.listBackupOperations().iterateAll()).hasSize(1);
    }

    @Test
    public void getAndSetIAMPolicy() {
        Policy policy = client.getDatabaseIAMPolicy(INSTANCE_ID, DB_ID);
        Truth.assertThat((Object)policy).isEqualTo((Object)Policy.newBuilder().build());
        Policy newPolicy = Policy.newBuilder().addIdentity(Role.editor(), Identity.user((String)"joe@example.com"), new Identity[0]).build();
        Policy returnedPolicy = client.setDatabaseIAMPolicy(INSTANCE_ID, DB_ID, newPolicy);
        Truth.assertThat((Object)returnedPolicy).isEqualTo((Object)newPolicy);
        Truth.assertThat((Object)client.getDatabaseIAMPolicy(INSTANCE_ID, DB_ID)).isEqualTo((Object)newPolicy);
    }

    @Test
    public void testDatabaseIAMPermissions() {
        Iterable permissions = client.testDatabaseIAMPermissions(INSTANCE_ID, DB_ID, Collections.singletonList("spanner.databases.select"));
        Truth.assertThat((Iterable)permissions).containsExactly(new Object[]{"spanner.databases.select"});
    }

    private Timestamp sevenDaysAgo() {
        return Timestamp.ofTimeMicroseconds((long)(TimeUnit.MICROSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS) - TimeUnit.MICROSECONDS.convert(7L, TimeUnit.DAYS)));
    }

    private void createTestDatabase() {
        try {
            this.createDatabaseOperation = client.createDatabase(INSTANCE_ID, DB_ID, INITIAL_STATEMENTS);
            this.createDatabaseOperation.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException((Throwable)e);
        }
    }

    private void createTestBackup() {
        try {
            this.createBackupOperation = client.createBackup(INSTANCE_ID, BCK_ID, DB_ID, TimestampHelper.afterDays((int)7));
            this.createBackupOperation.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException((Throwable)e);
        }
    }

    private void restoreTestBackup() {
        try {
            this.restoreDatabaseOperation = client.restoreDatabase(INSTANCE_ID, BCK_ID, INSTANCE_ID, RESTORED_ID);
            this.restoreDatabaseOperation.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException((Throwable)e);
        }
    }

    @Test
    public void retryCreateBackupSlowResponse() throws Exception {
        mockDatabaseAdmin.setCreateBackupResponseExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        String backupId = "other-backup-id";
        OperationFuture op = client.createBackup(INSTANCE_ID, "other-backup-id", DB_ID, TimestampHelper.afterDays((int)7));
        Backup backup = (Backup)op.get();
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/backups/%s", PROJECT_ID, INSTANCE_ID, "other-backup-id"));
        Truth.assertThat((Object)client.getBackup(INSTANCE_ID, "other-backup-id")).isEqualTo((Object)backup);
        Truth.assertThat((Integer)mockDatabaseAdmin.countRequestsOfType(CreateBackupRequest.class)).isEqualTo((Object)2);
    }

    @Test
    public void retryCreateBackupSlowStartup() throws Exception {
        mockDatabaseAdmin.setCreateBackupStartupExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        String backupId = "other-backup-id";
        OperationFuture op = client.createBackup(INSTANCE_ID, "other-backup-id", DB_ID, TimestampHelper.afterDays((int)7));
        Backup backup = (Backup)op.get();
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/backups/%s", PROJECT_ID, INSTANCE_ID, "other-backup-id"));
        Truth.assertThat((Object)client.getBackup(INSTANCE_ID, "other-backup-id")).isEqualTo((Object)backup);
        Truth.assertThat((Integer)mockDatabaseAdmin.countRequestsOfType(CreateBackupRequest.class)).isAtLeast((Comparable)Integer.valueOf(3));
    }

    @Test
    public void retryCreateDatabaseSlowResponse() throws Exception {
        mockDatabaseAdmin.setCreateDatabaseResponseExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        String databaseId = "other-database-id";
        OperationFuture op = client.createDatabase(INSTANCE_ID, "other-database-id", Collections.emptyList());
        Database database = (Database)op.get();
        Truth.assertThat((String)database.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/databases/%s", PROJECT_ID, INSTANCE_ID, "other-database-id"));
        Truth.assertThat((Object)client.getDatabase(INSTANCE_ID, "other-database-id")).isEqualTo((Object)database);
        Truth.assertThat((Integer)mockDatabaseAdmin.countRequestsOfType(CreateDatabaseRequest.class)).isEqualTo((Object)2);
    }

    @Test
    public void retryCreateDatabaseSlowStartup() throws Exception {
        mockDatabaseAdmin.setCreateDatabaseStartupExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        String databaseId = "other-database-id";
        OperationFuture op = client.createDatabase(INSTANCE_ID, "other-database-id", Collections.emptyList());
        Database database = (Database)op.get();
        Truth.assertThat((String)database.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/databases/%s", PROJECT_ID, INSTANCE_ID, "other-database-id"));
        Truth.assertThat((Object)client.getDatabase(INSTANCE_ID, "other-database-id")).isEqualTo((Object)database);
        Truth.assertThat((Integer)mockDatabaseAdmin.countRequestsOfType(CreateDatabaseRequest.class)).isAtLeast((Comparable)Integer.valueOf(3));
    }

    @Test
    public void retryRestoreDatabaseSlowResponse() throws Exception {
        mockDatabaseAdmin.setRestoreDatabaseResponseExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        String databaseId = "other-database-id";
        OperationFuture op = client.restoreDatabase(INSTANCE_ID, BCK_ID, INSTANCE_ID, "other-database-id");
        Database database = (Database)op.get();
        Truth.assertThat((String)database.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/databases/%s", PROJECT_ID, INSTANCE_ID, "other-database-id"));
        Database retrieved = client.getDatabase(INSTANCE_ID, "other-database-id");
        Truth.assertThat((Comparable)retrieved.getCreateTime()).isEqualTo((Object)database.getCreateTime());
        Truth.assertThat((Integer)mockDatabaseAdmin.countRequestsOfType(RestoreDatabaseRequest.class)).isEqualTo((Object)2);
    }

    @Test
    public void retryRestoreDatabaseSlowStartup() throws Exception {
        mockDatabaseAdmin.setRestoreDatabaseStartupExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        String databaseId = "other-database-id";
        OperationFuture op = client.restoreDatabase(INSTANCE_ID, BCK_ID, INSTANCE_ID, "other-database-id");
        Database database = (Database)op.get();
        Truth.assertThat((String)database.getId().getName()).isEqualTo((Object)String.format("projects/%s/instances/%s/databases/%s", PROJECT_ID, INSTANCE_ID, "other-database-id"));
        Database retrieved = client.getDatabase(INSTANCE_ID, "other-database-id");
        Truth.assertThat((Comparable)retrieved.getCreateTime()).isEqualTo((Object)database.getCreateTime());
        Truth.assertThat((Integer)mockDatabaseAdmin.countRequestsOfType(RestoreDatabaseRequest.class)).isAtLeast((Comparable)Integer.valueOf(3));
    }

    @Test
    public void testRetryOperationOnAdminMethodQuotaPerMinutePerProjectExceeded() {
        ErrorInfo info = ErrorInfo.newBuilder().putMetadata("quota_limit", "AdminMethodQuotaPerMinutePerProject").build();
        Metadata.Key key = Metadata.Key.of((String)(info.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)info));
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)info);
        mockDatabaseAdmin.addException((Exception)((Object)Status.RESOURCE_EXHAUSTED.withDescription("foo").asRuntimeException(trailers)));
        mockDatabaseAdmin.clearRequests();
        Database database = client.getDatabase(INSTANCE_ID, DB_ID);
        Assert.assertEquals((Object)DB_ID, (Object)database.getId().getDatabase());
        Assert.assertEquals((long)2L, (long)mockDatabaseAdmin.countRequestsOfType(GetDatabaseRequest.class));
    }
}

