/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.DatabaseId;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DatabaseIdTest {
    @Test
    public void basics() {
        String name = "projects/test-project/instances/test-instance/databases/database-1";
        DatabaseId db = DatabaseId.of((String)name);
        Truth.assertThat((String)db.getName()).isEqualTo((Object)name);
        Truth.assertThat((String)db.getInstanceId().getInstance()).isEqualTo((Object)"test-instance");
        Truth.assertThat((String)db.getDatabase()).isEqualTo((Object)"database-1");
        Truth.assertThat((Object)DatabaseId.of((String)"test-project", (String)"test-instance", (String)"database-1")).isEqualTo((Object)db);
        Truth.assertThat((Object)DatabaseId.of((String)name)).isEqualTo((Object)db);
        Truth.assertThat((Integer)DatabaseId.of((String)name).hashCode()).isEqualTo((Object)db.hashCode());
        Truth.assertThat((String)db.toString()).isEqualTo((Object)name);
    }

    @Test
    public void badName() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> DatabaseId.of((String)"bad name"));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"projects");
    }
}

