/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class SessionPoolMaintainerTest
extends BaseSessionPoolTest {
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    @Mock
    private SpannerImpl client;
    @Mock
    private SessionClient sessionClient;
    @Mock
    private SpannerOptions spannerOptions;
    private DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    private SessionPoolOptions options;
    private BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
    private List<SessionPool.PooledSession> idledSessions = new ArrayList<SessionPool.PooledSession>();
    private Map<String, Integer> pingedSessions = new HashMap<String, Integer>();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.client.getOptions()).thenReturn((Object)this.spannerOptions);
        Mockito.when((Object)this.client.getSessionClient(this.db)).thenReturn((Object)this.sessionClient);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        this.setupMockSessionCreation();
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxIdleSessions(1).setMaxSessions(5).setIncStep(1).setKeepAliveIntervalMinutes(2).build();
        this.idledSessions.clear();
        this.pingedSessions.clear();
    }

    private void setupMockSessionCreation() {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                int sessionCount = (Integer)invocation.getArgumentAt(0, Integer.class);
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgumentAt(2, SessionPool.SessionConsumerImpl.class);
                for (int i = 0; i < sessionCount; ++i) {
                    consumer.onSessionReady(this.setupMockSession(this.mockSession()));
                }
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.anyInt(), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Matchers.any(SessionClient.SessionConsumer.class));
    }

    private SessionImpl setupMockSession(SessionImpl session) {
        ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet mockResult = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)session.singleUse((TimestampBound)Matchers.any(TimestampBound.class))).thenReturn((Object)mockContext);
        Mockito.when((Object)mockContext.executeQuery((Statement)Matchers.any(Statement.class), new Options.QueryOption[0])).thenAnswer(invocation -> {
            Integer currentValue = this.pingedSessions.get(session.getName());
            if (currentValue == null) {
                currentValue = 0;
            }
            currentValue = currentValue + 1;
            this.pingedSessions.put(session.getName(), currentValue);
            return mockResult;
        });
        Mockito.when((Object)mockResult.next()).thenReturn((Object)true);
        return session;
    }

    private SessionPool createPool() throws Exception {
        SessionPool pool = SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(this), (SessionClient)this.client.getSessionClient(this.db), (SessionPool.Clock)this.clock);
        pool.idleSessionRemovedListener = input -> {
            this.idledSessions.add((SessionPool.PooledSession)input);
            return null;
        };
        while (pool.totalSessions() < this.options.getMinSessions()) {
            Thread.sleep(1L);
        }
        return pool;
    }

    @Test
    public void testKeepAlive() throws Exception {
        SessionPool pool = this.createPool();
        Truth.assertThat(this.pingedSessions).isEmpty();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).isEmpty();
        SessionPool.PooledSessionFuture session1 = pool.getSession();
        SessionPool.PooledSessionFuture session2 = pool.getSession();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).isEmpty();
        session2.close();
        session1.close();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).isEmpty();
        this.clock.currentTimeMillis += TimeUnit.MINUTES.toMillis(this.options.getKeepAliveIntervalMinutes()) + 1L;
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)1, new Object[0]);
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)1, new Object[]{session2.getName(), 1});
        SessionPool.PooledSessionFuture session3 = pool.getSession();
        SessionPool.PooledSessionFuture session4 = pool.getSession();
        SessionPool.PooledSessionFuture session5 = pool.getSession();
        Truth.assertThat((String)session3.getName()).isEqualTo((Object)session2.getName());
        Truth.assertThat((String)session4.getName()).isEqualTo((Object)session1.getName());
        session5.close();
        session4.close();
        session3.close();
        this.clock.currentTimeMillis += TimeUnit.MINUTES.toMillis(this.options.getKeepAliveIntervalMinutes()) + 1L;
        this.runMaintenanceLoop(this.clock, pool, 3L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)2, new Object[]{session2.getName(), 2});
        this.clock.currentTimeMillis += TimeUnit.MINUTES.toMillis(this.options.getKeepAliveIntervalMinutes()) + 1L;
        SessionPool.PooledSessionFuture session6 = pool.getSession();
        Truth.assertThat((String)session6.getName()).isEqualTo((Object)session1.getName());
        this.runMaintenanceLoop(this.clock, pool, 3L);
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)3);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)2, new Object[]{session2.getName(), 3});
        session6.get().markUsed();
        session6.close();
        this.runMaintenanceLoop(this.clock, pool, 3L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)2, new Object[]{session2.getName(), 3});
        SessionPool.PooledSessionFuture session7 = pool.getSession();
        SessionPool.PooledSessionFuture session8 = pool.getSession();
        SessionPool.PooledSessionFuture session9 = pool.getSession();
        Truth.assertThat((String)session7.getName()).isEqualTo((Object)session1.getName());
        Truth.assertThat((String)session8.getName()).isEqualTo((Object)session2.getName());
        Truth.assertThat((String)session9.getName()).isEqualTo((Object)session5.getName());
        session7.close();
        session8.close();
        session9.close();
        this.clock.currentTimeMillis += TimeUnit.MINUTES.toMillis(this.options.getKeepAliveIntervalMinutes()) + 1L;
        this.runMaintenanceLoop(this.clock, pool, 3L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)2, new Object[]{session2.getName(), 4, session5.getName(), 1});
    }

    @Test
    public void testIdleSessions() throws Exception {
        SessionPool pool = this.createPool();
        long loopsToIdleSessions = Double.valueOf(Math.ceil((double)this.options.getRemoveInactiveSessionAfter().toMillis() / (double)pool.poolMaintainer.loopFrequency)).longValue() + 2L;
        Truth.assertThat(this.idledSessions).isEmpty();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.idledSessions).isEmpty();
        SessionPool.PooledSessionFuture session1 = pool.getSession();
        SessionPool.PooledSessionFuture session2 = pool.getSession();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.idledSessions).isEmpty();
        session2.close();
        session1.close();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.idledSessions).isEmpty();
        this.runMaintenanceLoop(this.clock, pool, loopsToIdleSessions);
        Truth.assertThat(this.idledSessions).isEmpty();
        SessionPool.PooledSession session3 = pool.getSession().get();
        SessionPool.PooledSession session4 = pool.getSession().get();
        SessionPool.PooledSession session5 = pool.getSession().get();
        Truth.assertThat((String)session3.getName()).isEqualTo((Object)session2.getName());
        Truth.assertThat((String)session4.getName()).isEqualTo((Object)session1.getName());
        session5.close();
        session4.close();
        session3.close();
        this.runMaintenanceLoop(this.clock, pool, loopsToIdleSessions);
        Truth.assertThat(this.idledSessions).containsExactly(new Object[]{session5});
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)2);
        SessionPool.PooledSession session6 = pool.getSession().get();
        SessionPool.PooledSession session7 = pool.getSession().get();
        SessionPool.PooledSession session8 = pool.getSession().get();
        session8.close();
        session7.close();
        this.runMaintenanceLoop(this.clock, pool, loopsToIdleSessions);
        Truth.assertThat(this.idledSessions).containsExactly(new Object[]{session5, session8});
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)2);
        session6.markUsed();
        session6.close();
        SessionPool.PooledSession session9 = pool.getSession().get();
        SessionPool.PooledSession session10 = pool.getSession().get();
        SessionPool.PooledSession session11 = pool.getSession().get();
        this.runMaintenanceLoop(this.clock, pool, loopsToIdleSessions);
        Truth.assertThat(this.idledSessions).containsExactly(new Object[]{session5, session8});
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)3);
        session9.close();
        session10.close();
        session11.close();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.idledSessions).containsExactly(new Object[]{session5, session8, session9, session10, session11});
        while (pool.totalSessions() < this.options.getMinSessions()) {
            Thread.sleep(1L);
        }
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)this.options.getMinSessions());
    }
}

