/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class SpannerMatchers {
    private SpannerMatchers() {
    }

    static <T extends Message> Matcher<T> matchesProto(Class<T> clazz, String expected) {
        return new ProtoTextMatcher<T>(clazz, expected);
    }

    public static <T extends Throwable> Matcher<T> isSpannerException(ErrorCode code) {
        return new SpannerExceptionMatcher(code);
    }

    public static <T extends Throwable> Matcher<T> isExecutionExceptionWithSpannerCause(ErrorCode code) {
        return new ExecutionExceptionWithSpannerCauseMatcher(code);
    }

    private static class ExecutionExceptionWithSpannerCauseMatcher<T extends Throwable>
    extends BaseMatcher<T> {
        private final ErrorCode expectedCode;

        ExecutionExceptionWithSpannerCauseMatcher(ErrorCode expectedCode) {
            this.expectedCode = (ErrorCode)Preconditions.checkNotNull((Object)expectedCode);
        }

        public boolean matches(Object item) {
            if (!(item instanceof ExecutionException)) {
                return false;
            }
            ExecutionException ee = (ExecutionException)item;
            if (!(ee.getCause() instanceof SpannerException)) {
                return false;
            }
            SpannerException e = (SpannerException)ee.getCause();
            return e.getErrorCode() == this.expectedCode;
        }

        public void describeTo(Description description) {
            description.appendText("ExecutionException[SpannerException[" + this.expectedCode + "]]");
        }
    }

    private static class SpannerExceptionMatcher<T extends Throwable>
    extends BaseMatcher<T> {
        private final ErrorCode expectedCode;

        SpannerExceptionMatcher(ErrorCode expectedCode) {
            this.expectedCode = (ErrorCode)Preconditions.checkNotNull((Object)expectedCode);
        }

        public boolean matches(Object item) {
            if (!(item instanceof SpannerException)) {
                return false;
            }
            SpannerException e = (SpannerException)((Object)item);
            return e.getErrorCode() == this.expectedCode;
        }

        public void describeTo(Description description) {
            description.appendText("SpannerException[" + this.expectedCode + "]");
        }
    }

    private static class ProtoTextMatcher<T extends Message>
    extends BaseMatcher<T> {
        private final T expected;

        ProtoTextMatcher(Class<T> clazz, String expectedTextFormat) {
            T defaultInstance = this.getDefaultInstance(clazz);
            Message.Builder builder = defaultInstance.toBuilder();
            try {
                TextFormat.merge((CharSequence)expectedTextFormat, (Message.Builder)builder);
            }
            catch (TextFormat.ParseException e) {
                throw new IllegalArgumentException("Invalid text format for " + clazz.getName(), e);
            }
            Message expectedInstance = builder.build();
            this.expected = expectedInstance;
        }

        private T getDefaultInstance(Class<T> clazz) {
            try {
                Message instance = (Message)clazz.getMethod("getDefaultInstance", new Class[0]).invoke(clazz, new Object[0]);
                return (T)instance;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new AssertionError("Invalid proto class " + clazz, e);
            }
        }

        public boolean matches(Object item) {
            if (item == null || !this.expected.getClass().isAssignableFrom(item.getClass())) {
                return false;
            }
            Message actual = (Message)item;
            return this.expected.equals((Object)actual);
        }

        public void describeTo(Description description) {
            description.appendText(this.expected.toString());
        }
    }
}

