/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerOptionsThreadTest
extends AbstractMockServerTest {
    private static final int NUMBER_OF_TEST_RUNS = 2;
    private static final int DEFAULT_NUM_CHANNELS_PER_GAPIC_CLIENT = 4;
    private static final int NUM_GAPIC_CLIENTS = 4;
    private static final int NUM_THREADS = Math.max(16, Runtime.getRuntime().availableProcessors());
    private static final String SPANNER_THREAD_NAME = "Cloud-Spanner-TransportChannel";
    private static final String THREAD_PATTERN = "%s-[0-9]+";
    private final DatabaseId dbId = DatabaseId.of((String)"p", (String)"i", (String)"d");

    private SpannerOptions createOptions() {
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setHost("http://localhost:" + this.getPort()).setCredentials((Credentials)NoCredentials.getInstance())).build();
    }

    @Test
    public void testCloseAllThreadsWhenClosingSpanner() throws InterruptedException {
        int baseThreadCount = this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME);
        for (int i = 0; i < 2; ++i) {
            int i2;
            this.waitForStartup();
            Truth.assertThat((Integer)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME)).isAtMost((Comparable)Integer.valueOf(baseThreadCount));
            SpannerOptions options = this.createOptions();
            Spanner spanner = (Spanner)options.getService();
            DatabaseClient client = spanner.getDatabaseClient(this.dbId);
            ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
            for (int i22 = 0; i22 < options.getSessionPoolOptions().getMaxSessions(); ++i22) {
                ResultSet rs = client.singleUse().executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                rs.next();
                resultSets.add(rs);
                if (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME) == NUM_THREADS + baseThreadCount) break;
            }
            for (ResultSet rs : resultSets) {
                rs.close();
            }
            Truth.assertThat((Integer)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME)).isEqualTo((Object)(NUM_THREADS + baseThreadCount));
            for (i2 = 0; i2 < 8; ++i2) {
                InstanceAdminClient instanceAdminClient = spanner.getInstanceAdminClient();
                mockInstanceAdmin.addResponse((AbstractMessage)ListInstancesResponse.getDefaultInstance());
                instanceAdminClient.listInstances(new Options.ListOption[0]);
            }
            Truth.assertThat((Integer)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME)).isEqualTo((Object)(NUM_THREADS + baseThreadCount));
            for (i2 = 0; i2 < 8; ++i2) {
                DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
                mockDatabaseAdmin.addResponse((AbstractMessage)ListDatabasesResponse.getDefaultInstance());
                databaseAdminClient.listDatabases(this.dbId.getInstanceId().getInstance(), new Options.ListOption[0]);
            }
            Truth.assertThat((Integer)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME)).isEqualTo((Object)(NUM_THREADS + baseThreadCount));
            spanner.close();
            Stopwatch watch = Stopwatch.createStarted();
            while (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME) > baseThreadCount && watch.elapsed(TimeUnit.SECONDS) < 2L) {
                Thread.sleep(50L);
            }
            Truth.assertThat((Integer)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME)).isAtMost((Comparable)Integer.valueOf(baseThreadCount));
        }
    }

    @Test
    public void testMultipleSpannersFromSameSpannerOptions() throws InterruptedException {
        this.waitForStartup();
        int baseThreadCount = this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME);
        SpannerOptions options = this.createOptions();
        try (Spanner spanner1 = (Spanner)options.getService();){
            Spanner spanner2 = (Spanner)options.getService();
            Truth.assertThat((Object)spanner1).isSameInstanceAs((Object)spanner2);
            DatabaseClient client1 = spanner1.getDatabaseClient(this.dbId);
            DatabaseClient client2 = spanner2.getDatabaseClient(this.dbId);
            Truth.assertThat((Object)client1).isSameInstanceAs((Object)client2);
            try (ResultSet rs1 = client1.singleUse().executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                 ResultSet rs2 = client2.singleUse().executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);){
                while (rs1.next() && rs2.next()) {
                }
            }
        }
        Stopwatch watch = Stopwatch.createStarted();
        while (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME) > baseThreadCount && watch.elapsed(TimeUnit.SECONDS) < 2L) {
            Thread.sleep(50L);
        }
        Truth.assertThat((Integer)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME)).isAtMost((Comparable)Integer.valueOf(baseThreadCount));
    }

    private void waitForStartup() throws InterruptedException {
        int threadCount;
        Stopwatch watch = Stopwatch.createStarted();
        do {
            threadCount = this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME);
            Thread.sleep(100L);
        } while (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME) > threadCount && watch.elapsed(TimeUnit.SECONDS) < 5L);
    }

    private int getNumberOfThreadsWithName(String serviceName) {
        Pattern pattern = Pattern.compile(String.format(THREAD_PATTERN, serviceName));
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        int res = 0;
        for (Thread thread : threadSet) {
            if (!pattern.matcher(thread.getName()).matches()) continue;
            ++res;
        }
        return res;
    }
}

