/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.SpannerExceptionMatcher;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.TransactionMode;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class AbstractConnectionImplTest {
    public static final String UPDATE = "UPDATE foo SET bar=1";
    public static final String SELECT = "SELECT 1 AS TEST";
    public static final String DDL = "CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id)";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final String LOG_FILE = "src/test/resources/com/google/cloud/spanner/connection/ConnectionImplGeneratedSqlScriptTest.sql";
    private static final String DO_LOG_PROPERTY = "do_log_statements";
    private static boolean doLog;
    private static PrintWriter writer;

    abstract Connection getConnection();

    static void expectSpannerException(String reason, ConnectionConsumer consumer, Connection connection) {
        AbstractConnectionImplTest.expectSpannerException(reason, consumer, connection, ErrorCode.FAILED_PRECONDITION);
    }

    static void expectSpannerException(String reason, ConnectionConsumer consumer, Connection connection, ErrorCode errorCode) {
        SpannerException exception = null;
        try {
            consumer.accept(connection);
        }
        catch (SpannerException e) {
            exception = e;
        }
        MatcherAssert.assertThat((String)reason, (Object)((Object)exception), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((String)reason, (Object)exception.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)errorCode)));
    }

    AbstractConnectionImplTest() {
    }

    static void emptyScript() {
        AbstractConnectionImplTest.openLog(false);
        AbstractConnectionImplTest.closeLog();
    }

    void log(String statement) {
        if (doLog) {
            writer.println(statement);
        }
    }

    @BeforeClass
    public static void openLog() {
        doLog = Boolean.parseBoolean(System.getProperty(DO_LOG_PROPERTY, "false"));
        if (doLog) {
            AbstractConnectionImplTest.openLog(true);
        } else {
            writer = null;
        }
    }

    private static void openLog(boolean append) {
        try {
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(LOG_FILE, append), StandardCharsets.UTF_8), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void closeLog() {
        if (writer != null) {
            writer.close();
        }
    }

    @Test
    public void testClose() {
        this.getConnection().close();
    }

    @Test
    public void testIsClosed() {
        Connection connection = this.getConnection();
        MatcherAssert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        connection.close();
        MatcherAssert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)true));
    }

    abstract boolean isSetAutocommitAllowed();

    @Test
    public void testSetAutocommit() {
        try (Connection connection = this.getConnection();){
            if (this.isSetAutocommitAllowed()) {
                this.log("SET AUTOCOMMIT=FALSE;");
                connection.setAutocommit(false);
                this.log("@EXPECT RESULT_SET 'AUTOCOMMIT',FALSE");
                this.log("SHOW VARIABLE AUTOCOMMIT;");
                MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
                this.log("SET AUTOCOMMIT=TRUE;");
                connection.setAutocommit(true);
                this.log("@EXPECT RESULT_SET 'AUTOCOMMIT',TRUE");
                this.log("SHOW VARIABLE AUTOCOMMIT;");
                MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SET AUTOCOMMIT=" + (connection.isAutocommit() ? "FALSE;" : "TRUE;"));
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.setAutocommit(!connection.isAutocommit());
            }
        }
    }

    abstract boolean isSetReadOnlyAllowed();

    @Test
    public void testSetReadOnly() {
        try (Connection connection = this.getConnection();){
            if (this.isSetReadOnlyAllowed()) {
                this.log("SET READONLY=FALSE;");
                connection.setReadOnly(false);
                this.log("@EXPECT RESULT_SET 'READONLY',FALSE");
                this.log("SHOW VARIABLE READONLY;");
                MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
                this.log("SET READONLY=TRUE;");
                connection.setReadOnly(true);
                this.log("@EXPECT RESULT_SET 'READONLY',TRUE");
                this.log("SHOW VARIABLE READONLY;");
                MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SET READONLY=" + (connection.isAutocommit() ? "FALSE;" : "TRUE;"));
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.setReadOnly(!connection.isReadOnly());
            }
        }
    }

    @Test
    public void testSetStatementTimeout() {
        try (Connection connection = this.getConnection();){
            for (TimeUnit unit : ReadOnlyStalenessUtil.SUPPORTED_UNITS) {
                this.log(String.format("SET STATEMENT_TIMEOUT='1%s';", ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit)));
                connection.setStatementTimeout(1L, unit);
                this.log(String.format("@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1%s'", ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit)));
                this.log("SHOW VARIABLE STATEMENT_TIMEOUT;");
                MatcherAssert.assertThat((Object)connection.getStatementTimeout(unit), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                this.log("SET STATEMENT_TIMEOUT=null;");
                connection.clearStatementTimeout();
                this.log("@EXPECT RESULT_SET 'STATEMENT_TIMEOUT',null");
                this.log("SHOW VARIABLE STATEMENT_TIMEOUT;");
                MatcherAssert.assertThat((Object)connection.getStatementTimeout(unit), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                MatcherAssert.assertThat((Object)connection.hasStatementTimeout(), (Matcher)CoreMatchers.is((Object)false));
                boolean gotException = false;
                try {
                    this.log("@EXPECT EXCEPTION INVALID_ARGUMENT");
                    this.log(String.format("SET STATEMENT_TIMEOUT='0%s';", ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit)));
                    connection.setStatementTimeout(0L, unit);
                }
                catch (IllegalArgumentException e) {
                    gotException = true;
                }
                MatcherAssert.assertThat((Object)gotException, (Matcher)CoreMatchers.is((Object)true));
                this.log("@EXPECT RESULT_SET 'STATEMENT_TIMEOUT',null");
                this.log("SHOW VARIABLE STATEMENT_TIMEOUT;");
                MatcherAssert.assertThat((Object)connection.getStatementTimeout(unit), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                MatcherAssert.assertThat((Object)connection.hasStatementTimeout(), (Matcher)CoreMatchers.is((Object)false));
            }
        }
    }

    abstract boolean isStartBatchDmlAllowed();

    @Test
    public void testStartBatchDml() {
        try (Connection connection = this.getConnection();){
            if (this.isStartBatchDmlAllowed()) {
                MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
                MatcherAssert.assertThat((Object)(connection.isDdlBatchActive() || connection.isDmlBatchActive() ? 1 : 0), (Matcher)CoreMatchers.is((Object)false));
                this.log("START BATCH DML;");
                connection.startBatchDml();
                MatcherAssert.assertThat((Object)connection.isDmlBatchActive(), (Matcher)CoreMatchers.is((Object)true));
                AbstractConnectionImplTest.expectSpannerException("Select should not be allowed after startBatchDml()", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log("SELECT 1 AS TEST;");
                    t.execute(Statement.of((String)SELECT));
                }, connection);
                AbstractConnectionImplTest.expectSpannerException("DDL should not be allowed after startBatchDml()", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log("CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id);");
                    t.execute(Statement.of((String)DDL));
                }, connection);
                this.log("UPDATE foo SET bar=1;");
                connection.execute(Statement.of((String)UPDATE));
                MatcherAssert.assertThat((Object)connection.isDmlBatchActive(), (Matcher)CoreMatchers.is((Object)true));
            }
            this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
            this.log("START BATCH DML;");
            this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            connection.startBatchDml();
        }
    }

    abstract boolean isStartBatchDdlAllowed();

    @Test
    public void testStartBatchDdl() {
        try (Connection connection = this.getConnection();){
            if (this.isStartBatchDdlAllowed()) {
                MatcherAssert.assertThat((Object)connection.isTransactionStarted(), (Matcher)CoreMatchers.is((Object)false));
                MatcherAssert.assertThat((Object)connection.isInTransaction(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)(!connection.isAutocommit() ? 1 : 0))));
                MatcherAssert.assertThat((Object)(connection.isDdlBatchActive() || connection.isDmlBatchActive() ? 1 : 0), (Matcher)CoreMatchers.is((Object)false));
                this.log("START BATCH DDL;");
                connection.startBatchDdl();
                MatcherAssert.assertThat((Object)connection.isTransactionStarted(), (Matcher)CoreMatchers.is((Object)false));
                MatcherAssert.assertThat((Object)connection.isInTransaction(), (Matcher)CoreMatchers.is((Object)false));
                MatcherAssert.assertThat((Object)connection.isDdlBatchActive(), (Matcher)CoreMatchers.is((Object)true));
                AbstractConnectionImplTest.expectSpannerException("Select should not be allowed after startBatchDdl()", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log("SELECT 1 AS TEST;");
                    t.execute(Statement.of((String)SELECT));
                }, connection);
                AbstractConnectionImplTest.expectSpannerException("Update should not be allowed after startBatchDdl()", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log("UPDATE foo SET bar=1;");
                    t.execute(Statement.of((String)UPDATE));
                }, connection);
                this.log("CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id);");
                connection.execute(Statement.of((String)DDL));
                MatcherAssert.assertThat((Object)connection.isTransactionStarted(), (Matcher)CoreMatchers.is((Object)false));
                MatcherAssert.assertThat((Object)connection.isDdlBatchActive(), (Matcher)CoreMatchers.is((Object)true));
            }
            this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
            this.log("START BATCH DDL;");
            this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            connection.startBatchDdl();
        }
    }

    abstract boolean isRunBatchAllowed();

    @Test
    public void testRunBatch() {
        try (Connection connection = this.getConnection();){
            if (!this.isRunBatchAllowed()) {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            }
            this.log("RUN BATCH;");
            connection.runBatch();
        }
    }

    abstract boolean isAbortBatchAllowed();

    @Test
    public void testAbortBatch() {
        try (Connection connection = this.getConnection();){
            if (!this.isAbortBatchAllowed()) {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            }
            this.log("ABORT BATCH;");
            connection.abortBatch();
        }
    }

    abstract boolean isBeginTransactionAllowed();

    abstract boolean isSelectAllowedAfterBeginTransaction();

    abstract boolean isDmlAllowedAfterBeginTransaction();

    abstract boolean isDdlAllowedAfterBeginTransaction();

    @Test
    public void testBeginTransaction() {
        try (Connection connection = this.getConnection();){
            if (this.isBeginTransactionAllowed()) {
                MatcherAssert.assertThat((Object)connection.isTransactionStarted(), (Matcher)CoreMatchers.is((Object)false));
                MatcherAssert.assertThat((Object)connection.isInTransaction(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)(!connection.isAutocommit() ? 1 : 0))));
                this.log("BEGIN TRANSACTION;");
                connection.beginTransaction();
                MatcherAssert.assertThat((Object)connection.isTransactionStarted(), (Matcher)CoreMatchers.is((Object)false));
                MatcherAssert.assertThat((Object)connection.isInTransaction(), (Matcher)CoreMatchers.is((Object)true));
                if (this.isSelectAllowedAfterBeginTransaction()) {
                    this.log("SELECT 1 AS TEST;");
                    connection.execute(Statement.of((String)SELECT));
                } else {
                    AbstractConnectionImplTest.expectSpannerException("Select should not be allowed after beginTransaction", t -> {
                        this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                        this.log("SELECT 1 AS TEST;");
                        t.execute(Statement.of((String)SELECT));
                    }, connection);
                }
                if (this.isDmlAllowedAfterBeginTransaction()) {
                    this.log("UPDATE foo SET bar=1;");
                    connection.execute(Statement.of((String)UPDATE));
                } else {
                    AbstractConnectionImplTest.expectSpannerException("Update should not be allowed after beginTransaction", t -> {
                        this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                        this.log("UPDATE foo SET bar=1;");
                        t.execute(Statement.of((String)UPDATE));
                    }, connection);
                }
                if (this.isDdlAllowedAfterBeginTransaction()) {
                    this.log("CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id);");
                    connection.execute(Statement.of((String)DDL));
                } else {
                    AbstractConnectionImplTest.expectSpannerException("DDL should not be allowed after beginTransaction", t -> {
                        this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                        this.log("CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id);");
                        t.execute(Statement.of((String)DDL));
                    }, connection);
                }
                MatcherAssert.assertThat((Object)connection.isTransactionStarted(), (Matcher)CoreMatchers.is((Object)true));
            }
            this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
            this.log("BEGIN TRANSACTION;");
            this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            connection.beginTransaction();
        }
    }

    abstract boolean isSetTransactionTagAllowed();

    @Test
    public void testSetTransactionTag() {
        try (Connection connection = this.getConnection();){
            final String tag = "some-tag";
            if (this.isSetTransactionTagAllowed()) {
                this.log(String.format("SET TRANSACTION_TAG = '%s';", tag));
                connection.setTransactionTag(tag);
                Assert.assertEquals((Object)tag, (Object)connection.getTransactionTag());
            } else {
                AbstractConnectionImplTest.expectSpannerException("SET TRANSACTION_TAG should not be allowed", new ConnectionConsumer(){

                    @Override
                    public void accept(Connection t) {
                        AbstractConnectionImplTest.this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                        AbstractConnectionImplTest.this.log(String.format("SET TRANSACTION_TAG = '%s';", tag));
                        t.setTransactionTag(tag);
                    }
                }, connection);
            }
        }
    }

    abstract boolean isSetTransactionModeAllowed(TransactionMode var1);

    @Test
    public void testSetTransactionMode() {
        for (TransactionMode mode : TransactionMode.values()) {
            this.testSetTransactionMode(mode);
        }
    }

    private void testSetTransactionMode(TransactionMode mode) {
        try (Connection connection = this.getConnection();){
            if (this.isSetTransactionModeAllowed(mode)) {
                this.log("SET TRANSACTION " + mode.toString() + ";");
                connection.setTransactionMode(mode);
                MatcherAssert.assertThat((Object)connection.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)mode)));
            } else {
                AbstractConnectionImplTest.expectSpannerException(mode + " should not be allowed", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log("SET TRANSACTION " + mode.getStatementString() + ";");
                    t.setTransactionMode(mode);
                }, connection);
            }
        }
    }

    abstract boolean isGetTransactionModeAllowed();

    @Test
    public void testGetTransactionMode() {
        try (Connection connection = this.getConnection();){
            if (this.isGetTransactionModeAllowed()) {
                MatcherAssert.assertThat((Object)connection.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.getTransactionMode();
            }
        }
    }

    abstract boolean isSetAutocommitDmlModeAllowed();

    @Test
    public void testSetAutocommitDmlMode() {
        try (Connection connection = this.getConnection();){
            if (this.isSetAutocommitDmlModeAllowed()) {
                for (AutocommitDmlMode mode : AutocommitDmlMode.values()) {
                    this.log("SET AUTOCOMMIT_DML_MODE='" + mode.toString() + "';");
                    connection.setAutocommitDmlMode(mode);
                    this.log("@EXPECT RESULT_SET 'AUTOCOMMIT_DML_MODE','" + mode.toString() + "'");
                    this.log("SHOW VARIABLE AUTOCOMMIT_DML_MODE;");
                    MatcherAssert.assertThat((Object)connection.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)mode)));
                }
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SET AUTOCOMMIT_DML_MODE='" + AutocommitDmlMode.PARTITIONED_NON_ATOMIC.toString() + "';");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            }
        }
    }

    abstract boolean isGetAutocommitDmlModeAllowed();

    @Test
    public void testGetAutocommitDmlMode() {
        try (Connection connection = this.getConnection();){
            if (this.isGetAutocommitDmlModeAllowed()) {
                this.log("@EXPECT RESULT_SET 'AUTOCOMMIT_DML_MODE'");
                this.log("SHOW VARIABLE AUTOCOMMIT_DML_MODE;");
                MatcherAssert.assertThat((Object)connection.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SHOW VARIABLE AUTOCOMMIT_DML_MODE;");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.getAutocommitDmlMode();
            }
        }
    }

    abstract boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode var1);

    @Test
    public void testSetReadOnlyStaleness() {
        for (TimestampBound staleness : this.getTestTimestampBounds()) {
            this.testSetReadOnlyStaleness(staleness);
        }
    }

    private List<TimestampBound> getTestTimestampBounds() {
        return Arrays.asList(TimestampBound.strong(), TimestampBound.ofReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofExactStaleness((long)1L, (TimeUnit)TimeUnit.SECONDS), TimestampBound.ofMaxStaleness((long)100L, (TimeUnit)TimeUnit.MILLISECONDS), TimestampBound.ofExactStaleness((long)100L, (TimeUnit)TimeUnit.MICROSECONDS));
    }

    private void testSetReadOnlyStaleness(TimestampBound staleness) {
        try (Connection connection = this.getConnection();){
            if (this.isSetReadOnlyStalenessAllowed(staleness.getMode())) {
                this.log("SET READ_ONLY_STALENESS='" + ReadOnlyStalenessUtil.timestampBoundToString((TimestampBound)staleness) + "';");
                connection.setReadOnlyStaleness(staleness);
                this.log("@EXPECT RESULT_SET 'READ_ONLY_STALENESS','" + ReadOnlyStalenessUtil.timestampBoundToString((TimestampBound)staleness) + "'");
                this.log("SHOW VARIABLE READ_ONLY_STALENESS;");
                MatcherAssert.assertThat((Object)connection.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)staleness)));
            } else {
                AbstractConnectionImplTest.expectSpannerException(staleness.getMode() + " should not be allowed", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log("SET READ_ONLY_STALENESS='" + ReadOnlyStalenessUtil.timestampBoundToString((TimestampBound)staleness) + "';");
                    t.setReadOnlyStaleness(staleness);
                }, connection);
            }
        }
    }

    abstract boolean isGetReadOnlyStalenessAllowed();

    @Test
    public void testGetReadOnlyStaleness() {
        try (Connection connection = this.getConnection();){
            if (this.isGetReadOnlyStalenessAllowed()) {
                this.log("@EXPECT RESULT_SET 'READ_ONLY_STALENESS'");
                this.log("SHOW VARIABLE READ_ONLY_STALENESS;");
                MatcherAssert.assertThat((Object)connection.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SHOW VARIABLE READ_ONLY_STALENESS;");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.getReadOnlyStaleness();
            }
        }
    }

    boolean isSetOptimizerVersionAllowed() {
        return !this.getConnection().isClosed();
    }

    @Test
    public void testSetOptimizerVersion() {
        try (Connection connection = this.getConnection();){
            if (this.isSetOptimizerVersionAllowed()) {
                for (String version : new String[]{"1", "2", "latest", ""}) {
                    this.log("SET OPTIMIZER_VERSION='" + version + "';");
                    connection.setOptimizerVersion(version);
                    this.log("@EXPECT RESULT_SET 'OPTIMIZER_VERSION','" + version + "'");
                    this.log("SHOW VARIABLE OPTIMIZER_VERSION;");
                    MatcherAssert.assertThat((Object)connection.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)version)));
                }
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SET OPTIMIZER_VERSION='1';");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.setOptimizerVersion("1");
            }
        }
    }

    boolean isGetOptimizerVersionAllowed() {
        return !this.getConnection().isClosed();
    }

    @Test
    public void testGetOptimizerVersion() {
        try (Connection connection = this.getConnection();){
            if (this.isGetOptimizerVersionAllowed()) {
                this.log("@EXPECT RESULT_SET 'OPTIMIZER_VERSION'");
                this.log("SHOW VARIABLE OPTIMIZER_VERSION;");
                MatcherAssert.assertThat((Object)connection.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SHOW VARIABLE OPTIMIZER_VERSION;");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.getOptimizerVersion();
            }
        }
    }

    boolean isSetOptimizerStatisticsPackageAllowed() {
        return !this.getConnection().isClosed();
    }

    @Test
    public void testSetOptimizerStatisticsPackage() {
        try (Connection connection = this.getConnection();){
            if (this.isSetOptimizerStatisticsPackageAllowed()) {
                for (String statisticsPackage : new String[]{"custom-package", ""}) {
                    this.log("SET OPTIMIZER_STATISTICS_PACKAGE='" + statisticsPackage + "';");
                    connection.setOptimizerStatisticsPackage(statisticsPackage);
                    this.log("@EXPECT RESULT_SET 'OPTIMIZER_STATISTICS_PACKAGE','" + statisticsPackage + "'");
                    this.log("SHOW VARIABLE OPTIMIZER_STATISTICS_PACKAGE;");
                    MatcherAssert.assertThat((Object)connection.getOptimizerStatisticsPackage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)statisticsPackage)));
                }
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SET OPTIMIZER_STATISTICS_PACKAGE='custom-package';");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.setOptimizerStatisticsPackage("custom-package");
            }
        }
    }

    boolean isGetOptimizerStatisticsPackageAllowed() {
        return !this.getConnection().isClosed();
    }

    @Test
    public void testGetOptimizerStatisticsPackage() {
        try (Connection connection = this.getConnection();){
            if (this.isGetOptimizerStatisticsPackageAllowed()) {
                this.log("@EXPECT RESULT_SET 'OPTIMIZER_STATISTICS_PACKAGE'");
                this.log("SHOW VARIABLE OPTIMIZER_STATISTICS_PACKAGE;");
                MatcherAssert.assertThat((Object)connection.getOptimizerStatisticsPackage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.log("SHOW VARIABLE OPTIMIZER_STATISTICS_PACKAGE;");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.getOptimizerStatisticsPackage();
            }
        }
    }

    abstract boolean isCommitAllowed();

    @Test
    public void testCommit() {
        try (Connection connection = this.getConnection();){
            if (!this.isCommitAllowed()) {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            }
            this.log("COMMIT;");
            connection.commit();
        }
    }

    abstract boolean isRollbackAllowed();

    @Test
    public void testRollback() {
        try (Connection connection = this.getConnection();){
            if (!this.isRollbackAllowed()) {
                this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            }
            this.log("ROLLBACK;");
            connection.rollback();
        }
    }

    abstract boolean expectedIsInTransaction();

    @Test
    public void testIsInTransaction() {
        try (Connection connection = this.getConnection();){
            MatcherAssert.assertThat((Object)connection.isInTransaction(), (Matcher)CoreMatchers.is((Object)this.expectedIsInTransaction()));
        }
    }

    abstract boolean expectedIsTransactionStarted();

    @Test
    public void testIsTransactionStarted() {
        try (Connection connection = this.getConnection();){
            MatcherAssert.assertThat((Object)connection.isTransactionStarted(), (Matcher)CoreMatchers.is((Object)this.expectedIsTransactionStarted()));
        }
    }

    abstract boolean isGetReadTimestampAllowed();

    @Test
    public void testGetReadTimestamp() {
        try (Connection connection = this.getConnection();){
            if (this.isGetReadTimestampAllowed()) {
                this.log("@EXPECT RESULT_SET 'READ_TIMESTAMP'");
                this.log("SHOW VARIABLE READ_TIMESTAMP;");
                MatcherAssert.assertThat((Object)connection.getReadTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                this.log("@EXPECT RESULT_SET 'READ_TIMESTAMP',null");
                this.log("SHOW VARIABLE READ_TIMESTAMP;");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.getReadTimestamp();
            }
        }
    }

    abstract boolean isGetCommitTimestampAllowed();

    @Test
    public void testGetCommitTimestamp() {
        try (Connection connection = this.getConnection();){
            if (this.isGetCommitTimestampAllowed()) {
                this.log("@EXPECT RESULT_SET 'COMMIT_TIMESTAMP'");
                this.log("SHOW VARIABLE COMMIT_TIMESTAMP;");
                MatcherAssert.assertThat((Object)connection.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                this.log("@EXPECT RESULT_SET 'COMMIT_TIMESTAMP',null");
                this.log("SHOW VARIABLE COMMIT_TIMESTAMP;");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.getCommitTimestamp();
            }
        }
    }

    @Test
    public void testGetCommitResponse() {
        try (Connection connection = this.getConnection();){
            if (this.isGetCommitTimestampAllowed()) {
                this.log("@EXPECT RESULT_SET 'COMMIT_TIMESTAMP'");
                this.log("SHOW VARIABLE COMMIT_RESPONSE;");
                MatcherAssert.assertThat((Object)connection.getCommitResponse(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                this.log("@EXPECT RESULT_SET 'COMMIT_TIMESTAMP',null");
                this.log("SHOW VARIABLE COMMIT_RESPONSE;");
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
                connection.getCommitResponse();
            }
        }
    }

    abstract boolean isExecuteAllowed(StatementParser.StatementType var1);

    @Test
    public void testExecute() {
        for (StatementParser.StatementType type : new StatementParser.StatementType[]{StatementParser.StatementType.QUERY, StatementParser.StatementType.UPDATE, StatementParser.StatementType.DDL}) {
            this.testExecute(type);
        }
    }

    private void testExecute(StatementParser.StatementType type) {
        try (Connection connection = this.getConnection();){
            if (this.isExecuteAllowed(type)) {
                this.log(this.getTestStatement(type).getSql() + ";");
                MatcherAssert.assertThat((Object)connection.execute(this.getTestStatement(type)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else {
                AbstractConnectionImplTest.expectSpannerException(type + " should not be allowed", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log(this.getTestStatement(type).getSql() + ";");
                    t.execute(this.getTestStatement(type));
                }, connection);
            }
        }
    }

    private Statement getTestStatement(StatementParser.StatementType type) {
        switch (type) {
            case QUERY: {
                return Statement.of((String)SELECT);
            }
            case UPDATE: {
                return Statement.of((String)UPDATE);
            }
            case DDL: {
                return Statement.of((String)DDL);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Test
    public void testExecuteQuery() {
        for (StatementParser.StatementType type : new StatementParser.StatementType[]{StatementParser.StatementType.QUERY, StatementParser.StatementType.UPDATE, StatementParser.StatementType.DDL}) {
            this.testExecuteQuery(type);
        }
    }

    private void testExecuteQuery(StatementParser.StatementType type) {
        try (Connection connection = this.getConnection();){
            if (type == StatementParser.StatementType.QUERY && this.isExecuteAllowed(StatementParser.StatementType.QUERY)) {
                this.log("@EXPECT RESULT_SET 'TEST',1");
                this.log(this.getTestStatement(type).getSql() + ";");
                ResultSet rs = connection.executeQuery(this.getTestStatement(type), new Options.QueryOption[0]);
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            } else if (type == StatementParser.StatementType.QUERY) {
                AbstractConnectionImplTest.expectSpannerException(type + " should not be allowed", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log(this.getTestStatement(type).getSql() + ";");
                    t.executeQuery(this.getTestStatement(type), new Options.QueryOption[0]);
                }, connection, ErrorCode.FAILED_PRECONDITION);
            } else {
                AbstractConnectionImplTest.expectSpannerException(type + " should be an invalid argument", t -> t.executeQuery(this.getTestStatement(type), new Options.QueryOption[0]), connection, ErrorCode.INVALID_ARGUMENT);
            }
        }
    }

    @Test
    public void testAnalyzeQuery() {
        for (StatementParser.StatementType type : new StatementParser.StatementType[]{StatementParser.StatementType.QUERY, StatementParser.StatementType.UPDATE, StatementParser.StatementType.DDL}) {
            this.testAnalyzeQuery(type);
        }
    }

    private void testAnalyzeQuery(StatementParser.StatementType type) {
        try (Connection connection = this.getConnection();){
            ReadContext.QueryAnalyzeMode[] queryAnalyzeModeArray = ReadContext.QueryAnalyzeMode.values();
            int n = queryAnalyzeModeArray.length;
            for (int i = 0; i < n; ++i) {
                ReadContext.QueryAnalyzeMode mode;
                ReadContext.QueryAnalyzeMode currentMode = mode = queryAnalyzeModeArray[i];
                if (type == StatementParser.StatementType.QUERY && this.isExecuteAllowed(StatementParser.StatementType.QUERY)) {
                    ResultSet rs = connection.analyzeQuery(this.getTestStatement(type), currentMode);
                    MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                    while (rs.next()) {
                    }
                    MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                    continue;
                }
                if (type == StatementParser.StatementType.QUERY) {
                    AbstractConnectionImplTest.expectSpannerException(type + " should not be allowed", t -> t.analyzeQuery(this.getTestStatement(type), currentMode), connection, ErrorCode.FAILED_PRECONDITION);
                    continue;
                }
                AbstractConnectionImplTest.expectSpannerException(type + " should be an invalid argument", t -> t.analyzeQuery(this.getTestStatement(type), currentMode), connection, ErrorCode.INVALID_ARGUMENT);
            }
        }
    }

    @Test
    public void testExecuteUpdate() {
        for (StatementParser.StatementType type : new StatementParser.StatementType[]{StatementParser.StatementType.QUERY, StatementParser.StatementType.UPDATE, StatementParser.StatementType.DDL}) {
            this.testExecuteUpdate(type);
        }
    }

    private void testExecuteUpdate(StatementParser.StatementType type) {
        try (Connection connection = this.getConnection();){
            if (type == StatementParser.StatementType.UPDATE && this.isExecuteAllowed(StatementParser.StatementType.UPDATE)) {
                this.log("@EXPECT UPDATE_COUNT 1");
                this.log(this.getTestStatement(type).getSql() + ";");
                MatcherAssert.assertThat((Object)connection.executeUpdate(this.getTestStatement(type)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            } else if (type == StatementParser.StatementType.UPDATE) {
                AbstractConnectionImplTest.expectSpannerException(type + "should not be allowed", t -> {
                    this.log("@EXPECT EXCEPTION FAILED_PRECONDITION");
                    this.log(this.getTestStatement(type).getSql() + ";");
                    t.executeUpdate(this.getTestStatement(type));
                }, connection, ErrorCode.FAILED_PRECONDITION);
            } else {
                AbstractConnectionImplTest.expectSpannerException(type + " should be an invalid argument", t -> t.executeUpdate(this.getTestStatement(type)), connection, ErrorCode.INVALID_ARGUMENT);
            }
        }
    }

    abstract boolean isWriteAllowed();

    @Test
    public void testWrite() {
        try (Connection connection = this.getConnection();){
            if (!this.isWriteAllowed() || !connection.isAutocommit()) {
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            }
            connection.write(this.createTestMutation());
        }
    }

    @Test
    public void testWriteIterable() {
        try (Connection connection = this.getConnection();){
            if (!this.isWriteAllowed() || !connection.isAutocommit()) {
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            }
            connection.write(Collections.singletonList(this.createTestMutation()));
        }
    }

    @Test
    public void testBufferedWrite() {
        try (Connection connection = this.getConnection();){
            if (!this.isWriteAllowed() || connection.isAutocommit()) {
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            }
            connection.bufferedWrite(this.createTestMutation());
        }
    }

    @Test
    public void testBufferedWriteIterable() {
        try (Connection connection = this.getConnection();){
            if (!this.isWriteAllowed() || connection.isAutocommit()) {
                this.exception.expect((Matcher)SpannerExceptionMatcher.matchCode(ErrorCode.FAILED_PRECONDITION));
            }
            connection.bufferedWrite(Collections.singletonList(this.createTestMutation()));
        }
    }

    private Mutation createTestMutation() {
        return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).set("name").to("bar")).build();
    }

    static interface ConnectionConsumer {
        public void accept(Connection var1);
    }
}

