/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForceCloseSpannerFunction;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConnectionAsyncApiTest
extends AbstractMockServerTest {
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final Function<Connection, Void> AUTOCOMMIT = input -> {
        input.setAutocommit(true);
        return null;
    };
    private static final Function<Connection, Void> READ_ONLY = input -> {
        input.setReadOnly(true);
        return null;
    };
    private static final Function<Connection, Void> READ_WRITE = input -> null;

    @AfterClass
    public static void stopExecutor() {
        executor.shutdown();
    }

    @After
    public void reset() {
        mockSpanner.removeAllExecutionTimes();
        executor.shutdownNow();
        executor = Executors.newSingleThreadExecutor();
    }

    @Test
    public void testExecuteQueryAsyncAutocommit() {
        this.testExecuteQueryAsync(AUTOCOMMIT);
    }

    @Test
    public void testExecuteQueryAsyncAutocommitIsNonBlocking() {
        this.testExecuteQueryAsyncIsNonBlocking(AUTOCOMMIT);
    }

    @Test
    public void testExecuteQueryAsStatementAsyncAutocommit() {
        this.testExecuteQueryAsync(AUTOCOMMIT, true);
    }

    @Test
    public void testExecuteQueryAutocommit() {
        this.testExecuteQuery(AUTOCOMMIT);
    }

    @Test
    public void testExecuteUpdateAsyncAutocommit() {
        this.testExecuteUpdateAsync(AUTOCOMMIT);
    }

    @Test
    public void testExecuteUpdateAsyncAutocommitIsNonBlocking() {
        this.testExecuteUpdateAsyncIsNonBlocking(AUTOCOMMIT);
    }

    @Test
    public void testExecuteUpdateAsStatementAsyncAutocommit() {
        this.testExecuteUpdateAsync(AUTOCOMMIT, true);
    }

    @Test
    public void testExecuteUpdateAutocommit() {
        this.testExecuteUpdate(AUTOCOMMIT);
    }

    @Test
    public void testExecuteBatchUpdateAsyncAutocommit() {
        this.testExecuteBatchUpdateAsync(AUTOCOMMIT);
    }

    @Test
    public void testExecuteBatchUpdateAsyncAutocommitIsNonBlocking() {
        this.testExecuteBatchUpdateAsyncIsNonBlocking(AUTOCOMMIT);
    }

    @Test
    public void testExecuteBatchUpdateAutocommit() {
        this.testExecuteBatchUpdate(AUTOCOMMIT);
    }

    @Test
    public void testWriteAsyncAutocommit() {
        this.testWriteAsync(AUTOCOMMIT);
    }

    @Test
    public void testWriteAutocommit() {
        this.testWrite(AUTOCOMMIT);
    }

    @Test
    public void testExecuteQueryAsyncReadOnly() {
        this.testExecuteQueryAsync(READ_ONLY);
    }

    @Test
    public void testExecuteQueryAsyncReadOnlyIsNonBlocking() {
        this.testExecuteQueryAsyncIsNonBlocking(READ_ONLY);
    }

    @Test
    public void testExecuteQueryAsStatementAsyncReadOnly() {
        this.testExecuteQueryAsync(READ_ONLY, true);
    }

    @Test
    public void testExecuteQueryReadOnly() {
        this.testExecuteQuery(READ_ONLY);
    }

    @Test
    public void testExecuteQueryAsyncReadWrite() {
        this.testExecuteQueryAsync(READ_WRITE);
    }

    @Test
    public void testExecuteQueryAsyncReadWriteIsNonBlocking() {
        this.testExecuteQueryAsyncIsNonBlocking(READ_WRITE);
    }

    @Test
    public void testExecuteQueryAsStatementAsyncReadWrite() {
        this.testExecuteQueryAsync(READ_WRITE, true);
    }

    @Test
    public void testExecuteQueryReadWrite() {
        this.testExecuteQuery(READ_WRITE);
    }

    @Test
    public void testExecuteUpdateAsyncReadWrite() {
        this.testExecuteUpdateAsync(READ_WRITE);
    }

    @Test
    public void testExecuteUpdateAsyncReadWriteIsNonBlocking() {
        this.testExecuteUpdateAsyncIsNonBlocking(READ_WRITE);
    }

    @Test
    public void testExecuteUpdateAsStatementAsyncReadWrite() {
        this.testExecuteUpdateAsync(READ_WRITE, true);
    }

    @Test
    public void testExecuteUpdateReadWrite() {
        this.testExecuteUpdate(READ_WRITE);
    }

    @Test
    public void testExecuteBatchUpdateAsyncReadWrite() {
        this.testExecuteBatchUpdateAsync(READ_WRITE);
    }

    @Test
    public void testExecuteBatchUpdateAsyncReadWriteIsNonBlocking() {
        this.testExecuteBatchUpdateAsyncIsNonBlocking(READ_WRITE);
    }

    @Test
    public void testExecuteBatchUpdateReadWrite() {
        this.testExecuteBatchUpdate(READ_WRITE);
    }

    @Test
    public void testBufferedWriteReadWrite() {
        this.testBufferedWrite(READ_WRITE);
    }

    @Test
    public void testReadWriteMultipleAsyncStatements() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Truth.assertThat((Boolean)connection.isAutocommit()).isFalse();
            ApiFuture update1 = connection.executeUpdateAsync(INSERT_STATEMENT);
            ApiFuture update2 = connection.executeUpdateAsync(INSERT_STATEMENT);
            ApiFuture batch = connection.executeBatchUpdateAsync((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            final SettableApiFuture rowCount = SettableApiFuture.create();
            try (AsyncResultSet rs = connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                rs.setCallback((Executor)executor, new AsyncResultSet.ReadyCallback(){
                    int count = 0;

                    public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                        try {
                            while (true) {
                                switch (resultSet.tryNext()) {
                                    case DONE: {
                                        rowCount.set((Object)this.count);
                                        return AsyncResultSet.CallbackResponse.DONE;
                                    }
                                    case NOT_READY: {
                                        return AsyncResultSet.CallbackResponse.CONTINUE;
                                    }
                                    case OK: {
                                        ++this.count;
                                    }
                                }
                            }
                        }
                        catch (SpannerException e) {
                            rowCount.setException((Throwable)e);
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                    }
                });
            }
            ApiFuture commit = connection.commitAsync();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)update1))).isEqualTo((Object)1L);
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)update2))).isEqualTo((Object)1L);
            Truth.assertThat((long[])((long[])SpannerApiFutures.get((ApiFuture)batch))).asList().containsExactly(new Object[]{1L, 1L});
            Truth.assertThat((Integer)((Integer)SpannerApiFutures.get((ApiFuture)rowCount))).isEqualTo((Object)100);
            Assert.assertNull((Object)SpannerApiFutures.get((ApiFuture)commit));
            CommitRequest commitRequest = (CommitRequest)mockSpanner.getRequestsOfType(CommitRequest.class).stream().reduce((first, second) -> second).get();
            ArrayList requests = Lists.newArrayList((Iterable)Collections2.filter(mockSpanner.getRequests(), input -> input instanceof ExecuteSqlRequest && ((ExecuteSqlRequest)input).getSession().equals(commitRequest.getSession()) || input instanceof ExecuteBatchDmlRequest && ((ExecuteBatchDmlRequest)input).getSession().equals(commitRequest.getSession())));
            Truth.assertThat((Iterable)requests).hasSize(4);
            Truth.assertThat(requests.get(0)).isInstanceOf(ExecuteSqlRequest.class);
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(0)).getSeqno()).isEqualTo((Object)1L);
            Truth.assertThat(requests.get(1)).isInstanceOf(ExecuteSqlRequest.class);
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(1)).getSeqno()).isEqualTo((Object)2L);
            Truth.assertThat(requests.get(2)).isInstanceOf(ExecuteBatchDmlRequest.class);
            Truth.assertThat((Long)((ExecuteBatchDmlRequest)requests.get(2)).getSeqno()).isEqualTo((Object)3L);
            Truth.assertThat(requests.get(3)).isInstanceOf(ExecuteSqlRequest.class);
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(3)).getSeqno()).isEqualTo((Object)4L);
        }
    }

    @Test
    public void testAutocommitRunBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.execute(Statement.of((String)"START BATCH DML"));
            connection.execute(INSERT_STATEMENT);
            connection.execute(INSERT_STATEMENT);
            StatementResult res = connection.execute(Statement.of((String)"RUN BATCH"));
            Truth.assertThat((Comparable)res.getResultType()).isEqualTo((Object)StatementResult.ResultType.RESULT_SET);
            try (ResultSet rs = res.getResultSet();){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Iterable)rs.getLongList(0)).containsExactly(new Object[]{1L, 1L});
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
        }
    }

    @Test
    public void testAutocommitRunBatchAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeAsync(Statement.of((String)"SET AUTOCOMMIT = TRUE"));
            connection.executeAsync(Statement.of((String)"START BATCH DML"));
            connection.executeAsync(INSERT_STATEMENT);
            connection.executeAsync(INSERT_STATEMENT);
            ApiFuture res = connection.runBatchAsync();
            Truth.assertThat((long[])((long[])SpannerApiFutures.get((ApiFuture)res))).asList().containsExactly(new Object[]{1L, 1L});
        }
    }

    @Test
    public void testExecuteDdlAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeAsync(Statement.of((String)"SET AUTOCOMMIT = TRUE"));
            connection.executeAsync(Statement.of((String)"START BATCH DDL"));
            connection.executeAsync(Statement.of((String)"CREATE TABLE FOO (ID INT64) PRIMARY KEY (ID)"));
            connection.executeAsync(Statement.of((String)"ABORT BATCH"));
        }
    }

    @Test
    public void testExecuteInvalidStatementAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeAsync(Statement.of((String)"UPSERT INTO FOO (ID, VAL) VALUES (1, 'foo')")));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testExecuteClientSideQueryAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeAsync(Statement.of((String)"SET AUTOCOMMIT = TRUE"));
            SettableApiFuture autocommit = SettableApiFuture.create();
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SHOW VARIABLE AUTOCOMMIT"), new Options.QueryOption[0]);){
                rs.setCallback((Executor)executor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                            case OK: {
                                autocommit.set((Object)resultSet.getBoolean("AUTOCOMMIT"));
                            }
                        }
                    }
                });
            }
            Truth.assertThat((Boolean)((Boolean)SpannerApiFutures.get((ApiFuture)autocommit))).isTrue();
        }
    }

    @Test
    public void testExecuteInvalidQueryAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try {
                connection.executeQueryAsync(INSERT_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            }
        }
    }

    @Test
    public void testExecuteInvalidUpdateAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try {
                connection.executeUpdateAsync(SELECT_RANDOM_STATEMENT);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            }
        }
    }

    @Test
    public void testExecuteInvalidBatchUpdateAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try {
                connection.executeBatchUpdateAsync((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)SELECT_RANDOM_STATEMENT));
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            }
        }
    }

    @Test
    public void testRunEmptyBatchAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDml();
            Truth.assertThat((long[])((long[])SpannerApiFutures.get((ApiFuture)connection.runBatchAsync()))).isEqualTo((Object)new long[0]);
        }
    }

    private void testExecuteQueryAsync(Function<Connection, Void> connectionConfigurator) {
        this.testExecuteQueryAsync(connectionConfigurator, false);
    }

    private void testExecuteQueryAsync(Function<Connection, Void> connectionConfigurator, boolean executeAsStatement) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                ApiFuture res;
                AtomicInteger rowCount = new AtomicInteger();
                AtomicBoolean receivedTimeout = new AtomicBoolean();
                if (timeout) {
                    mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                try (AsyncResultSet rs = executeAsStatement ? connection.executeAsync(SELECT_RANDOM_STATEMENT).getResultSetAsync() : connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    res = rs.setCallback((Executor)executor, resultSet -> {
                        try {
                            while (true) {
                                switch (resultSet.tryNext()) {
                                    case OK: {
                                        rowCount.incrementAndGet();
                                        break;
                                    }
                                    case DONE: {
                                        return AsyncResultSet.CallbackResponse.DONE;
                                    }
                                    case NOT_READY: {
                                        return AsyncResultSet.CallbackResponse.CONTINUE;
                                    }
                                }
                            }
                        }
                        catch (SpannerException e) {
                            receivedTimeout.set(e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED);
                            throw e;
                        }
                    });
                }
                try {
                    SpannerApiFutures.get((ApiFuture)res);
                    Truth.assertThat((Integer)rowCount.get()).isEqualTo((Object)100);
                    if (connection.isReadOnly() || !connection.isInTransaction()) {
                        Truth.assertThat((Comparable)connection.getReadTimestamp()).isNotNull();
                    }
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Object[])e.getSuppressed()).hasLength(1);
                    Truth.assertThat((String)e.getSuppressed()[0].getMessage()).contains((CharSequence)SELECT_RANDOM_STATEMENT.getSql());
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                    Truth.assertThat((Boolean)timeout).isTrue();
                    Truth.assertThat((Boolean)receivedTimeout.get()).isTrue();
                    if (connection.isReadOnly() || !connection.isInTransaction()) continue;
                    connection.clearStatementTimeout();
                    connection.rollback();
                }
            }
        }
    }

    private void testExecuteQuery(Function<Connection, Void> connectionConfigurator) {
        long rowCount = 0L;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                if (timeout) {
                    mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        ++rowCount;
                    }
                    Truth.assertThat((Long)rowCount).isEqualTo((Object)100);
                    if (connection.isReadOnly() || !connection.isInTransaction()) {
                        Truth.assertThat((Comparable)connection.getReadTimestamp()).isNotNull();
                    }
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Boolean)timeout).isTrue();
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                    if (connection.isReadOnly() || !connection.isInTransaction()) continue;
                    connection.clearStatementTimeout();
                    connection.rollback();
                }
            }
        }
    }

    private void testExecuteUpdateAsync(Function<Connection, Void> connectionConfigurator) {
        this.testExecuteUpdateAsync(connectionConfigurator, false);
    }

    private void testExecuteUpdateAsync(Function<Connection, Void> connectionConfigurator, boolean executeAsStatement) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                if (timeout) {
                    mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                ApiFuture updateCount = executeAsStatement ? connection.executeAsync(INSERT_STATEMENT).getUpdateCountAsync() : connection.executeUpdateAsync(INSERT_STATEMENT);
                try {
                    Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)updateCount))).isEqualTo((Object)1L);
                    if (connection.isInTransaction()) {
                        connection.commitAsync();
                    }
                    Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Boolean)timeout).isTrue();
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                    if (connection.isReadOnly() || !connection.isInTransaction()) continue;
                    connection.clearStatementTimeout();
                    connection.rollback();
                }
            }
        }
    }

    private void testExecuteUpdate(Function<Connection, Void> connectionConfigurator) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                if (timeout) {
                    mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                try {
                    long updateCount = connection.executeUpdate(INSERT_STATEMENT);
                    Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
                    if (connection.isInTransaction()) {
                        connection.commit();
                    }
                    Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Boolean)timeout).isTrue();
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                    if (connection.isReadOnly() || !connection.isInTransaction()) continue;
                    connection.clearStatementTimeout();
                    connection.rollback();
                }
            }
        }
    }

    private void testExecuteBatchUpdateAsync(Function<Connection, Void> connectionConfigurator) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                if (timeout) {
                    mockSpanner.setExecuteBatchDmlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                ApiFuture updateCounts = connection.executeBatchUpdateAsync((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
                try {
                    Truth.assertThat((long[])((long[])SpannerApiFutures.get((ApiFuture)updateCounts))).asList().containsExactly(new Object[]{1L, 1L});
                    if (connection.isInTransaction()) {
                        connection.commitAsync();
                    }
                    Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Boolean)timeout).isTrue();
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                    if (connection.isReadOnly() || !connection.isInTransaction()) continue;
                    connection.clearStatementTimeout();
                    connection.rollback();
                }
            }
        }
    }

    private void testExecuteBatchUpdate(Function<Connection, Void> connectionConfigurator) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                if (timeout) {
                    mockSpanner.setExecuteBatchDmlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                try {
                    long[] updateCounts = connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
                    Truth.assertThat((long[])updateCounts).asList().containsExactly(new Object[]{1L, 1L});
                    if (connection.isInTransaction()) {
                        connection.commit();
                    }
                    Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                    Truth.assertThat((Boolean)timeout).isTrue();
                    if (connection.isReadOnly() || !connection.isInTransaction()) continue;
                    connection.clearStatementTimeout();
                    connection.rollback();
                }
            }
        }
        SpannerPool.INSTANCE.checkAndCloseSpanners(SpannerPool.CheckAndCloseSpannersMode.ERROR, (Function)new ForceCloseSpannerFunction(100L, TimeUnit.MILLISECONDS));
    }

    private void testWriteAsync(Function<Connection, Void> connectionConfigurator) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                if (timeout) {
                    mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                ApiFuture fut = connection.writeAsync((Iterable)ImmutableList.of((Object)Mutation.newInsertBuilder((String)"foo").build(), (Object)Mutation.newInsertBuilder((String)"bar").build()));
                try {
                    Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)fut)).isNull();
                    Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Boolean)timeout).isTrue();
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                }
            }
        }
    }

    private void testWrite(Function<Connection, Void> connectionConfigurator) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                if (timeout) {
                    mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                try {
                    connection.write((Iterable)ImmutableList.of((Object)Mutation.newInsertBuilder((String)"foo").build(), (Object)Mutation.newInsertBuilder((String)"bar").build()));
                    Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Boolean)timeout).isTrue();
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                }
            }
        }
    }

    private void testBufferedWrite(Function<Connection, Void> connectionConfigurator) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            for (boolean timeout : new boolean[]{true, false}) {
                if (timeout) {
                    mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0));
                    connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
                } else {
                    mockSpanner.removeAllExecutionTimes();
                    connection.clearStatementTimeout();
                }
                try {
                    connection.bufferedWrite((Iterable)ImmutableList.of((Object)Mutation.newInsertBuilder((String)"foo").build(), (Object)Mutation.newInsertBuilder((String)"bar").build()));
                    connection.commitAsync();
                    Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
                    Truth.assertThat((Boolean)timeout).isFalse();
                }
                catch (SpannerException e) {
                    Truth.assertThat((Boolean)timeout).isTrue();
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                    connection.clearStatementTimeout();
                    connection.rollbackAsync();
                }
            }
        }
    }

    private void testExecuteQueryAsyncIsNonBlocking(Function<Connection, Void> connectionConfigurator) {
        AtomicInteger rowCount = new AtomicInteger();
        mockSpanner.freeze();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            ApiFuture res;
            connectionConfigurator.apply((Object)connection);
            try (AsyncResultSet rs = connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                res = rs.setCallback((Executor)executor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case OK: {
                                rowCount.incrementAndGet();
                                break;
                            }
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                    }
                });
                mockSpanner.unfreeze();
            }
            SpannerApiFutures.get((ApiFuture)res);
            Truth.assertThat((Integer)rowCount.get()).isEqualTo((Object)100);
        }
    }

    private void testExecuteUpdateAsyncIsNonBlocking(Function<Connection, Void> connectionConfigurator) {
        mockSpanner.freeze();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            ApiFuture updateCount = connection.executeUpdateAsync(INSERT_STATEMENT);
            if (connection.isInTransaction()) {
                connection.commitAsync();
            }
            mockSpanner.unfreeze();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)updateCount))).isEqualTo((Object)1L);
            Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
        }
    }

    private void testExecuteBatchUpdateAsyncIsNonBlocking(Function<Connection, Void> connectionConfigurator) {
        mockSpanner.freeze();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connectionConfigurator.apply((Object)connection);
            ApiFuture updateCounts = connection.executeBatchUpdateAsync((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            if (connection.isInTransaction()) {
                connection.commitAsync();
            }
            mockSpanner.unfreeze();
            Truth.assertThat((long[])((long[])SpannerApiFutures.get((ApiFuture)updateCounts))).asList().containsExactly(new Object[]{1L, 1L});
            Truth.assertThat((Comparable)connection.getCommitTimestamp()).isNotNull();
        }
    }
}

