/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SerialIntegrationTest;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={SerialIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITBulkConnectionTest
extends ITAbstractSpannerTest {
    private static final int NUMBER_OF_TEST_CONNECTIONS = 250;

    @Test
    public void testBulkCreateConnectionsSingleThreaded() {
        ArrayList<ITAbstractSpannerTest.ITConnection> connections = new ArrayList<ITAbstractSpannerTest.ITConnection>();
        for (int i = 0; i < 250; ++i) {
            connections.add(this.createConnection());
        }
        for (ITAbstractSpannerTest.ITConnection connection : connections) {
            ResultSet rs = connection.executeQuery(Statement.of((String)"select 1"), new Options.QueryOption[0]);
            Throwable throwable = null;
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)connection.getReadTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        for (ITAbstractSpannerTest.ITConnection connection : connections) {
            connection.close();
        }
        this.closeSpanner();
    }

    @Test
    public void testBulkCreateConnectionsMultiThreaded() throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(50);
        for (int i = 0; i < 250; ++i) {
            executor.submit(() -> {
                try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
                     ResultSet rs = connection.executeQuery(Statement.of((String)"select 1"), new Options.QueryOption[0]);){
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)connection.getReadTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                }
                return null;
            });
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        this.closeSpanner();
    }
}

