/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.AbortedException;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnavailableException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IsRetryableInternalError;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import io.grpc.Status;
import io.opencensus.trace.Span;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

public class PartitionedDmlTransaction
implements SessionImpl.SessionTransaction {
    private static final Logger LOGGER = Logger.getLogger(PartitionedDmlTransaction.class.getName());
    private final SessionImpl session;
    private final SpannerRpc rpc;
    private final Ticker ticker;
    private final IsRetryableInternalError isRetryableInternalErrorPredicate;
    private volatile boolean isValid = true;

    PartitionedDmlTransaction(SessionImpl session, SpannerRpc rpc, Ticker ticker) {
        this.session = session;
        this.rpc = rpc;
        this.ticker = ticker;
        this.isRetryableInternalErrorPredicate = new IsRetryableInternalError();
    }

    long executeStreamingPartitionedUpdate(Statement statement, Duration timeout, Options.UpdateOption ... updateOptions) {
        Preconditions.checkState((boolean)this.isValid, (Object)"Partitioned DML has been invalidated by a new operation on the session");
        LOGGER.log(Level.FINER, "Starting PartitionedUpdate statement");
        ByteString resumeToken = ByteString.EMPTY;
        boolean foundStats = false;
        long updateCount = 0L;
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        Options options = Options.fromUpdateOptions(updateOptions);
        try {
            ExecuteSqlRequest request = this.newTransactionRequestFrom(statement, options);
            while (true) {
                Duration remainingTimeout = this.tryUpdateTimeout(timeout, stopwatch);
                try {
                    ServerStream<PartialResultSet> stream = this.rpc.executeStreamingPartitionedDml(request, this.session.getOptions(), remainingTimeout);
                    for (PartialResultSet rs : stream) {
                        if (rs.getResumeToken() != null && !rs.getResumeToken().isEmpty()) {
                            resumeToken = rs.getResumeToken();
                        }
                        if (!rs.hasStats()) continue;
                        foundStats = true;
                        updateCount += rs.getStats().getRowCountLowerBound();
                    }
                }
                catch (UnavailableException e) {
                    LOGGER.log(Level.FINER, "Retrying PartitionedDml transaction after UnavailableException", e);
                    request = this.resumeOrRestartRequest(resumeToken, statement, request, options);
                    continue;
                }
                catch (InternalException e) {
                    if (!this.isRetryableInternalErrorPredicate.apply(e)) {
                        throw e;
                    }
                    LOGGER.log(Level.FINER, "Retrying PartitionedDml transaction after InternalException - EOS", e);
                    request = this.resumeOrRestartRequest(resumeToken, statement, request, options);
                    continue;
                }
                catch (AbortedException e) {
                    LOGGER.log(Level.FINER, "Retrying PartitionedDml transaction after AbortedException", e);
                    resumeToken = ByteString.EMPTY;
                    foundStats = false;
                    updateCount = 0L;
                    request = this.newTransactionRequestFrom(statement, options);
                    continue;
                }
                break;
            }
            if (!foundStats) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Partitioned DML response missing stats possibly due to non-DML statement as input");
            }
            LOGGER.log(Level.FINER, "Finished PartitionedUpdate statement");
            return updateCount;
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
    }

    @Override
    public void invalidate() {
        this.isValid = false;
    }

    @Override
    public void setSpan(Span span) {
    }

    private Duration tryUpdateTimeout(Duration timeout, Stopwatch stopwatch) {
        Duration remainingTimeout = timeout.minus(stopwatch.elapsed(TimeUnit.MILLISECONDS), (TemporalUnit)ChronoUnit.MILLIS);
        if (remainingTimeout.isNegative() || remainingTimeout.isZero()) {
            throw new DeadlineExceededException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), false);
        }
        return remainingTimeout;
    }

    private ExecuteSqlRequest resumeOrRestartRequest(ByteString resumeToken, Statement statement, ExecuteSqlRequest originalRequest, Options options) {
        if (resumeToken.isEmpty()) {
            return this.newTransactionRequestFrom(statement, options);
        }
        return ExecuteSqlRequest.newBuilder((ExecuteSqlRequest)originalRequest).setResumeToken(resumeToken).build();
    }

    @VisibleForTesting
    ExecuteSqlRequest newTransactionRequestFrom(Statement statement, Options options) {
        ByteString transactionId = this.initTransaction();
        TransactionSelector transactionSelector = TransactionSelector.newBuilder().setId(transactionId).build();
        ExecuteSqlRequest.Builder builder = ExecuteSqlRequest.newBuilder().setSql(statement.getSql()).setQueryMode(ExecuteSqlRequest.QueryMode.NORMAL).setSession(this.session.getName()).setTransaction(transactionSelector);
        this.setParameters(builder, statement.getParameters());
        builder.setResumeToken(ByteString.EMPTY);
        if (options.hasPriority() || options.hasTag()) {
            RequestOptions.Builder requestOptionsBuilder = RequestOptions.newBuilder();
            if (options.hasPriority()) {
                requestOptionsBuilder.setPriority(options.priority());
            }
            if (options.hasTag()) {
                requestOptionsBuilder.setRequestTag(options.tag());
            }
            builder.setRequestOptions(requestOptionsBuilder.build());
        }
        return builder.build();
    }

    private ByteString initTransaction() {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.session.getName()).setOptions(TransactionOptions.newBuilder().setPartitionedDml(TransactionOptions.PartitionedDml.getDefaultInstance())).build();
        Transaction tx = this.rpc.beginTransaction(request, this.session.getOptions());
        if (tx.getId().isEmpty()) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Failed to init transaction, missing transaction id\n" + this.session.getName());
        }
        return tx.getId();
    }

    private void setParameters(ExecuteSqlRequest.Builder requestBuilder, Map<String, Value> statementParameters) {
        if (!statementParameters.isEmpty()) {
            Struct.Builder paramsBuilder = requestBuilder.getParamsBuilder();
            for (Map.Entry<String, Value> param : statementParameters.entrySet()) {
                paramsBuilder.putFields(param.getKey(), param.getValue().toProto());
                requestBuilder.putParamTypes(param.getKey(), param.getValue().getType().toProto());
            }
        }
    }
}

