/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.spanner.InstanceId;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;

public final class BackupId {
    private static final PathTemplate NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}/instances/{instance}/backups/{backup}");
    private final InstanceId instanceId;
    private final String backup;

    BackupId(InstanceId instanceId, String backup) {
        this.instanceId = (InstanceId)Preconditions.checkNotNull((Object)instanceId);
        this.backup = (String)Preconditions.checkNotNull((Object)backup);
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public String getBackup() {
        return this.backup;
    }

    public String getName() {
        return String.format("projects/%s/instances/%s/backups/%s", this.instanceId.getProject(), this.instanceId.getInstance(), this.backup);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.backup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupId that = (BackupId)o;
        return that.instanceId.equals(this.instanceId) && that.backup.equals(this.backup);
    }

    public String toString() {
        return this.getName();
    }

    static BackupId of(String name) {
        Preconditions.checkNotNull((Object)name);
        Map parts = NAME_TEMPLATE.match(name);
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (String)"Name should conform to pattern %s: %s", (Object)NAME_TEMPLATE, (Object)name);
        return BackupId.of((String)parts.get("project"), (String)parts.get("instance"), (String)parts.get("backup"));
    }

    public static BackupId of(String project, String instance, String backup) {
        return new BackupId(new InstanceId(project, instance), backup);
    }

    public static BackupId of(InstanceId instanceId, String backup) {
        return new BackupId(instanceId, backup);
    }
}

