/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.database.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminClient;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStub;
import com.google.cloud.spanner.admin.database.v1.stub.GrpcDatabaseAdminStub;
import com.google.cloud.spanner.admin.database.v1.stub.HttpJsonDatabaseAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.CopyBackupMetadata;
import com.google.spanner.admin.database.v1.CopyBackupRequest;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateBackupRequest;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DeleteBackupRequest;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetBackupRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.ListBackupOperationsRequest;
import com.google.spanner.admin.database.v1.ListBackupOperationsResponse;
import com.google.spanner.admin.database.v1.ListBackupsRequest;
import com.google.spanner.admin.database.v1.ListBackupsResponse;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsRequest;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsResponse;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseRequest;
import com.google.spanner.admin.database.v1.UpdateBackupRequest;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DatabaseAdminStubSettings
extends StubSettings<DatabaseAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/spanner.admin").build();
    private final PagedCallSettings<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> listDatabasesSettings;
    private final UnaryCallSettings<CreateDatabaseRequest, Operation> createDatabaseSettings;
    private final OperationCallSettings<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings;
    private final UnaryCallSettings<GetDatabaseRequest, Database> getDatabaseSettings;
    private final UnaryCallSettings<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlSettings;
    private final OperationCallSettings<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationSettings;
    private final UnaryCallSettings<DropDatabaseRequest, Empty> dropDatabaseSettings;
    private final UnaryCallSettings<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings;
    private final OperationCallSettings<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationSettings;
    private final UnaryCallSettings<CopyBackupRequest, Operation> copyBackupSettings;
    private final OperationCallSettings<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationSettings;
    private final UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings;
    private final UnaryCallSettings<UpdateBackupRequest, Backup> updateBackupSettings;
    private final UnaryCallSettings<DeleteBackupRequest, Empty> deleteBackupSettings;
    private final PagedCallSettings<ListBackupsRequest, ListBackupsResponse, DatabaseAdminClient.ListBackupsPagedResponse> listBackupsSettings;
    private final UnaryCallSettings<RestoreDatabaseRequest, Operation> restoreDatabaseSettings;
    private final OperationCallSettings<RestoreDatabaseRequest, Database, RestoreDatabaseMetadata> restoreDatabaseOperationSettings;
    private final PagedCallSettings<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, DatabaseAdminClient.ListDatabaseOperationsPagedResponse> listDatabaseOperationsSettings;
    private final PagedCallSettings<ListBackupOperationsRequest, ListBackupOperationsResponse, DatabaseAdminClient.ListBackupOperationsPagedResponse> listBackupOperationsSettings;
    private static final PagedListDescriptor<ListDatabasesRequest, ListDatabasesResponse, Database> LIST_DATABASES_PAGE_STR_DESC = new PagedListDescriptor<ListDatabasesRequest, ListDatabasesResponse, Database>(){

        public String emptyToken() {
            return "";
        }

        public ListDatabasesRequest injectToken(ListDatabasesRequest payload, String token) {
            return ListDatabasesRequest.newBuilder((ListDatabasesRequest)payload).setPageToken(token).build();
        }

        public ListDatabasesRequest injectPageSize(ListDatabasesRequest payload, int pageSize) {
            return ListDatabasesRequest.newBuilder((ListDatabasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatabasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatabasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Database> extractResources(ListDatabasesResponse payload) {
            return payload.getDatabasesList() == null ? ImmutableList.of() : payload.getDatabasesList();
        }
    };
    private static final PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup> LIST_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupsRequest injectToken(ListBackupsRequest payload, String token) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageToken(token).build();
        }

        public ListBackupsRequest injectPageSize(ListBackupsRequest payload, int pageSize) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Backup> extractResources(ListBackupsResponse payload) {
            return payload.getBackupsList() == null ? ImmutableList.of() : payload.getBackupsList();
        }
    };
    private static final PagedListDescriptor<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation> LIST_DATABASE_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation>(){

        public String emptyToken() {
            return "";
        }

        public ListDatabaseOperationsRequest injectToken(ListDatabaseOperationsRequest payload, String token) {
            return ListDatabaseOperationsRequest.newBuilder((ListDatabaseOperationsRequest)payload).setPageToken(token).build();
        }

        public ListDatabaseOperationsRequest injectPageSize(ListDatabaseOperationsRequest payload, int pageSize) {
            return ListDatabaseOperationsRequest.newBuilder((ListDatabaseOperationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatabaseOperationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatabaseOperationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Operation> extractResources(ListDatabaseOperationsResponse payload) {
            return payload.getOperationsList() == null ? ImmutableList.of() : payload.getOperationsList();
        }
    };
    private static final PagedListDescriptor<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation> LIST_BACKUP_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupOperationsRequest injectToken(ListBackupOperationsRequest payload, String token) {
            return ListBackupOperationsRequest.newBuilder((ListBackupOperationsRequest)payload).setPageToken(token).build();
        }

        public ListBackupOperationsRequest injectPageSize(ListBackupOperationsRequest payload, int pageSize) {
            return ListBackupOperationsRequest.newBuilder((ListBackupOperationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupOperationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupOperationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Operation> extractResources(ListBackupOperationsResponse payload) {
            return payload.getOperationsList() == null ? ImmutableList.of() : payload.getOperationsList();
        }
    };
    private static final PagedListResponseFactory<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> LIST_DATABASES_PAGE_STR_FACT = new PagedListResponseFactory<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse>(){

        public ApiFuture<DatabaseAdminClient.ListDatabasesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> callable, ListDatabasesRequest request, ApiCallContext context, ApiFuture<ListDatabasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATABASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatabaseAdminClient.ListDatabasesPagedResponse.createAsync((PageContext<ListDatabasesRequest, ListDatabasesResponse, Database>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, DatabaseAdminClient.ListBackupsPagedResponse> LIST_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, DatabaseAdminClient.ListBackupsPagedResponse>(){

        public ApiFuture<DatabaseAdminClient.ListBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupsRequest, ListBackupsResponse> callable, ListBackupsRequest request, ApiCallContext context, ApiFuture<ListBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatabaseAdminClient.ListBackupsPagedResponse.createAsync((PageContext<ListBackupsRequest, ListBackupsResponse, Backup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, DatabaseAdminClient.ListDatabaseOperationsPagedResponse> LIST_DATABASE_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, DatabaseAdminClient.ListDatabaseOperationsPagedResponse>(){

        public ApiFuture<DatabaseAdminClient.ListDatabaseOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse> callable, ListDatabaseOperationsRequest request, ApiCallContext context, ApiFuture<ListDatabaseOperationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATABASE_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatabaseAdminClient.ListDatabaseOperationsPagedResponse.createAsync((PageContext<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupOperationsRequest, ListBackupOperationsResponse, DatabaseAdminClient.ListBackupOperationsPagedResponse> LIST_BACKUP_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupOperationsRequest, ListBackupOperationsResponse, DatabaseAdminClient.ListBackupOperationsPagedResponse>(){

        public ApiFuture<DatabaseAdminClient.ListBackupOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupOperationsRequest, ListBackupOperationsResponse> callable, ListBackupOperationsRequest request, ApiCallContext context, ApiFuture<ListBackupOperationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUP_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatabaseAdminClient.ListBackupOperationsPagedResponse.createAsync((PageContext<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> listDatabasesSettings() {
        return this.listDatabasesSettings;
    }

    public UnaryCallSettings<CreateDatabaseRequest, Operation> createDatabaseSettings() {
        return this.createDatabaseSettings;
    }

    public OperationCallSettings<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings() {
        return this.createDatabaseOperationSettings;
    }

    public UnaryCallSettings<GetDatabaseRequest, Database> getDatabaseSettings() {
        return this.getDatabaseSettings;
    }

    public UnaryCallSettings<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlSettings() {
        return this.updateDatabaseDdlSettings;
    }

    public OperationCallSettings<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationSettings() {
        return this.updateDatabaseDdlOperationSettings;
    }

    public UnaryCallSettings<DropDatabaseRequest, Empty> dropDatabaseSettings() {
        return this.dropDatabaseSettings;
    }

    public UnaryCallSettings<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlSettings() {
        return this.getDatabaseDdlSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings() {
        return this.createBackupSettings;
    }

    public OperationCallSettings<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationSettings() {
        return this.createBackupOperationSettings;
    }

    public UnaryCallSettings<CopyBackupRequest, Operation> copyBackupSettings() {
        return this.copyBackupSettings;
    }

    public OperationCallSettings<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationSettings() {
        return this.copyBackupOperationSettings;
    }

    public UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings() {
        return this.getBackupSettings;
    }

    public UnaryCallSettings<UpdateBackupRequest, Backup> updateBackupSettings() {
        return this.updateBackupSettings;
    }

    public UnaryCallSettings<DeleteBackupRequest, Empty> deleteBackupSettings() {
        return this.deleteBackupSettings;
    }

    public PagedCallSettings<ListBackupsRequest, ListBackupsResponse, DatabaseAdminClient.ListBackupsPagedResponse> listBackupsSettings() {
        return this.listBackupsSettings;
    }

    public UnaryCallSettings<RestoreDatabaseRequest, Operation> restoreDatabaseSettings() {
        return this.restoreDatabaseSettings;
    }

    public OperationCallSettings<RestoreDatabaseRequest, Database, RestoreDatabaseMetadata> restoreDatabaseOperationSettings() {
        return this.restoreDatabaseOperationSettings;
    }

    public PagedCallSettings<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, DatabaseAdminClient.ListDatabaseOperationsPagedResponse> listDatabaseOperationsSettings() {
        return this.listDatabaseOperationsSettings;
    }

    public PagedCallSettings<ListBackupOperationsRequest, ListBackupOperationsResponse, DatabaseAdminClient.ListBackupOperationsPagedResponse> listBackupOperationsSettings() {
        return this.listBackupOperationsSettings;
    }

    public DatabaseAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDatabaseAdminStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDatabaseAdminStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "spanner.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "spanner.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DatabaseAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatabaseAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatabaseAdminStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DatabaseAdminStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DatabaseAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDatabasesSettings = settingsBuilder.listDatabasesSettings().build();
        this.createDatabaseSettings = settingsBuilder.createDatabaseSettings().build();
        this.createDatabaseOperationSettings = settingsBuilder.createDatabaseOperationSettings().build();
        this.getDatabaseSettings = settingsBuilder.getDatabaseSettings().build();
        this.updateDatabaseDdlSettings = settingsBuilder.updateDatabaseDdlSettings().build();
        this.updateDatabaseDdlOperationSettings = settingsBuilder.updateDatabaseDdlOperationSettings().build();
        this.dropDatabaseSettings = settingsBuilder.dropDatabaseSettings().build();
        this.getDatabaseDdlSettings = settingsBuilder.getDatabaseDdlSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.createBackupSettings = settingsBuilder.createBackupSettings().build();
        this.createBackupOperationSettings = settingsBuilder.createBackupOperationSettings().build();
        this.copyBackupSettings = settingsBuilder.copyBackupSettings().build();
        this.copyBackupOperationSettings = settingsBuilder.copyBackupOperationSettings().build();
        this.getBackupSettings = settingsBuilder.getBackupSettings().build();
        this.updateBackupSettings = settingsBuilder.updateBackupSettings().build();
        this.deleteBackupSettings = settingsBuilder.deleteBackupSettings().build();
        this.listBackupsSettings = settingsBuilder.listBackupsSettings().build();
        this.restoreDatabaseSettings = settingsBuilder.restoreDatabaseSettings().build();
        this.restoreDatabaseOperationSettings = settingsBuilder.restoreDatabaseOperationSettings().build();
        this.listDatabaseOperationsSettings = settingsBuilder.listDatabaseOperationsSettings().build();
        this.listBackupOperationsSettings = settingsBuilder.listBackupOperationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DatabaseAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> listDatabasesSettings;
        private final UnaryCallSettings.Builder<CreateDatabaseRequest, Operation> createDatabaseSettings;
        private final OperationCallSettings.Builder<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings;
        private final UnaryCallSettings.Builder<GetDatabaseRequest, Database> getDatabaseSettings;
        private final UnaryCallSettings.Builder<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlSettings;
        private final OperationCallSettings.Builder<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationSettings;
        private final UnaryCallSettings.Builder<DropDatabaseRequest, Empty> dropDatabaseSettings;
        private final UnaryCallSettings.Builder<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings;
        private final OperationCallSettings.Builder<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationSettings;
        private final UnaryCallSettings.Builder<CopyBackupRequest, Operation> copyBackupSettings;
        private final OperationCallSettings.Builder<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationSettings;
        private final UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings;
        private final UnaryCallSettings.Builder<UpdateBackupRequest, Backup> updateBackupSettings;
        private final UnaryCallSettings.Builder<DeleteBackupRequest, Empty> deleteBackupSettings;
        private final PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, DatabaseAdminClient.ListBackupsPagedResponse> listBackupsSettings;
        private final UnaryCallSettings.Builder<RestoreDatabaseRequest, Operation> restoreDatabaseSettings;
        private final OperationCallSettings.Builder<RestoreDatabaseRequest, Database, RestoreDatabaseMetadata> restoreDatabaseOperationSettings;
        private final PagedCallSettings.Builder<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, DatabaseAdminClient.ListDatabaseOperationsPagedResponse> listDatabaseOperationsSettings;
        private final PagedCallSettings.Builder<ListBackupOperationsRequest, ListBackupOperationsResponse, DatabaseAdminClient.ListBackupOperationsPagedResponse> listBackupOperationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDatabasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATABASES_PAGE_STR_FACT);
            this.createDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.getDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatabaseDdlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatabaseDdlOperationSettings = OperationCallSettings.newBuilder();
            this.dropDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDatabaseDdlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupOperationSettings = OperationCallSettings.newBuilder();
            this.copyBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.copyBackupOperationSettings = OperationCallSettings.newBuilder();
            this.getBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUPS_PAGE_STR_FACT);
            this.restoreDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.listDatabaseOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATABASE_OPERATIONS_PAGE_STR_FACT);
            this.listBackupOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUP_OPERATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDatabasesSettings, this.createDatabaseSettings, this.getDatabaseSettings, this.updateDatabaseDdlSettings, this.dropDatabaseSettings, this.getDatabaseDdlSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, this.createBackupSettings, this.copyBackupSettings, this.getBackupSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateBackupSettings, this.deleteBackupSettings, this.listBackupsSettings, this.restoreDatabaseSettings, this.listDatabaseOperationsSettings, this.listBackupOperationsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DatabaseAdminStubSettings settings) {
            super((StubSettings)settings);
            this.listDatabasesSettings = settings.listDatabasesSettings.toBuilder();
            this.createDatabaseSettings = settings.createDatabaseSettings.toBuilder();
            this.createDatabaseOperationSettings = settings.createDatabaseOperationSettings.toBuilder();
            this.getDatabaseSettings = settings.getDatabaseSettings.toBuilder();
            this.updateDatabaseDdlSettings = settings.updateDatabaseDdlSettings.toBuilder();
            this.updateDatabaseDdlOperationSettings = settings.updateDatabaseDdlOperationSettings.toBuilder();
            this.dropDatabaseSettings = settings.dropDatabaseSettings.toBuilder();
            this.getDatabaseDdlSettings = settings.getDatabaseDdlSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.createBackupSettings = settings.createBackupSettings.toBuilder();
            this.createBackupOperationSettings = settings.createBackupOperationSettings.toBuilder();
            this.copyBackupSettings = settings.copyBackupSettings.toBuilder();
            this.copyBackupOperationSettings = settings.copyBackupOperationSettings.toBuilder();
            this.getBackupSettings = settings.getBackupSettings.toBuilder();
            this.updateBackupSettings = settings.updateBackupSettings.toBuilder();
            this.deleteBackupSettings = settings.deleteBackupSettings.toBuilder();
            this.listBackupsSettings = settings.listBackupsSettings.toBuilder();
            this.restoreDatabaseSettings = settings.restoreDatabaseSettings.toBuilder();
            this.restoreDatabaseOperationSettings = settings.restoreDatabaseOperationSettings.toBuilder();
            this.listDatabaseOperationsSettings = settings.listDatabaseOperationsSettings.toBuilder();
            this.listBackupOperationsSettings = settings.listBackupOperationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDatabasesSettings, this.createDatabaseSettings, this.getDatabaseSettings, this.updateDatabaseDdlSettings, this.dropDatabaseSettings, this.getDatabaseDdlSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, this.createBackupSettings, this.copyBackupSettings, this.getBackupSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateBackupSettings, this.deleteBackupSettings, this.listBackupsSettings, this.restoreDatabaseSettings, this.listDatabaseOperationsSettings, this.listBackupOperationsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DatabaseAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DatabaseAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatabaseAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DatabaseAdminStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DatabaseAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DatabaseAdminStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DatabaseAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatabaseAdminStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DatabaseAdminStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DatabaseAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDatabasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.getDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDatabaseDdlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.dropDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDatabaseDdlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.createBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.copyBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.getBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.restoreDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listDatabaseOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listBackupOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Database.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDatabaseMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            builder.updateDatabaseDdlOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateDatabaseDdlMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            builder.createBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateBackupMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)172800000L)).build()));
            builder.copyBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CopyBackupMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restoreDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Database.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RestoreDatabaseMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> listDatabasesSettings() {
            return this.listDatabasesSettings;
        }

        public UnaryCallSettings.Builder<CreateDatabaseRequest, Operation> createDatabaseSettings() {
            return this.createDatabaseSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings() {
            return this.createDatabaseOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDatabaseRequest, Database> getDatabaseSettings() {
            return this.getDatabaseSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlSettings() {
            return this.updateDatabaseDdlSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationSettings() {
            return this.updateDatabaseDdlOperationSettings;
        }

        public UnaryCallSettings.Builder<DropDatabaseRequest, Empty> dropDatabaseSettings() {
            return this.dropDatabaseSettings;
        }

        public UnaryCallSettings.Builder<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlSettings() {
            return this.getDatabaseDdlSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings() {
            return this.createBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationSettings() {
            return this.createBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<CopyBackupRequest, Operation> copyBackupSettings() {
            return this.copyBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationSettings() {
            return this.copyBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings() {
            return this.getBackupSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackupRequest, Backup> updateBackupSettings() {
            return this.updateBackupSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupRequest, Empty> deleteBackupSettings() {
            return this.deleteBackupSettings;
        }

        public PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, DatabaseAdminClient.ListBackupsPagedResponse> listBackupsSettings() {
            return this.listBackupsSettings;
        }

        public UnaryCallSettings.Builder<RestoreDatabaseRequest, Operation> restoreDatabaseSettings() {
            return this.restoreDatabaseSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestoreDatabaseRequest, Database, RestoreDatabaseMetadata> restoreDatabaseOperationSettings() {
            return this.restoreDatabaseOperationSettings;
        }

        public PagedCallSettings.Builder<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, DatabaseAdminClient.ListDatabaseOperationsPagedResponse> listDatabaseOperationsSettings() {
            return this.listDatabaseOperationsSettings;
        }

        public PagedCallSettings.Builder<ListBackupOperationsRequest, ListBackupOperationsResponse, DatabaseAdminClient.ListBackupOperationsPagedResponse> listBackupOperationsSettings() {
            return this.listBackupOperationsSettings;
        }

        public DatabaseAdminStubSettings build() throws IOException {
            return new DatabaseAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

