/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ForwardingStructReader;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.spanner.v1.ResultSetStats;

public class ForwardingResultSet
extends ForwardingStructReader
implements ResultSet {
    private Supplier<ResultSet> delegate;

    public ForwardingResultSet(ResultSet delegate) {
        super(delegate);
        this.delegate = Suppliers.ofInstance((Object)((ResultSet)Preconditions.checkNotNull((Object)delegate)));
    }

    public ForwardingResultSet(Supplier<ResultSet> supplier) {
        super(supplier);
        this.delegate = supplier;
    }

    void replaceDelegate(ResultSet newDelegate) {
        Preconditions.checkNotNull((Object)newDelegate);
        super.replaceDelegate(newDelegate);
        this.delegate = Suppliers.ofInstance((Object)((ResultSet)Preconditions.checkNotNull((Object)newDelegate)));
    }

    @Override
    public boolean next() throws SpannerException {
        return ((ResultSet)this.delegate.get()).next();
    }

    @Override
    public Struct getCurrentRowAsStruct() {
        return ((ResultSet)this.delegate.get()).getCurrentRowAsStruct();
    }

    @Override
    public void close() {
        ResultSet rs;
        try {
            rs = (ResultSet)this.delegate.get();
        }
        catch (Exception e) {
            return;
        }
        rs.close();
    }

    @Override
    public ResultSetStats getStats() {
        return ((ResultSet)this.delegate.get()).getStats();
    }
}

