/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.RandomResultSetGenerator;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class InlineBeginTransactionTest {
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static final Statement UPDATE_STATEMENT;
    private static final Statement INVALID_UPDATE_STATEMENT;
    private static final long UPDATE_COUNT = 1L;
    private static final Statement SELECT1;
    private static final ResultSetMetadata SELECT1_METADATA;
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET;
    private static final com.google.spanner.v1.ResultSet EMPTY_RESULTSET;
    private static final Statement SELECT1_UNION_ALL_SELECT2;
    private static final com.google.spanner.v1.ResultSet SELECT1_UNION_ALL_SELECT2_RESULTSET;
    private static final Statement INVALID_SELECT;
    private static final Statement READ_STATEMENT;
    private static final Statement READ_ROW_STATEMENT;
    protected Spanner spanner;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1_UNION_ALL_SELECT2, SELECT1_UNION_ALL_SELECT2_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(READ_STATEMENT, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(READ_ROW_STATEMENT, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid update statement").asRuntimeException()));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_SELECT, Status.INVALID_ARGUMENT.withDescription("invalid select statement").asRuntimeException()));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setTrackTransactionStarter().build().getService();
    }

    @After
    public void tearDown() {
        this.spanner.close();
        mockSpanner.reset();
        mockSpanner.clearRequests();
    }

    private static int countRequests(Class<? extends AbstractMessage> requestType) {
        int count = 0;
        for (AbstractMessage msg : mockSpanner.getRequests()) {
            if (!msg.getClass().equals(requestType)) continue;
            ++count;
        }
        return count;
    }

    private static int countTransactionsStarted() {
        return mockSpanner.getTransactionsStarted().size();
    }

    static {
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
        INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
        SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
        SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
        SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
        EMPTY_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(SELECT1_METADATA).build();
        SELECT1_UNION_ALL_SELECT2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
        SELECT1_UNION_ALL_SELECT2_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1_METADATA).build();
        INVALID_SELECT = Statement.of((String)"SELECT * FROM NON_EXISTING_TABLE");
        READ_STATEMENT = Statement.of((String)"SELECT ID FROM FOO WHERE 1=1");
        READ_ROW_STATEMENT = Statement.of((String)"SELECT BAR FROM FOO WHERE ID=1");
    }

    @RunWith(value=JUnit4.class)
    public static class InlineBeginTransactionWithoutExecutorTest
    extends InlineBeginTransactionTest {
        @Test
        public void testInlinedBeginTx() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxAborted() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            AtomicBoolean firstAttempt = new AtomicBoolean(true);
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                long res = transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                if (firstAttempt.getAndSet(false)) {
                    mockSpanner.abortTransaction(transaction);
                }
                return res;
            });
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginFirstUpdateAborts() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){
                boolean firstAttempt = true;

                public Long run(TransactionContext transaction) {
                    if (this.firstAttempt) {
                        this.firstAttempt = false;
                        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(UPDATE_STATEMENT, mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"some-tx"))));
                    } else {
                        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
                    }
                    return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                }
            });
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstQueryAborts() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){
                boolean firstAttempt = true;

                public Long run(TransactionContext transaction) {
                    if (this.firstAttempt) {
                        this.firstAttempt = false;
                        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(SELECT1, mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"some-tx"))));
                    } else {
                        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
                    }
                    try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                        if (rs.next()) {
                            Long l = rs.getLong(0);
                            return l;
                        }
                    }
                    return 0L;
                }
            });
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstQueryReturnsUnavailable() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)((Object)Status.UNAVAILABLE.asRuntimeException()), 0L));
            long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                }
                return 0L;
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstReadReturnsUnavailable() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)((Object)Status.UNAVAILABLE.asRuntimeException()), 0L));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                }
                return 0L;
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstReadReturnsUnavailableRetryReturnsAborted() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofExceptions(Arrays.asList(Status.UNAVAILABLE.asRuntimeException(), Status.ABORTED.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                }
                return 0L;
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstQueryReturnsUnavailableRetryReturnsAborted() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofExceptions(Arrays.asList(Status.UNAVAILABLE.asRuntimeException(), Status.ABORTED.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                }
                return 0L;
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstDmlReturnsUnavailableRetryReturnsAborted() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofExceptions(Arrays.asList(Status.UNAVAILABLE.asRuntimeException(), Status.ABORTED.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstReadReturnsUnavailableRetryReturnsAborted_WithCatchAll() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofExceptions(Arrays.asList(Status.UNAVAILABLE.asRuntimeException(), Status.ABORTED.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (!rs.next()) return 0L;
                    Long l = rs.getLong(0);
                    return l;
                }
                catch (AbortedException abortedException) {
                    // empty catch block
                }
                return 0L;
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstQueryReturnsUnavailableRetryReturnsAborted_WithCatchAll() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofExceptions(Arrays.asList(Status.UNAVAILABLE.asRuntimeException(), Status.ABORTED.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try {
                    return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                }
                catch (AbortedException abortedException) {
                    return 0L;
                }
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstDmlReturnsUnavailableRetryReturnsAborted_WithCatchAll() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofExceptions(Arrays.asList(Status.UNAVAILABLE.asRuntimeException(), Status.ABORTED.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                    if (!rs.next()) return 0L;
                    Long l = rs.getLong(0);
                    return l;
                }
                catch (AbortedException abortedException) {
                    // empty catch block
                }
                return 0L;
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginFirstReadCancelledSecondReadAborted_WithCatch() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.CANCELLED.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (!rs.next()) return 0L;
                    Long l = rs.getLong(0);
                    return l;
                }
                catch (SpannerException e) {
                    if (e.getErrorCode() == ErrorCode.CANCELLED) {
                        mockSpanner.abortNextTransaction();
                        return 0L;
                    }
                    if (e.getErrorCode() != ErrorCode.ABORTED) throw e;
                    return 0L;
                }
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginFirstReadCancelledSecondReadAborted_WithoutCatch() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.CANCELLED.asRuntimeException())));
            Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (!rs.next()) return 0L;
                    Long l = rs.getLong(0);
                    return l;
                }
                catch (SpannerException e) {
                    if (e.getErrorCode() != ErrorCode.CANCELLED) throw e;
                    mockSpanner.abortNextTransaction();
                    throw e;
                }
            }));
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(RollbackRequest.class)).isEqualTo((Object)0);
        }

        @Test
        public void testInlinedBeginFirstReadCancelledSecondReadAborted_WithCatchForCancelled() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.CANCELLED.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (!rs.next()) return 0L;
                    Long l = rs.getLong(0);
                    return l;
                }
                catch (SpannerException e) {
                    if (e.getErrorCode() != ErrorCode.CANCELLED) throw e;
                    mockSpanner.abortNextTransaction();
                    return 0L;
                }
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginCommitAfterReadReturnsUnavailable() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.UNAVAILABLE.asRuntimeException())));
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                }
                return 0L;
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginFirstReadReturnsUnavailableAndCommitAborts() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)((Object)Status.UNAVAILABLE.asRuntimeException()), 0L));
            AtomicBoolean firstAttempt = new AtomicBoolean(true);
            Long value = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                long res = 0L;
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (rs.next()) {
                        res = rs.getLong(0);
                    }
                }
                if (firstAttempt.compareAndSet(true, false)) {
                    mockSpanner.abortTransaction(transaction);
                }
                return res;
            });
            Truth.assertThat((Long)value).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginTxWithQuery() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                }
                return 0L;
            });
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxWithRead() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                }
                return 0L;
            });
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxWithBatchDml() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            long[] updateCounts = (long[])client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]));
            Truth.assertThat((long[])updateCounts).asList().containsExactly(new Object[]{1L, 1L});
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteBatchDmlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxWithError() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]));
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            });
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginTxWithErrorOnFirstStatement_andThenErrorOnBeginTransaction() {
            mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.INTERNAL.withDescription("Begin transaction failed due to an internal error").asRuntimeException())));
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            SpannerException outerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                SpannerException innerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]));
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)innerException.getErrorCode());
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)outerException.getErrorCode());
            Truth.assertThat((String)outerException.getMessage()).contains((CharSequence)"Begin transaction failed due to an internal error");
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxWithUncaughtError() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0])));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(RollbackRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxWithUncaughtErrorAfterSuccessfulBegin() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                return transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(RollbackRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxBatchDmlWithErrorOnFirstStatement() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            Void res = (Void)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                SpannerBatchUpdateException e = (SpannerBatchUpdateException)Assert.assertThrows(SpannerBatchUpdateException.class, () -> transaction.batchUpdate((Iterable)ImmutableList.of((Object)INVALID_UPDATE_STATEMENT, (Object)UPDATE_STATEMENT), new Options.UpdateOption[0]));
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
                Assert.assertEquals((long)0L, (long)e.getUpdateCounts().length);
                return null;
            });
            Truth.assertThat((Object)res).isNull();
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteBatchDmlRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginTxBatchDmlWithErrorOnSecondStatement() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                SpannerBatchUpdateException e = (SpannerBatchUpdateException)Assert.assertThrows(SpannerBatchUpdateException.class, () -> transaction.batchUpdate((Iterable)ImmutableList.of((Object)UPDATE_STATEMENT, (Object)INVALID_UPDATE_STATEMENT), new Options.UpdateOption[0]));
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
                Assert.assertEquals((long)1L, (long)e.getUpdateCounts().length);
                return e.getUpdateCounts()[0];
            });
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteBatchDmlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxWithErrorOnStreamingSql() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            Void res = (Void)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(INVALID_SELECT, new Options.QueryOption[0]);){
                    SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
                    Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
                }
                return null;
            });
            Truth.assertThat((Object)res).isNull();
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginTxWithErrorOnSecondPartialResultSet() {
            Statement statement = Statement.of((String)"SELECT * FROM BROKEN_TABLE");
            RandomResultSetGenerator generator = new RandomResultSetGenerator(2);
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)((Object)Status.DATA_LOSS.asRuntimeException()), 1L));
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            Void res = (Void)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(statement, new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)rs.next());
                    SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
                    Assert.assertEquals((Object)ErrorCode.DATA_LOSS, (Object)e.getErrorCode());
                }
                return null;
            });
            Truth.assertThat((Object)res).isNull();
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxWithParallelQueries() {
            int numQueries = 100;
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(16);
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>(100);
                for (int i = 0; i < 100; ++i) {
                    futures.add(executor.submit(() -> {
                        try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                            if (rs.next()) {
                                Long l = rs.getLong(0);
                                return l;
                            }
                        }
                        return 0L;
                    }));
                }
                Long res = 0L;
                for (Future future : futures) {
                    res = res + (Long)future.get();
                }
                return res;
            });
            Truth.assertThat((Long)updateCount).isEqualTo((Object)100L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginTxWithOnlyMutations() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.buffer(Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).build(), Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{1L}))));
                return null;
            });
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testTransactionManagerInlinedBeginTx() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager txMgr = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext txn = txMgr.begin();
                while (true) {
                    try {
                        Truth.assertThat((Long)txn.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])).isEqualTo((Object)1L);
                        txMgr.commit();
                    }
                    catch (AbortedException e) {
                        txn = txMgr.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testTransactionManagerInlinedBeginTxAborted() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager txMgr = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext txn = txMgr.begin();
                boolean first = true;
                while (true) {
                    try {
                        Truth.assertThat((Long)txn.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])).isEqualTo((Object)1L);
                        if (first) {
                            mockSpanner.abortAllTransactions();
                            first = false;
                        }
                        txMgr.commit();
                    }
                    catch (AbortedException e) {
                        txn = txMgr.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testTransactionManagerInlinedBeginTxWithOnlyMutations() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager txMgr = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext txn = txMgr.begin();
                while (true) {
                    try {
                        txn.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).build());
                        txMgr.commit();
                    }
                    catch (AbortedException e) {
                        txn = txMgr.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testTransactionManagerInlinedBeginTxWithError() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager txMgr = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext txn = txMgr.begin();
                while (true) {
                    TransactionContext txnToUse = txn;
                    try {
                        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> txnToUse.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]));
                        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
                        Assert.assertEquals((long)1L, (long)txnToUse.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
                        txMgr.commit();
                    }
                    catch (AbortedException e) {
                        txn = txMgr.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testTransactionManagerInlinedBeginTxWithUncaughtError() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager txMgr = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext txn = txMgr.begin();
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> txn.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]));
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginAsyncTxWithParallelQueries() throws InterruptedException, ExecutionException {
            int numQueries = 100;
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(16);
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ApiFuture updateCount = client.runAsync(new Options.TransactionOption[0]).runAsync(txn -> {
                ArrayList<SettableApiFuture> futures = new ArrayList<SettableApiFuture>(100);
                for (int i = 0; i < 100; ++i) {
                    SettableApiFuture res = SettableApiFuture.create();
                    try (AsyncResultSet rs = txn.executeQueryAsync(SELECT1, new Options.QueryOption[0]);){
                        rs.setCallback((Executor)executor, resultSet -> {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    res.set((Object)resultSet.getLong(0));
                                }
                            }
                            throw new IllegalStateException();
                        });
                    }
                    futures.add(res);
                }
                return ApiFutures.transformAsync((ApiFuture)ApiFutures.allAsList(futures), input -> {
                    long sum = 0L;
                    for (Long l : input) {
                        sum += l.longValue();
                    }
                    return ApiFutures.immediateFuture((Object)sum);
                }, (Executor)MoreExecutors.directExecutor());
            }, (Executor)executor);
            Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)100L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void queryWithoutNext() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.executeQuery(SELECT1, new Options.QueryOption[0]);
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }))).isEqualTo((Object)1L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(BeginTransactionRequest.class)).isEqualTo((Object)0L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void queryAsyncWithoutCallback() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.executeQueryAsync(SELECT1, new Options.QueryOption[0]);
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }))).isEqualTo((Object)1L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(BeginTransactionRequest.class)).isEqualTo((Object)0L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void readWithoutNext() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.read("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }))).isEqualTo((Object)1L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(BeginTransactionRequest.class)).isEqualTo((Object)0L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ReadRequest.class)).isEqualTo((Object)0L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void readAsyncWithoutCallback() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.readAsync("FOO", KeySet.all(), Collections.singletonList("ID"), new Options.ReadOption[0]);
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }))).isEqualTo((Object)1L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(BeginTransactionRequest.class)).isEqualTo((Object)0L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ReadRequest.class)).isEqualTo((Object)0L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void query_ThenUpdate_ThenConsumeResultSet() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);
                long updateCount = transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                while (rs.next()) {
                }
                return updateCount;
            }))).isEqualTo((Object)1L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(BeginTransactionRequest.class)).isEqualTo((Object)0L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)2L);
            Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
            List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
            Truth.assertThat((Object)requests.get(0)).isInstanceOf(ExecuteSqlRequest.class);
            Truth.assertThat((String)requests.get(0).getSql()).isEqualTo((Object)UPDATE_STATEMENT.getSql());
            Truth.assertThat((Object)requests.get(1)).isInstanceOf(ExecuteSqlRequest.class);
            Truth.assertThat((String)requests.get(1).getSql()).isEqualTo((Object)SELECT1.getSql());
        }

        @Test
        public void testInlinedBeginTxWithStreamRetry() {
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)((Object)Status.UNAVAILABLE.asRuntimeException()), 1L));
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(SELECT1_UNION_ALL_SELECT2, new Options.QueryOption[0]);){
                    while (rs.next()) {
                    }
                }
                return null;
            });
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)2);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
            List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
            Truth.assertThat((Object)requests.get(0)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest request1 = requests.get(0);
            Truth.assertThat((String)request1.getSql()).isEqualTo((Object)SELECT1_UNION_ALL_SELECT2.getSql());
            Truth.assertThat((Boolean)request1.getTransaction().getBegin().hasReadWrite()).isTrue();
            Truth.assertThat((Iterable)request1.getTransaction().getId()).isEqualTo((Object)ByteString.EMPTY);
            Truth.assertThat((Iterable)request1.getResumeToken()).isEqualTo((Object)ByteString.EMPTY);
            Truth.assertThat((Object)requests.get(1)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest request2 = requests.get(1);
            Truth.assertThat((String)request2.getSql()).isEqualTo((Object)SELECT1_UNION_ALL_SELECT2.getSql());
            Truth.assertThat((Boolean)request2.getTransaction().hasBegin()).isFalse();
            Truth.assertThat((Iterable)request2.getTransaction().getId()).isNotEqualTo((Object)ByteString.EMPTY);
            Truth.assertThat((Iterable)request2.getResumeToken()).isNotEqualTo((Object)ByteString.EMPTY);
        }

        @Test
        public void testWaitForTransactionTimeout() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){
                int attempt = 0;

                public Void run(TransactionContext transaction) {
                    ++this.attempt;
                    TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transaction;
                    if (this.attempt == 1) {
                        impl.waitForTransactionTimeoutMillis = 1L;
                        mockSpanner.freeze();
                    } else {
                        impl.waitForTransactionTimeoutMillis = 60000L;
                    }
                    ApiFuture updateCount = transaction.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                        while (rs.next()) {
                        }
                    }
                    catch (Throwable t) {
                        mockSpanner.unfreeze();
                        SpannerApiFutures.get((ApiFuture)updateCount);
                        throw t;
                    }
                    return null;
                }
            });
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)3);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
        }

        @Test
        public void testWaitForTransactionTimeoutForCommit() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            AtomicBoolean firstAttempt = new AtomicBoolean(true);
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transaction;
                Struct res = transaction.readRow("FOO", Key.of((Object[])new Object[]{1L}), Collections.singletonList("BAR"));
                if (firstAttempt.compareAndSet(true, false)) {
                    impl.waitForTransactionTimeoutMillis = 1L;
                    impl.transactionIdFuture = SettableApiFuture.create();
                    impl.transactionId = null;
                } else {
                    impl.waitForTransactionTimeoutMillis = 60000L;
                }
                return res;
            }));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
            Assert.assertEquals((long)0L, (long)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class));
            Assert.assertEquals((long)1L, (long)InlineBeginTransactionTest.countRequests(ReadRequest.class));
            Assert.assertEquals((long)0L, (long)InlineBeginTransactionTest.countRequests(CommitRequest.class));
        }

        @Test
        public void testQueryWithInlineBeginDidNotReturnTransaction() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.ignoreNextInlineBeginRequest();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(SELECT1_UNION_ALL_SELECT2, new Options.QueryOption[0]);){
                    while (rs.next()) {
                    }
                }
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"The statement did not return a transaction even though one was requested");
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
        }

        @Test
        public void testReadWithInlineBeginDidNotReturnTransaction() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.ignoreNextInlineBeginRequest();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.readRow("FOO", Key.of((Object[])new Object[]{1L}), Collections.singletonList("BAR"))));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"The statement did not return a transaction even though one was requested");
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
        }

        @Test
        public void testUpdateWithInlineBeginDidNotReturnTransaction() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.ignoreNextInlineBeginRequest();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"The statement did not return a transaction even though one was requested");
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
        }

        @Test
        public void testBatchUpdateWithInlineBeginDidNotReturnTransaction() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.ignoreNextInlineBeginRequest();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[0]);
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"The statement did not return a transaction even though one was requested");
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteBatchDmlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
        }

        @Test
        public void testQueryAsyncWithInlineBeginDidNotReturnTransaction() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            ExecutorService executor = Executors.newSingleThreadExecutor();
            mockSpanner.ignoreNextInlineBeginRequest();
            SpannerException outerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                try (AsyncResultSet rs = transaction.executeQueryAsync(SELECT1_UNION_ALL_SELECT2, new Options.QueryOption[0]);){
                    Void void_ = (Void)SpannerApiFutures.get((ApiFuture)rs.setCallback((Executor)executor, resultSet -> {
                        try {
                            while (true) {
                                switch (resultSet.tryNext()) {
                                    case OK: {
                                        break;
                                    }
                                    case DONE: {
                                        return AsyncResultSet.CallbackResponse.DONE;
                                    }
                                    case NOT_READY: {
                                        return AsyncResultSet.CallbackResponse.CONTINUE;
                                    }
                                }
                            }
                        }
                        catch (SpannerException e) {
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                    }));
                    return void_;
                }
            }));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)outerException.getErrorCode());
            Truth.assertThat((String)outerException.getMessage()).contains((CharSequence)"The statement did not return a transaction even though one was requested");
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
        }

        @Test
        public void testUpdateAsyncWithInlineBeginDidNotReturnTransaction() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.ignoreNextInlineBeginRequest();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> (Long)SpannerApiFutures.get((ApiFuture)transaction.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]))));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"The statement did not return a transaction even though one was requested");
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
        }

        @Test
        public void testBatchUpdateAsyncWithInlineBeginDidNotReturnTransaction() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            mockSpanner.ignoreNextInlineBeginRequest();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> (long[])SpannerApiFutures.get((ApiFuture)transaction.batchUpdateAsync(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[0]))));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"The statement did not return a transaction even though one was requested");
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ExecuteBatchDmlRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)0);
        }

        @Test
        public void testInlinedBeginTx_withCancelledOnFirstStatement() {
            final Statement statement = Statement.of((String)"INSERT INTO FOO (Id) VALUES (1)");
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(statement, Status.CANCELLED.withDescription("Read/query was cancelled due to the enclosing transaction being invalidated by a later transaction in the same session.").asRuntimeException()));
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){
                int attempt = 0;

                public Long run(TransactionContext transaction) {
                    if (this.attempt > 0) {
                        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement, 1L));
                    }
                    ++this.attempt;
                    return transaction.executeUpdate(statement, new Options.UpdateOption[0]);
                }
            });
            Assert.assertEquals((long)1L, (long)updateCount);
            Assert.assertEquals((long)1L, (long)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class));
            Assert.assertEquals((long)2L, (long)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class));
            Assert.assertEquals((long)1L, (long)InlineBeginTransactionTest.countRequests(CommitRequest.class));
            Assert.assertEquals((long)2L, (long)InlineBeginTransactionTest.countTransactionsStarted());
        }

        @Test
        public void testInlinedBeginTx_withStickyCancelledOnFirstStatement() {
            Statement statement = Statement.of((String)"INSERT INTO FOO (Id) VALUES (1)");
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(statement, Status.CANCELLED.withDescription("Read/query was cancelled due to the enclosing transaction being invalidated by a later transaction in the same session.").asRuntimeException()));
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(statement, new Options.UpdateOption[0])));
            Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            Assert.assertEquals((long)1L, (long)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class));
            Assert.assertEquals((long)2L, (long)InlineBeginTransactionTest.countRequests(ExecuteSqlRequest.class));
            Assert.assertEquals((long)0L, (long)InlineBeginTransactionTest.countRequests(CommitRequest.class));
            Assert.assertEquals((long)2L, (long)InlineBeginTransactionTest.countTransactionsStarted());
        }

        @Test
        public void testReadRowAborted() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            for (boolean emptyResult : new boolean[]{true, false}) {
                AtomicBoolean firstAttempt = new AtomicBoolean(true);
                Struct row = (Struct)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                    if (firstAttempt.compareAndSet(true, false)) {
                        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(READ_ROW_STATEMENT, mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"tx"))));
                    } else {
                        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(READ_ROW_STATEMENT, emptyResult ? EMPTY_RESULTSET : SELECT1_RESULTSET));
                    }
                    return transaction.readRow("FOO", Key.of((Object[])new Object[]{1L}), Collections.singletonList("BAR"));
                });
                if (emptyResult) {
                    Assert.assertNull((Object)row);
                } else {
                    Assert.assertNotNull((Object)row);
                    Assert.assertEquals((long)1L, (long)row.getLong(0));
                }
                Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
                Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)2);
                Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
                mockSpanner.clearRequests();
            }
        }

        @Test
        public void testReadRowCommitAborted() {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            for (boolean emptyResult : new boolean[]{true, false}) {
                mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(READ_ROW_STATEMENT, emptyResult ? EMPTY_RESULTSET : SELECT1_RESULTSET));
                AtomicBoolean firstAttempt = new AtomicBoolean(true);
                Struct row = (Struct)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                    Struct res = transaction.readRow("FOO", Key.of((Object[])new Object[]{1L}), Collections.singletonList("BAR"));
                    if (firstAttempt.compareAndSet(true, false)) {
                        mockSpanner.abortTransaction(transaction);
                    }
                    return res;
                });
                if (emptyResult) {
                    Assert.assertNull((Object)row);
                } else {
                    Assert.assertNotNull((Object)row);
                    Assert.assertEquals((long)1L, (long)row.getLong(0));
                }
                Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
                Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(ReadRequest.class)).isEqualTo((Object)2);
                Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)2);
                mockSpanner.clearRequests();
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class InlineBeginTransactionWithExecutorTest
    extends InlineBeginTransactionTest {
        @Parameterized.Parameter
        public Executor executor;

        @Parameterized.Parameters(name="executor = {0}")
        public static Collection<Object[]> data() {
            return Arrays.asList({MoreExecutors.directExecutor()}, {Executors.newSingleThreadExecutor()}, {Executors.newFixedThreadPool(4)});
        }

        @Test
        public void testInlinedBeginAsyncTx() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ApiFuture updateCount = client.runAsync(new Options.TransactionOption[0]).runAsync(txn -> txn.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
            Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginAsyncTxAborted() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            AtomicBoolean firstAttempt = new AtomicBoolean(true);
            ApiFuture updateCount = client.runAsync(new Options.TransactionOption[0]).runAsync(txn -> {
                ApiFuture res = txn.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                if (firstAttempt.getAndSet(false)) {
                    mockSpanner.abortTransaction(txn);
                }
                return res;
            }, this.executor);
            Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginAsyncTxWithQuery() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
            ApiFuture updateCount = client.runAsync(new Options.TransactionOption[0]).runAsync(txn -> {
                SettableApiFuture res = SettableApiFuture.create();
                try (AsyncResultSet rs = txn.executeQueryAsync(SELECT1, new Options.QueryOption[0]);){
                    rs.setCallback(this.executor, resultSet -> {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                            case OK: {
                                res.set((Object)resultSet.getLong(0));
                            }
                        }
                        throw new IllegalStateException();
                    });
                }
                return res;
            }, (Executor)queryExecutor);
            Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
            queryExecutor.shutdown();
        }

        @Test
        public void testInlinedBeginAsyncTxWithBatchDml() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ApiFuture updateCounts = client.runAsync(new Options.TransactionOption[0]).runAsync(transaction -> transaction.batchUpdateAsync(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]), this.executor);
            Truth.assertThat((long[])((long[])updateCounts.get())).asList().containsExactly(new Object[]{1L, 1L});
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testInlinedBeginAsyncTxWithError() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ApiFuture updateCount = client.runAsync(new Options.TransactionOption[0]).runAsync(transaction -> {
                transaction.executeUpdateAsync(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
                return transaction.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }, this.executor);
            Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testInlinedBeginAsyncTxWithOnlyMutations() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            client.runAsync(new Options.TransactionOption[0]).runAsync(transaction -> {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).build());
                return ApiFutures.immediateFuture(null);
            }, this.executor).get();
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testAsyncTransactionManagerInlinedBeginTx() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (AsyncTransactionManager txMgr = client.transactionManagerAsync(new Options.TransactionOption[0]);){
                AsyncTransactionManager.TransactionContextFuture txn = txMgr.beginAsync();
                while (true) {
                    AsyncTransactionManager.AsyncTransactionStep updateCount = txn.then((transaction, ignored) -> transaction.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = updateCount.commitAsync();
                    try {
                        Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
                        Truth.assertThat((Comparable)commitTimestamp.get()).isNotNull();
                    }
                    catch (AbortedException e) {
                        txn = txMgr.resetForRetryAsync();
                        continue;
                    }
                    break;
                }
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testAsyncTransactionManagerInlinedBeginTxAborted() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (AsyncTransactionManager txMgr = client.transactionManagerAsync(new Options.TransactionOption[0]);){
                AsyncTransactionManager.TransactionContextFuture txn = txMgr.beginAsync();
                boolean first = true;
                while (true) {
                    try {
                        AsyncTransactionManager.AsyncTransactionStep updateCount = txn.then((transaction, ignored) -> transaction.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
                        if (first) {
                            updateCount.then((ignored1, ignored2) -> {
                                mockSpanner.abortAllTransactions();
                                return ApiFutures.immediateFuture(null);
                            }, MoreExecutors.directExecutor());
                            first = false;
                        }
                        Truth.assertThat((Comparable)updateCount.commitAsync().get()).isNotNull();
                        Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
                    }
                    catch (AbortedException e) {
                        txn = txMgr.resetForRetryAsync();
                        continue;
                    }
                    break;
                }
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)2);
        }

        @Test
        public void testAsyncTransactionManagerInlinedBeginTxWithOnlyMutations() throws InterruptedException, ExecutionException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (AsyncTransactionManager txMgr = client.transactionManagerAsync(new Options.TransactionOption[0]);){
                AsyncTransactionManager.TransactionContextFuture txn = txMgr.beginAsync();
                while (true) {
                    try {
                        txn.then((transaction, ignored) -> {
                            transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).build());
                            return ApiFutures.immediateFuture(null);
                        }, this.executor).commitAsync().get();
                    }
                    catch (AbortedException e) {
                        txn = txMgr.resetForRetryAsync();
                        continue;
                    }
                    break;
                }
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(CommitRequest.class)).isEqualTo((Object)1);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }

        @Test
        public void testAsyncTransactionManagerInlinedBeginTxWithError() throws InterruptedException {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (AsyncTransactionManager txMgr = client.transactionManagerAsync(new Options.TransactionOption[0]);){
                AsyncTransactionManager.TransactionContextFuture txn = txMgr.beginAsync();
                while (true) {
                    try {
                        AsyncTransactionManager.AsyncTransactionStep updateCount = txn.then((transaction, ignored) -> transaction.executeUpdateAsync(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor).then((transaction, ignored) -> transaction.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
                        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)updateCount.commitAsync()));
                        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
                    }
                    catch (AbortedException e) {
                        txn = txMgr.resetForRetryAsync();
                        continue;
                    }
                    break;
                }
            }
            Truth.assertThat((Integer)InlineBeginTransactionTest.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
            Truth.assertThat((Integer)InlineBeginTransactionTest.countTransactionsStarted()).isEqualTo((Object)1);
        }
    }
}

