/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ResultSetsTest {
    @Test
    public void resultSetIteration() {
        double doubleVal = 1.2;
        BigDecimal bigDecimalVal = BigDecimal.valueOf(123L, 2);
        String stringVal = "stringVal";
        String jsonVal = "{\"color\":\"red\",\"value\":\"#f00\"}";
        String byteVal = "101";
        long usecs = 32343L;
        int year = 2018;
        int month = 5;
        int day = 26;
        boolean[] boolArray = new boolean[]{true, false, true, true, false};
        long[] longArray = new long[]{Long.MAX_VALUE, Long.MIN_VALUE, 0L, 1L, -1L};
        double[] doubleArray = new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 0.0, 1.0, -1.0, 1.2341};
        BigDecimal[] bigDecimalArray = new BigDecimal[]{BigDecimal.valueOf(1L, Integer.MAX_VALUE), BigDecimal.valueOf(1L, Integer.MIN_VALUE), BigDecimal.ZERO, BigDecimal.TEN, BigDecimal.valueOf(3141592L, 6)};
        ByteArray[] byteArray = new ByteArray[]{ByteArray.copyFrom((String)"123"), ByteArray.copyFrom((String)"456"), ByteArray.copyFrom((String)"789")};
        Timestamp[] timestampArray = new Timestamp[]{Timestamp.ofTimeMicroseconds((long)101L), Timestamp.ofTimeMicroseconds((long)202L), Timestamp.ofTimeMicroseconds((long)303L)};
        Date[] dateArray = new Date[]{Date.fromYearMonthDay((int)1, (int)2, (int)3), Date.fromYearMonthDay((int)4, (int)5, (int)6), Date.fromYearMonthDay((int)7, (int)8, (int)9)};
        String[] stringArray = new String[]{"abc", "def", "ghi"};
        String[] jsonArray = new String[]{"{}", "{\"color\":\"red\",\"value\":\"#f00\"}", "[]"};
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.int64()), Type.StructField.of((String)"f3", (Type)Type.bool()), Type.StructField.of((String)"doubleVal", (Type)Type.float64()), Type.StructField.of((String)"bigDecimalVal", (Type)Type.numeric()), Type.StructField.of((String)"stringVal", (Type)Type.string()), Type.StructField.of((String)"jsonVal", (Type)Type.json()), Type.StructField.of((String)"pgJsonbVal", (Type)Type.pgJsonb()), Type.StructField.of((String)"byteVal", (Type)Type.bytes()), Type.StructField.of((String)"timestamp", (Type)Type.timestamp()), Type.StructField.of((String)"date", (Type)Type.date()), Type.StructField.of((String)"boolArray", (Type)Type.array((Type)Type.bool())), Type.StructField.of((String)"longArray", (Type)Type.array((Type)Type.int64())), Type.StructField.of((String)"doubleArray", (Type)Type.array((Type)Type.float64())), Type.StructField.of((String)"bigDecimalArray", (Type)Type.array((Type)Type.numeric())), Type.StructField.of((String)"byteArray", (Type)Type.array((Type)Type.bytes())), Type.StructField.of((String)"timestampArray", (Type)Type.array((Type)Type.timestamp())), Type.StructField.of((String)"dateArray", (Type)Type.array((Type)Type.date())), Type.StructField.of((String)"stringArray", (Type)Type.array((Type)Type.string())), Type.StructField.of((String)"jsonArray", (Type)Type.array((Type)Type.json())), Type.StructField.of((String)"pgJsonbArray", (Type)Type.array((Type)Type.pgJsonb()))});
        Struct struct1 = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("x")).set("f2").to(2L)).set("f3").to(Value.bool((boolean)true))).set("doubleVal").to(Value.float64((double)doubleVal))).set("bigDecimalVal").to(Value.numeric((BigDecimal)bigDecimalVal))).set("stringVal").to(stringVal)).set("jsonVal").to(Value.json((String)jsonVal))).set("pgJsonbVal").to(Value.pgJsonb((String)jsonVal))).set("byteVal").to(Value.bytes((ByteArray)ByteArray.copyFrom((String)byteVal)))).set("timestamp").to(Timestamp.ofTimeMicroseconds((long)usecs))).set("date").to(Date.fromYearMonthDay((int)year, (int)month, (int)day))).set("boolArray").to(Value.boolArray((boolean[])boolArray))).set("longArray").to(Value.int64Array((long[])longArray))).set("doubleArray").to(Value.float64Array((double[])doubleArray))).set("bigDecimalArray").to(Value.numericArray(Arrays.asList(bigDecimalArray)))).set("byteArray").to(Value.bytesArray(Arrays.asList(byteArray)))).set("timestampArray").to(Value.timestampArray(Arrays.asList(timestampArray)))).set("dateArray").to(Value.dateArray(Arrays.asList(dateArray)))).set("stringArray").to(Value.stringArray(Arrays.asList(stringArray)))).set("jsonArray").to(Value.jsonArray(Arrays.asList(jsonArray)))).set("pgJsonbArray").to(Value.pgJsonbArray(Arrays.asList(jsonArray)))).build();
        Struct struct2 = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("y")).set("f2").to(3L)).set("f3").to(Value.bool(null))).set("doubleVal").to(Value.float64((double)doubleVal))).set("bigDecimalVal").to(Value.numeric((BigDecimal)bigDecimalVal))).set("stringVal").to(stringVal)).set("jsonVal").to(Value.json((String)jsonVal))).set("pgJsonbVal").to(Value.pgJsonb((String)jsonVal))).set("byteVal").to(Value.bytes((ByteArray)ByteArray.copyFrom((String)byteVal)))).set("timestamp").to(Timestamp.ofTimeMicroseconds((long)usecs))).set("date").to(Date.fromYearMonthDay((int)year, (int)month, (int)day))).set("boolArray").to(Value.boolArray((boolean[])boolArray))).set("longArray").to(Value.int64Array((long[])longArray))).set("doubleArray").to(Value.float64Array((double[])doubleArray))).set("bigDecimalArray").to(Value.numericArray(Arrays.asList(bigDecimalArray)))).set("byteArray").to(Value.bytesArray(Arrays.asList(byteArray)))).set("timestampArray").to(Value.timestampArray(Arrays.asList(timestampArray)))).set("dateArray").to(Value.dateArray(Arrays.asList(dateArray)))).set("stringArray").to(Value.stringArray(Arrays.asList(stringArray)))).set("jsonArray").to(Value.jsonArray(Arrays.asList(jsonArray)))).set("pgJsonbArray").to(Value.pgJsonbArray(Arrays.asList(jsonArray)))).build();
        ResultSet rs = ResultSets.forRows((Type)type, Arrays.asList(struct1, struct2));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((ResultSet)rs).getType());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Must be preceded by a next() call");
        int columnIndex = 0;
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((Object)rs.getType()).isEqualTo((Object)type);
        Truth.assertThat((Integer)rs.getColumnCount()).isEqualTo((Object)type.getStructFields().size());
        Truth.assertThat((Integer)rs.getColumnIndex("f1")).isEqualTo((Object)0);
        Truth.assertThat((Object)rs.getColumnType("nonexistent")).isNull();
        Truth.assertThat((Object)rs.getColumnType("f1")).isEqualTo((Object)Type.string());
        Truth.assertThat((Object)rs.getColumnType(0)).isEqualTo((Object)Type.string());
        Truth.assertThat((Integer)rs.getColumnIndex("f2")).isEqualTo((Object)1);
        Truth.assertThat((Object)rs.getColumnType("f2")).isEqualTo((Object)Type.int64());
        Truth.assertThat((Object)rs.getColumnType(1)).isEqualTo((Object)Type.int64());
        Truth.assertThat((Integer)rs.getColumnIndex("f3")).isEqualTo((Object)2);
        Truth.assertThat((Object)rs.getColumnType("f3")).isEqualTo((Object)Type.bool());
        Truth.assertThat((Object)rs.getColumnType(2)).isEqualTo((Object)Type.bool());
        Truth.assertThat((Object)rs.getCurrentRowAsStruct()).isEqualTo((Object)struct1);
        Truth.assertThat((String)rs.getString(columnIndex)).isEqualTo((Object)"x");
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.string((String)"x"));
        Truth.assertThat((Long)rs.getLong(columnIndex)).isEqualTo((Object)2L);
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.int64((long)2L));
        Truth.assertThat((Boolean)rs.getBoolean(columnIndex)).isTrue();
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.bool((boolean)true));
        Truth.assertThat((Boolean)rs.getBoolean("f3")).isTrue();
        Truth.assertThat((Object)rs.getValue("f3")).isEqualTo((Object)Value.bool((boolean)true));
        Truth.assertThat((Double)rs.getDouble("doubleVal")).isWithin(0.0).of(doubleVal);
        Truth.assertThat((Double)rs.getValue("doubleVal").getFloat64()).isWithin(0.0).of(doubleVal);
        Truth.assertThat((Double)rs.getDouble(columnIndex)).isWithin(0.0).of(doubleVal);
        Truth.assertThat((Double)rs.getValue(columnIndex++).getFloat64()).isWithin(0.0).of(doubleVal);
        Truth.assertThat((BigDecimal)rs.getBigDecimal("bigDecimalVal")).isEqualTo((Object)new BigDecimal("1.23"));
        Truth.assertThat((Object)rs.getValue("bigDecimalVal")).isEqualTo((Object)Value.numeric((BigDecimal)new BigDecimal("1.23")));
        Truth.assertThat((BigDecimal)rs.getBigDecimal(columnIndex)).isEqualTo((Object)new BigDecimal("1.23"));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.numeric((BigDecimal)new BigDecimal("1.23")));
        Truth.assertThat((String)rs.getString(columnIndex)).isEqualTo((Object)stringVal);
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.string((String)stringVal));
        Truth.assertThat((String)rs.getString("stringVal")).isEqualTo((Object)stringVal);
        Truth.assertThat((Object)rs.getValue("stringVal")).isEqualTo((Object)Value.string((String)stringVal));
        Truth.assertThat((String)rs.getJson(columnIndex)).isEqualTo((Object)jsonVal);
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.json((String)jsonVal));
        Truth.assertThat((String)rs.getJson("jsonVal")).isEqualTo((Object)jsonVal);
        Truth.assertThat((Object)rs.getValue("jsonVal")).isEqualTo((Object)Value.json((String)jsonVal));
        Assert.assertEquals((Object)jsonVal, (Object)rs.getPgJsonb(columnIndex));
        Assert.assertEquals((Object)Value.pgJsonb((String)jsonVal), (Object)rs.getValue(columnIndex++));
        Assert.assertEquals((Object)jsonVal, (Object)rs.getPgJsonb("pgJsonbVal"));
        Assert.assertEquals((Object)Value.pgJsonb((String)jsonVal), (Object)rs.getValue("pgJsonbVal"));
        Truth.assertThat((Iterable)rs.getBytes(columnIndex)).isEqualTo((Object)ByteArray.copyFrom((String)byteVal));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.bytes((ByteArray)ByteArray.copyFrom((String)byteVal)));
        Truth.assertThat((Iterable)rs.getBytes("byteVal")).isEqualTo((Object)ByteArray.copyFrom((String)byteVal));
        Truth.assertThat((Object)rs.getValue("byteVal")).isEqualTo((Object)Value.bytes((ByteArray)ByteArray.copyFrom((String)byteVal)));
        Truth.assertThat((Comparable)rs.getTimestamp(columnIndex)).isEqualTo((Object)Timestamp.ofTimeMicroseconds((long)usecs));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.timestamp((Timestamp)Timestamp.ofTimeMicroseconds((long)usecs)));
        Truth.assertThat((Comparable)rs.getTimestamp("timestamp")).isEqualTo((Object)Timestamp.ofTimeMicroseconds((long)usecs));
        Truth.assertThat((Object)rs.getValue("timestamp")).isEqualTo((Object)Value.timestamp((Timestamp)Timestamp.ofTimeMicroseconds((long)usecs)));
        Truth.assertThat((Comparable)rs.getDate(columnIndex)).isEqualTo((Object)Date.fromYearMonthDay((int)year, (int)month, (int)day));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.date((Date)Date.fromYearMonthDay((int)year, (int)month, (int)day)));
        Truth.assertThat((Comparable)rs.getDate("date")).isEqualTo((Object)Date.fromYearMonthDay((int)year, (int)month, (int)day));
        Truth.assertThat((Object)rs.getValue("date")).isEqualTo((Object)Value.date((Date)Date.fromYearMonthDay((int)year, (int)month, (int)day)));
        Truth.assertThat((boolean[])rs.getBooleanArray(columnIndex)).isEqualTo((Object)boolArray);
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.boolArray((boolean[])boolArray));
        Truth.assertThat((boolean[])rs.getBooleanArray("boolArray")).isEqualTo((Object)boolArray);
        Truth.assertThat((Object)rs.getValue("boolArray")).isEqualTo((Object)Value.boolArray((boolean[])boolArray));
        Truth.assertThat((long[])rs.getLongArray(columnIndex)).isEqualTo((Object)longArray);
        Truth.assertThat((Object)rs.getValue(columnIndex)).isEqualTo((Object)Value.int64Array((long[])longArray));
        Truth.assertThat((long[])rs.getLongArray("longArray")).isEqualTo((Object)longArray);
        Truth.assertThat((Object)rs.getValue("longArray")).isEqualTo((Object)Value.int64Array((long[])longArray));
        Truth.assertThat((Iterable)rs.getLongList(columnIndex++)).isEqualTo((Object)Longs.asList((long[])longArray));
        Truth.assertThat((Iterable)rs.getLongList("longArray")).isEqualTo((Object)Longs.asList((long[])longArray));
        Truth.assertThat((double[])rs.getDoubleArray(columnIndex)).usingTolerance(0.0).containsAtLeast(doubleArray);
        Truth.assertThat((Object)rs.getValue(columnIndex)).isEqualTo((Object)Value.float64Array((double[])doubleArray));
        Truth.assertThat((double[])rs.getDoubleArray("doubleArray")).usingTolerance(0.0).containsExactly(doubleArray).inOrder();
        Truth.assertThat((Object)rs.getValue("doubleArray")).isEqualTo((Object)Value.float64Array((double[])doubleArray));
        Truth.assertThat((Iterable)rs.getDoubleList(columnIndex++)).isEqualTo((Object)Doubles.asList((double[])doubleArray));
        Truth.assertThat((Iterable)rs.getDoubleList("doubleArray")).isEqualTo((Object)Doubles.asList((double[])doubleArray));
        Truth.assertThat((Iterable)rs.getBigDecimalList(columnIndex)).isEqualTo(Arrays.asList(bigDecimalArray));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.numericArray(Arrays.asList(bigDecimalArray)));
        Truth.assertThat((Iterable)rs.getBigDecimalList("bigDecimalArray")).isEqualTo(Arrays.asList(bigDecimalArray));
        Truth.assertThat((Object)rs.getValue("bigDecimalArray")).isEqualTo((Object)Value.numericArray(Arrays.asList(bigDecimalArray)));
        Truth.assertThat((Iterable)rs.getBytesList(columnIndex)).isEqualTo(Arrays.asList(byteArray));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.bytesArray(Arrays.asList(byteArray)));
        Truth.assertThat((Iterable)rs.getBytesList("byteArray")).isEqualTo(Arrays.asList(byteArray));
        Truth.assertThat((Object)rs.getValue("byteArray")).isEqualTo((Object)Value.bytesArray(Arrays.asList(byteArray)));
        Truth.assertThat((Iterable)rs.getTimestampList(columnIndex)).isEqualTo(Arrays.asList(timestampArray));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.timestampArray(Arrays.asList(timestampArray)));
        Truth.assertThat((Iterable)rs.getTimestampList("timestampArray")).isEqualTo(Arrays.asList(timestampArray));
        Truth.assertThat((Object)rs.getValue("timestampArray")).isEqualTo((Object)Value.timestampArray(Arrays.asList(timestampArray)));
        Truth.assertThat((Iterable)rs.getDateList(columnIndex)).isEqualTo(Arrays.asList(dateArray));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.dateArray(Arrays.asList(dateArray)));
        Truth.assertThat((Iterable)rs.getDateList("dateArray")).isEqualTo(Arrays.asList(dateArray));
        Truth.assertThat((Object)rs.getValue("dateArray")).isEqualTo((Object)Value.dateArray(Arrays.asList(dateArray)));
        Truth.assertThat((Iterable)rs.getStringList(columnIndex)).isEqualTo(Arrays.asList(stringArray));
        Truth.assertThat((Object)rs.getValue(columnIndex++)).isEqualTo((Object)Value.stringArray(Arrays.asList(stringArray)));
        Truth.assertThat((Iterable)rs.getStringList("stringArray")).isEqualTo(Arrays.asList(stringArray));
        Truth.assertThat((Object)rs.getValue("stringArray")).isEqualTo((Object)Value.stringArray(Arrays.asList(stringArray)));
        Truth.assertThat((Iterable)rs.getJsonList(columnIndex++)).isEqualTo(Arrays.asList(jsonArray));
        Truth.assertThat((Iterable)rs.getJsonList("jsonArray")).isEqualTo(Arrays.asList(jsonArray));
        Assert.assertEquals(Arrays.asList(jsonArray), (Object)rs.getPgJsonbList(columnIndex));
        Assert.assertEquals(Arrays.asList(jsonArray), (Object)rs.getPgJsonbList("pgJsonbArray"));
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((Object)rs.getCurrentRowAsStruct()).isEqualTo((Object)struct2);
        Truth.assertThat((String)rs.getString(0)).isEqualTo((Object)"y");
        Truth.assertThat((Long)rs.getLong(1)).isEqualTo((Object)3L);
        Truth.assertThat((Boolean)rs.isNull(2)).isTrue();
        Truth.assertThat((Boolean)rs.next()).isFalse();
        UnsupportedOperationException unsupported = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> ((ResultSet)rs).getStats());
        Truth.assertThat((String)unsupported.getMessage()).contains((CharSequence)"ResultSetStats are available only for results returned from analyzeQuery");
    }

    @Test
    public void resultSetIterationWithStructColumns() {
        Type nestedStructType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"g1", (Type)Type.string())});
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)nestedStructType), Type.StructField.of((String)"f2", (Type)Type.int64())});
        Struct value1 = ((Struct.Builder)Struct.newBuilder().set("g1").to("abc")).build();
        Struct struct1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(value1)).set("f2").to((Long)null)).build();
        UnsupportedOperationException e = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> ResultSets.forRows((Type)type, Collections.singletonList(struct1)));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"STRUCT-typed columns are not supported inside ResultSets.");
    }

    @Test
    public void resultSetIterationWithArrayStructColumns() {
        Type nestedStructType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"g1", (Type)Type.string())});
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.array((Type)nestedStructType)), Type.StructField.of((String)"f2", (Type)Type.int64())});
        Struct value1 = ((Struct.Builder)Struct.newBuilder().set("g1").to("abc")).build();
        List<Struct> arrayValue = Arrays.asList(value1, null);
        Struct struct1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").toStructArray(nestedStructType, arrayValue)).set("f2").to((Long)null)).build();
        Struct struct2 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").toStructArray(nestedStructType, null)).set("f2").to(20L)).build();
        ResultSet rs = ResultSets.forRows((Type)type, Arrays.asList(struct1, struct2));
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((Object)rs.getType()).isEqualTo((Object)type);
        Truth.assertThat((Integer)rs.getColumnCount()).isEqualTo((Object)2);
        Truth.assertThat((Integer)rs.getColumnIndex("f1")).isEqualTo((Object)0);
        Truth.assertThat((Object)rs.getColumnType("f1")).isEqualTo((Object)Type.array((Type)nestedStructType));
        Truth.assertThat((Object)rs.getColumnType(0)).isEqualTo((Object)Type.array((Type)nestedStructType));
        Truth.assertThat((Integer)rs.getColumnIndex("f2")).isEqualTo((Object)1);
        Truth.assertThat((Object)rs.getColumnType("f2")).isEqualTo((Object)Type.int64());
        Truth.assertThat((Object)rs.getColumnType(1)).isEqualTo((Object)Type.int64());
        Truth.assertThat((Object)rs.getCurrentRowAsStruct()).isEqualTo((Object)struct1);
        Truth.assertThat((Iterable)rs.getStructList(0)).isEqualTo(arrayValue);
        Truth.assertThat((Object)rs.getValue(0)).isEqualTo((Object)Value.structArray((Type)nestedStructType, arrayValue));
        Truth.assertThat((Iterable)rs.getStructList("f1")).isEqualTo(arrayValue);
        Truth.assertThat((Object)rs.getValue("f1")).isEqualTo((Object)Value.structArray((Type)nestedStructType, arrayValue));
        Truth.assertThat((Boolean)rs.isNull(1)).isTrue();
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((Object)rs.getCurrentRowAsStruct()).isEqualTo((Object)struct2);
        Truth.assertThat((Boolean)rs.isNull(0)).isTrue();
        Truth.assertThat((Boolean)rs.isNull("f1")).isTrue();
        Truth.assertThat((Long)rs.getLong(1)).isEqualTo((Object)20);
        Truth.assertThat((Object)rs.getValue(1)).isEqualTo((Object)Value.int64((long)20L));
        Truth.assertThat((Long)rs.getLong("f2")).isEqualTo((Object)20);
        Truth.assertThat((Object)rs.getValue("f2")).isEqualTo((Object)Value.int64((long)20L));
        Truth.assertThat((Boolean)rs.next()).isFalse();
    }

    @Test
    public void closeResultSet() {
        ResultSet rs = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string())}), Collections.singletonList(((Struct.Builder)Struct.newBuilder().set("f1").to("x")).build()));
        rs.close();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> rs.getCurrentRowAsStruct());
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void exceptionIfNextIsNotCalled() {
        ResultSet rs = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string())}), Collections.singletonList(((Struct.Builder)Struct.newBuilder().set("f1").to("x")).build()));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> rs.getCurrentRowAsStruct());
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void testToAsyncResultSet() {
        ResultSet delegate = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string())}), Collections.singletonList(((Struct.Builder)Struct.newBuilder().set("f1").to("x")).build()));
        AtomicInteger count = new AtomicInteger();
        AsyncResultSet rs = ResultSets.toAsyncResultSet((ResultSet)delegate);
        ApiFuture fut = rs.setCallback(MoreExecutors.directExecutor(), resultSet -> {
            while (true) {
                switch (resultSet.tryNext()) {
                    case DONE: {
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                    case NOT_READY: {
                        return AsyncResultSet.CallbackResponse.CONTINUE;
                    }
                    case OK: {
                        count.incrementAndGet();
                        Truth.assertThat((String)resultSet.getString("f1")).isEqualTo((Object)"x");
                    }
                }
            }
        });
        SpannerApiFutures.get((ApiFuture)fut);
        Truth.assertThat((Integer)count.get()).isEqualTo((Object)1);
    }

    @Test
    public void testToAsyncResultSetWithExecProvider() {
        ResultSet delegate = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string())}), Collections.singletonList(((Struct.Builder)Struct.newBuilder().set("f1").to("x")).build()));
        ExecutorProvider provider = new ExecutorProvider(){
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

            public boolean shouldAutoClose() {
                return true;
            }

            public ScheduledExecutorService getExecutor() {
                return this.executor;
            }
        };
        AtomicInteger count = new AtomicInteger();
        AsyncResultSet rs = ResultSets.toAsyncResultSet((ResultSet)delegate, (ExecutorProvider)provider, (Options.QueryOption[])new Options.QueryOption[0]);
        ApiFuture fut = rs.setCallback(MoreExecutors.directExecutor(), resultSet -> {
            while (true) {
                switch (resultSet.tryNext()) {
                    case DONE: {
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                    case NOT_READY: {
                        return AsyncResultSet.CallbackResponse.CONTINUE;
                    }
                    case OK: {
                        count.incrementAndGet();
                        Truth.assertThat((String)resultSet.getString("f1")).isEqualTo((Object)"x");
                    }
                }
            }
        });
        SpannerApiFutures.get((ApiFuture)fut);
        Truth.assertThat((Integer)count.get()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)provider.getExecutor().isShutdown()).isTrue();
    }

    @Test
    public void testToAsyncResultSetWithFuture() {
        ApiFuture delegateFuture = ApiFutures.immediateFuture((Object)ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string())}), Collections.singletonList(((Struct.Builder)Struct.newBuilder().set("f1").to("x")).build())));
        ExecutorProvider provider = new ExecutorProvider(){
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

            public boolean shouldAutoClose() {
                return false;
            }

            public ScheduledExecutorService getExecutor() {
                return this.executor;
            }
        };
        AtomicInteger count = new AtomicInteger();
        AsyncResultSet rs = ResultSets.toAsyncResultSet((ApiFuture)delegateFuture, (ExecutorProvider)provider, (Options.QueryOption[])new Options.QueryOption[0]);
        ApiFuture fut = rs.setCallback(MoreExecutors.directExecutor(), resultSet -> {
            while (true) {
                switch (resultSet.tryNext()) {
                    case DONE: {
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                    case NOT_READY: {
                        return AsyncResultSet.CallbackResponse.CONTINUE;
                    }
                    case OK: {
                        count.incrementAndGet();
                        Truth.assertThat((String)resultSet.getString("f1")).isEqualTo((Object)"x");
                    }
                }
            }
        });
        SpannerApiFutures.get((ApiFuture)fut);
        Truth.assertThat((Integer)count.get()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)provider.getExecutor().isShutdown()).isFalse();
        provider.getExecutor().shutdown();
    }
}

