/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.admin.database.v1.MockDatabaseAdminImpl;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdminImpl;
import com.google.common.base.Stopwatch;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerThreadsTest {
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static MockSpannerServiceImpl mockSpanner;
    private static MockInstanceAdminImpl mockInstanceAdmin;
    private static MockDatabaseAdminImpl mockDatabaseAdmin;
    private static Server server;
    private static InetSocketAddress address;
    private static final int NUMBER_OF_TEST_RUNS = 2;
    private static final int NUM_THREADS_PER_CHANNEL = 4;
    private static final String THREAD_PATTERN = "%s-[0-9]+";

    @BeforeClass
    public static void startServer() throws IOException {
        Assume.assumeTrue((String)"Skip tests when emulator is enabled as this test interferes with the check whether the emulator is running", (System.getenv("SPANNER_EMULATOR_HOST") == null ? 1 : 0) != 0);
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockInstanceAdmin = new MockInstanceAdminImpl();
        mockDatabaseAdmin = new MockDatabaseAdminImpl();
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).addService((BindableService)mockInstanceAdmin)).addService((BindableService)mockDatabaseAdmin)).build().start();
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        if (server != null) {
            server.shutdown();
            server.awaitTermination();
        }
    }

    @After
    public void reset() {
        mockSpanner.reset();
    }

    private static String generateRandomThreadNameFormat() {
        return UUID.randomUUID() + "-%d";
    }

    @Test
    public void testCloseAllThreadsWhenClosingSpanner() throws InterruptedException {
        String threadName = SpannerThreadsTest.generateRandomThreadNameFormat();
        int initialNumberOfThreads = this.getNumberOfThreadsWithName(threadName, false, 0);
        Assert.assertEquals((long)0L, (long)initialNumberOfThreads);
        for (int i = 0; i < 2; ++i) {
            int i2;
            SpannerOptions options = SpannerThreadsTest.createSpannerOptions(threadName);
            Spanner spanner = (Spanner)options.getService();
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
            for (int i22 = 0; i22 < options.getSessionPoolOptions().getMaxSessions(); ++i22) {
                ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                rs.next();
                resultSets.add(rs);
                if (this.getNumberOfThreadsWithName(threadName, false, initialNumberOfThreads) == options.getNumChannels() * 4 + initialNumberOfThreads) break;
            }
            for (ResultSet rs : resultSets) {
                rs.close();
            }
            for (i2 = 0; i2 < options.getNumChannels() * 2; ++i2) {
                this.mockGetInstanceResponse();
                InstanceAdminClient instanceAdminClient = spanner.getInstanceAdminClient();
                instanceAdminClient.getInstance("projects/[PROJECT]/instances/[INSTANCE]");
            }
            for (i2 = 0; i2 < options.getNumChannels() * 2; ++i2) {
                this.mockGetDatabaseResponse();
                DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
                databaseAdminClient.getDatabase("projects/[PROJECT]/instances/[INSTANCE]", "[DATABASE]");
            }
            spanner.close();
            Stopwatch watch = Stopwatch.createStarted();
            while (this.getNumberOfThreadsWithName(threadName, false, initialNumberOfThreads) > initialNumberOfThreads && watch.elapsed(TimeUnit.SECONDS) < 2L) {
                Thread.sleep(10L);
            }
            MatcherAssert.assertThat((Object)this.getNumberOfThreadsWithName(threadName, true, initialNumberOfThreads), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)initialNumberOfThreads)));
        }
    }

    @Test
    public void testMultipleOpenSpanners() throws InterruptedException {
        String threadName = SpannerThreadsTest.generateRandomThreadNameFormat();
        ArrayList<Spanner> spanners = new ArrayList<Spanner>();
        int initialNumberOfThreads = this.getNumberOfThreadsWithName(threadName, false, 0);
        Assert.assertEquals((long)0L, (long)initialNumberOfThreads);
        for (int openSpanners = 1; openSpanners <= 3; ++openSpanners) {
            SpannerOptions options = SpannerThreadsTest.createSpannerOptions(threadName);
            Spanner spanner = (Spanner)options.getService();
            spanners.add(spanner);
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
            for (int sessionCount = 0; sessionCount < options.getSessionPoolOptions().getMaxSessions() && this.getNumberOfThreadsWithName(threadName, false, initialNumberOfThreads) < options.getNumChannels() * 4 * openSpanners + initialNumberOfThreads; ++sessionCount) {
                ResultSet resultSet = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                resultSet.next();
                resultSets.add(resultSet);
            }
            for (ResultSet resultSet : resultSets) {
                resultSet.close();
            }
        }
        for (Spanner spanner : spanners) {
            spanner.close();
        }
        Stopwatch watch = Stopwatch.createStarted();
        while (this.getNumberOfThreadsWithName(threadName, false, initialNumberOfThreads) > initialNumberOfThreads && watch.elapsed(TimeUnit.SECONDS) < 5L) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)initialNumberOfThreads, (long)this.getNumberOfThreadsWithName(threadName, true, initialNumberOfThreads));
    }

    private static SpannerOptions createSpannerOptions(String threadNameFormat) {
        String endpoint = address.getHostString() + ":" + server.getPort();
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator(input -> {
            input.usePlaintext();
            return input;
        }).setHost("http://" + endpoint).setCredentials((Credentials)NoCredentials.getInstance())).setTransportChannelExecutorThreadNameFormat(threadNameFormat).build();
    }

    private int getNumberOfThreadsWithName(String serviceName, boolean dumpStack, int expected) {
        Pattern pattern = Pattern.compile(String.format(THREAD_PATTERN, serviceName));
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        Thread[] threads = new Thread[200];
        int numberOfThreads = group.enumerate(threads);
        int res = 0;
        ArrayList<Thread> found = new ArrayList<Thread>();
        for (int i = 0; i < numberOfThreads; ++i) {
            if (!pattern.matcher(threads[i].getName()).matches()) continue;
            if (dumpStack) {
                found.add(threads[i]);
            }
            ++res;
        }
        if (dumpStack && res > expected) {
            found.stream().forEach(t -> this.dumpThread((Thread)t));
        }
        return res;
    }

    private void dumpThread(Thread thread) {
        StackTraceElement[] stackTraceElements;
        StringBuilder dump = new StringBuilder();
        dump.append('\"');
        dump.append(thread.getName());
        dump.append("\" ");
        Thread.State state = thread.getState();
        dump.append("\n   java.lang.Thread.State: ");
        dump.append((Object)state);
        for (StackTraceElement stackTraceElement : stackTraceElements = thread.getStackTrace()) {
            dump.append("\n        at ");
            dump.append(stackTraceElement);
        }
        dump.append("\n\n");
        System.out.print(dump.toString());
    }

    private void mockGetInstanceResponse() {
        InstanceName name2 = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceConfigName config = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        String displayName = "displayName1615086568";
        int nodeCount = 1539922066;
        Instance expectedResponse = Instance.newBuilder().setName(name2.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(nodeCount).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
    }

    private void mockGetDatabaseResponse() {
        DatabaseName name2 = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Database expectedResponse = Database.newBuilder().setName(name2.toString()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
    }
}

