/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DdlTest
extends AbstractMockServerTest {
    @After
    public void reset() {
        mockDatabaseAdmin.reset();
    }

    @Override
    protected String getBaseUrl() {
        return String.format("cloudspanner://localhost:%d/projects/proj/instances/inst/databases/db?usePlainText=true", this.getPort());
    }

    private void addUpdateDdlResponse() {
        mockDatabaseAdmin.addResponse((AbstractMessage)Operation.newBuilder().setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.newBuilder().setDatabase("projects/proj/instances/inst/databases/db").build())).setName("projects/proj/instances/inst/databases/db/operations/1").setDone(true).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build());
    }

    @Test
    public void testSingleAnalyzeStatement() {
        this.addUpdateDdlResponse();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            StatementResult result = connection.execute(Statement.of((String)"analyze"));
            Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)result.getResultType());
        }
        List requests = mockDatabaseAdmin.getRequests().stream().filter(request -> request instanceof UpdateDatabaseDdlRequest).map(request -> (UpdateDatabaseDdlRequest)request).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((long)1L, (long)((UpdateDatabaseDdlRequest)requests.get(0)).getStatementsCount());
        Assert.assertEquals((Object)"analyze", (Object)((UpdateDatabaseDdlRequest)requests.get(0)).getStatements(0));
    }

    @Test
    public void testBatchedAnalyzeStatement() {
        this.addUpdateDdlResponse();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDdl();
            Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)connection.execute(Statement.of((String)"create table foo (id int64) primary key (id)")).getResultType());
            Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)connection.execute(Statement.of((String)"analyze")).getResultType());
            connection.runBatch();
        }
        List requests = mockDatabaseAdmin.getRequests().stream().filter(request -> request instanceof UpdateDatabaseDdlRequest).map(request -> (UpdateDatabaseDdlRequest)request).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((long)2L, (long)((UpdateDatabaseDdlRequest)requests.get(0)).getStatementsCount());
        Assert.assertEquals((Object)"create table foo (id int64) primary key (id)", (Object)((UpdateDatabaseDdlRequest)requests.get(0)).getStatements(0));
        Assert.assertEquals((Object)"analyze", (Object)((UpdateDatabaseDdlRequest)requests.get(0)).getStatements(1));
    }
}

