/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDatabaseRolePermissionTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseAdminClient dbAdminClient;
    private static RemoteSpannerHelper testHelper;
    private static List<DatabaseId> databasesToDrop;

    @BeforeClass
    public static void setUp() {
        Assume.assumeFalse((String)"Emulator does not support database roles", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        testHelper = env.getTestHelper();
        dbAdminClient = testHelper.getClient().getDatabaseAdminClient();
        databasesToDrop = new ArrayList<DatabaseId>();
    }

    @AfterClass
    public static void cleanup() throws Exception {
        if (databasesToDrop != null) {
            for (DatabaseId id : databasesToDrop) {
                try {
                    dbAdminClient.dropDatabase(id.getInstanceId().getInstance(), id.getDatabase());
                }
                catch (Exception e) {
                    System.err.println("Failed to drop database " + id + ", skipping...: " + e.getMessage());
                }
            }
        }
    }

    @Test
    public void grantAndRevokeDatabaseRolePermissions() throws Exception {
        String dbRoleParent = "parent";
        String databaseId = testHelper.getUniqueDatabaseId();
        String instanceId = testHelper.getInstanceId().getInstance();
        String createTableT = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        String createRoleParent = String.format("CREATE ROLE %s", "parent");
        String grantSelectOnTableToParent = String.format("GRANT SELECT ON TABLE T TO ROLE %s", "parent");
        Database createdDatabase = (Database)dbAdminClient.createDatabase(instanceId, databaseId, (Iterable)ImmutableList.of((Object)"CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)", (Object)createRoleParent, (Object)grantSelectOnTableToParent)).get(5L, TimeUnit.MINUTES);
        SpannerOptions options = testHelper.getOptions().toBuilder().setDatabaseRole("parent").build();
        Spanner spanner = (Spanner)options.getService();
        DatabaseClient dbClient = spanner.getDatabaseClient(createdDatabase.getId());
        try (ResultSet rs = dbClient.singleUse().executeQuery(Statement.of((String)"SELECT COUNT(*) as cnt FROM T"), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)dbClient.getDatabaseRole(), (Object)"parent");
        }
        catch (PermissionDeniedException e) {
            Assert.fail((String)"Got PermissionDeniedException when it should not have occurred.");
        }
        String revokeSelectOnTableFromParent = String.format("REVOKE SELECT ON TABLE T FROM ROLE %s", "parent");
        dbAdminClient.updateDatabaseDdl(instanceId, databaseId, Arrays.asList(revokeSelectOnTableFromParent), null).get(5L, TimeUnit.MINUTES);
        try (ResultSet rs = dbClient.singleUse().executeQuery(Statement.of((String)"SELECT COUNT(*) as cnt FROM T"), new Options.QueryOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.PERMISSION_DENIED);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"parent");
        }
        String dropTableT = "DROP TABLE T";
        String dropRoleParent = String.format("DROP ROLE %s", "parent");
        dbAdminClient.updateDatabaseDdl(instanceId, databaseId, Arrays.asList("DROP TABLE T", dropRoleParent), null).get(5L, TimeUnit.MINUTES);
        databasesToDrop.add(createdDatabase.getId());
    }

    @Test
    public void roleWithNoPermissions() throws Exception {
        String dbRoleOrphan = testHelper.getUniqueDatabaseRole();
        String databaseId = testHelper.getUniqueDatabaseId();
        String instanceId = testHelper.getInstanceId().getInstance();
        String createTableT = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        String createRoleOrphan = String.format("CREATE ROLE %s", dbRoleOrphan);
        Database createdDatabase = (Database)dbAdminClient.createDatabase(instanceId, databaseId, (Iterable)ImmutableList.of((Object)"CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)", (Object)createRoleOrphan)).get(5L, TimeUnit.MINUTES);
        SpannerOptions options = testHelper.getOptions().toBuilder().setDatabaseRole(dbRoleOrphan).build();
        Spanner spanner = (Spanner)options.getService();
        DatabaseClient dbClient = spanner.getDatabaseClient(createdDatabase.getId());
        try (ResultSet rs = dbClient.singleUse().executeQuery(Statement.of((String)"SELECT COUNT(*) as cnt FROM T"), new Options.QueryOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.PERMISSION_DENIED);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)dbRoleOrphan);
        }
        String dropTableT = "DROP TABLE T";
        String dropRoleParent = String.format("DROP ROLE %s", dbRoleOrphan);
        dbAdminClient.updateDatabaseDdl(instanceId, databaseId, Arrays.asList("DROP TABLE T", dropRoleParent), null).get(5L, TimeUnit.MINUTES);
        databasesToDrop.add(createdDatabase.getId());
    }
}

