/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITPitrCreateDatabaseTest {
    private static final Duration OPERATION_TIMEOUT = Duration.ofMinutes((long)2L);
    private static final String VERSION_RETENTION_PERIOD = "7d";
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private RemoteSpannerHelper testHelper;
    private DatabaseAdminClient dbAdminClient;
    private List<Database> databasesToDrop;

    @BeforeClass
    public static void doNotRunOnEmulator() {
        Assume.assumeFalse((String)"PITR-lite features are not supported by the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
    }

    @Before
    public void setUp() {
        this.testHelper = env.getTestHelper();
        this.dbAdminClient = this.testHelper.getClient().getDatabaseAdminClient();
        this.databasesToDrop = new ArrayList<Database>();
    }

    @After
    public void tearDown() {
        for (Database database : this.databasesToDrop) {
            DatabaseId id = database.getId();
            this.dbAdminClient.dropDatabase(id.getInstanceId().getInstance(), id.getDatabase());
        }
    }

    @Test
    public void returnsTheVersionRetentionPeriodSetThroughCreateDatabase() throws Exception {
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String databaseId = this.testHelper.getUniqueDatabaseId();
        String extraStatement = "ALTER DATABASE " + databaseId + " SET OPTIONS (version_retention_period = '" + VERSION_RETENTION_PERIOD + "')";
        Database database = this.createDatabase(instanceId, databaseId, extraStatement);
        Truth.assertThat((String)database.getVersionRetentionPeriod()).isEqualTo((Object)VERSION_RETENTION_PERIOD);
        Truth.assertThat((Comparable)database.getEarliestVersionTime()).isNotNull();
    }

    @Test
    public void returnsTheVersionRetentionPeriodSetThroughGetDatabase() throws Exception {
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String databaseId = this.testHelper.getUniqueDatabaseId();
        String extraStatement = "ALTER DATABASE " + databaseId + " SET OPTIONS (version_retention_period = '" + VERSION_RETENTION_PERIOD + "')";
        this.createDatabase(instanceId, databaseId, extraStatement);
        Database database = this.dbAdminClient.getDatabase(instanceId, databaseId);
        Truth.assertThat((String)database.getVersionRetentionPeriod()).isEqualTo((Object)VERSION_RETENTION_PERIOD);
        Truth.assertThat((Comparable)database.getEarliestVersionTime()).isNotNull();
    }

    @Test(expected=DatabaseNotFoundException.class)
    public void returnsAnErrorWhenAnInvalidVersionRetentionPeriodIsGiven() {
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String databaseId = this.testHelper.getUniqueDatabaseId();
        String extraStatement = "ALTER DATABASE " + databaseId + " SET OPTIONS (version_retention_period = '0d')";
        try {
            this.createDatabase(instanceId, databaseId, extraStatement);
            Assert.fail((String)"Expected invalid argument error when setting invalid version retention period");
        }
        catch (Exception e) {
            SpannerException spannerException = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)spannerException.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
        this.dbAdminClient.getDatabase(instanceId, databaseId);
    }

    private Database createDatabase(String instanceId, String databaseId, String extraStatement) throws Exception {
        Database database = (Database)this.dbAdminClient.createDatabase(instanceId, databaseId, Collections.singletonList(extraStatement)).get(OPERATION_TIMEOUT.toNanos(), TimeUnit.NANOSECONDS);
        this.databasesToDrop.add(database);
        return database;
    }
}

