/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITTransactionManagerTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseClient client;
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    @Parameterized.Parameter
    public DialectTestParameter dialect;

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        }
        return params;
    }

    @BeforeClass
    public static void setUpDatabase() throws ExecutionException, InterruptedException, TimeoutException {
        Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T (  K                   STRING(MAX) NOT NULL,  BoolValue           BOOL,) PRIMARY KEY (K)"});
        googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Collections.singletonList("CREATE TABLE T (  K        VARCHAR PRIMARY KEY,  BoolValue BOOL)"));
            postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
        }
    }

    @Before
    public void before() {
        client = this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? googleStandardSQLClient : postgreSQLClient;
        client.write((Iterable)ImmutableList.of((Object)Mutation.delete((String)"T", (KeySet)KeySet.all())));
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    @Test
    public void simpleInsert() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.STARTED);
                txn.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key1")).set("BoolValue").to(true)).build());
                try {
                    manager.commit();
                    Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.COMMITTED);
                    Struct row = client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key1"}), Arrays.asList("K", "BoolValue"));
                    Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"Key1");
                    Truth.assertThat((Boolean)row.getBoolean(1)).isTrue();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void invalidInsert() throws InterruptedException {
        TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);
        try {
            TransactionContext txn = manager.begin();
            while (true) {
                txn.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"InvalidTable").set("K").to("Key1")).set("BoolValue").to(true)).build());
                try {
                    manager.commit();
                    Assert.fail((String)"Expected exception");
                    continue;
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.COMMIT_FAILED);
                    try {
                        manager.resetForRetry();
                        Assert.fail((String)"Expected exception");
                    }
                    catch (IllegalStateException ex) {
                        Assert.assertNotNull((Object)ex.getMessage());
                    }
                    if (manager != null) {
                        manager.close();
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (manager != null) {
                try {
                    manager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Test
    public void rollback() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                txn.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key2")).set("BoolValue").to(true)).build());
                try {
                    manager.rollback();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.ROLLED_BACK);
            Truth.assertThat((Object)client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key2"}), Arrays.asList("K", "BoolValue"))).isNull();
        }
    }

    @Test
    public void abortAndRetry() throws InterruptedException {
        Assume.assumeFalse((String)"Emulator does not support more than 1 simultaneous transaction. This test would therefore loop indefinitely on the emulator.", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        client.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(true)).build()));
        try (TransactionManager manager1 = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn2;
            TransactionManager manager2;
            TransactionContext txn1 = manager1.begin();
            while (true) {
                try {
                    txn1.readRow("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue"));
                    manager2 = client.transactionManager(new Options.TransactionOption[0]);
                    txn2 = manager2.begin();
                    txn2.readRow("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue"));
                    txn1.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(false)).build());
                    manager1.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    if (manager1.getState() != TransactionManager.TransactionState.ABORTED) continue;
                    txn1 = manager1.resetForRetry();
                    continue;
                }
                break;
            }
            try {
                manager2.commit();
                Assert.fail((String)"Expected to abort");
            }
            catch (AbortedException e) {
                Truth.assertThat((Comparable)manager2.getState()).isEqualTo((Object)TransactionManager.TransactionState.ABORTED);
                txn2 = manager2.resetForRetry();
            }
            txn2.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(true)).build());
            manager2.commit();
            Struct row = client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue"));
            Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"Key3");
            Truth.assertThat((Boolean)row.getBoolean(1)).isTrue();
            manager2.close();
        }
    }

    @Test
    public void testTransactionManagerReturnsCommitStats() throws InterruptedException {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.commitStats()});){
            TransactionContext transaction = manager.begin();
            while (true) {
                transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("KeyCommitStats")).set("BoolValue").to(true)).build());
                try {
                    manager.commit();
                    Assert.assertNotNull((Object)manager.getCommitResponse().getCommitStats());
                    Assert.assertEquals((long)2L, (long)manager.getCommitResponse().getCommitStats().getMutationCount());
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }
}

