/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import io.grpc.Context;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITWriteTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    @Parameterized.Parameter
    public DialectTestParameter dialect;
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    private static final String GOOGLE_STANDARD_SQL_SCHEMA_WITH_NUMERIC_AND_JSON = "CREATE TABLE T (  K                   STRING(MAX) NOT NULL,  BoolValue           BOOL,  Int64Value          INT64,  Float64Value        FLOAT64,  StringValue         STRING(MAX),  JsonValue           JSON,  BytesValue          BYTES(MAX),  TimestampValue      TIMESTAMP OPTIONS (allow_commit_timestamp = true),  DateValue           DATE,  NumericValue        NUMERIC,  BoolArrayValue      ARRAY<BOOL>,  Int64ArrayValue     ARRAY<INT64>,  Float64ArrayValue   ARRAY<FLOAT64>,  StringArrayValue    ARRAY<STRING(MAX)>,  JsonArrayValue      ARRAY<JSON>,  BytesArrayValue     ARRAY<BYTES(MAX)>,  TimestampArrayValue ARRAY<TIMESTAMP>,  DateArrayValue      ARRAY<DATE>,  NumericArrayValue   ARRAY<NUMERIC>,) PRIMARY KEY (K)";
    private static final String POSTGRESQL_SCHEMA_WITH_NUMERIC = "CREATE TABLE T (  K                   VARCHAR PRIMARY KEY,  BoolValue           BOOL,  Int64Value          BIGINT,  Float64Value        DOUBLE PRECISION,  StringValue         VARCHAR,  BytesValue          BYTEA,  TimestampValue      TIMESTAMPTZ,  DateValue           DATE,  NumericValue        NUMERIC,  BoolArrayValue      BOOL[],  Int64ArrayValue     BIGINT[],  Float64ArrayValue   DOUBLE PRECISION[],  StringArrayValue    VARCHAR[],  BytesArrayValue     BYTEA[],  TimestampArrayValue TIMESTAMPTZ[],  DateArrayValue      DATE[],  NumericArrayValue   NUMERIC[])";
    private static final String GOOGLE_STANDARD_SQL_SCHEMA_WITHOUT_NUMERIC_AND_JSON = "CREATE TABLE T (  K                   STRING(MAX) NOT NULL,  BoolValue           BOOL,  Int64Value          INT64,  Float64Value        FLOAT64,  StringValue         STRING(MAX),  BytesValue          BYTES(MAX),  TimestampValue      TIMESTAMP OPTIONS (allow_commit_timestamp = true),  DateValue           DATE,  BoolArrayValue      ARRAY<BOOL>,  Int64ArrayValue     ARRAY<INT64>,  Float64ArrayValue   ARRAY<FLOAT64>,  StringArrayValue    ARRAY<STRING(MAX)>,  BytesArrayValue     ARRAY<BYTES(MAX)>,  TimestampArrayValue ARRAY<TIMESTAMP>,  DateArrayValue      ARRAY<DATE>,) PRIMARY KEY (K)";
    private static int seq;
    private static DatabaseClient client;
    private String lastKey;

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        }
        return params;
    }

    @BeforeClass
    public static void setUpDatabase() throws ExecutionException, InterruptedException, TimeoutException {
        if (EmulatorSpannerHelper.isUsingEmulator()) {
            Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(new String[]{GOOGLE_STANDARD_SQL_SCHEMA_WITHOUT_NUMERIC_AND_JSON});
            googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
        } else {
            Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(new String[]{GOOGLE_STANDARD_SQL_SCHEMA_WITH_NUMERIC_AND_JSON});
            googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
            Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Collections.singletonList(POSTGRESQL_SCHEMA_WITH_NUMERIC));
            postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
        }
    }

    @Before
    public void before() {
        client = this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? googleStandardSQLClient : postgreSQLClient;
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    private static String uniqueString() {
        return String.format("k%04d", seq++);
    }

    private Timestamp write(Mutation m) {
        return client.write(Collections.singletonList(m));
    }

    private Mutation.WriteBuilder baseInsert() {
        this.lastKey = ITWriteTest.uniqueString();
        return (Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(this.lastKey);
    }

    private Struct readLastRow(String ... columns) {
        return client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{this.lastKey}), Arrays.asList(columns));
    }

    @Test
    public void writeAtLeastOnce() {
        this.lastKey = ITWriteTest.uniqueString();
        client.writeAtLeastOnce(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(this.lastKey)).set("StringValue").to("v1")).build()));
        Struct row = this.readLastRow("StringValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"v1");
    }

    @Test
    public void testWriteReturnsCommitStats() {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.lastKey = ITWriteTest.uniqueString();
        CommitResponse response = client.writeWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(this.lastKey)).set("StringValue").to("v1")).build()), new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCommitTimestamp());
        Assert.assertNotNull((Object)response.getCommitStats());
        Assert.assertEquals((long)2L, (long)response.getCommitStats().getMutationCount());
    }

    @Test
    public void testWriteAtLeastOnceReturnsCommitStats() {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.lastKey = ITWriteTest.uniqueString();
        CommitResponse response = client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(this.lastKey)).set("StringValue").to("v1")).build()), new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCommitTimestamp());
        Assert.assertNotNull((Object)response.getCommitStats());
        Assert.assertEquals((long)2L, (long)response.getCommitStats().getMutationCount());
    }

    @Test
    public void writeAlreadyExists() {
        this.lastKey = "key1";
        client.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("key1")).set("StringValue").to("v1")).build()));
        Struct row = this.readLastRow("StringValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"v1");
        try {
            client.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to(this.lastKey)).set("StringValue").to("v2")).build()));
            Assert.fail((String)"missing expected ALREADY_EXISTS exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.ALREADY_EXISTS);
        }
        row = this.readLastRow("StringValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"v1");
    }

    @Ignore
    @Test
    public void emptyWrite() {
        try {
            client.write(Collections.emptyList());
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
    }

    @Test
    public void writeBool() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolValue").to(true)).build());
        Struct row = this.readLastRow("BoolValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Boolean)row.getBoolean(0)).isTrue();
    }

    @Test
    public void writeBoolNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolValue").to((Boolean)null)).build());
        Struct row = this.readLastRow("BoolValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeInt64() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64Value").to(1234L)).build());
        Struct row = this.readLastRow("Int64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1234L);
    }

    @Test
    public void writeInt64Null() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64Value").to((Long)null)).build());
        Struct row = this.readLastRow("Int64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeFloat64() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to(2.0)).build());
        Struct row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isWithin(0.0).of(2.0);
    }

    @Test
    public void writeFloat64NonNumbers() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to(Double.NEGATIVE_INFINITY)).build());
        Struct row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isNegativeInfinity();
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to(Double.POSITIVE_INFINITY)).build());
        row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isPositiveInfinity();
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to(Double.NaN)).build());
        row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isNaN();
    }

    @Test
    public void writeFloat64Null() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to((Double)null)).build());
        Struct row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeString() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringValue").to("V1")).build());
        Struct row = this.readLastRow("StringValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"V1");
    }

    @Test
    public void writeStringNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringValue").to((String)null)).build());
        Struct row = this.readLastRow("StringValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeJson() {
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Assume.assumeFalse((String)"PostgreSQL does not yet support JSON", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("JsonValue").to(Value.json((String)"{\"rating\":9,\"open\":true}"))).build());
        Struct row = this.readLastRow("JsonValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Object)row.getColumnType("JsonValue")).isEqualTo((Object)Type.json());
        Truth.assertThat((String)row.getJson(0)).isEqualTo((Object)"{\"open\":true,\"rating\":9}");
    }

    @Test
    public void writeJsonEmpty() {
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Assume.assumeFalse((String)"PostgreSQL does not yet support JSON", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("JsonValue").to(Value.json((String)"{}"))).build());
        Struct row = this.readLastRow("JsonValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Object)row.getColumnType("JsonValue")).isEqualTo((Object)Type.json());
        Truth.assertThat((String)row.getJson(0)).isEqualTo((Object)"{}");
    }

    @Test
    public void writeJsonNull() {
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Assume.assumeFalse((String)"PostgreSQL does not yet support JSON", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("JsonValue").to(Value.json(null))).build());
        Struct row = this.readLastRow("JsonValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
        Truth.assertThat((Object)row.getColumnType("JsonValue")).isEqualTo((Object)Type.json());
    }

    @Test
    public void writeBytes() {
        ByteArray data = ByteArray.copyFrom((String)"V1");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesValue").to(data)).build());
        Struct row = this.readLastRow("BytesValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytes(0)).isEqualTo((Object)data);
    }

    @Test
    public void writeBytesAsString() {
        Random random = new Random();
        byte[] data = new byte[256];
        random.nextBytes(data);
        String base64 = Base64.getEncoder().encodeToString(data);
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesValue").to(base64)).build());
        Struct row = this.readLastRow("BytesValue");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertArrayEquals((byte[])data, (byte[])row.getBytes(0).toByteArray());
        Assert.assertEquals((Object)base64, (Object)row.getValue(0).getAsString());
    }

    @Test
    public void writeBytesAsStringUsingDml() {
        Random random = new Random();
        byte[] data = new byte[256];
        random.nextBytes(data);
        String base64 = Base64.getEncoder().encodeToString(data);
        Long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            this.lastKey = ITWriteTest.uniqueString();
            return transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)("insert into T (BytesValue, K) values (" + this.queryParamString(1) + ", " + this.queryParamString(2) + ")")).bind("p1").to(Value.bytesFromBase64((String)base64))).bind("p2").to(this.lastKey)).build(), new Options.UpdateOption[0]);
        });
        Assert.assertNotNull((Object)updateCount);
        Assert.assertEquals((long)1L, (long)updateCount);
        Struct row = this.readLastRow("BytesValue");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertArrayEquals((byte[])data, (byte[])row.getBytes(0).toByteArray());
        Assert.assertEquals((Object)base64, (Object)row.getValue(0).getAsString());
    }

    String queryParamString(int index) {
        return this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? "@p" + index : "$" + index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeBytesRandom() {
        Random rnd = new Random();
        long seed = rnd.nextLong();
        rnd.setSeed(seed);
        HashMap<String, ByteArray> expected = new HashMap<String, ByteArray>();
        boolean pass = false;
        try {
            for (int length : new int[]{1, 2, 5, 11}) {
                byte[] data = new byte[length];
                for (int i = 0; i < 3; ++i) {
                    rnd.nextBytes(data);
                    String key = ITWriteTest.uniqueString();
                    ByteArray value = ByteArray.copyFrom((byte[])data);
                    expected.put(key, value);
                    this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(key)).set("BytesValue").to(value)).build());
                }
            }
            KeySet.Builder keys = KeySet.newBuilder();
            for (String key : expected.keySet()) {
                keys.addKey(Key.of((Object[])new Object[]{key}));
            }
            ResultSet resultSet = client.singleUse(TimestampBound.strong()).read("T", keys.build(), Arrays.asList("K", "BytesValue"), new Options.ReadOption[0]);
            while (resultSet.next()) {
                String key = resultSet.getString(0);
                ByteArray value = resultSet.getBytes(1);
                Truth.assertThat(expected).containsKey((Object)key);
                ByteArray expectedValue = (ByteArray)expected.remove(key);
                Truth.assertThat((Iterable)value).isEqualTo((Object)expectedValue);
            }
            Truth.assertThat(expected).isEmpty();
            pass = true;
        }
        finally {
            if (!pass) {
                System.out.println("To reproduce failure, use seed " + seed);
            }
        }
    }

    @Test
    public void writeBytesNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesValue").to((ByteArray)null)).build());
        Struct row = this.readLastRow("BytesValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeTimestamp() {
        Assume.assumeFalse((String)"PostgresSQL does not yet support Timestamp", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Timestamp timestamp = Timestamp.parseTimestamp((String)"2016-09-15T00:00:00.111111Z");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampValue").to(timestamp)).build());
        Struct row = this.readLastRow("TimestampValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Comparable)row.getTimestamp(0)).isEqualTo((Object)timestamp);
    }

    @Test
    public void writeTimestampNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampValue").to((Timestamp)null)).build());
        Struct row = this.readLastRow("TimestampValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeCommitTimestamp() {
        Assume.assumeFalse((String)"PostgreSQL does not yet support Commit Timestamp", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Timestamp commitTimestamp = this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampValue").to(Value.COMMIT_TIMESTAMP)).build());
        Struct row = this.readLastRow("TimestampValue");
        Truth.assertThat((Comparable)row.getTimestamp(0)).isEqualTo((Object)commitTimestamp);
    }

    @Test
    public void writeDate() {
        Date date = Date.parseDate((String)"2016-09-15");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateValue").to(date)).build());
        Struct row = this.readLastRow("DateValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Comparable)row.getDate(0)).isEqualTo((Object)date);
    }

    @Test
    public void writeDateNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateValue").to((Date)null)).build());
        Struct row = this.readLastRow("DateValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeNumeric() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("NumericValue").to("3.141592")).build());
        Struct row = this.readLastRow("NumericValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        if (this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL) {
            Truth.assertThat((BigDecimal)row.getBigDecimal(0)).isEqualTo((Object)BigDecimal.valueOf(3141592L, 6));
        } else {
            Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"3.141592");
        }
    }

    @Test
    public void writeNumericNull() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("NumericValue").to((String)null)).build());
        Struct row = this.readLastRow("NumericValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeBoolArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolArrayValue").toBoolArray((boolean[])null)).build());
        Struct row = this.readLastRow("BoolArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeBoolArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolArrayValue").toBoolArray(new boolean[0])).build());
        Struct row = this.readLastRow("BoolArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBooleanList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeBoolArray() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolArrayValue").toBoolArray(Arrays.asList(true, null, false))).build());
        Struct row = this.readLastRow("BoolArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBooleanList(0)).containsExactly(new Object[]{true, null, false}).inOrder();
        try {
            row.getBooleanArray(0);
            Assert.fail((String)"Expected exception");
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void writeBoolArrayNoNulls() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolArrayValue").toBoolArray(Arrays.asList(true, false))).build());
        Struct row = this.readLastRow("BoolArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((boolean[])row.getBooleanArray(0)).isEqualTo((Object)new boolean[]{true, false});
    }

    @Test
    public void writeInt64ArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64ArrayValue").toInt64Array((long[])null)).build());
        Struct row = this.readLastRow("Int64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeInt64ArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64ArrayValue").toInt64Array(new long[0])).build());
        Struct row = this.readLastRow("Int64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getLongList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeInt64Array() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64ArrayValue").toInt64Array(Arrays.asList(1L, 2L, null))).build());
        Struct row = this.readLastRow("Int64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getLongList(0)).containsExactly(new Object[]{1L, 2L, null}).inOrder();
        try {
            row.getLongArray(0);
            Assert.fail((String)"Expected exception");
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void writeInt64ArrayNoNulls() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64ArrayValue").toInt64Array(Arrays.asList(1L, 2L))).build());
        Struct row = this.readLastRow("Int64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((long[])row.getLongArray(0)).isEqualTo((Object)new long[]{1L, 2L});
    }

    @Test
    public void writeFloat64ArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64ArrayValue").toFloat64Array((double[])null)).build());
        Struct row = this.readLastRow("Float64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeFloat64ArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64ArrayValue").toFloat64Array(new double[0])).build());
        Struct row = this.readLastRow("Float64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDoubleList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeFloat64Array() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64ArrayValue").toFloat64Array(Arrays.asList(null, 1.0, 2.0))).build());
        Struct row = this.readLastRow("Float64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDoubleList(0)).containsExactly(new Object[]{null, 1.0, 2.0}).inOrder();
        try {
            row.getDoubleArray(0);
            Assert.fail((String)"Expected exception");
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void writeFloat64ArrayNoNulls() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64ArrayValue").toFloat64Array(Arrays.asList(1.0, 2.0))).build());
        Struct row = this.readLastRow("Float64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Integer)row.getDoubleArray(0).length).isEqualTo((Object)2);
        Truth.assertThat((Double)row.getDoubleArray(0)[0]).isWithin(0.0).of(1.0);
        Truth.assertThat((Double)row.getDoubleArray(0)[1]).isWithin(0.0).of(2.0);
    }

    @Test
    public void writeStringArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringArrayValue").toStringArray(null)).build());
        Struct row = this.readLastRow("StringArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeStringArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringArrayValue").toStringArray(Collections.emptyList())).build());
        Struct row = this.readLastRow("StringArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeStringArray() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringArrayValue").toStringArray(Arrays.asList("a", null, "b"))).build());
        Struct row = this.readLastRow("StringArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[]{"a", null, "b"}).inOrder();
    }

    @Test
    public void writeJsonArrayNull() {
        Assume.assumeFalse((String)"PostgreSQL does not yet support Array", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("JsonArrayValue").toJsonArray(null)).build());
        Struct row = this.readLastRow("JsonArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
        Truth.assertThat((Object)row.getColumnType("JsonArrayValue")).isEqualTo((Object)Type.array((Type)Type.json()));
    }

    @Test
    public void writeJsonArrayEmpty() {
        Assume.assumeFalse((String)"PostgreSQL does not yet support Array", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("JsonArrayValue").toJsonArray(Collections.emptyList())).build());
        Struct row = this.readLastRow("JsonArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Object)row.getColumnType("JsonArrayValue")).isEqualTo((Object)Type.array((Type)Type.json()));
        Truth.assertThat((Iterable)row.getJsonList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeJsonArray() {
        Assume.assumeFalse((String)"PostgreSQL does not yet support Array", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("JsonArrayValue").toJsonArray(Arrays.asList("[]", null, "{}"))).build());
        Struct row = this.readLastRow("JsonArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Object)row.getColumnType("JsonArrayValue")).isEqualTo((Object)Type.array((Type)Type.json()));
        Truth.assertThat((Iterable)row.getJsonList(0)).containsExactly(new Object[]{"[]", null, "{}"}).inOrder();
    }

    @Test
    public void writeJsonArrayNoNulls() {
        Assume.assumeFalse((String)"PostgreSQL does not yet support Array", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("JsonArrayValue").toJsonArray(Arrays.asList("[]", "{\"color\":\"red\",\"value\":\"#f00\"}", "{}"))).build());
        Struct row = this.readLastRow("JsonArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Object)row.getColumnType("JsonArrayValue")).isEqualTo((Object)Type.array((Type)Type.json()));
        Truth.assertThat((Iterable)row.getJsonList(0)).containsExactly(new Object[]{"[]", "{\"color\":\"red\",\"value\":\"#f00\"}", "{}"}).inOrder();
    }

    @Test
    public void writeBytesArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesArrayValue").toBytesArray(null)).build());
        Struct row = this.readLastRow("BytesArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeBytesArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesArrayValue").toBytesArray(Collections.emptyList())).build());
        Struct row = this.readLastRow("BytesArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytesList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeBytesArray() {
        List<ByteArray> data = Arrays.asList(ByteArray.copyFrom((String)"a"), ByteArray.copyFrom((String)"b"), null);
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesArrayValue").toBytesArray(data)).build());
        Struct row = this.readLastRow("BytesArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytesList(0)).isEqualTo(data);
    }

    @Test
    public void writeTimestampArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampArrayValue").toTimestampArray(null)).build());
        Struct row = this.readLastRow("TimestampArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeTimestampArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampArrayValue").toTimestampArray(Collections.emptyList())).build());
        Struct row = this.readLastRow("TimestampArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getTimestampList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeTimestampArray() {
        Timestamp t1 = Timestamp.parseTimestamp((String)"2016-09-18T00:00:00Z");
        Timestamp t2 = Timestamp.parseTimestamp((String)"2016-09-19T00:00:00Z");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampArrayValue").toTimestampArray(Arrays.asList(t1, null, t2))).build());
        Struct row = this.readLastRow("TimestampArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getTimestampList(0)).containsExactly(new Object[]{t1, null, t2}).inOrder();
    }

    @Test
    public void writeDateArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateArrayValue").toDateArray(null)).build());
        Struct row = this.readLastRow("DateArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeDateArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateArrayValue").toDateArray(Collections.emptyList())).build());
        Struct row = this.readLastRow("DateArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDateList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeDateArray() {
        Date d1 = Date.parseDate((String)"2016-09-18");
        Date d2 = Date.parseDate((String)"2016-09-19");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateArrayValue").toDateArray(Arrays.asList(d1, null, d2))).build());
        Struct row = this.readLastRow("DateArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDateList(0)).containsExactly(new Object[]{d1, null, d2}).inOrder();
    }

    @Test
    public void writeNumericArrayNull() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("NumericArrayValue").toNumericArray(null)).build());
        Struct row = this.readLastRow("NumericArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeNumericArrayEmpty() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("NumericArrayValue").toNumericArray((Iterable)ImmutableList.of())).build());
        Struct row = this.readLastRow("NumericArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        if (this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL) {
            Truth.assertThat((Iterable)row.getBigDecimalList(0)).containsExactly(new Object[0]);
        } else {
            Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[0]);
        }
    }

    @Test
    public void writeNumericArray() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("NumericArrayValue").toNumericArray(Arrays.asList(new BigDecimal("3.141592"), new BigDecimal("6.626"), null))).build());
        Struct row = this.readLastRow("NumericArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        if (this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL) {
            Truth.assertThat((Iterable)row.getBigDecimalList(0)).containsExactly(new Object[]{BigDecimal.valueOf(3141592L, 6), BigDecimal.valueOf(6626L, 3), null});
        } else {
            Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[]{"3.141592", "6.626", null}).inOrder();
        }
    }

    @Test
    public void writeNumericArrayNoNulls() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("NumericArrayValue").toNumericArray(Arrays.asList(new BigDecimal("3.141592"), new BigDecimal("6.626")))).build());
        Struct row = this.readLastRow("NumericArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        if (this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL) {
            Truth.assertThat((Iterable)row.getBigDecimalList(0)).containsExactly(new Object[]{BigDecimal.valueOf(3141592L, 6), BigDecimal.valueOf(6626L, 3)});
        } else {
            Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[]{BigDecimal.valueOf(3141592L, 6).toString(), BigDecimal.valueOf(6626L, 3).toString()}).inOrder();
        }
    }

    @Test
    public void tableNotFound() {
        try {
            this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TableThatDoesNotExist").set("K").to(ITWriteTest.uniqueString())).set("StringuniqueString(Value").to("V1")).build());
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
        }
    }

    @Test
    public void columnNotFound() {
        try {
            this.write(((Mutation.WriteBuilder)this.baseInsert().set("ColumnThatDoesNotExist").to("V1")).build());
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
        }
    }

    @Test
    public void incorrectType() {
        try {
            this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringValue").to(1.234)).build());
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"STRING");
        }
    }

    @Test
    public void cancellation() {
        Context.CancellableContext context = Context.current().withCancellation();
        context.cancel((Throwable)new RuntimeException("Cancelled by test"));
        Runnable work = context.wrap(() -> this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolValue").to(true)).build()));
        try {
            work.run();
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)((Object)e), SpannerMatchers.isSpannerException(ErrorCode.CANCELLED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deadline() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        Context.CancellableContext context = Context.current().withDeadlineAfter(10L, TimeUnit.NANOSECONDS, executor);
        Runnable work = context.wrap(() -> this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolValue").to(true)).build()));
        try {
            work.run();
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)((Object)e), SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        }
        finally {
            executor.shutdown();
        }
    }
}

