/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ListValue;
import com.google.spanner.v1.KeySet;
import com.google.spanner.v1.Mutation;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Mutation
implements Serializable {
    private static final long serialVersionUID = 1784900828296918555L;
    private final String table;
    private final Op operation;
    private final ImmutableList<String> columns;
    private final ImmutableList<Value> values;
    private final KeySet keySet;

    private Mutation(String table, Op operation, @Nullable ImmutableList<String> columns, @Nullable ImmutableList<Value> values, @Nullable KeySet keySet) {
        this.table = table;
        this.operation = operation;
        this.columns = columns;
        this.values = values;
        this.keySet = keySet;
    }

    public static WriteBuilder newInsertBuilder(String table) {
        return new WriteBuilder(table, Op.INSERT);
    }

    public static WriteBuilder newUpdateBuilder(String table) {
        return new WriteBuilder(table, Op.UPDATE);
    }

    public static WriteBuilder newInsertOrUpdateBuilder(String table) {
        return new WriteBuilder(table, Op.INSERT_OR_UPDATE);
    }

    public static WriteBuilder newReplaceBuilder(String table) {
        return new WriteBuilder(table, Op.REPLACE);
    }

    public static Mutation delete(String table, Key key) {
        return Mutation.delete(table, KeySet.singleKey(key));
    }

    public static Mutation delete(String table, KeySet keySet) {
        return new Mutation(table, Op.DELETE, null, null, (KeySet)Preconditions.checkNotNull((Object)keySet));
    }

    public String getTable() {
        return this.table;
    }

    public Op getOperation() {
        return this.operation;
    }

    public Iterable<String> getColumns() {
        Preconditions.checkState((this.operation != Op.DELETE ? 1 : 0) != 0, (Object)"columns() cannot be called for a DELETE mutation");
        return this.columns;
    }

    public Iterable<Value> getValues() {
        Preconditions.checkState((this.operation != Op.DELETE ? 1 : 0) != 0, (Object)"values() cannot be called for a DELETE mutation");
        return this.values;
    }

    public Map<String, Value> asMap() {
        Preconditions.checkState((this.operation != Op.DELETE ? 1 : 0) != 0, (Object)"asMap() cannot be called for a DELETE mutation");
        LinkedHashMap<String, Value> map = new LinkedHashMap<String, Value>();
        for (int i = 0; i < this.columns.size(); ++i) {
            Value value = map.put((String)this.columns.get(i), (Value)this.values.get(i));
        }
        return Collections.unmodifiableMap(map);
    }

    public KeySet getKeySet() {
        Preconditions.checkState((this.operation == Op.DELETE ? 1 : 0) != 0, (Object)"keySet() can only be called for a DELETE mutation");
        return this.keySet;
    }

    void toString(StringBuilder b) {
        boolean isWrite;
        String opName;
        switch (this.operation) {
            case INSERT: {
                opName = "insert";
                isWrite = true;
                break;
            }
            case INSERT_OR_UPDATE: {
                opName = "insert_or_update";
                isWrite = true;
                break;
            }
            case UPDATE: {
                opName = "update";
                isWrite = true;
                break;
            }
            case REPLACE: {
                opName = "replace";
                isWrite = true;
                break;
            }
            case DELETE: {
                opName = "delete";
                isWrite = false;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled Op: " + (Object)((Object)this.operation)));
            }
        }
        if (isWrite) {
            b.append(opName).append('(').append(this.table).append('{');
            for (int i = 0; i < this.columns.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append((String)this.columns.get(i));
                b.append('=');
                b.append(this.values.get(i));
            }
            b.append("})");
        } else {
            b.append("delete(").append(this.table);
            this.keySet.toString(b);
            b.append(')');
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mutation that = (Mutation)o;
        return this.operation == that.operation && Objects.equals(this.table, that.table) && Objects.equals(this.columns, that.columns) && this.areValuesEqual((List<Value>)this.values, (List<Value>)that.values) && Objects.equals(this.keySet, that.keySet);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.table, this.columns, this.values, this.keySet});
    }

    private boolean areValuesEqual(List<Value> values, List<Value> otherValues) {
        if (values == null && otherValues == null) {
            return true;
        }
        if (values == null || otherValues == null) {
            return false;
        }
        if (values.size() != otherValues.size()) {
            return false;
        }
        for (int i = 0; i < values.size(); ++i) {
            Value otherValue;
            Value value = values.get(i);
            if (value.equals(otherValue = otherValues.get(i)) || this.isNaN(value) && this.isNaN(otherValue)) continue;
            return false;
        }
        return true;
    }

    private boolean isNaN(Value value) {
        return !value.isNull() && value.getType().equals(Type.float64()) && Double.isNaN(value.getFloat64());
    }

    static void toProto(Iterable<Mutation> mutations, List<com.google.spanner.v1.Mutation> out) {
        Mutation last = null;
        Mutation.Builder proto = null;
        Mutation.Write.Builder write = null;
        KeySet.Builder keySet = null;
        for (Mutation mutation : mutations) {
            if (mutation.operation == Op.DELETE) {
                if (last != null && last.operation == Op.DELETE && mutation.table.equals(last.table)) {
                    mutation.keySet.appendToProto(keySet);
                } else {
                    if (proto != null) {
                        out.add(proto.build());
                    }
                    proto = com.google.spanner.v1.Mutation.newBuilder();
                    Mutation.Delete.Builder delete = proto.getDeleteBuilder().setTable(mutation.table);
                    keySet = delete.getKeySetBuilder();
                    mutation.keySet.appendToProto(keySet);
                }
                write = null;
            } else {
                ListValue.Builder values = ListValue.newBuilder();
                for (Value value : mutation.getValues()) {
                    values.addValues(value.toProto());
                }
                if (last != null && mutation.operation == last.operation && mutation.table.equals(last.table) && mutation.columns.equals(last.columns)) {
                    write.addValues(values);
                } else {
                    if (proto != null) {
                        out.add(proto.build());
                    }
                    proto = com.google.spanner.v1.Mutation.newBuilder();
                    switch (mutation.operation) {
                        case INSERT: {
                            write = proto.getInsertBuilder();
                            break;
                        }
                        case UPDATE: {
                            write = proto.getUpdateBuilder();
                            break;
                        }
                        case INSERT_OR_UPDATE: {
                            write = proto.getInsertOrUpdateBuilder();
                            break;
                        }
                        case REPLACE: {
                            write = proto.getReplaceBuilder();
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Impossible: " + (Object)((Object)mutation.operation)));
                        }
                    }
                    write.setTable(mutation.table).addAllColumns(mutation.columns).addValues(values);
                }
                keySet = null;
            }
            last = mutation;
        }
        if (proto != null) {
            out.add(proto.build());
        }
    }

    public static enum Op {
        INSERT,
        UPDATE,
        INSERT_OR_UPDATE,
        REPLACE,
        DELETE;

    }

    public static class WriteBuilder {
        private final String table;
        private final Op operation;
        private final ImmutableList.Builder<String> columns;
        private final ImmutableList.Builder<Value> values;
        private final ValueBinder<WriteBuilder> binder;
        private String currentColumn;

        private WriteBuilder(String table, Op operation) {
            this.table = (String)Preconditions.checkNotNull((Object)table);
            this.operation = operation;
            this.columns = ImmutableList.builder();
            this.values = ImmutableList.builder();
            class BinderImpl
            extends ValueBinder<WriteBuilder> {
                BinderImpl() {
                }

                @Override
                WriteBuilder handle(Value value) {
                    WriteBuilder.this.checkBindingInProgress(true);
                    WriteBuilder.this.columns.add((Object)WriteBuilder.this.currentColumn);
                    WriteBuilder.this.values.add((Object)value);
                    WriteBuilder.this.currentColumn = null;
                    return WriteBuilder.this;
                }
            }
            this.binder = new BinderImpl();
        }

        public ValueBinder<WriteBuilder> set(String columnName) {
            this.checkBindingInProgress(false);
            this.currentColumn = (String)Preconditions.checkNotNull((Object)columnName);
            return this.binder;
        }

        public Mutation build() {
            this.checkBindingInProgress(false);
            ImmutableList columnNames = this.columns.build();
            this.checkDuplicateColumns((ImmutableList<String>)columnNames);
            return new Mutation(this.table, this.operation, columnNames, this.values.build(), null);
        }

        private void checkBindingInProgress(boolean expectInProgress) {
            if (expectInProgress) {
                Preconditions.checkState((this.currentColumn != null ? 1 : 0) != 0, (Object)"No binding currently active");
            } else if (this.currentColumn != null) {
                throw new IllegalStateException("Incomplete binding for column " + this.currentColumn);
            }
        }

        private void checkDuplicateColumns(ImmutableList<String> columnNames) {
            HashSet<String> columnNameSet = new HashSet<String>();
            for (String columnName : columnNames) {
                if (columnNameSet.contains(columnName = columnName.toLowerCase())) {
                    throw new IllegalStateException("Duplicate column: " + columnName);
                }
                columnNameSet.add(columnName);
            }
        }
    }
}

