/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.ForwardingApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.TransactionContext;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class TransactionContextFutureImpl
extends ForwardingApiFuture<TransactionContext>
implements AsyncTransactionManager.TransactionContextFuture {
    final CommittableAsyncTransactionManager mgr;
    final SettableApiFuture<Timestamp> txnResult = SettableApiFuture.create();

    static <I, O> ApiFuture<O> runAsyncTransactionFunction(AsyncTransactionManager.AsyncTransactionFunction<I, O> function, TransactionContext txn, I input, Executor executor) throws Exception {
        if (executor == MoreExecutors.directExecutor()) {
            return (ApiFuture)Preconditions.checkNotNull(function.apply(txn, input), (Object)"AsyncTransactionFunction returned <null>. Did you mean to return ApiFutures.immediateFuture(null)?");
        }
        final SettableApiFuture res = SettableApiFuture.create();
        executor.execute(() -> {
            try {
                ApiFuture functionResult = (ApiFuture)Preconditions.checkNotNull(function.apply(txn, input), (Object)"AsyncTransactionFunction returned <null>. Did you mean to return ApiFutures.immediateFuture(null)?");
                ApiFutures.addCallback((ApiFuture)functionResult, (ApiFutureCallback)new ApiFutureCallback<O>(){

                    public void onFailure(Throwable t) {
                        res.setException(t);
                    }

                    public void onSuccess(O result) {
                        res.set(result);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
            catch (Throwable t) {
                res.setException(t);
            }
        });
        return res;
    }

    TransactionContextFutureImpl(CommittableAsyncTransactionManager mgr, ApiFuture<TransactionContext> txnFuture) {
        super(txnFuture);
        this.mgr = mgr;
    }

    public <O> AsyncTransactionStatementImpl<Void, O> then(AsyncTransactionManager.AsyncTransactionFunction<Void, O> function, Executor executor) {
        final SettableApiFuture input = SettableApiFuture.create();
        ApiFutures.addCallback((ApiFuture)this, (ApiFutureCallback)new ApiFutureCallback<TransactionContext>(){

            public void onFailure(Throwable t) {
                TransactionContextFutureImpl.this.mgr.onError(t);
                input.setException(t);
            }

            public void onSuccess(TransactionContext result) {
                input.set(null);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return new AsyncTransactionStatementImpl<Void, O>(this, (ApiFuture<Void>)input, function, executor);
    }

    @InternalApi
    static interface CommittableAsyncTransactionManager
    extends AsyncTransactionManager {
        public void onError(Throwable var1);

        public ApiFuture<Timestamp> commitAsync();
    }

    class AsyncTransactionStatementImpl<I, O>
    extends ForwardingApiFuture<O>
    implements AsyncTransactionManager.AsyncTransactionStep<I, O> {
        final ApiFuture<TransactionContext> txnFuture;
        final SettableApiFuture<O> statementResult;

        AsyncTransactionStatementImpl(ApiFuture<TransactionContext> txnFuture, ApiFuture<I> input, AsyncTransactionManager.AsyncTransactionFunction<I, O> function, Executor executor) {
            this(SettableApiFuture.create(), txnFuture, input, function, executor);
        }

        AsyncTransactionStatementImpl(SettableApiFuture<O> delegate, final ApiFuture<TransactionContext> txnFuture, ApiFuture<I> input, final AsyncTransactionManager.AsyncTransactionFunction<I, O> function, final Executor executor) {
            super(delegate);
            this.statementResult = delegate;
            this.txnFuture = txnFuture;
            ApiFutures.addCallback(input, (ApiFutureCallback)new ApiFutureCallback<I>(){

                public void onFailure(Throwable t) {
                    TransactionContextFutureImpl.this.mgr.onError(t);
                    AsyncTransactionStatementImpl.this.statementResult.setException(t);
                    TransactionContextFutureImpl.this.txnResult.setException(t);
                }

                public void onSuccess(I result) {
                    try {
                        ApiFutures.addCallback(TransactionContextFutureImpl.runAsyncTransactionFunction(function, (TransactionContext)txnFuture.get(), result, executor), (ApiFutureCallback)new ApiFutureCallback<O>(){

                            public void onFailure(Throwable t) {
                                TransactionContextFutureImpl.this.mgr.onError(t);
                                AsyncTransactionStatementImpl.this.statementResult.setException(t);
                                TransactionContextFutureImpl.this.txnResult.setException(t);
                            }

                            public void onSuccess(O result) {
                                AsyncTransactionStatementImpl.this.statementResult.set(result);
                            }
                        }, (Executor)MoreExecutors.directExecutor());
                    }
                    catch (Throwable t) {
                        TransactionContextFutureImpl.this.mgr.onError(t);
                        AsyncTransactionStatementImpl.this.statementResult.setException(t);
                        TransactionContextFutureImpl.this.txnResult.setException(t);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public <RES> AsyncTransactionStatementImpl<O, RES> then(AsyncTransactionManager.AsyncTransactionFunction<O, RES> next, Executor executor) {
            return new AsyncTransactionStatementImpl<O, RES>(this.txnFuture, this.statementResult, next, executor);
        }

        @Override
        public AsyncTransactionManager.CommitTimestampFuture commitAsync() {
            ApiFutures.addCallback(this.statementResult, (ApiFutureCallback)new ApiFutureCallback<O>(){

                public void onFailure(Throwable t) {
                    TransactionContextFutureImpl.this.mgr.onError(t);
                    TransactionContextFutureImpl.this.txnResult.setException(t);
                }

                public void onSuccess(O result) {
                    ApiFutures.addCallback(TransactionContextFutureImpl.this.mgr.commitAsync(), (ApiFutureCallback)new ApiFutureCallback<Timestamp>(){

                        public void onFailure(Throwable t) {
                            TransactionContextFutureImpl.this.mgr.onError(t);
                            TransactionContextFutureImpl.this.txnResult.setException(t);
                        }

                        public void onSuccess(Timestamp result) {
                            TransactionContextFutureImpl.this.txnResult.set((Object)result);
                        }
                    }, (Executor)MoreExecutors.directExecutor());
                }
            }, (Executor)MoreExecutors.directExecutor());
            return new CommitTimestampFutureImpl((ApiFuture<Timestamp>)TransactionContextFutureImpl.this.txnResult);
        }
    }

    static class CommitTimestampFutureImpl
    extends ForwardingApiFuture<Timestamp>
    implements AsyncTransactionManager.CommitTimestampFuture {
        CommitTimestampFutureImpl(ApiFuture<Timestamp> delegate) {
            super((ApiFuture)Preconditions.checkNotNull(delegate));
        }

        @Override
        public Timestamp get() throws AbortedException, ExecutionException, InterruptedException {
            try {
                return (Timestamp)super.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() != null && e.getCause() instanceof AbortedException) {
                    throw (AbortedException)((Object)e.getCause());
                }
                throw e;
            }
        }

        @Override
        public Timestamp get(long timeout, TimeUnit unit) throws AbortedException, ExecutionException, InterruptedException, TimeoutException {
            try {
                return (Timestamp)super.get(timeout, unit);
            }
            catch (ExecutionException e) {
                if (e.getCause() != null && e.getCause() instanceof AbortedException) {
                    throw (AbortedException)((Object)e.getCause());
                }
                throw e;
            }
        }
    }
}

