/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.stub.GrpcSpannerCallableFactory;
import com.google.cloud.spanner.v1.stub.SpannerStub;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcSpannerStub
extends SpannerStub {
    private static final MethodDescriptor<CreateSessionRequest, Session> createSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/CreateSession").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Session.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/BatchCreateSessions").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchCreateSessionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchCreateSessionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSessionRequest, Session> getSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/GetSession").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Session.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSessionsRequest, ListSessionsResponse> listSessionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/ListSessions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSessionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSessionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSessionRequest, Empty> deleteSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/DeleteSession").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ExecuteSqlRequest, ResultSet> executeSqlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/ExecuteSql").setRequestMarshaller(ProtoUtils.marshaller((Message)ExecuteSqlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ResultSet.getDefaultInstance())).build();
    private static final MethodDescriptor<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.spanner.v1.Spanner/ExecuteStreamingSql").setRequestMarshaller(ProtoUtils.marshaller((Message)ExecuteSqlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PartialResultSet.getDefaultInstance())).build();
    private static final MethodDescriptor<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/ExecuteBatchDml").setRequestMarshaller(ProtoUtils.marshaller((Message)ExecuteBatchDmlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ExecuteBatchDmlResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ReadRequest, ResultSet> readMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/Read").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ResultSet.getDefaultInstance())).build();
    private static final MethodDescriptor<ReadRequest, PartialResultSet> streamingReadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.spanner.v1.Spanner/StreamingRead").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PartialResultSet.getDefaultInstance())).build();
    private static final MethodDescriptor<BeginTransactionRequest, Transaction> beginTransactionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/BeginTransaction").setRequestMarshaller(ProtoUtils.marshaller((Message)BeginTransactionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Transaction.getDefaultInstance())).build();
    private static final MethodDescriptor<CommitRequest, CommitResponse> commitMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/Commit").setRequestMarshaller(ProtoUtils.marshaller((Message)CommitRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CommitResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RollbackRequest, Empty> rollbackMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/Rollback").setRequestMarshaller(ProtoUtils.marshaller((Message)RollbackRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<PartitionQueryRequest, PartitionResponse> partitionQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/PartitionQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)PartitionQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PartitionResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PartitionReadRequest, PartitionResponse> partitionReadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.v1.Spanner/PartitionRead").setRequestMarshaller(ProtoUtils.marshaller((Message)PartitionReadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PartitionResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateSessionRequest, Session> createSessionCallable;
    private final UnaryCallable<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsCallable;
    private final UnaryCallable<GetSessionRequest, Session> getSessionCallable;
    private final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable;
    private final UnaryCallable<ListSessionsRequest, SpannerClient.ListSessionsPagedResponse> listSessionsPagedCallable;
    private final UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable;
    private final UnaryCallable<ExecuteSqlRequest, ResultSet> executeSqlCallable;
    private final ServerStreamingCallable<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlCallable;
    private final UnaryCallable<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlCallable;
    private final UnaryCallable<ReadRequest, ResultSet> readCallable;
    private final ServerStreamingCallable<ReadRequest, PartialResultSet> streamingReadCallable;
    private final UnaryCallable<BeginTransactionRequest, Transaction> beginTransactionCallable;
    private final UnaryCallable<CommitRequest, CommitResponse> commitCallable;
    private final UnaryCallable<RollbackRequest, Empty> rollbackCallable;
    private final UnaryCallable<PartitionQueryRequest, PartitionResponse> partitionQueryCallable;
    private final UnaryCallable<PartitionReadRequest, PartitionResponse> partitionReadCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSpannerStub create(SpannerStubSettings settings) throws IOException {
        return new GrpcSpannerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSpannerStub create(ClientContext clientContext) throws IOException {
        return new GrpcSpannerStub(SpannerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSpannerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSpannerStub(SpannerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSpannerStub(SpannerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSpannerCallableFactory());
    }

    protected GrpcSpannerStub(SpannerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSessionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateSessionRequest>(){

            public Map<String, String> extract(CreateSessionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"database", (Object)String.valueOf(request.getDatabase()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchCreateSessionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateSessionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchCreateSessionsRequest>(){

            public Map<String, String> extract(BatchCreateSessionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"database", (Object)String.valueOf(request.getDatabase()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSessionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetSessionRequest>(){

            public Map<String, String> extract(GetSessionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listSessionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSessionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListSessionsRequest>(){

            public Map<String, String> extract(ListSessionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"database", (Object)String.valueOf(request.getDatabase()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSessionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteSessionRequest>(){

            public Map<String, String> extract(DeleteSessionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings executeSqlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(executeSqlMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ExecuteSqlRequest>(){

            public Map<String, String> extract(ExecuteSqlRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings executeStreamingSqlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(executeStreamingSqlMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ExecuteSqlRequest>(){

            public Map<String, String> extract(ExecuteSqlRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings executeBatchDmlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(executeBatchDmlMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ExecuteBatchDmlRequest>(){

            public Map<String, String> extract(ExecuteBatchDmlRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings readTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadRequest>(){

            public Map<String, String> extract(ReadRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings streamingReadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingReadMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadRequest>(){

            public Map<String, String> extract(ReadRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings beginTransactionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(beginTransactionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BeginTransactionRequest>(){

            public Map<String, String> extract(BeginTransactionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings commitTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(commitMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CommitRequest>(){

            public Map<String, String> extract(CommitRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings rollbackTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rollbackMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<RollbackRequest>(){

            public Map<String, String> extract(RollbackRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings partitionQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(partitionQueryMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<PartitionQueryRequest>(){

            public Map<String, String> extract(PartitionQueryRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings partitionReadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(partitionReadMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<PartitionReadRequest>(){

            public Map<String, String> extract(PartitionReadRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        this.createSessionCallable = callableFactory.createUnaryCallable(createSessionTransportSettings, settings.createSessionSettings(), clientContext);
        this.batchCreateSessionsCallable = callableFactory.createUnaryCallable(batchCreateSessionsTransportSettings, settings.batchCreateSessionsSettings(), clientContext);
        this.getSessionCallable = callableFactory.createUnaryCallable(getSessionTransportSettings, settings.getSessionSettings(), clientContext);
        this.listSessionsCallable = callableFactory.createUnaryCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.listSessionsPagedCallable = callableFactory.createPagedCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.deleteSessionCallable = callableFactory.createUnaryCallable(deleteSessionTransportSettings, settings.deleteSessionSettings(), clientContext);
        this.executeSqlCallable = callableFactory.createUnaryCallable(executeSqlTransportSettings, settings.executeSqlSettings(), clientContext);
        this.executeStreamingSqlCallable = callableFactory.createServerStreamingCallable(executeStreamingSqlTransportSettings, settings.executeStreamingSqlSettings(), clientContext);
        this.executeBatchDmlCallable = callableFactory.createUnaryCallable(executeBatchDmlTransportSettings, settings.executeBatchDmlSettings(), clientContext);
        this.readCallable = callableFactory.createUnaryCallable(readTransportSettings, settings.readSettings(), clientContext);
        this.streamingReadCallable = callableFactory.createServerStreamingCallable(streamingReadTransportSettings, settings.streamingReadSettings(), clientContext);
        this.beginTransactionCallable = callableFactory.createUnaryCallable(beginTransactionTransportSettings, settings.beginTransactionSettings(), clientContext);
        this.commitCallable = callableFactory.createUnaryCallable(commitTransportSettings, settings.commitSettings(), clientContext);
        this.rollbackCallable = callableFactory.createUnaryCallable(rollbackTransportSettings, settings.rollbackSettings(), clientContext);
        this.partitionQueryCallable = callableFactory.createUnaryCallable(partitionQueryTransportSettings, settings.partitionQuerySettings(), clientContext);
        this.partitionReadCallable = callableFactory.createUnaryCallable(partitionReadTransportSettings, settings.partitionReadSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.createSessionCallable;
    }

    @Override
    public UnaryCallable<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsCallable() {
        return this.batchCreateSessionsCallable;
    }

    @Override
    public UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.getSessionCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.listSessionsCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, SpannerClient.ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.listSessionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable() {
        return this.deleteSessionCallable;
    }

    @Override
    public UnaryCallable<ExecuteSqlRequest, ResultSet> executeSqlCallable() {
        return this.executeSqlCallable;
    }

    @Override
    public ServerStreamingCallable<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlCallable() {
        return this.executeStreamingSqlCallable;
    }

    @Override
    public UnaryCallable<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlCallable() {
        return this.executeBatchDmlCallable;
    }

    @Override
    public UnaryCallable<ReadRequest, ResultSet> readCallable() {
        return this.readCallable;
    }

    @Override
    public ServerStreamingCallable<ReadRequest, PartialResultSet> streamingReadCallable() {
        return this.streamingReadCallable;
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, Transaction> beginTransactionCallable() {
        return this.beginTransactionCallable;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.commitCallable;
    }

    @Override
    public UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.rollbackCallable;
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, PartitionResponse> partitionQueryCallable() {
        return this.partitionQueryCallable;
    }

    @Override
    public UnaryCallable<PartitionReadRequest, PartitionResponse> partitionReadCallable() {
        return this.partitionReadCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

