/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.spanner.v1.BatchWriteResponse;
import javax.annotation.Nullable;

class DatabaseClientImpl
implements DatabaseClient {
    private static final String READ_WRITE_TRANSACTION = "CloudSpanner.ReadWriteTransaction";
    private static final String READ_ONLY_TRANSACTION = "CloudSpanner.ReadOnlyTransaction";
    private static final String PARTITION_DML_TRANSACTION = "CloudSpanner.PartitionDMLTransaction";
    private final TraceWrapper tracer;
    @VisibleForTesting
    final String clientId;
    @VisibleForTesting
    final SessionPool pool;

    @VisibleForTesting
    DatabaseClientImpl(SessionPool pool, TraceWrapper tracer) {
        this("", pool, tracer);
    }

    DatabaseClientImpl(String clientId, SessionPool pool, TraceWrapper tracer) {
        this.clientId = clientId;
        this.pool = pool;
        this.tracer = tracer;
    }

    @VisibleForTesting
    SessionPool.PooledSessionFuture getSession() {
        return this.pool.getSession();
    }

    @Override
    public Dialect getDialect() {
        return this.pool.getDialect();
    }

    @Override
    @Nullable
    public String getDatabaseRole() {
        return this.pool.getDatabaseRole();
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION);
        try {
            IScope s = this.tracer.withSpan(span);
            try {
                CommitResponse commitResponse = (CommitResponse)this.runWithSessionRetry(session -> session.writeWithOptions(mutations, options));
                if (s != null) {
                    s.close();
                }
                return commitResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    span.setStatus(e);
                    throw e;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION);
        try {
            IScope s = this.tracer.withSpan(span);
            try {
                CommitResponse commitResponse = (CommitResponse)this.runWithSessionRetry(session -> session.writeAtLeastOnceWithOptions(mutations, options));
                if (s != null) {
                    s.close();
                }
                return commitResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    span.setStatus(e);
                    throw e;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... options) throws SpannerException {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION);
        try {
            IScope s = this.tracer.withSpan(span);
            try {
                ServerStream serverStream = (ServerStream)this.runWithSessionRetry(session -> session.batchWriteAtLeastOnce(mutationGroups, options));
                if (s != null) {
                    s.close();
                }
                return serverStream;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    span.setStatus(e);
                    throw e;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public ReadContext singleUse() {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadContext readContext = this.getSession().singleUse();
            if (s != null) {
                s.close();
            }
            return readContext;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadContext readContext = this.getSession().singleUse(bound);
            if (s != null) {
                s.close();
            }
            return readContext;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadOnlyTransaction readOnlyTransaction = this.getSession().singleUseReadOnlyTransaction();
            if (s != null) {
                s.close();
            }
            return readOnlyTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadOnlyTransaction readOnlyTransaction = this.getSession().singleUseReadOnlyTransaction(bound);
            if (s != null) {
                s.close();
            }
            return readOnlyTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadOnlyTransaction readOnlyTransaction = this.getSession().readOnlyTransaction();
            if (s != null) {
                s.close();
            }
            return readOnlyTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadOnlyTransaction readOnlyTransaction = this.getSession().readOnlyTransaction(bound);
            if (s != null) {
                s.close();
            }
            return readOnlyTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            TransactionRunner transactionRunner = this.getSession().readWriteTransaction(options);
            if (s != null) {
                s.close();
            }
            return transactionRunner;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public TransactionManager transactionManager(Options.TransactionOption ... options) {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            TransactionManager transactionManager = this.getSession().transactionManager(options);
            if (s != null) {
                s.close();
            }
            return transactionManager;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public AsyncRunner runAsync(Options.TransactionOption ... options) {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            AsyncRunner asyncRunner = this.getSession().runAsync(options);
            if (s != null) {
                s.close();
            }
            return asyncRunner;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            AsyncTransactionManager asyncTransactionManager = this.getSession().transactionManagerAsync(options);
            if (s != null) {
                s.close();
            }
            return asyncTransactionManager;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
        ISpan span = this.tracer.spanBuilder(PARTITION_DML_TRANSACTION);
        IScope s = this.tracer.withSpan(span);
        try {
            long l = (Long)this.runWithSessionRetry(session -> session.executePartitionedUpdate(stmt, options));
            if (s != null) {
                s.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    private <T> T runWithSessionRetry(Function<Session, T> callable) {
        SessionPool.PooledSessionFuture session = this.getSession();
        while (true) {
            try {
                return (T)callable.apply((Object)session);
            }
            catch (SessionNotFoundException e) {
                session = this.pool.replaceSession(e, session);
                continue;
            }
            break;
        }
    }

    ListenableFuture<Void> closeAsync(SpannerImpl.ClosedException closedException) {
        return this.pool.closeAsync(closedException);
    }
}

