/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ClientSideStatementExecutor;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.StatementResult;
import java.lang.reflect.Method;
import java.util.regex.Matcher;

class ClientSideStatementRunPartitionedQueryExecutor
implements ClientSideStatementExecutor {
    private final ClientSideStatementImpl statement;
    private final Method method;

    ClientSideStatementRunPartitionedQueryExecutor(ClientSideStatementImpl statement) throws ClientSideStatementImpl.CompileException {
        try {
            this.statement = statement;
            this.method = ConnectionStatementExecutor.class.getDeclaredMethod(statement.getMethodName(), Statement.class);
        }
        catch (Exception e) {
            throw new ClientSideStatementImpl.CompileException(e, statement);
        }
    }

    @Override
    public StatementResult execute(ConnectionStatementExecutor connection, AbstractStatementParser.ParsedStatement parsedStatement) throws Exception {
        String sql = this.getParameterValue(parsedStatement);
        return (StatementResult)this.method.invoke((Object)connection, parsedStatement.getStatement().toBuilder().replace(sql).build());
    }

    String getParameterValue(AbstractStatementParser.ParsedStatement parsedStatement) {
        Matcher matcher = this.statement.getPattern().matcher(parsedStatement.getSqlWithoutComments());
        if (matcher.find() && matcher.groupCount() >= 2) {
            String space = matcher.group(1);
            String value = matcher.group(2);
            return (space + value).trim();
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Invalid argument for RUN PARTITIONED QUERY: %s", parsedStatement.getStatement().getSql()));
    }
}

