/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.InstantiatingWatchdogProvider;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.UnavailableException;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.NoCredentials;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.grpc.GcpManagedChannelBuilder;
import com.google.cloud.grpc.GcpManagedChannelOptions;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.AdminRequestsPerMinuteExceededException;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Restore;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.ThreadFactoryUtil;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStub;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.cloud.spanner.admin.database.v1.stub.GrpcDatabaseAdminCallableFactory;
import com.google.cloud.spanner.admin.database.v1.stub.GrpcDatabaseAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.GrpcInstanceAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.cloud.spanner.encryption.EncryptionConfigProtoMapper;
import com.google.cloud.spanner.spi.v1.GrpcDatabaseAdminStubWithCustomCallableFactory;
import com.google.cloud.spanner.spi.v1.SpannerInterceptorProvider;
import com.google.cloud.spanner.spi.v1.SpannerMetadataProvider;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.cloud.spanner.v1.stub.GrpcSpannerStub;
import com.google.cloud.spanner.v1.stub.SpannerStub;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsGrpc;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.CopyBackupMetadata;
import com.google.spanner.admin.database.v1.CopyBackupRequest;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateBackupRequest;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.DatabaseAdminGrpc;
import com.google.spanner.admin.database.v1.DatabaseRole;
import com.google.spanner.admin.database.v1.DeleteBackupRequest;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetBackupRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.ListBackupOperationsRequest;
import com.google.spanner.admin.database.v1.ListBackupOperationsResponse;
import com.google.spanner.admin.database.v1.ListBackupsRequest;
import com.google.spanner.admin.database.v1.ListBackupsResponse;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsRequest;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsResponse;
import com.google.spanner.admin.database.v1.ListDatabaseRolesRequest;
import com.google.spanner.admin.database.v1.ListDatabaseRolesResponse;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseRequest;
import com.google.spanner.admin.database.v1.UpdateBackupRequest;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.UpdateDatabaseMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseRequest;
import com.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata;
import com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.CreateInstanceRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceRequest;
import com.google.spanner.admin.instance.v1.GetInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.GetInstanceRequest;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceAdminGrpc;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceRequest;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.BatchWriteRequest;
import com.google.spanner.v1.BatchWriteResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.Transaction;
import io.grpc.CallCredentials;
import io.grpc.Context;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.opencensus.metrics.Metrics;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@InternalApi
public class GapicSpannerRpc
implements SpannerRpc {
    private static final PathTemplate PROJECT_NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}");
    private static final PathTemplate OPERATION_NAME_TEMPLATE = PathTemplate.create((String)"{database=projects/*/instances/*/databases/*}/operations/{operation}");
    private static final int MAX_MESSAGE_SIZE = 0x6400000;
    private static final int MAX_METADATA_SIZE = 32768;
    private static final String PROPERTY_TIMEOUT_SECONDS = "com.google.cloud.spanner.watchdogTimeoutSeconds";
    private static final String PROPERTY_PERIOD_SECONDS = "com.google.cloud.spanner.watchdogPeriodSeconds";
    private static final int DEFAULT_TIMEOUT_SECONDS = 1800;
    private static final int DEFAULT_PERIOD_SECONDS = 10;
    private static final int GRPC_KEEPALIVE_SECONDS = 120;
    private static final String USER_AGENT_KEY = "user-agent";
    private static final String CLIENT_LIBRARY_LANGUAGE = "spanner-java";
    public static final String DEFAULT_USER_AGENT = "spanner-java/" + GaxProperties.getLibraryVersion(GapicSpannerRpc.class);
    private static final String API_FILE = "grpc-gcp-apiconfig.json";
    private boolean rpcIsClosed;
    private final SpannerStub spannerStub;
    private final RetrySettings executeQueryRetrySettings;
    private final Set<StatusCode.Code> executeQueryRetryableCodes;
    private final RetrySettings readRetrySettings;
    private final Set<StatusCode.Code> readRetryableCodes;
    private final SpannerStub partitionedDmlStub;
    private final RetrySettings partitionedDmlRetrySettings;
    private final InstanceAdminStub instanceAdminStub;
    private final DatabaseAdminStubSettings databaseAdminStubSettings;
    private final DatabaseAdminStub databaseAdminStub;
    private final String projectId;
    private final String projectName;
    private final SpannerMetadataProvider metadataProvider;
    private final SpannerOptions.CallCredentialsProvider callCredentialsProvider;
    private final String compressorName;
    private final Duration waitTimeout = GapicSpannerRpc.systemProperty("com.google.cloud.spanner.watchdogTimeoutSeconds", 1800);
    private final Duration idleTimeout = GapicSpannerRpc.systemProperty("com.google.cloud.spanner.watchdogTimeoutSeconds", 1800);
    private final Duration checkInterval = GapicSpannerRpc.systemProperty("com.google.cloud.spanner.watchdogPeriodSeconds", 10);
    private final ScheduledExecutorService spannerWatchdog;
    private final boolean throttleAdministrativeRequests;
    private final RetrySettings retryAdministrativeRequestsSettings;
    private static final double ADMINISTRATIVE_REQUESTS_RATE_LIMIT = 1.0;
    private static final ConcurrentMap<String, RateLimiter> ADMINISTRATIVE_REQUESTS_RATE_LIMITERS = new ConcurrentHashMap<String, RateLimiter>();
    private final boolean leaderAwareRoutingEnabled;
    private static final RetrySettings ADMIN_REQUESTS_LIMIT_EXCEEDED_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)5L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofSeconds((long)60L)).setMaxAttempts(10).build();

    public static GapicSpannerRpc create(SpannerOptions options) {
        return new GapicSpannerRpc(options);
    }

    public GapicSpannerRpc(SpannerOptions options) {
        this(options, true);
    }

    GapicSpannerRpc(SpannerOptions options, boolean initializeStubs) {
        this.projectId = options.getProjectId();
        String projectNameStr = PROJECT_NAME_TEMPLATE.instantiate(new String[]{"project", this.projectId});
        try {
            projectNameStr = URLDecoder.decode(projectNameStr, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.projectName = projectNameStr;
        this.throttleAdministrativeRequests = options.isAutoThrottleAdministrativeRequests();
        if (this.throttleAdministrativeRequests) {
            ADMINISTRATIVE_REQUESTS_RATE_LIMITERS.putIfAbsent(projectNameStr, RateLimiter.create((double)1.0));
        }
        this.retryAdministrativeRequestsSettings = options.getRetryAdministrativeRequestsSettings();
        ApiClientHeaderProvider.Builder internalHeaderProviderBuilder = ApiClientHeaderProvider.newBuilder();
        ApiClientHeaderProvider internalHeaderProvider = internalHeaderProviderBuilder.setClientLibToken(options.getClientLibToken(), GaxProperties.getLibraryVersion(((Object)((Object)options)).getClass())).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion()).build();
        HeaderProvider mergedHeaderProvider = options.getMergedHeaderProvider((HeaderProvider)internalHeaderProvider);
        HeaderProvider headerProviderWithUserAgent = GapicSpannerRpc.headerProviderWithUserAgentFrom(mergedHeaderProvider);
        this.metadataProvider = SpannerMetadataProvider.create(headerProviderWithUserAgent.getHeaders(), internalHeaderProviderBuilder.getResourceHeaderKey());
        this.callCredentialsProvider = options.getCallCredentialsProvider();
        this.compressorName = options.getCompressorName();
        this.leaderAwareRoutingEnabled = options.isLeaderAwareRoutingEnabled();
        if (initializeStubs) {
            ExecutorService executor;
            InstantiatingGrpcChannelProvider.Builder defaultChannelProviderBuilder = InstantiatingGrpcChannelProvider.newBuilder().setChannelConfigurator(options.getChannelConfigurator()).setEndpoint(options.getEndpoint()).setMaxInboundMessageSize(Integer.valueOf(0x6400000)).setMaxInboundMetadataSize(Integer.valueOf(32768)).setPoolSize(options.getNumChannels()).setKeepAliveTime(Duration.ofSeconds((long)120L)).setInterceptorProvider((GrpcInterceptorProvider)SpannerInterceptorProvider.create((GrpcInterceptorProvider)MoreObjects.firstNonNull((Object)options.getInterceptorProvider(), (Object)SpannerInterceptorProvider.createDefault(options.getOpenTelemetry()))).withEncoding(this.compressorName)).setHeaderProvider(headerProviderWithUserAgent).setAllowNonDefaultServiceAccount(true).setAttemptDirectPath(options.isAttemptDirectPath() && !Objects.equals(options.getScopedCredentials(), NoCredentials.getInstance()));
            if (options.isUseVirtualThreads() && (executor = ThreadFactoryUtil.tryCreateVirtualThreadPerTaskExecutor("spanner-virtual-grpc-executor")) != null) {
                defaultChannelProviderBuilder.setExecutor((Executor)executor);
            }
            GapicSpannerRpc.maybeEnableGrpcGcpExtension(defaultChannelProviderBuilder, options);
            TransportChannelProvider channelProvider = (TransportChannelProvider)MoreObjects.firstNonNull((Object)options.getChannelProvider(), (Object)defaultChannelProviderBuilder.build());
            CredentialsProvider credentialsProvider = GrpcTransportOptions.setUpCredentialsProvider((ServiceOptions)options);
            this.spannerWatchdog = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Cloud-Spanner-WatchdogProvider-%d").build());
            WatchdogProvider watchdogProvider = InstantiatingWatchdogProvider.create().withExecutor(this.spannerWatchdog).withCheckInterval(this.checkInterval).withClock(NanoClock.getDefaultClock());
            try {
                this.spannerStub = GrpcSpannerStub.create(((SpannerStubSettings.Builder)((SpannerStubSettings.Builder)((SpannerStubSettings.Builder)options.getSpannerStubSettings().toBuilder().setTransportChannelProvider(channelProvider)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogProvider(watchdogProvider)).build());
                this.readRetrySettings = options.getSpannerStubSettings().streamingReadSettings().getRetrySettings();
                this.readRetryableCodes = options.getSpannerStubSettings().streamingReadSettings().getRetryableCodes();
                this.executeQueryRetrySettings = options.getSpannerStubSettings().executeStreamingSqlSettings().getRetrySettings();
                this.executeQueryRetryableCodes = options.getSpannerStubSettings().executeStreamingSqlSettings().getRetryableCodes();
                this.partitionedDmlRetrySettings = options.getSpannerStubSettings().executeSqlSettings().getRetrySettings().toBuilder().setInitialRpcTimeout(options.getPartitionedDmlTimeout()).setMaxRpcTimeout(options.getPartitionedDmlTimeout()).setTotalTimeout(options.getPartitionedDmlTimeout()).setRpcTimeoutMultiplier(1.0).build();
                SpannerStubSettings.Builder pdmlSettings = options.getSpannerStubSettings().toBuilder();
                ((SpannerStubSettings.Builder)((SpannerStubSettings.Builder)((SpannerStubSettings.Builder)pdmlSettings.setTransportChannelProvider(channelProvider)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogProvider(watchdogProvider)).executeSqlSettings().setRetrySettings(this.partitionedDmlRetrySettings);
                pdmlSettings.executeStreamingSqlSettings().setRetrySettings(this.partitionedDmlRetrySettings);
                if (options.getPartitionedDmlTimeout().dividedBy(10L).compareTo(pdmlSettings.getStreamWatchdogCheckInterval()) < 0) {
                    pdmlSettings.setStreamWatchdogCheckInterval(options.getPartitionedDmlTimeout().dividedBy(10L));
                    pdmlSettings.setStreamWatchdogProvider(pdmlSettings.getStreamWatchdogProvider().withCheckInterval(pdmlSettings.getStreamWatchdogCheckInterval()));
                }
                this.partitionedDmlStub = GrpcSpannerStub.create(pdmlSettings.build());
                this.instanceAdminStub = GrpcInstanceAdminStub.create(((InstanceAdminStubSettings.Builder)((InstanceAdminStubSettings.Builder)((InstanceAdminStubSettings.Builder)options.getInstanceAdminStubSettings().toBuilder().setTransportChannelProvider(channelProvider)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogProvider(watchdogProvider)).build());
                this.databaseAdminStubSettings = ((DatabaseAdminStubSettings.Builder)((DatabaseAdminStubSettings.Builder)((DatabaseAdminStubSettings.Builder)options.getDatabaseAdminStubSettings().toBuilder().setTransportChannelProvider(channelProvider)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogProvider(watchdogProvider)).build();
                if (options.isAutoThrottleAdministrativeRequests()) {
                    GrpcDatabaseAdminCallableFactory factory = new GrpcDatabaseAdminCallableFactory(){

                        @Override
                        public <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, UnaryCallSettings<RequestT, ResponseT> callSettings, ClientContext clientContext) {
                            if (grpcCallSettings.getMethodDescriptor().getFullMethodName().equals("google.longrunning.Operations/GetOperation")) {
                                ImmutableSet codes = ImmutableSet.builderWithExpectedSize((int)(callSettings.getRetryableCodes().size() + 1)).addAll((Iterable)callSettings.getRetryableCodes()).add((Object)StatusCode.Code.RESOURCE_EXHAUSTED).build();
                                callSettings = callSettings.toBuilder().setRetryableCodes((Set)codes).build();
                            }
                            return super.createUnaryCallable(grpcCallSettings, callSettings, clientContext);
                        }
                    };
                    this.databaseAdminStub = new GrpcDatabaseAdminStubWithCustomCallableFactory(this.databaseAdminStubSettings, ClientContext.create((StubSettings)this.databaseAdminStubSettings), factory);
                } else {
                    this.databaseAdminStub = GrpcDatabaseAdminStub.create(this.databaseAdminStubSettings);
                }
                GapicSpannerRpc.checkEmulatorConnection(options, channelProvider, credentialsProvider);
            }
            catch (Exception e) {
                throw SpannerExceptionFactory.newSpannerException(e);
            }
        } else {
            this.databaseAdminStub = null;
            this.instanceAdminStub = null;
            this.spannerStub = null;
            this.readRetrySettings = null;
            this.readRetryableCodes = null;
            this.executeQueryRetrySettings = null;
            this.executeQueryRetryableCodes = null;
            this.partitionedDmlStub = null;
            this.databaseAdminStubSettings = null;
            this.spannerWatchdog = null;
            this.partitionedDmlRetrySettings = null;
        }
    }

    private static String parseGrpcGcpApiConfig() {
        try {
            return Resources.toString((URL)GapicSpannerRpc.class.getResource(API_FILE), (Charset)Charset.forName("UTF8"));
        }
        catch (IOException e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
    }

    private static GcpManagedChannelOptions grpcGcpOptionsWithMetrics(SpannerOptions options) {
        GcpManagedChannelOptions grpcGcpOptions = (GcpManagedChannelOptions)MoreObjects.firstNonNull((Object)options.getGrpcGcpOptions(), (Object)new GcpManagedChannelOptions());
        GcpManagedChannelOptions.GcpMetricsOptions metricsOptions = (GcpManagedChannelOptions.GcpMetricsOptions)MoreObjects.firstNonNull((Object)grpcGcpOptions.getMetricsOptions(), (Object)GcpManagedChannelOptions.GcpMetricsOptions.newBuilder().build());
        GcpManagedChannelOptions.GcpMetricsOptions.Builder metricsOptionsBuilder = GcpManagedChannelOptions.GcpMetricsOptions.newBuilder((GcpManagedChannelOptions.GcpMetricsOptions)metricsOptions);
        if (metricsOptions.getMetricRegistry() == null) {
            metricsOptionsBuilder.withMetricRegistry(Metrics.getMetricRegistry());
        }
        if (metricsOptions.getNamePrefix().equals("")) {
            metricsOptionsBuilder.withNamePrefix("cloud.google.com/java/spanner/gcp-channel-pool/");
        }
        return GcpManagedChannelOptions.newBuilder((GcpManagedChannelOptions)grpcGcpOptions).withMetricsOptions(metricsOptionsBuilder.build()).build();
    }

    private static void maybeEnableGrpcGcpExtension(InstantiatingGrpcChannelProvider.Builder defaultChannelProviderBuilder, SpannerOptions options) {
        if (!options.isGrpcGcpExtensionEnabled()) {
            return;
        }
        String jsonApiConfig = GapicSpannerRpc.parseGrpcGcpApiConfig();
        GcpManagedChannelOptions grpcGcpOptions = GapicSpannerRpc.grpcGcpOptionsWithMetrics(options);
        ApiFunction apiFunction = channelBuilder -> {
            if (options.getChannelConfigurator() != null) {
                channelBuilder = (ManagedChannelBuilder)options.getChannelConfigurator().apply(channelBuilder);
            }
            return GcpManagedChannelBuilder.forDelegateBuilder((ManagedChannelBuilder)channelBuilder).withApiConfigJsonString(jsonApiConfig).withOptions(grpcGcpOptions).setPoolSize(options.getNumChannels());
        };
        defaultChannelProviderBuilder.setPoolSize(1).setChannelConfigurator(apiFunction);
    }

    private static HeaderProvider headerProviderWithUserAgentFrom(HeaderProvider headerProvider) {
        Optional<Map.Entry> existingUserAgentEntry = headerProvider.getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(USER_AGENT_KEY)).findFirst();
        String existingUserAgentValue = existingUserAgentEntry.map(Map.Entry::getValue).orElse(null);
        String userAgent = Stream.of(existingUserAgentValue, DEFAULT_USER_AGENT).filter(Objects::nonNull).collect(Collectors.joining(" "));
        HashMap<String, String> headersWithUserAgent = new HashMap<String, String>(headerProvider.getHeaders());
        existingUserAgentEntry.ifPresent(entry -> headersWithUserAgent.remove(entry.getKey()));
        headersWithUserAgent.put(USER_AGENT_KEY, userAgent);
        return FixedHeaderProvider.create(headersWithUserAgent);
    }

    private static void checkEmulatorConnection(SpannerOptions options, TransportChannelProvider channelProvider, CredentialsProvider credentialsProvider) throws IOException {
        String emulatorHost = System.getenv("SPANNER_EMULATOR_HOST");
        if (options.getChannelProvider() == null && emulatorHost != null && options.getHost() != null && options.getHost().startsWith("http://localhost") && options.getHost().endsWith(emulatorHost)) {
            try {
                InstanceAdminStubSettings.Builder testEmulatorSettings = (InstanceAdminStubSettings.Builder)((InstanceAdminStubSettings.Builder)options.getInstanceAdminStubSettings().toBuilder().setTransportChannelProvider(channelProvider)).setCredentialsProvider(credentialsProvider);
                testEmulatorSettings.listInstanceConfigsSettings().setSimpleTimeoutNoRetries(Duration.ofSeconds((long)10L));
                try (GrpcInstanceAdminStub stub = GrpcInstanceAdminStub.create(testEmulatorSettings.build());){
                    stub.listInstanceConfigsCallable().call((Object)ListInstanceConfigsRequest.newBuilder().setParent(String.format("projects/%s", options.getProjectId())).build());
                }
            }
            catch (UnavailableException e) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.UNAVAILABLE, String.format("The environment variable SPANNER_EMULATOR_HOST has been set to %s, but no running emulator could be found at that address.\nDid you forget to start the emulator, or to unset the environment variable?", emulatorHost));
            }
        }
    }

    private <T> T runWithRetryOnAdministrativeRequestsExceeded(Callable<T> callable) {
        try {
            return (T)RetryHelper.runWithRetries(callable, (RetrySettings)this.retryAdministrativeRequestsSettings, new AdminRequestsLimitExceededRetryAlgorithm(), (ApiClock)NanoClock.getDefaultClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw SpannerExceptionFactory.asSpannerException(e.getCause());
        }
    }

    private Operation mostRecentOperation(OperationsLister lister, Function<Operation, Timestamp> getStartTimeFunction, Timestamp initialCallTime) {
        Operation res = null;
        Timestamp currMaxStartTime = null;
        String nextPageToken = null;
        block0: do {
            SpannerRpc.Paginated<Operation> operations = lister.listOperations(nextPageToken);
            nextPageToken = operations.getNextPageToken();
            for (Operation op : operations.getResults()) {
                Timestamp startTime = (Timestamp)getStartTimeFunction.apply((Object)op);
                if (res == null || TimestampComparator.INSTANCE.compare(startTime, currMaxStartTime) > 0 && TimestampComparator.INSTANCE.compare(startTime, initialCallTime) >= 0) {
                    currMaxStartTime = startTime;
                    res = op;
                }
                if (startTime != null || currMaxStartTime != null || op.getDone()) continue;
                res = op;
                continue block0;
            }
        } while (nextPageToken != null);
        return res;
    }

    private void acquireAdministrativeRequestsRateLimiter() {
        RateLimiter limiter;
        if (this.throttleAdministrativeRequests && (limiter = (RateLimiter)ADMINISTRATIVE_REQUESTS_RATE_LIMITERS.get(this.projectName)) != null) {
            limiter.acquire();
        }
    }

    @Override
    public SpannerRpc.Paginated<InstanceConfig> listInstanceConfigs(int pageSize, @Nullable String pageToken) throws SpannerException {
        ListInstanceConfigsRequest.Builder requestBuilder = ListInstanceConfigsRequest.newBuilder().setParent(this.projectName).setPageSize(pageSize);
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListInstanceConfigsRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, this.projectName, request, InstanceAdminGrpc.getListInstanceConfigsMethod());
        ListInstanceConfigsResponse response = (ListInstanceConfigsResponse)GapicSpannerRpc.get(this.instanceAdminStub.listInstanceConfigsCallable().futureCall((Object)request, (ApiCallContext)context));
        return new SpannerRpc.Paginated<InstanceConfig>(response.getInstanceConfigsList(), response.getNextPageToken());
    }

    @Override
    public OperationFuture<InstanceConfig, CreateInstanceConfigMetadata> createInstanceConfig(String parent, String instanceConfigId, InstanceConfig instanceConfig, @Nullable Boolean validateOnly) throws SpannerException {
        CreateInstanceConfigRequest.Builder builder = CreateInstanceConfigRequest.newBuilder().setParent(parent).setInstanceConfigId(instanceConfigId).setInstanceConfig(instanceConfig);
        if (validateOnly != null) {
            builder.setValidateOnly(validateOnly.booleanValue());
        }
        CreateInstanceConfigRequest request = builder.build();
        GrpcCallContext context = this.newCallContext(null, parent, request, InstanceAdminGrpc.getCreateInstanceConfigMethod());
        return this.instanceAdminStub.createInstanceConfigOperationCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public OperationFuture<InstanceConfig, UpdateInstanceConfigMetadata> updateInstanceConfig(InstanceConfig instanceConfig, @Nullable Boolean validateOnly, FieldMask fieldMask) throws SpannerException {
        UpdateInstanceConfigRequest.Builder builder = UpdateInstanceConfigRequest.newBuilder().setInstanceConfig(instanceConfig).setUpdateMask(fieldMask);
        if (validateOnly != null) {
            builder.setValidateOnly(validateOnly.booleanValue());
        }
        UpdateInstanceConfigRequest request = builder.build();
        GrpcCallContext context = this.newCallContext(null, instanceConfig.getName(), request, InstanceAdminGrpc.getUpdateInstanceConfigMethod());
        return this.instanceAdminStub.updateInstanceConfigOperationCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public InstanceConfig getInstanceConfig(String instanceConfigName) throws SpannerException {
        GetInstanceConfigRequest request = GetInstanceConfigRequest.newBuilder().setName(instanceConfigName).build();
        GrpcCallContext context = this.newCallContext(null, this.projectName, request, InstanceAdminGrpc.getGetInstanceConfigMethod());
        return (InstanceConfig)GapicSpannerRpc.get(this.instanceAdminStub.getInstanceConfigCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public void deleteInstanceConfig(String instanceConfigName, @Nullable String etag, @Nullable Boolean validateOnly) throws SpannerException {
        DeleteInstanceConfigRequest.Builder requestBuilder = DeleteInstanceConfigRequest.newBuilder().setName(instanceConfigName);
        if (etag != null) {
            requestBuilder.setEtag(etag);
        }
        if (validateOnly != null) {
            requestBuilder.setValidateOnly(validateOnly.booleanValue());
        }
        DeleteInstanceConfigRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, instanceConfigName, request, InstanceAdminGrpc.getDeleteInstanceConfigMethod());
        GapicSpannerRpc.get(this.instanceAdminStub.deleteInstanceConfigCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public SpannerRpc.Paginated<Operation> listInstanceConfigOperations(int pageSize, @Nullable String filter, @Nullable String pageToken) {
        this.acquireAdministrativeRequestsRateLimiter();
        ListInstanceConfigOperationsRequest.Builder requestBuilder = ListInstanceConfigOperationsRequest.newBuilder().setParent(this.projectName).setPageSize(pageSize);
        if (filter != null) {
            requestBuilder.setFilter(filter);
        }
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListInstanceConfigOperationsRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, this.projectName, request, InstanceAdminGrpc.getListInstanceConfigOperationsMethod());
        ListInstanceConfigOperationsResponse response = this.runWithRetryOnAdministrativeRequestsExceeded(() -> (ListInstanceConfigOperationsResponse)GapicSpannerRpc.get(this.instanceAdminStub.listInstanceConfigOperationsCallable().futureCall((Object)request, (ApiCallContext)context)));
        return new SpannerRpc.Paginated<Operation>(response.getOperationsList(), response.getNextPageToken());
    }

    @Override
    public SpannerRpc.Paginated<Instance> listInstances(int pageSize, @Nullable String pageToken, @Nullable String filter) throws SpannerException {
        ListInstancesRequest.Builder requestBuilder = ListInstancesRequest.newBuilder().setParent(this.projectName).setPageSize(pageSize);
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        if (filter != null) {
            requestBuilder.setFilter(filter);
        }
        ListInstancesRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, this.projectName, request, InstanceAdminGrpc.getListInstancesMethod());
        ListInstancesResponse response = (ListInstancesResponse)GapicSpannerRpc.get(this.instanceAdminStub.listInstancesCallable().futureCall((Object)request, (ApiCallContext)context));
        return new SpannerRpc.Paginated<Instance>(response.getInstancesList(), response.getNextPageToken());
    }

    @Override
    public OperationFuture<Instance, CreateInstanceMetadata> createInstance(String parent, String instanceId, Instance instance) throws SpannerException {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstanceId(instanceId).setInstance(instance).build();
        GrpcCallContext context = this.newCallContext(null, parent, request, InstanceAdminGrpc.getCreateInstanceMethod());
        return this.instanceAdminStub.createInstanceOperationCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public OperationFuture<Instance, UpdateInstanceMetadata> updateInstance(Instance instance, FieldMask fieldMask) throws SpannerException {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setFieldMask(fieldMask).build();
        GrpcCallContext context = this.newCallContext(null, instance.getName(), request, InstanceAdminGrpc.getUpdateInstanceMethod());
        return this.instanceAdminStub.updateInstanceOperationCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public Instance getInstance(String instanceName) throws SpannerException {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(instanceName).build();
        GrpcCallContext context = this.newCallContext(null, instanceName, request, InstanceAdminGrpc.getGetInstanceMethod());
        return (Instance)GapicSpannerRpc.get(this.instanceAdminStub.getInstanceCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public void deleteInstance(String instanceName) throws SpannerException {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(instanceName).build();
        GrpcCallContext context = this.newCallContext(null, instanceName, request, InstanceAdminGrpc.getDeleteInstanceMethod());
        GapicSpannerRpc.get(this.instanceAdminStub.deleteInstanceCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public SpannerRpc.Paginated<Operation> listBackupOperations(String instanceName, int pageSize, @Nullable String filter, @Nullable String pageToken) {
        this.acquireAdministrativeRequestsRateLimiter();
        ListBackupOperationsRequest.Builder requestBuilder = ListBackupOperationsRequest.newBuilder().setParent(instanceName).setPageSize(pageSize);
        if (filter != null) {
            requestBuilder.setFilter(filter);
        }
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListBackupOperationsRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, instanceName, request, DatabaseAdminGrpc.getListBackupOperationsMethod());
        ListBackupOperationsResponse response = this.runWithRetryOnAdministrativeRequestsExceeded(() -> (ListBackupOperationsResponse)GapicSpannerRpc.get(this.databaseAdminStub.listBackupOperationsCallable().futureCall((Object)request, (ApiCallContext)context)));
        return new SpannerRpc.Paginated<Operation>(response.getOperationsList(), response.getNextPageToken());
    }

    @Override
    public SpannerRpc.Paginated<Operation> listDatabaseOperations(String instanceName, int pageSize, @Nullable String filter, @Nullable String pageToken) {
        this.acquireAdministrativeRequestsRateLimiter();
        ListDatabaseOperationsRequest.Builder requestBuilder = ListDatabaseOperationsRequest.newBuilder().setParent(instanceName).setPageSize(pageSize);
        if (filter != null) {
            requestBuilder.setFilter(filter);
        }
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListDatabaseOperationsRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, instanceName, request, DatabaseAdminGrpc.getListDatabaseOperationsMethod());
        ListDatabaseOperationsResponse response = this.runWithRetryOnAdministrativeRequestsExceeded(() -> (ListDatabaseOperationsResponse)GapicSpannerRpc.get(this.databaseAdminStub.listDatabaseOperationsCallable().futureCall((Object)request, (ApiCallContext)context)));
        return new SpannerRpc.Paginated<Operation>(response.getOperationsList(), response.getNextPageToken());
    }

    @Override
    public SpannerRpc.Paginated<DatabaseRole> listDatabaseRoles(String databaseName, int pageSize, @Nullable String pageToken) {
        this.acquireAdministrativeRequestsRateLimiter();
        ListDatabaseRolesRequest.Builder requestBuilder = ListDatabaseRolesRequest.newBuilder().setParent(databaseName).setPageSize(pageSize);
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListDatabaseRolesRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, databaseName, request, DatabaseAdminGrpc.getListDatabaseRolesMethod());
        ListDatabaseRolesResponse response = this.runWithRetryOnAdministrativeRequestsExceeded(() -> (ListDatabaseRolesResponse)GapicSpannerRpc.get(this.databaseAdminStub.listDatabaseRolesCallable().futureCall((Object)request, (ApiCallContext)context)));
        return new SpannerRpc.Paginated<DatabaseRole>(response.getDatabaseRolesList(), response.getNextPageToken());
    }

    @Override
    public SpannerRpc.Paginated<com.google.spanner.admin.database.v1.Backup> listBackups(String instanceName, int pageSize, @Nullable String filter, @Nullable String pageToken) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        ListBackupsRequest.Builder requestBuilder = ListBackupsRequest.newBuilder().setParent(instanceName).setPageSize(pageSize);
        if (filter != null) {
            requestBuilder.setFilter(filter);
        }
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListBackupsRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, instanceName, request, DatabaseAdminGrpc.getListBackupsMethod());
        ListBackupsResponse response = this.runWithRetryOnAdministrativeRequestsExceeded(() -> (ListBackupsResponse)GapicSpannerRpc.get(this.databaseAdminStub.listBackupsCallable().futureCall((Object)request, (ApiCallContext)context)));
        return new SpannerRpc.Paginated<com.google.spanner.admin.database.v1.Backup>(response.getBackupsList(), response.getNextPageToken());
    }

    @Override
    public SpannerRpc.Paginated<com.google.spanner.admin.database.v1.Database> listDatabases(String instanceName, int pageSize, @Nullable String pageToken) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        ListDatabasesRequest.Builder requestBuilder = ListDatabasesRequest.newBuilder().setParent(instanceName).setPageSize(pageSize);
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListDatabasesRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, instanceName, request, DatabaseAdminGrpc.getListDatabasesMethod());
        ListDatabasesResponse response = this.runWithRetryOnAdministrativeRequestsExceeded(() -> (ListDatabasesResponse)GapicSpannerRpc.get(this.databaseAdminStub.listDatabasesCallable().futureCall((Object)request, (ApiCallContext)context)));
        return new SpannerRpc.Paginated<com.google.spanner.admin.database.v1.Database>(response.getDatabasesList(), response.getNextPageToken());
    }

    @Override
    public OperationFuture<com.google.spanner.admin.database.v1.Database, CreateDatabaseMetadata> createDatabase(String instanceName, String createDatabaseStatement, Iterable<String> additionalStatements, Database databaseInfo) throws SpannerException {
        String databaseId = databaseInfo.getId().getDatabase();
        CreateDatabaseRequest.Builder requestBuilder = CreateDatabaseRequest.newBuilder().setParent(instanceName).setCreateStatement(createDatabaseStatement).addAllExtraStatements(additionalStatements);
        if (databaseInfo.getEncryptionConfig() != null) {
            requestBuilder.setEncryptionConfig(EncryptionConfigProtoMapper.encryptionConfig(databaseInfo.getEncryptionConfig()));
        }
        if (databaseInfo.getDialect() != null) {
            requestBuilder.setDatabaseDialect(databaseInfo.getDialect().toProto());
        }
        if (databaseInfo.getProtoDescriptors() != null) {
            requestBuilder.setProtoDescriptors(databaseInfo.getProtoDescriptors());
        }
        CreateDatabaseRequest request = requestBuilder.build();
        OperationFutureCallable<CreateDatabaseRequest, com.google.spanner.admin.database.v1.Database, CreateDatabaseMetadata> callable = new OperationFutureCallable<CreateDatabaseRequest, com.google.spanner.admin.database.v1.Database, CreateDatabaseMetadata>(this.databaseAdminStub.createDatabaseOperationCallable(), request, DatabaseAdminGrpc.getCreateDatabaseMethod(), instanceName, nextPageToken -> this.listDatabaseOperations(instanceName, 0, String.format("(metadata.@type:type.googleapis.com/%s) AND (name:%s/operations/)", CreateDatabaseMetadata.getDescriptor().getFullName(), String.format("%s/databases/%s", instanceName, databaseId)), nextPageToken), (Function<Operation, Timestamp>)((Function)input -> {
            if (input.getDone() && input.hasResponse()) {
                try {
                    Timestamp createTime = ((com.google.spanner.admin.database.v1.Database)input.getResponse().unpack(com.google.spanner.admin.database.v1.Database.class)).getCreateTime();
                    if (Timestamp.getDefaultInstance().equals((Object)createTime)) {
                        return null;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    return null;
                }
            }
            return null;
        }));
        return (OperationFuture)RetryHelper.runWithRetries(callable, (RetrySettings)this.databaseAdminStubSettings.createDatabaseOperationSettings().getInitialCallSettings().getRetrySettings(), new OperationFutureRetryAlgorithm(), (ApiClock)NanoClock.getDefaultClock());
    }

    @Override
    public OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdl(Database databaseInfo, Iterable<String> updateDatabaseStatements, @Nullable String updateId) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        Preconditions.checkNotNull((Object)databaseInfo.getId());
        UpdateDatabaseDdlRequest.Builder requestBuilder = UpdateDatabaseDdlRequest.newBuilder().setDatabase(databaseInfo.getId().getName()).addAllStatements(updateDatabaseStatements).setOperationId((String)MoreObjects.firstNonNull((Object)updateId, (Object)""));
        if (databaseInfo.getProtoDescriptors() != null) {
            requestBuilder.setProtoDescriptors(databaseInfo.getProtoDescriptors());
        }
        UpdateDatabaseDdlRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, databaseInfo.getId().getName(), request, DatabaseAdminGrpc.getUpdateDatabaseDdlMethod());
        OperationCallable<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> callable = this.databaseAdminStub.updateDatabaseDdlOperationCallable();
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> {
            OperationFuture operationFuture;
            block4: {
                operationFuture = callable.futureCall((Object)request, (ApiCallContext)context);
                try {
                    operationFuture.getInitialFuture().get();
                }
                catch (InterruptedException e) {
                    throw SpannerExceptionFactory.newSpannerException(e);
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause();
                    SpannerException se = SpannerExceptionFactory.asSpannerException(t);
                    if (se instanceof AdminRequestsPerMinuteExceededException) {
                        throw se;
                    }
                    if (!(t instanceof AlreadyExistsException)) break block4;
                    String operationName = OPERATION_NAME_TEMPLATE.instantiate(new String[]{"database", databaseInfo.getId().getName(), "operation", updateId});
                    return callable.resumeFutureCall(operationName, (ApiCallContext)context);
                }
            }
            return operationFuture;
        });
    }

    @Override
    public void dropDatabase(String databaseName) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        DropDatabaseRequest request = DropDatabaseRequest.newBuilder().setDatabase(databaseName).build();
        GrpcCallContext context = this.newCallContext(null, databaseName, request, DatabaseAdminGrpc.getDropDatabaseMethod());
        this.runWithRetryOnAdministrativeRequestsExceeded(() -> {
            GapicSpannerRpc.get(this.databaseAdminStub.dropDatabaseCallable().futureCall((Object)request, (ApiCallContext)context));
            return null;
        });
    }

    @Override
    public com.google.spanner.admin.database.v1.Database getDatabase(String databaseName) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(databaseName).build();
        GrpcCallContext context = this.newCallContext(null, databaseName, request, DatabaseAdminGrpc.getGetDatabaseMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (com.google.spanner.admin.database.v1.Database)GapicSpannerRpc.get(this.databaseAdminStub.getDatabaseCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public OperationFuture<com.google.spanner.admin.database.v1.Database, UpdateDatabaseMetadata> updateDatabase(com.google.spanner.admin.database.v1.Database database, FieldMask updateMask) throws SpannerException {
        UpdateDatabaseRequest request = UpdateDatabaseRequest.newBuilder().setDatabase(database).setUpdateMask(updateMask).build();
        GrpcCallContext context = this.newCallContext(null, database.getName(), request, DatabaseAdminGrpc.getUpdateDatabaseMethod());
        return this.databaseAdminStub.updateDatabaseOperationCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public GetDatabaseDdlResponse getDatabaseDdl(String databaseName) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        GetDatabaseDdlRequest request = GetDatabaseDdlRequest.newBuilder().setDatabase(databaseName).build();
        GrpcCallContext context = this.newCallContext(null, databaseName, request, DatabaseAdminGrpc.getGetDatabaseDdlMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (GetDatabaseDdlResponse)GapicSpannerRpc.get(this.databaseAdminStub.getDatabaseDdlCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public OperationFuture<com.google.spanner.admin.database.v1.Backup, CreateBackupMetadata> createBackup(Backup backupInfo) throws SpannerException {
        String instanceName = backupInfo.getInstanceId().getName();
        String databaseName = backupInfo.getDatabase().getName();
        String backupId = backupInfo.getId().getBackup();
        Backup.Builder backupBuilder = com.google.spanner.admin.database.v1.Backup.newBuilder().setDatabase(databaseName).setExpireTime(backupInfo.getExpireTime().toProto());
        if (backupInfo.getVersionTime() != null) {
            backupBuilder.setVersionTime(backupInfo.getVersionTime().toProto());
        }
        com.google.spanner.admin.database.v1.Backup backup = backupBuilder.build();
        CreateBackupRequest.Builder requestBuilder = CreateBackupRequest.newBuilder().setParent(instanceName).setBackupId(backupId).setBackup(backup);
        if (backupInfo.getEncryptionConfig() != null) {
            requestBuilder.setEncryptionConfig(EncryptionConfigProtoMapper.createBackupEncryptionConfig(backupInfo.getEncryptionConfig()));
        }
        CreateBackupRequest request = requestBuilder.build();
        OperationFutureCallable<CreateBackupRequest, com.google.spanner.admin.database.v1.Backup, CreateBackupMetadata> callable = new OperationFutureCallable<CreateBackupRequest, com.google.spanner.admin.database.v1.Backup, CreateBackupMetadata>(this.databaseAdminStub.createBackupOperationCallable(), request, DatabaseAdminGrpc.getCreateBackupMethod(), instanceName, nextPageToken -> this.listBackupOperations(instanceName, 0, String.format("(metadata.@type:type.googleapis.com/%s) AND (metadata.name:%s)", CreateBackupMetadata.getDescriptor().getFullName(), String.format("%s/backups/%s", instanceName, backupId)), nextPageToken), (Function<Operation, Timestamp>)((Function)input -> {
            try {
                return ((CreateBackupMetadata)input.getMetadata().unpack(CreateBackupMetadata.class)).getProgress().getStartTime();
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }));
        return (OperationFuture)RetryHelper.runWithRetries(callable, (RetrySettings)this.databaseAdminStubSettings.createBackupOperationSettings().getInitialCallSettings().getRetrySettings(), new OperationFutureRetryAlgorithm(), (ApiClock)NanoClock.getDefaultClock());
    }

    @Override
    public OperationFuture<com.google.spanner.admin.database.v1.Backup, CopyBackupMetadata> copyBackup(BackupId sourceBackupId, Backup destinationBackup) throws SpannerException {
        Preconditions.checkNotNull((Object)sourceBackupId);
        Preconditions.checkNotNull((Object)destinationBackup);
        String instanceName = destinationBackup.getInstanceId().getName();
        String backupId = destinationBackup.getId().getBackup();
        CopyBackupRequest.Builder requestBuilder = CopyBackupRequest.newBuilder().setParent(instanceName).setBackupId(backupId).setSourceBackup(sourceBackupId.getName()).setExpireTime(destinationBackup.getExpireTime().toProto());
        if (destinationBackup.getEncryptionConfig() != null) {
            requestBuilder.setEncryptionConfig(EncryptionConfigProtoMapper.copyBackupEncryptionConfig(destinationBackup.getEncryptionConfig()));
        }
        CopyBackupRequest request = requestBuilder.build();
        OperationFutureCallable<CopyBackupRequest, com.google.spanner.admin.database.v1.Backup, CopyBackupMetadata> callable = new OperationFutureCallable<CopyBackupRequest, com.google.spanner.admin.database.v1.Backup, CopyBackupMetadata>(this.databaseAdminStub.copyBackupOperationCallable(), request, DatabaseAdminGrpc.getCopyBackupMethod(), instanceName, nextPageToken -> this.listBackupOperations(instanceName, 0, String.format("(metadata.@type:type.googleapis.com/%s) AND (metadata.name:%s)", CopyBackupMetadata.getDescriptor().getFullName(), String.format("%s/backups/%s", instanceName, backupId)), nextPageToken), (Function<Operation, Timestamp>)((Function)input -> {
            try {
                return ((CopyBackupMetadata)input.getMetadata().unpack(CopyBackupMetadata.class)).getProgress().getStartTime();
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }));
        return (OperationFuture)RetryHelper.runWithRetries(callable, (RetrySettings)this.databaseAdminStubSettings.copyBackupOperationSettings().getInitialCallSettings().getRetrySettings(), new OperationFutureRetryAlgorithm(), (ApiClock)NanoClock.getDefaultClock());
    }

    @Override
    public OperationFuture<com.google.spanner.admin.database.v1.Database, RestoreDatabaseMetadata> restoreDatabase(Restore restore) {
        String databaseInstanceName = restore.getDestination().getInstanceId().getName();
        String databaseId = restore.getDestination().getDatabase();
        RestoreDatabaseRequest.Builder requestBuilder = RestoreDatabaseRequest.newBuilder().setParent(databaseInstanceName).setDatabaseId(databaseId).setBackup(restore.getSource().getName());
        if (restore.getEncryptionConfig() != null) {
            requestBuilder.setEncryptionConfig(EncryptionConfigProtoMapper.restoreDatabaseEncryptionConfig(restore.getEncryptionConfig()));
        }
        OperationFutureCallable<RestoreDatabaseRequest, com.google.spanner.admin.database.v1.Database, RestoreDatabaseMetadata> callable = new OperationFutureCallable<RestoreDatabaseRequest, com.google.spanner.admin.database.v1.Database, RestoreDatabaseMetadata>(this.databaseAdminStub.restoreDatabaseOperationCallable(), requestBuilder.build(), DatabaseAdminGrpc.getRestoreDatabaseMethod(), databaseInstanceName, nextPageToken -> this.listDatabaseOperations(databaseInstanceName, 0, String.format("(metadata.@type:type.googleapis.com/%s) AND (metadata.name:%s)", RestoreDatabaseMetadata.getDescriptor().getFullName(), String.format("%s/databases/%s", databaseInstanceName, databaseId)), nextPageToken), (Function<Operation, Timestamp>)((Function)input -> {
            try {
                return ((RestoreDatabaseMetadata)input.getMetadata().unpack(RestoreDatabaseMetadata.class)).getProgress().getStartTime();
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }));
        return (OperationFuture)RetryHelper.runWithRetries(callable, (RetrySettings)this.databaseAdminStubSettings.restoreDatabaseOperationSettings().getInitialCallSettings().getRetrySettings(), new OperationFutureRetryAlgorithm(), (ApiClock)NanoClock.getDefaultClock());
    }

    @Override
    public com.google.spanner.admin.database.v1.Backup updateBackup(com.google.spanner.admin.database.v1.Backup backup, FieldMask updateMask) {
        this.acquireAdministrativeRequestsRateLimiter();
        UpdateBackupRequest request = UpdateBackupRequest.newBuilder().setBackup(backup).setUpdateMask(updateMask).build();
        GrpcCallContext context = this.newCallContext(null, backup.getName(), request, DatabaseAdminGrpc.getUpdateBackupMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (com.google.spanner.admin.database.v1.Backup)this.databaseAdminStub.updateBackupCallable().call((Object)request, (ApiCallContext)context));
    }

    @Override
    public void deleteBackup(String backupName) {
        this.acquireAdministrativeRequestsRateLimiter();
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(backupName).build();
        GrpcCallContext context = this.newCallContext(null, backupName, request, DatabaseAdminGrpc.getDeleteBackupMethod());
        this.runWithRetryOnAdministrativeRequestsExceeded(() -> {
            this.databaseAdminStub.deleteBackupCallable().call((Object)request, (ApiCallContext)context);
            return null;
        });
    }

    @Override
    public com.google.spanner.admin.database.v1.Backup getBackup(String backupName) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(backupName).build();
        GrpcCallContext context = this.newCallContext(null, backupName, request, DatabaseAdminGrpc.getGetBackupMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (com.google.spanner.admin.database.v1.Backup)GapicSpannerRpc.get(this.databaseAdminStub.getBackupCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public Operation getOperation(String name) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(name).build();
        GrpcCallContext context = this.newCallContext(null, name, request, OperationsGrpc.getGetOperationMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (Operation)GapicSpannerRpc.get(this.databaseAdminStub.getOperationsStub().getOperationCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public void cancelOperation(String name) throws SpannerException {
        this.acquireAdministrativeRequestsRateLimiter();
        CancelOperationRequest request = CancelOperationRequest.newBuilder().setName(name).build();
        GrpcCallContext context = this.newCallContext(null, name, request, OperationsGrpc.getCancelOperationMethod());
        this.runWithRetryOnAdministrativeRequestsExceeded(() -> {
            GapicSpannerRpc.get(this.databaseAdminStub.getOperationsStub().cancelOperationCallable().futureCall((Object)request, (ApiCallContext)context));
            return null;
        });
    }

    @Override
    public List<Session> batchCreateSessions(String databaseName, int sessionCount, @Nullable String databaseRole, @Nullable Map<String, String> labels, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        BatchCreateSessionsRequest.Builder requestBuilder = BatchCreateSessionsRequest.newBuilder().setDatabase(databaseName).setSessionCount(sessionCount);
        Session.Builder sessionBuilder = Session.newBuilder();
        if (labels != null && !labels.isEmpty()) {
            sessionBuilder.putAllLabels(labels);
        }
        if (databaseRole != null && !databaseRole.isEmpty()) {
            sessionBuilder.setCreatorRole(databaseRole);
        }
        requestBuilder.setSessionTemplate(sessionBuilder);
        BatchCreateSessionsRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(options, databaseName, request, SpannerGrpc.getBatchCreateSessionsMethod(), true);
        return ((BatchCreateSessionsResponse)GapicSpannerRpc.get(this.spannerStub.batchCreateSessionsCallable().futureCall((Object)request, (ApiCallContext)context))).getSessionList();
    }

    @Override
    public Session createSession(String databaseName, @Nullable String databaseRole, @Nullable Map<String, String> labels, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        CreateSessionRequest.Builder requestBuilder = CreateSessionRequest.newBuilder().setDatabase(databaseName);
        Session.Builder sessionBuilder = Session.newBuilder();
        if (labels != null && !labels.isEmpty()) {
            sessionBuilder.putAllLabels(labels);
        }
        if (databaseRole != null && !databaseRole.isEmpty()) {
            sessionBuilder.setCreatorRole(databaseRole);
        }
        requestBuilder.setSession(sessionBuilder);
        CreateSessionRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(options, databaseName, request, SpannerGrpc.getCreateSessionMethod(), true);
        return (Session)GapicSpannerRpc.get(this.spannerStub.createSessionCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public void deleteSession(String sessionName, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GapicSpannerRpc.get(this.asyncDeleteSession(sessionName, options));
    }

    @Override
    public ApiFuture<Empty> asyncDeleteSession(String sessionName, @Nullable Map<SpannerRpc.Option, ?> options) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(sessionName).build();
        GrpcCallContext context = this.newCallContext(options, sessionName, request, SpannerGrpc.getDeleteSessionMethod());
        return this.spannerStub.deleteSessionCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public RetrySettings getReadRetrySettings() {
        return this.readRetrySettings;
    }

    @Override
    public Set<StatusCode.Code> getReadRetryableCodes() {
        return this.readRetryableCodes;
    }

    @Override
    public SpannerRpc.StreamingCall read(ReadRequest request, SpannerRpc.ResultStreamConsumer consumer, @Nullable Map<SpannerRpc.Option, ?> options, boolean routeToLeader) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getReadMethod(), routeToLeader);
        SpannerResponseObserver responseObserver = new SpannerResponseObserver(consumer);
        this.spannerStub.streamingReadCallable().call((Object)request, (ResponseObserver)responseObserver, (ApiCallContext)context);
        return new GrpcStreamingCall((ApiCallContext)context, responseObserver.getController());
    }

    @Override
    public RetrySettings getExecuteQueryRetrySettings() {
        return this.executeQueryRetrySettings;
    }

    @Override
    public Set<StatusCode.Code> getExecuteQueryRetryableCodes() {
        return this.executeQueryRetryableCodes;
    }

    @Override
    public ResultSet executeQuery(ExecuteSqlRequest request, @Nullable Map<SpannerRpc.Option, ?> options, boolean routeToLeader) {
        return GapicSpannerRpc.get(this.executeQueryAsync(request, options, routeToLeader));
    }

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(ExecuteSqlRequest request, @Nullable Map<SpannerRpc.Option, ?> options, boolean routeToLeader) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getExecuteSqlMethod(), routeToLeader);
        return this.spannerStub.executeSqlCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public ResultSet executePartitionedDml(ExecuteSqlRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getExecuteSqlMethod(), true);
        return (ResultSet)GapicSpannerRpc.get(this.partitionedDmlStub.executeSqlCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public RetrySettings getPartitionedDmlRetrySettings() {
        return this.partitionedDmlRetrySettings;
    }

    @Override
    public ServerStream<PartialResultSet> executeStreamingPartitionedDml(ExecuteSqlRequest request, Map<SpannerRpc.Option, ?> options, Duration timeout) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getExecuteStreamingSqlMethod(), true);
        context = context.withTimeout(timeout).withStreamWaitTimeout(timeout);
        return this.partitionedDmlStub.executeStreamingSqlCallable().call((Object)request, (ApiCallContext)context);
    }

    @Override
    public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(BatchWriteRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getBatchWriteMethod());
        return this.spannerStub.batchWriteCallable().call((Object)request, (ApiCallContext)context);
    }

    @Override
    public SpannerRpc.StreamingCall executeQuery(ExecuteSqlRequest request, SpannerRpc.ResultStreamConsumer consumer, @Nullable Map<SpannerRpc.Option, ?> options, boolean routeToLeader) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getExecuteStreamingSqlMethod(), routeToLeader);
        SpannerResponseObserver responseObserver = new SpannerResponseObserver(consumer);
        this.spannerStub.executeStreamingSqlCallable().call((Object)request, (ResponseObserver)responseObserver, (ApiCallContext)context);
        return new GrpcStreamingCall((ApiCallContext)context, responseObserver.getController());
    }

    @Override
    public ExecuteBatchDmlResponse executeBatchDml(ExecuteBatchDmlRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        return GapicSpannerRpc.get(this.executeBatchDmlAsync(request, options));
    }

    @Override
    public ApiFuture<ExecuteBatchDmlResponse> executeBatchDmlAsync(ExecuteBatchDmlRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getExecuteBatchDmlMethod(), true);
        return this.spannerStub.executeBatchDmlCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public ApiFuture<Transaction> beginTransactionAsync(BeginTransactionRequest request, @Nullable Map<SpannerRpc.Option, ?> options, boolean routeToLeader) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getBeginTransactionMethod(), routeToLeader);
        return this.spannerStub.beginTransactionCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public Transaction beginTransaction(BeginTransactionRequest request, @Nullable Map<SpannerRpc.Option, ?> options, boolean routeToLeader) throws SpannerException {
        return GapicSpannerRpc.get(this.beginTransactionAsync(request, options, routeToLeader));
    }

    @Override
    public ApiFuture<CommitResponse> commitAsync(CommitRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getCommitMethod(), true);
        return this.spannerStub.commitCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public CommitResponse commit(CommitRequest commitRequest, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        return GapicSpannerRpc.get(this.commitAsync(commitRequest, options));
    }

    @Override
    public ApiFuture<Empty> rollbackAsync(RollbackRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getRollbackMethod(), true);
        return this.spannerStub.rollbackCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public void rollback(RollbackRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GapicSpannerRpc.get(this.rollbackAsync(request, options));
    }

    @Override
    public PartitionResponse partitionQuery(PartitionQueryRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getPartitionQueryMethod(), true);
        return (PartitionResponse)GapicSpannerRpc.get(this.spannerStub.partitionQueryCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public PartitionResponse partitionRead(PartitionReadRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), request, SpannerGrpc.getPartitionReadMethod(), true);
        return (PartitionResponse)GapicSpannerRpc.get(this.spannerStub.partitionReadCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public Policy getDatabaseAdminIAMPolicy(String resource, @Nullable GetPolicyOptions options) {
        this.acquireAdministrativeRequestsRateLimiter();
        GetIamPolicyRequest.Builder builder = GetIamPolicyRequest.newBuilder().setResource(resource);
        if (options != null) {
            builder.setOptions(options);
        }
        GetIamPolicyRequest request = builder.build();
        GrpcCallContext context = this.newCallContext(null, resource, request, DatabaseAdminGrpc.getGetIamPolicyMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (Policy)GapicSpannerRpc.get(this.databaseAdminStub.getIamPolicyCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public Policy setDatabaseAdminIAMPolicy(String resource, Policy policy) {
        this.acquireAdministrativeRequestsRateLimiter();
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        GrpcCallContext context = this.newCallContext(null, resource, request, DatabaseAdminGrpc.getSetIamPolicyMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (Policy)GapicSpannerRpc.get(this.databaseAdminStub.setIamPolicyCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public TestIamPermissionsResponse testDatabaseAdminIAMPermissions(String resource, Iterable<String> permissions) {
        this.acquireAdministrativeRequestsRateLimiter();
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        GrpcCallContext context = this.newCallContext(null, resource, request, DatabaseAdminGrpc.getTestIamPermissionsMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (TestIamPermissionsResponse)GapicSpannerRpc.get(this.databaseAdminStub.testIamPermissionsCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public Policy getInstanceAdminIAMPolicy(String resource) {
        this.acquireAdministrativeRequestsRateLimiter();
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        GrpcCallContext context = this.newCallContext(null, resource, request, InstanceAdminGrpc.getGetIamPolicyMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (Policy)GapicSpannerRpc.get(this.instanceAdminStub.getIamPolicyCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public Policy setInstanceAdminIAMPolicy(String resource, Policy policy) {
        this.acquireAdministrativeRequestsRateLimiter();
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        GrpcCallContext context = this.newCallContext(null, resource, request, InstanceAdminGrpc.getSetIamPolicyMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (Policy)GapicSpannerRpc.get(this.instanceAdminStub.setIamPolicyCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    @Override
    public TestIamPermissionsResponse testInstanceAdminIAMPermissions(String resource, Iterable<String> permissions) {
        this.acquireAdministrativeRequestsRateLimiter();
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        GrpcCallContext context = this.newCallContext(null, resource, request, InstanceAdminGrpc.getTestIamPermissionsMethod());
        return this.runWithRetryOnAdministrativeRequestsExceeded(() -> (TestIamPermissionsResponse)GapicSpannerRpc.get(this.instanceAdminStub.testIamPermissionsCallable().futureCall((Object)request, (ApiCallContext)context)));
    }

    private static <T> T get(Future<T> future) throws SpannerException {
        Context context = Context.current();
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(context, e);
        }
    }

    @Deprecated
    @VisibleForTesting
    GrpcCallContext newCallContext(@Nullable Map<SpannerRpc.Option, ?> options, String resource) {
        return this.newCallContext(options, resource, null, null);
    }

    @VisibleForTesting
    <ReqT, RespT> GrpcCallContext newCallContext(@Nullable Map<SpannerRpc.Option, ?> options, String resource, ReqT request, MethodDescriptor<ReqT, RespT> method) {
        return this.newCallContext(options, resource, request, method, false);
    }

    @VisibleForTesting
    <ReqT, RespT> GrpcCallContext newCallContext(@Nullable Map<SpannerRpc.Option, ?> options, String resource, ReqT request, MethodDescriptor<ReqT, RespT> method, boolean routeToLeader) {
        CallCredentials callCredentials;
        GrpcCallContext context = GrpcCallContext.createDefault();
        if (options != null) {
            context = context.withChannelAffinity(Integer.valueOf(SpannerRpc.Option.CHANNEL_HINT.getLong(options).intValue()));
        }
        if (this.compressorName != null) {
            context = context.withCallOptions(context.getCallOptions().withCompression(this.compressorName));
        }
        context = context.withExtraHeaders(this.metadataProvider.newExtraHeaders(resource, this.projectName));
        if (routeToLeader && this.leaderAwareRoutingEnabled) {
            context = context.withExtraHeaders(this.metadataProvider.newRouteToLeaderHeader());
        }
        if (this.callCredentialsProvider != null && (callCredentials = this.callCredentialsProvider.getCallCredentials()) != null) {
            context = context.withCallOptions(context.getCallOptions().withCallCredentials(callCredentials));
        }
        context = context.withStreamWaitTimeout(this.waitTimeout).withStreamIdleTimeout(this.idleTimeout);
        SpannerOptions.CallContextConfigurator configurator = (SpannerOptions.CallContextConfigurator)SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY.get();
        ApiCallContext apiCallContextFromContext = null;
        if (configurator != null) {
            apiCallContextFromContext = configurator.configure((ApiCallContext)context, request, method);
        }
        return (GrpcCallContext)context.merge(apiCallContextFromContext);
    }

    @Override
    public void shutdown() {
        this.rpcIsClosed = true;
        if (this.spannerStub != null) {
            this.spannerStub.close();
            this.partitionedDmlStub.close();
            this.instanceAdminStub.close();
            this.databaseAdminStub.close();
            this.spannerWatchdog.shutdown();
            try {
                this.spannerStub.awaitTermination(10L, TimeUnit.SECONDS);
                this.partitionedDmlStub.awaitTermination(10L, TimeUnit.SECONDS);
                this.instanceAdminStub.awaitTermination(10L, TimeUnit.SECONDS);
                this.databaseAdminStub.awaitTermination(10L, TimeUnit.SECONDS);
                this.spannerWatchdog.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }
    }

    public void shutdownNow() {
        this.rpcIsClosed = true;
        this.spannerStub.close();
        this.partitionedDmlStub.close();
        this.instanceAdminStub.close();
        this.databaseAdminStub.close();
        this.spannerWatchdog.shutdown();
        this.spannerStub.shutdownNow();
        this.partitionedDmlStub.shutdownNow();
        this.instanceAdminStub.shutdownNow();
        this.databaseAdminStub.shutdownNow();
        this.spannerWatchdog.shutdownNow();
    }

    @Override
    public boolean isClosed() {
        return this.rpcIsClosed;
    }

    private static Duration systemProperty(String name, int defaultValue) {
        String stringValue = System.getProperty(name, "");
        return Duration.ofSeconds((long)(stringValue.isEmpty() ? (long)defaultValue : (long)Integer.parseInt(stringValue)));
    }

    private static interface OperationsLister {
        public SpannerRpc.Paginated<Operation> listOperations(String var1);
    }

    @VisibleForTesting
    static final class AdminRequestsLimitExceededRetryAlgorithm<T>
    implements ResultRetryAlgorithm<T> {
        AdminRequestsLimitExceededRetryAlgorithm() {
        }

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, T prevResponse, TimedAttemptSettings prevSettings) {
            return null;
        }

        public boolean shouldRetry(Throwable prevThrowable, T prevResponse) throws CancellationException {
            return prevThrowable instanceof AdminRequestsPerMinuteExceededException;
        }
    }

    private static final class TimestampComparator
    implements Comparator<Timestamp> {
        private static final TimestampComparator INSTANCE = new TimestampComparator();

        private TimestampComparator() {
        }

        @Override
        public int compare(Timestamp t1, Timestamp t2) {
            if (t1 == null && t2 == null) {
                return 0;
            }
            if (t1 != null && t2 == null) {
                return 1;
            }
            if (t1 == null && t2 != null) {
                return -1;
            }
            if (t1.getSeconds() > t2.getSeconds() || t1.getSeconds() == t2.getSeconds() && t1.getNanos() > t2.getNanos()) {
                return 1;
            }
            if (t1.getSeconds() < t2.getSeconds() || t1.getSeconds() == t2.getSeconds() && t1.getNanos() < t2.getNanos()) {
                return -1;
            }
            return 0;
        }
    }

    private final class OperationFutureCallable<RequestT, ResponseT, MetadataT extends Message>
    implements Callable<OperationFuture<ResponseT, MetadataT>> {
        final OperationCallable<RequestT, ResponseT, MetadataT> operationCallable;
        final RequestT initialRequest;
        final MethodDescriptor<RequestT, Operation> method;
        final String instanceName;
        final OperationsLister lister;
        final Function<Operation, Timestamp> getStartTimeFunction;
        Timestamp initialCallTime;
        boolean isRetry = false;

        OperationFutureCallable(OperationCallable<RequestT, ResponseT, MetadataT> operationCallable, RequestT initialRequest, MethodDescriptor<RequestT, Operation> method, String instanceName, OperationsLister lister, Function<Operation, Timestamp> getStartTimeFunction) {
            this.operationCallable = operationCallable;
            this.initialRequest = initialRequest;
            this.method = method;
            this.instanceName = instanceName;
            this.lister = lister;
            this.getStartTimeFunction = getStartTimeFunction;
        }

        @Override
        public OperationFuture<ResponseT, MetadataT> call() {
            GapicSpannerRpc.this.acquireAdministrativeRequestsRateLimiter();
            return (OperationFuture)GapicSpannerRpc.this.runWithRetryOnAdministrativeRequestsExceeded(() -> {
                String operationName = null;
                if (this.isRetry) {
                    Operation operation = GapicSpannerRpc.this.mostRecentOperation(this.lister, (Function<Operation, Timestamp>)this.getStartTimeFunction, this.initialCallTime);
                    if (operation != null) {
                        operationName = operation.getName();
                    }
                } else {
                    this.initialCallTime = Timestamp.newBuilder().setSeconds(TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS)).build();
                }
                this.isRetry = true;
                if (operationName == null) {
                    GrpcCallContext context = GapicSpannerRpc.this.newCallContext(null, this.instanceName, this.initialRequest, this.method);
                    return this.operationCallable.futureCall(this.initialRequest, (ApiCallContext)context);
                }
                return this.operationCallable.resumeFutureCall(operationName);
            });
        }
    }

    private static final class OperationFutureRetryAlgorithm<ResultT, MetadataT>
    implements ResultRetryAlgorithm<OperationFuture<ResultT, MetadataT>> {
        private static final ImmutableList<StatusCode.Code> RETRYABLE_CODES = ImmutableList.of((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE);

        private OperationFutureRetryAlgorithm() {
        }

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, OperationFuture<ResultT, MetadataT> prevResponse, TimedAttemptSettings prevSettings) {
            return null;
        }

        public boolean shouldRetry(Throwable prevThrowable, OperationFuture<ResultT, MetadataT> prevResponse) throws CancellationException {
            if (prevThrowable instanceof ApiException) {
                ApiException e = (ApiException)prevThrowable;
                return RETRYABLE_CODES.contains((Object)e.getStatusCode().getCode());
            }
            if (prevResponse != null) {
                try {
                    prevResponse.getInitialFuture().get();
                }
                catch (ExecutionException ee) {
                    Throwable cause = ee.getCause();
                    if (cause instanceof ApiException) {
                        ApiException e = (ApiException)cause;
                        return RETRYABLE_CODES.contains((Object)e.getStatusCode().getCode());
                    }
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return false;
        }
    }

    private static class SpannerResponseObserver
    implements ResponseObserver<PartialResultSet> {
        private StreamController controller;
        private final SpannerRpc.ResultStreamConsumer consumer;

        public SpannerResponseObserver(SpannerRpc.ResultStreamConsumer consumer) {
            this.consumer = consumer;
        }

        public void onStart(StreamController controller) {
            controller.disableAutoInboundFlowControl();
            this.controller = controller;
        }

        public void onResponse(PartialResultSet response) {
            this.consumer.onPartialResultSet(response);
        }

        public void onError(Throwable t) {
            this.consumer.onError(SpannerExceptionFactory.newSpannerException(t));
        }

        public void onComplete() {
            this.consumer.onCompleted();
        }

        StreamController getController() {
            return (StreamController)Preconditions.checkNotNull((Object)this.controller);
        }
    }

    private static final class GrpcStreamingCall
    implements SpannerRpc.StreamingCall {
        private final ApiCallContext callContext;
        private final StreamController controller;

        GrpcStreamingCall(ApiCallContext callContext, StreamController controller) {
            this.callContext = callContext;
            this.controller = controller;
        }

        @Override
        public ApiCallContext getCallContext() {
            return this.callContext;
        }

        @Override
        public void request(int numMessages) {
            this.controller.request(numMessages);
        }

        @Override
        public void cancel(@Nullable String message) {
            this.controller.cancel();
        }
    }
}

