/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractLazyInitializer;
import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.GrpcStruct;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ListValue;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.Value;
import com.google.spanner.v1.Transaction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.Base64;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractResultSet<R>
extends AbstractStructReader
implements ResultSet {
    AbstractResultSet() {
    }

    static double valueProtoToFloat64(com.google.protobuf.Value proto) {
        if (proto.getKindCase() == Value.KindCase.STRING_VALUE) {
            switch (proto.getStringValue()) {
                case "-Infinity": {
                    return Double.NEGATIVE_INFINITY;
                }
                case "Infinity": {
                    return Double.POSITIVE_INFINITY;
                }
                case "NaN": {
                    return Double.NaN;
                }
            }
        }
        if (proto.getKindCase() != Value.KindCase.NUMBER_VALUE) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value for column type " + Type.float64() + " expected NUMBER_VALUE or STRING_VALUE with value one of \"Infinity\", \"-Infinity\", or \"NaN\" but was " + proto.getKindCase() + (proto.getKindCase() == Value.KindCase.STRING_VALUE ? " with value \"" + proto.getStringValue() + "\"" : ""));
        }
        return proto.getNumberValue();
    }

    static NullPointerException throwNotNull(int columnIndex) {
        throw new NullPointerException("Cannot call array getter for column " + columnIndex + " with null elements");
    }

    protected abstract GrpcStruct currRow();

    @Override
    public Struct getCurrentRowAsStruct() {
        return this.currRow().immutableCopy();
    }

    @Override
    protected boolean getBooleanInternal(int columnIndex) {
        return this.currRow().getBooleanInternal(columnIndex);
    }

    @Override
    protected long getLongInternal(int columnIndex) {
        return this.currRow().getLongInternal(columnIndex);
    }

    @Override
    protected double getDoubleInternal(int columnIndex) {
        return this.currRow().getDoubleInternal(columnIndex);
    }

    @Override
    protected BigDecimal getBigDecimalInternal(int columnIndex) {
        return this.currRow().getBigDecimalInternal(columnIndex);
    }

    @Override
    protected String getStringInternal(int columnIndex) {
        return this.currRow().getStringInternal(columnIndex);
    }

    @Override
    protected <T extends AbstractMessage> T getProtoMessageInternal(int columnIndex, T message) {
        return this.currRow().getProtoMessageInternal(columnIndex, message);
    }

    @Override
    protected <T extends ProtocolMessageEnum> T getProtoEnumInternal(int columnIndex, Function<Integer, ProtocolMessageEnum> method) {
        return this.currRow().getProtoEnumInternal(columnIndex, method);
    }

    @Override
    protected String getJsonInternal(int columnIndex) {
        return this.currRow().getJsonInternal(columnIndex);
    }

    @Override
    protected String getPgJsonbInternal(int columnIndex) {
        return this.currRow().getPgJsonbInternal(columnIndex);
    }

    @Override
    protected ByteArray getBytesInternal(int columnIndex) {
        return this.currRow().getBytesInternal(columnIndex);
    }

    @Override
    protected Timestamp getTimestampInternal(int columnIndex) {
        return this.currRow().getTimestampInternal(columnIndex);
    }

    @Override
    protected Date getDateInternal(int columnIndex) {
        return this.currRow().getDateInternal(columnIndex);
    }

    @Override
    protected Value getValueInternal(int columnIndex) {
        return this.currRow().getValueInternal(columnIndex);
    }

    @Override
    protected boolean[] getBooleanArrayInternal(int columnIndex) {
        return this.currRow().getBooleanArrayInternal(columnIndex);
    }

    @Override
    protected List<Boolean> getBooleanListInternal(int columnIndex) {
        return this.currRow().getBooleanListInternal(columnIndex);
    }

    @Override
    protected long[] getLongArrayInternal(int columnIndex) {
        return this.currRow().getLongArrayInternal(columnIndex);
    }

    @Override
    protected List<Long> getLongListInternal(int columnIndex) {
        return this.currRow().getLongListInternal(columnIndex);
    }

    @Override
    protected double[] getDoubleArrayInternal(int columnIndex) {
        return this.currRow().getDoubleArrayInternal(columnIndex);
    }

    @Override
    protected List<Double> getDoubleListInternal(int columnIndex) {
        return this.currRow().getDoubleListInternal(columnIndex);
    }

    @Override
    protected List<BigDecimal> getBigDecimalListInternal(int columnIndex) {
        return this.currRow().getBigDecimalListInternal(columnIndex);
    }

    @Override
    protected List<String> getStringListInternal(int columnIndex) {
        return this.currRow().getStringListInternal(columnIndex);
    }

    @Override
    protected List<String> getJsonListInternal(int columnIndex) {
        return this.currRow().getJsonListInternal(columnIndex);
    }

    @Override
    protected List<String> getPgJsonbListInternal(int columnIndex) {
        return this.currRow().getJsonListInternal(columnIndex);
    }

    @Override
    protected List<ByteArray> getBytesListInternal(int columnIndex) {
        return this.currRow().getBytesListInternal(columnIndex);
    }

    @Override
    protected <T extends AbstractMessage> List<T> getProtoMessageListInternal(int columnIndex, T message) {
        return this.currRow().getProtoMessageListInternal(columnIndex, message);
    }

    @Override
    protected <T extends ProtocolMessageEnum> List<T> getProtoEnumListInternal(int columnIndex, Function<Integer, ProtocolMessageEnum> method) {
        return this.currRow().getProtoEnumListInternal(columnIndex, method);
    }

    @Override
    protected List<Timestamp> getTimestampListInternal(int columnIndex) {
        return this.currRow().getTimestampListInternal(columnIndex);
    }

    @Override
    protected List<Date> getDateListInternal(int columnIndex) {
        return this.currRow().getDateListInternal(columnIndex);
    }

    @Override
    protected List<Struct> getStructListInternal(int columnIndex) {
        return this.currRow().getStructListInternal(columnIndex);
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.currRow().isNull(columnIndex);
    }

    static class Int64Array
    extends PrimitiveArray<Long, long[]> {
        Int64Array(ListValue protoList) {
            super(protoList);
        }

        Int64Array(long[] data, BitSet nulls) {
            super(data, nulls, data.length);
        }

        @Override
        long[] newArray(int size) {
            return new long[size];
        }

        @Override
        void setProto(long[] array, int i, com.google.protobuf.Value protoValue) {
            array[i] = Long.parseLong(protoValue.getStringValue());
        }

        @Override
        Long get(long[] array, int i) {
            return array[i];
        }
    }

    static class Float64Array
    extends PrimitiveArray<Double, double[]> {
        Float64Array(ListValue protoList) {
            super(protoList);
        }

        Float64Array(double[] data, BitSet nulls) {
            super(data, nulls, data.length);
        }

        @Override
        double[] newArray(int size) {
            return new double[size];
        }

        @Override
        void setProto(double[] array, int i, com.google.protobuf.Value protoValue) {
            array[i] = AbstractResultSet.valueProtoToFloat64(protoValue);
        }

        @Override
        Double get(double[] array, int i) {
            return array[i];
        }
    }

    static abstract class PrimitiveArray<T, A>
    extends AbstractList<T> {
        private final A data;
        private final BitSet nulls;
        private final int size;

        PrimitiveArray(ListValue protoList) {
            this.size = protoList.getValuesCount();
            A data = this.newArray(this.size);
            BitSet nulls = new BitSet(this.size);
            for (int i = 0; i < protoList.getValuesCount(); ++i) {
                if (protoList.getValues(i).getKindCase() == Value.KindCase.NULL_VALUE) {
                    nulls.set(i);
                    continue;
                }
                this.setProto(data, i, protoList.getValues(i));
            }
            this.data = data;
            this.nulls = nulls;
        }

        PrimitiveArray(A data, BitSet nulls, int size) {
            this.data = data;
            this.nulls = nulls;
            this.size = size;
        }

        abstract A newArray(int var1);

        abstract void setProto(A var1, int var2, com.google.protobuf.Value var3);

        abstract T get(A var1, int var2);

        @Override
        public T get(int index) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException("index=" + index + " size=" + this.size);
            }
            return this.nulls.get(index) ? null : (T)this.get(this.data, index);
        }

        @Override
        public int size() {
            return this.size;
        }

        A toPrimitiveArray(int columnIndex) {
            if (this.nulls.length() > 0) {
                throw AbstractResultSet.throwNotNull(columnIndex);
            }
            A r = this.newArray(this.size);
            System.arraycopy(this.data, 0, r, 0, this.size);
            return r;
        }
    }

    @VisibleForTesting
    static interface CloseableIterator<T>
    extends Iterator<T> {
        public void close(@Nullable String var1);

        public boolean isWithBeginTransaction();
    }

    static final class LazyByteArray
    implements Serializable {
        private static final Base64.Encoder ENCODER = Base64.getEncoder();
        private static final Base64.Decoder DECODER = Base64.getDecoder();
        private final String base64String;
        private transient AbstractLazyInitializer<ByteArray> byteArray;

        LazyByteArray(@Nonnull String base64String) {
            this.base64String = (String)Preconditions.checkNotNull((Object)base64String);
            this.byteArray = this.defaultInitializer();
        }

        LazyByteArray(final @Nonnull ByteArray byteArray) {
            this.base64String = ENCODER.encodeToString(((ByteArray)Preconditions.checkNotNull((Object)byteArray)).toByteArray());
            this.byteArray = new AbstractLazyInitializer<ByteArray>(){

                @Override
                protected ByteArray initialize() {
                    return byteArray;
                }
            };
        }

        private AbstractLazyInitializer<ByteArray> defaultInitializer() {
            return new AbstractLazyInitializer<ByteArray>(){

                @Override
                protected ByteArray initialize() {
                    return ByteArray.copyFrom((byte[])DECODER.decode(base64String));
                }
            };
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.byteArray = this.defaultInitializer();
        }

        ByteArray getByteArray() {
            try {
                return this.byteArray.get();
            }
            catch (Throwable t) {
                throw SpannerExceptionFactory.asSpannerException(t);
            }
        }

        String getBase64String() {
            return this.base64String;
        }

        public String toString() {
            return this.getBase64String();
        }

        public int hashCode() {
            return this.base64String.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof LazyByteArray) {
                return this.lazyByteArraysEqual((LazyByteArray)o);
            }
            return false;
        }

        private boolean lazyByteArraysEqual(LazyByteArray other) {
            return Objects.equals(this.getBase64String(), other.getBase64String());
        }
    }

    static interface Listener {
        public void onTransactionMetadata(Transaction var1, boolean var2) throws SpannerException;

        public SpannerException onError(SpannerException var1, boolean var2);

        public void onDone(boolean var1);
    }
}

