/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Dialect;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeAnnotationCode;
import com.google.spanner.v1.TypeCode;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Type
implements Serializable {
    private static final Type TYPE_BOOL = new Type(Code.BOOL, null, null);
    private static final Type TYPE_INT64 = new Type(Code.INT64, null, null);
    private static final Type TYPE_FLOAT64 = new Type(Code.FLOAT64, null, null);
    private static final Type TYPE_NUMERIC = new Type(Code.NUMERIC, null, null);
    private static final Type TYPE_PG_NUMERIC = new Type(Code.PG_NUMERIC, null, null);
    private static final Type TYPE_STRING = new Type(Code.STRING, null, null);
    private static final Type TYPE_JSON = new Type(Code.JSON, null, null);
    private static final Type TYPE_PG_JSONB = new Type(Code.PG_JSONB, null, null);
    private static final Type TYPE_BYTES = new Type(Code.BYTES, null, null);
    private static final Type TYPE_TIMESTAMP = new Type(Code.TIMESTAMP, null, null);
    private static final Type TYPE_DATE = new Type(Code.DATE, null, null);
    private static final Type TYPE_ARRAY_BOOL = new Type(Code.ARRAY, TYPE_BOOL, null);
    private static final Type TYPE_ARRAY_INT64 = new Type(Code.ARRAY, TYPE_INT64, null);
    private static final Type TYPE_ARRAY_FLOAT64 = new Type(Code.ARRAY, TYPE_FLOAT64, null);
    private static final Type TYPE_ARRAY_NUMERIC = new Type(Code.ARRAY, TYPE_NUMERIC, null);
    private static final Type TYPE_ARRAY_PG_NUMERIC = new Type(Code.ARRAY, TYPE_PG_NUMERIC, null);
    private static final Type TYPE_ARRAY_STRING = new Type(Code.ARRAY, TYPE_STRING, null);
    private static final Type TYPE_ARRAY_JSON = new Type(Code.ARRAY, TYPE_JSON, null);
    private static final Type TYPE_ARRAY_PG_JSONB = new Type(Code.ARRAY, TYPE_PG_JSONB, null);
    private static final Type TYPE_ARRAY_BYTES = new Type(Code.ARRAY, TYPE_BYTES, null);
    private static final Type TYPE_ARRAY_TIMESTAMP = new Type(Code.ARRAY, TYPE_TIMESTAMP, null);
    private static final Type TYPE_ARRAY_DATE = new Type(Code.ARRAY, TYPE_DATE, null);
    private static final int AMBIGUOUS_FIELD = -1;
    private static final long serialVersionUID = -3076152125004114582L;
    private final com.google.spanner.v1.Type proto;
    private final Code code;
    private final Type arrayElementType;
    private final ImmutableList<StructField> structFields;
    private String protoTypeFqn;
    private Map<String, Integer> fieldsByName;

    static Type unrecognized(com.google.spanner.v1.Type proto) {
        return new Type(proto);
    }

    public static Type bool() {
        return TYPE_BOOL;
    }

    public static Type int64() {
        return TYPE_INT64;
    }

    public static Type float64() {
        return TYPE_FLOAT64;
    }

    public static Type numeric() {
        return TYPE_NUMERIC;
    }

    public static Type pgNumeric() {
        return TYPE_PG_NUMERIC;
    }

    public static Type string() {
        return TYPE_STRING;
    }

    public static Type json() {
        return TYPE_JSON;
    }

    public static Type pgJsonb() {
        return TYPE_PG_JSONB;
    }

    public static Type proto(String protoTypeFqn) {
        return new Type(Code.PROTO, protoTypeFqn);
    }

    public static Type protoEnum(String protoTypeFqn) {
        return new Type(Code.ENUM, protoTypeFqn);
    }

    public static Type bytes() {
        return TYPE_BYTES;
    }

    public static Type timestamp() {
        return TYPE_TIMESTAMP;
    }

    public static Type date() {
        return TYPE_DATE;
    }

    public static Type array(Type elementType) {
        Preconditions.checkNotNull((Object)elementType);
        switch (elementType.getCode()) {
            case BOOL: {
                return TYPE_ARRAY_BOOL;
            }
            case INT64: {
                return TYPE_ARRAY_INT64;
            }
            case FLOAT64: {
                return TYPE_ARRAY_FLOAT64;
            }
            case NUMERIC: {
                return TYPE_ARRAY_NUMERIC;
            }
            case PG_NUMERIC: {
                return TYPE_ARRAY_PG_NUMERIC;
            }
            case STRING: {
                return TYPE_ARRAY_STRING;
            }
            case JSON: {
                return TYPE_ARRAY_JSON;
            }
            case PG_JSONB: {
                return TYPE_ARRAY_PG_JSONB;
            }
            case BYTES: {
                return TYPE_ARRAY_BYTES;
            }
            case TIMESTAMP: {
                return TYPE_ARRAY_TIMESTAMP;
            }
            case DATE: {
                return TYPE_ARRAY_DATE;
            }
        }
        return new Type(Code.ARRAY, elementType, null);
    }

    public static Type struct(Iterable<StructField> fields) {
        return new Type(Code.STRUCT, null, (ImmutableList<StructField>)ImmutableList.copyOf(fields));
    }

    public static Type struct(StructField ... fields) {
        return new Type(Code.STRUCT, null, (ImmutableList<StructField>)ImmutableList.copyOf((Object[])fields));
    }

    private Type(@Nonnull Code code, @Nullable Type arrayElementType, @Nullable ImmutableList<StructField> structFields) {
        this(null, (Code)((Object)Preconditions.checkNotNull((Object)((Object)code))), arrayElementType, structFields);
    }

    private Type(@Nonnull com.google.spanner.v1.Type proto) {
        this((com.google.spanner.v1.Type)Preconditions.checkNotNull((Object)proto), Code.UNRECOGNIZED, proto.hasArrayElementType() ? new Type(proto.getArrayElementType()) : null, null);
    }

    private Type(com.google.spanner.v1.Type proto, Code code, Type arrayElementType, ImmutableList<StructField> structFields) {
        this.proto = proto;
        this.code = code;
        this.arrayElementType = arrayElementType;
        this.structFields = structFields;
    }

    private Type(Code code, @Nonnull String protoTypeFqn) {
        this(code, null, null);
        this.protoTypeFqn = protoTypeFqn;
    }

    public Code getCode() {
        return this.code;
    }

    public Type getArrayElementType() {
        Preconditions.checkState((this.arrayElementType != null ? 1 : 0) != 0, (Object)"Illegal call for non-ARRAY type");
        return this.arrayElementType;
    }

    public List<StructField> getStructFields() {
        Preconditions.checkState((this.code == Code.STRUCT ? 1 : 0) != 0, (Object)"Illegal call for non-STRUCT type");
        return this.structFields;
    }

    public String getProtoTypeFqn() {
        Preconditions.checkState((this.code == Code.PROTO || this.code == Code.ENUM ? 1 : 0) != 0, (Object)"Illegal call for non-Proto type");
        return this.protoTypeFqn;
    }

    public int getFieldIndex(String fieldName) {
        Integer index;
        Preconditions.checkState((this.code == Code.STRUCT ? 1 : 0) != 0, (Object)"Illegal call for non-STRUCT type");
        if (this.fieldsByName == null) {
            TreeMap<String, Integer> tmp = new TreeMap<String, Integer>();
            for (int i = 0; i < this.getStructFields().size(); ++i) {
                StructField field = this.getStructFields().get(i);
                if (tmp.put(field.getName(), i) == null) continue;
                tmp.put(field.getName(), -1);
            }
            this.fieldsByName = ImmutableMap.copyOf(tmp);
        }
        if ((index = this.fieldsByName.get(fieldName)) == null) {
            throw new IllegalArgumentException("Field not found: " + fieldName);
        }
        if (index == -1) {
            throw new IllegalArgumentException("Ambiguous field name: " + fieldName);
        }
        return index;
    }

    void toString(StringBuilder b) {
        if (this.code == Code.ARRAY || this.proto != null && this.proto.hasArrayElementType()) {
            if (this.code == Code.ARRAY) {
                b.append("ARRAY<");
            } else {
                b.append("UNRECOGNIZED<");
            }
            this.arrayElementType.toString(b);
            b.append('>');
        } else if (this.code == Code.STRUCT) {
            b.append("STRUCT<");
            for (int i = 0; i < this.structFields.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                StructField f = (StructField)this.structFields.get(i);
                b.append(f.getName()).append(' ');
                f.getType().toString(b);
            }
            b.append('>');
        } else if (this.proto != null) {
            b.append(this.proto.getCode().name());
            if (this.proto.getTypeAnnotation() != TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED) {
                b.append("<").append(this.proto.getTypeAnnotation().name()).append(">");
            }
        } else {
            b.append(this.code.toString());
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public String getSpannerTypeName(Dialect dialect) {
        switch (dialect) {
            case POSTGRESQL: {
                return this.getTypeNamePostgreSQL();
            }
        }
        return this.getTypeNameGoogleSQL();
    }

    private String getTypeNameGoogleSQL() {
        if (this.code == Code.ARRAY) {
            return this.code.getGoogleSQLName() + "<" + this.arrayElementType.getTypeNameGoogleSQL() + ">";
        }
        return this.code.getGoogleSQLName();
    }

    private String getTypeNamePostgreSQL() {
        if (this.code == Code.ARRAY) {
            return this.arrayElementType.getTypeNamePostgreSQL() + "[]";
        }
        return this.code.getPostgreSQLName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type that = (Type)o;
        if (this.proto != null) {
            return Objects.equals(this.proto, that.proto);
        }
        return this.code == that.code && Objects.equals(this.arrayElementType, that.arrayElementType) && Objects.equals(this.structFields, that.structFields) && Objects.equals(this.protoTypeFqn, that.protoTypeFqn);
    }

    public int hashCode() {
        if (this.proto != null) {
            return this.proto.hashCode();
        }
        return Objects.hash(new Object[]{this.code, this.arrayElementType, this.structFields});
    }

    com.google.spanner.v1.Type toProto() {
        if (this.proto != null) {
            return this.proto;
        }
        Type.Builder proto = com.google.spanner.v1.Type.newBuilder();
        proto.setCode(this.code.getTypeCode());
        proto.setTypeAnnotation(this.code.getTypeAnnotationCode());
        if (this.code == Code.ARRAY) {
            proto.setArrayElementType(this.arrayElementType.toProto());
        } else if (this.code == Code.STRUCT) {
            StructType.Builder fields = proto.getStructTypeBuilder();
            for (StructField field : this.structFields) {
                fields.addFieldsBuilder().setName(field.getName()).setType(field.getType().toProto());
            }
        } else if (this.code == Code.PROTO || this.code == Code.ENUM) {
            proto.setProtoTypeFqn(this.protoTypeFqn);
        }
        return proto.build();
    }

    static Type fromProto(com.google.spanner.v1.Type proto) {
        Code type = Code.fromProto(proto.getCode(), proto.getTypeAnnotation());
        switch (type) {
            case BOOL: {
                return Type.bool();
            }
            case INT64: {
                return Type.int64();
            }
            case FLOAT64: {
                return Type.float64();
            }
            case NUMERIC: {
                return Type.numeric();
            }
            case PG_NUMERIC: {
                return Type.pgNumeric();
            }
            case STRING: {
                return Type.string();
            }
            case JSON: {
                return Type.json();
            }
            case PG_JSONB: {
                return Type.pgJsonb();
            }
            case BYTES: {
                return Type.bytes();
            }
            case TIMESTAMP: {
                return Type.timestamp();
            }
            case DATE: {
                return Type.date();
            }
            case PROTO: {
                return Type.proto(proto.getProtoTypeFqn());
            }
            case ENUM: {
                return Type.protoEnum(proto.getProtoTypeFqn());
            }
            case ARRAY: {
                Type elementType;
                Preconditions.checkArgument((boolean)proto.hasArrayElementType(), (String)"Missing expected 'array_element_type' field in 'Type' message: %s", (Object)proto);
                try {
                    elementType = Type.fromProto(proto.getArrayElementType());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Could not parse 'array_element_type' attribute in 'Type' message: " + proto, e);
                }
                return Type.array(elementType);
            }
            case STRUCT: {
                Preconditions.checkArgument((boolean)proto.hasStructType(), (String)"Missing expected 'struct_type' field in 'Type' message: %s", (Object)proto);
                ArrayList<StructField> fields = new ArrayList<StructField>(proto.getStructType().getFieldsCount());
                for (StructType.Field field : proto.getStructType().getFieldsList()) {
                    Preconditions.checkArgument((boolean)field.hasType(), (String)"Missing expected 'type' attribute in 'Field': %s", (Object)proto);
                    String name = Strings.nullToEmpty((String)field.getName());
                    fields.add(StructField.of(name, Type.fromProto(field.getType())));
                }
                return Type.struct(fields);
            }
        }
        return Type.unrecognized(proto);
    }

    public static enum Code {
        UNRECOGNIZED(TypeCode.UNRECOGNIZED, "unknown"),
        BOOL(TypeCode.BOOL, "boolean"),
        INT64(TypeCode.INT64, "bigint"),
        NUMERIC(TypeCode.NUMERIC, "unknown"),
        PG_NUMERIC(TypeCode.NUMERIC, "numeric", TypeAnnotationCode.PG_NUMERIC),
        FLOAT64(TypeCode.FLOAT64, "double precision"),
        STRING(TypeCode.STRING, "character varying"),
        JSON(TypeCode.JSON, "unknown"),
        PG_JSONB(TypeCode.JSON, "jsonb", TypeAnnotationCode.PG_JSONB),
        PROTO(TypeCode.PROTO, "proto"),
        ENUM(TypeCode.ENUM, "enum"),
        BYTES(TypeCode.BYTES, "bytea"),
        TIMESTAMP(TypeCode.TIMESTAMP, "timestamp with time zone"),
        DATE(TypeCode.DATE, "date"),
        ARRAY(TypeCode.ARRAY, "array"),
        STRUCT(TypeCode.STRUCT, "struct");

        private static final Map<Map.Entry<TypeCode, TypeAnnotationCode>, Code> protoToCode;
        private final String postgreSQLName;
        private final TypeCode typeCode;
        private final TypeAnnotationCode typeAnnotationCode;

        private Code(TypeCode typeCode, String postgreSQLName) {
            this(typeCode, postgreSQLName, TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED);
        }

        private Code(TypeCode typeCode, String postgreSQLName, TypeAnnotationCode typeAnnotationCode) {
            this.typeCode = typeCode;
            this.postgreSQLName = postgreSQLName;
            this.typeAnnotationCode = typeAnnotationCode;
        }

        TypeCode getTypeCode() {
            return this.typeCode;
        }

        TypeAnnotationCode getTypeAnnotationCode() {
            return this.typeAnnotationCode;
        }

        static Code fromProto(TypeCode typeCode, TypeAnnotationCode typeAnnotationCode) {
            Code code = protoToCode.get(new AbstractMap.SimpleEntry<TypeCode, TypeAnnotationCode>(typeCode, typeAnnotationCode));
            return code == null ? UNRECOGNIZED : code;
        }

        public String toString() {
            if (this.typeAnnotationCode == TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED) {
                return this.typeCode.toString();
            }
            return this.typeCode.toString() + "<" + this.typeAnnotationCode.toString() + ">";
        }

        private String getGoogleSQLName() {
            return this.name();
        }

        private String getPostgreSQLName() {
            return this.postgreSQLName;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Code code : Code.values()) {
                builder.put(new AbstractMap.SimpleEntry<TypeCode, TypeAnnotationCode>(code.getTypeCode(), code.getTypeAnnotationCode()), (Object)code);
            }
            protoToCode = builder.build();
        }
    }

    public static final class StructField
    implements Serializable {
        private static final long serialVersionUID = 8640511292704408210L;
        private final String name;
        private final Type type;

        public static StructField of(String name, Type type) {
            return new StructField(name, type);
        }

        private StructField(String name, Type type) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.type = (Type)Preconditions.checkNotNull((Object)type);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructField that = (StructField)o;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

