/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.AsyncStatementResult;
import com.google.cloud.spanner.connection.AsyncStatementResultImpl;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.DdlBatch;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.DmlBatch;
import com.google.cloud.spanner.connection.EmulatorUtil;
import com.google.cloud.spanner.connection.MergedResultSet;
import com.google.cloud.spanner.connection.PartitionId;
import com.google.cloud.spanner.connection.PartitionedQueryResultSet;
import com.google.cloud.spanner.connection.ReadOnlyTransaction;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.SingleUseTransaction;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.StatementResultImpl;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

class ConnectionImpl
implements Connection {
    private static final String CLOSED_ERROR_MSG = "This connection is closed";
    private static final String ONLY_ALLOWED_IN_AUTOCOMMIT = "This method may only be called while in autocommit mode";
    private static final String NOT_ALLOWED_IN_AUTOCOMMIT = "This method may not be called while in autocommit mode";
    private volatile LeakedConnectionException leakedException;
    private final SpannerPool spannerPool;
    private AbstractStatementParser statementParser;
    private final ConnectionStatementExecutor connectionStatementExecutor = new ConnectionStatementExecutorImpl(this);
    private final StatementExecutor statementExecutor;
    private final ConnectionOptions options;
    private StatementExecutor.StatementTimeout statementTimeout = new StatementExecutor.StatementTimeout();
    private boolean closed = false;
    private final Spanner spanner;
    private final DdlClient ddlClient;
    private final DatabaseClient dbClient;
    private final BatchClient batchClient;
    private boolean autocommit;
    private boolean readOnly;
    private boolean returnCommitStats;
    private boolean delayTransactionStartUntilFirstWrite;
    private UnitOfWork currentUnitOfWork = null;
    private boolean inTransaction = false;
    private boolean transactionBeginMarked = false;
    private BatchMode batchMode;
    private UnitOfWorkType unitOfWorkType;
    private final Stack<UnitOfWork> transactionStack = new Stack();
    private boolean retryAbortsInternally;
    private final List<TransactionRetryListener> transactionRetryListeners = new ArrayList<TransactionRetryListener>();
    private AutocommitDmlMode autocommitDmlMode = AutocommitDmlMode.TRANSACTIONAL;
    private TimestampBound readOnlyStaleness = TimestampBound.strong();
    private boolean autoPartitionMode;
    private boolean dataBoostEnabled;
    private int maxPartitions;
    private int maxPartitionedParallelism;
    private DirectedReadOptions directedReadOptions = null;
    private ExecuteSqlRequest.QueryOptions queryOptions = ExecuteSqlRequest.QueryOptions.getDefaultInstance();
    private Options.RpcPriority rpcPriority = null;
    private SavepointSupport savepointSupport = SavepointSupport.FAIL_AFTER_ROLLBACK;
    private String transactionTag;
    private String statementTag;
    private final Commit commit = new Commit();
    private final Rollback rollback = new Rollback();

    ConnectionImpl(ConnectionOptions options) {
        Preconditions.checkNotNull((Object)options);
        this.leakedException = options.isTrackConnectionLeaks() ? new LeakedConnectionException() : null;
        this.statementExecutor = new StatementExecutor(options.isUseVirtualThreads(), options.getStatementExecutionInterceptors());
        this.spannerPool = SpannerPool.INSTANCE;
        this.options = options;
        this.spanner = this.spannerPool.getSpanner(options, this);
        if (options.isAutoConfigEmulator()) {
            EmulatorUtil.maybeCreateInstanceAndDatabase(this.spanner, options.getDatabaseId(), options.getDialect());
        }
        this.dbClient = this.spanner.getDatabaseClient(options.getDatabaseId());
        this.batchClient = this.spanner.getBatchClient(options.getDatabaseId());
        this.retryAbortsInternally = options.isRetryAbortsInternally();
        this.readOnly = options.isReadOnly();
        this.autocommit = options.isAutocommit();
        this.queryOptions = this.queryOptions.toBuilder().mergeFrom(options.getQueryOptions()).build();
        this.rpcPriority = options.getRPCPriority();
        this.returnCommitStats = options.isReturnCommitStats();
        this.delayTransactionStartUntilFirstWrite = options.isDelayTransactionStartUntilFirstWrite();
        this.dataBoostEnabled = options.isDataBoostEnabled();
        this.autoPartitionMode = options.isAutoPartitionMode();
        this.maxPartitions = options.getMaxPartitions();
        this.maxPartitionedParallelism = options.getMaxPartitionedParallelism();
        this.ddlClient = this.createDdlClient();
        this.setDefaultTransactionOptions();
    }

    @VisibleForTesting
    ConnectionImpl(ConnectionOptions options, SpannerPool spannerPool, DdlClient ddlClient, DatabaseClient dbClient, BatchClient batchClient) {
        this.leakedException = options.isTrackConnectionLeaks() ? new LeakedConnectionException() : null;
        this.statementExecutor = new StatementExecutor(options.isUseVirtualThreads(), Collections.emptyList());
        this.spannerPool = (SpannerPool)Preconditions.checkNotNull((Object)spannerPool);
        this.options = (ConnectionOptions)Preconditions.checkNotNull((Object)options);
        this.spanner = spannerPool.getSpanner(options, this);
        this.ddlClient = (DdlClient)Preconditions.checkNotNull((Object)ddlClient);
        this.dbClient = (DatabaseClient)Preconditions.checkNotNull((Object)dbClient);
        this.batchClient = (BatchClient)Preconditions.checkNotNull((Object)batchClient);
        this.setReadOnly(options.isReadOnly());
        this.setAutocommit(options.isAutocommit());
        this.setReturnCommitStats(options.isReturnCommitStats());
        this.setDefaultTransactionOptions();
    }

    @VisibleForTesting
    Spanner getSpanner() {
        return this.spanner;
    }

    private DdlClient createDdlClient() {
        return DdlClient.newBuilder().setDatabaseAdminClient(this.spanner.getDatabaseAdminClient()).setInstanceId(this.options.getInstanceId()).setDatabaseName(this.options.getDatabaseName()).build();
    }

    private AbstractStatementParser getStatementParser() {
        if (this.statementParser == null) {
            this.statementParser = AbstractStatementParser.getInstance(this.dbClient.getDialect());
        }
        return this.statementParser;
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get(10L, TimeUnit.SECONDS);
        }
        catch (SpannerException | InterruptedException | ExecutionException | TimeoutException object) {
        }
        finally {
            this.statementExecutor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Void> closeAsync() {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed()) {
                ArrayList<ApiFuture<Void>> futures = new ArrayList<ApiFuture<Void>>();
                if (this.isBatchActive()) {
                    this.abortBatch();
                }
                if (this.isTransactionStarted()) {
                    try {
                        futures.add(this.rollbackAsync());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.closed = true;
                try {
                    futures.add(this.statementExecutor.submit(() -> null));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
                this.statementExecutor.shutdown();
                this.leakedException = null;
                this.spannerPool.removeConnection(this.options, this);
                return ApiFutures.transform((ApiFuture)ApiFutures.allAsList(futures), ignored -> null, (Executor)MoreExecutors.directExecutor());
            }
        }
        return ApiFutures.immediateFuture(null);
    }

    UnitOfWorkType getUnitOfWorkType() {
        return this.unitOfWorkType;
    }

    BatchMode getBatchMode() {
        return this.batchMode;
    }

    boolean isInBatch() {
        return this.batchMode != BatchMode.NONE;
    }

    LeakedConnectionException getLeakedException() {
        return this.leakedException;
    }

    @Override
    public Dialect getDialect() {
        return this.dbClient.getDialect();
    }

    @Override
    public DatabaseClient getDatabaseClient() {
        return this.dbClient;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setAutocommit(boolean autocommit) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        if (this.isAutocommit() == autocommit) {
            return;
        }
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set autocommit while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set autocommit while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot set autocommit while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot set autocommit when a transaction has begun");
        this.autocommit = autocommit;
        this.clearLastTransactionAndSetDefaultTransactionOptions();
        if (!(autocommit || this.readOnlyStaleness.getMode() != TimestampBound.Mode.MAX_STALENESS && this.readOnlyStaleness.getMode() != TimestampBound.Mode.MIN_READ_TIMESTAMP)) {
            this.readOnlyStaleness = TimestampBound.strong();
        }
    }

    @Override
    public boolean isAutocommit() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsAutocommit();
    }

    private boolean internalIsAutocommit() {
        return this.autocommit;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set read-only while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set read-only while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot set read-only while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot set read-only when a transaction has begun");
        this.readOnly = readOnly;
        this.clearLastTransactionAndSetDefaultTransactionOptions();
    }

    @Override
    public boolean isReadOnly() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.readOnly;
    }

    private void clearLastTransactionAndSetDefaultTransactionOptions() {
        this.setDefaultTransactionOptions();
        this.currentUnitOfWork = null;
    }

    @Override
    public void setAutocommitDmlMode(AutocommitDmlMode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set autocommit DML mode while in a batch");
        ConnectionPreconditions.checkState(!this.isInTransaction() && this.isAutocommit(), "Cannot set autocommit DML mode while not in autocommit mode or while a transaction is active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot set autocommit DML mode for a read-only connection");
        this.autocommitDmlMode = mode;
    }

    @Override
    public AutocommitDmlMode getAutocommitDmlMode() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot get autocommit DML mode while in a batch");
        return this.autocommitDmlMode;
    }

    @Override
    public void setReadOnlyStaleness(TimestampBound staleness) {
        Preconditions.checkNotNull((Object)staleness);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set read-only while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set read-only staleness when a transaction has been started");
        if (staleness.getMode() == TimestampBound.Mode.MAX_STALENESS || staleness.getMode() == TimestampBound.Mode.MIN_READ_TIMESTAMP) {
            ConnectionPreconditions.checkState(this.isAutocommit() && !this.inTransaction, "MAX_STALENESS and MIN_READ_TIMESTAMP are only allowed in autocommit mode");
        }
        this.readOnlyStaleness = staleness;
    }

    @Override
    public TimestampBound getReadOnlyStaleness() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot get read-only while in a batch");
        return this.readOnlyStaleness;
    }

    @Override
    public void setDirectedRead(DirectedReadOptions directedReadOptions) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set directed read options when a transaction has been started");
        this.directedReadOptions = directedReadOptions;
    }

    @Override
    public DirectedReadOptions getDirectedRead() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.directedReadOptions;
    }

    @Override
    public void setOptimizerVersion(String optimizerVersion) {
        Preconditions.checkNotNull((Object)optimizerVersion);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.queryOptions = this.queryOptions.toBuilder().setOptimizerVersion(optimizerVersion).build();
    }

    @Override
    public String getOptimizerVersion() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.queryOptions.getOptimizerVersion();
    }

    @Override
    public void setOptimizerStatisticsPackage(String optimizerStatisticsPackage) {
        Preconditions.checkNotNull((Object)optimizerStatisticsPackage);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.queryOptions = this.queryOptions.toBuilder().setOptimizerStatisticsPackage(optimizerStatisticsPackage).build();
    }

    @Override
    public String getOptimizerStatisticsPackage() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.queryOptions.getOptimizerStatisticsPackage();
    }

    @Override
    public void setRPCPriority(Options.RpcPriority rpcPriority) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.rpcPriority = rpcPriority;
    }

    @Override
    public Options.RpcPriority getRPCPriority() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.rpcPriority;
    }

    @Override
    public void setStatementTimeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"Zero or negative timeout values are not allowed");
        Preconditions.checkArgument((boolean)StatementExecutor.StatementTimeout.isValidTimeoutUnit(unit), (Object)"Time unit must be one of NANOSECONDS, MICROSECONDS, MILLISECONDS or SECONDS");
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.statementTimeout.setTimeoutValue(timeout, unit);
    }

    @Override
    public void clearStatementTimeout() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.statementTimeout.clearTimeoutValue();
    }

    @Override
    public long getStatementTimeout(TimeUnit unit) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        Preconditions.checkArgument((boolean)StatementExecutor.StatementTimeout.isValidTimeoutUnit(unit), (Object)"Time unit must be one of NANOSECONDS, MICROSECONDS, MILLISECONDS or SECONDS");
        return this.statementTimeout.getTimeoutValue(unit);
    }

    @Override
    public boolean hasStatementTimeout() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.statementTimeout.hasTimeout();
    }

    @Override
    public void cancel() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        if (this.currentUnitOfWork != null) {
            this.currentUnitOfWork.cancel();
        }
    }

    @Override
    public TransactionMode getTransactionMode() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isDdlBatchActive(), "This connection is in a DDL batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        return this.unitOfWorkType.getTransactionMode();
    }

    @Override
    public void setTransactionMode(TransactionMode transactionMode) {
        Preconditions.checkNotNull((Object)((Object)transactionMode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set transaction mode while in a batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "The transaction mode cannot be set after the transaction has started");
        ConnectionPreconditions.checkState(!this.isReadOnly() || transactionMode == TransactionMode.READ_ONLY_TRANSACTION, "The transaction mode can only be READ_ONLY when the connection is in read_only mode");
        this.transactionBeginMarked = true;
        this.unitOfWorkType = UnitOfWorkType.of(transactionMode);
    }

    @Override
    public String getTransactionTag() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isDdlBatchActive(), "This connection is in a DDL batch");
        return this.transactionTag;
    }

    @Override
    public void setTransactionTag(String tag) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set transaction tag while in a batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "The transaction tag cannot be set after the transaction has started");
        ConnectionPreconditions.checkState(this.getTransactionMode() == TransactionMode.READ_WRITE_TRANSACTION, "Transaction tag can only be set for a read/write transaction");
        this.transactionBeginMarked = true;
        this.transactionTag = tag;
    }

    @Override
    public String getStatementTag() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Statement tags are not allowed inside a batch");
        return this.statementTag;
    }

    @Override
    public void setStatementTag(String tag) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Statement tags are not allowed inside a batch");
        this.statementTag = tag;
    }

    private void checkSetRetryAbortsInternallyAvailable() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "RetryAbortsInternally cannot be set after the transaction has started");
    }

    @Override
    public boolean isRetryAbortsInternally() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.retryAbortsInternally;
    }

    @Override
    public void setRetryAbortsInternally(boolean retryAbortsInternally) {
        this.checkSetRetryAbortsInternallyAvailable();
        this.retryAbortsInternally = retryAbortsInternally;
    }

    @Override
    public void addTransactionRetryListener(TransactionRetryListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.transactionRetryListeners.add(listener);
    }

    @Override
    public boolean removeTransactionRetryListener(TransactionRetryListener listener) {
        Preconditions.checkNotNull((Object)listener);
        return this.transactionRetryListeners.remove(listener);
    }

    @Override
    public Iterator<TransactionRetryListener> getTransactionRetryListeners() {
        return Collections.unmodifiableList(this.transactionRetryListeners).iterator();
    }

    @Override
    public boolean isInTransaction() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsInTransaction();
    }

    private boolean internalIsInTransaction() {
        return !this.isDdlBatchActive() && (!this.internalIsAutocommit() || this.inTransaction);
    }

    @Override
    public boolean isTransactionStarted() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsTransactionStarted();
    }

    private boolean internalIsTransactionStarted() {
        if (this.internalIsAutocommit() && !this.inTransaction) {
            return false;
        }
        return this.internalIsInTransaction() && this.currentUnitOfWork != null && this.currentUnitOfWork.getState() == UnitOfWork.UnitOfWorkState.STARTED;
    }

    @Override
    public Timestamp getReadTimestamp() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getReadTimestamp();
    }

    Timestamp getReadTimestampOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getReadTimestampOrNull();
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getCommitTimestamp();
    }

    Timestamp getCommitTimestampOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getCommitTimestampOrNull();
    }

    @Override
    public CommitResponse getCommitResponse() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getCommitResponse();
    }

    CommitResponse getCommitResponseOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getCommitResponseOrNull();
    }

    @Override
    public void setReturnCommitStats(boolean returnCommitStats) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.returnCommitStats = returnCommitStats;
    }

    @Override
    public boolean isReturnCommitStats() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.returnCommitStats;
    }

    @Override
    public void setDelayTransactionStartUntilFirstWrite(boolean delayTransactionStartUntilFirstWrite) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set DelayTransactionStartUntilFirstWrite while a transaction is active");
        this.delayTransactionStartUntilFirstWrite = delayTransactionStartUntilFirstWrite;
    }

    @Override
    public boolean isDelayTransactionStartUntilFirstWrite() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.delayTransactionStartUntilFirstWrite;
    }

    private void setDefaultTransactionOptions() {
        if (this.transactionStack.isEmpty()) {
            this.unitOfWorkType = this.isReadOnly() ? UnitOfWorkType.READ_ONLY_TRANSACTION : UnitOfWorkType.READ_WRITE_TRANSACTION;
            this.batchMode = BatchMode.NONE;
            this.transactionTag = null;
        } else {
            this.popUnitOfWorkFromTransactionStack();
        }
    }

    @Override
    public void beginTransaction() {
        SpannerApiFutures.get(this.beginTransactionAsync());
    }

    @Override
    public ApiFuture<Void> beginTransactionAsync() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "This connection has an active batch and cannot begin a transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Beginning a new transaction is not allowed when a transaction is already running");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "A transaction has already begun");
        this.transactionBeginMarked = true;
        this.clearLastTransactionAndSetDefaultTransactionOptions();
        if (this.isAutocommit()) {
            this.inTransaction = true;
        }
        return ApiFutures.immediateFuture(null);
    }

    @Override
    public void commit() {
        SpannerApiFutures.get(this.commitAsync(UnitOfWork.CallType.SYNC));
    }

    @Override
    public ApiFuture<Void> commitAsync() {
        return this.commitAsync(UnitOfWork.CallType.ASYNC);
    }

    private ApiFuture<Void> commitAsync(UnitOfWork.CallType callType) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.endCurrentTransactionAsync(callType, this.commit);
    }

    @Override
    public void rollback() {
        SpannerApiFutures.get(this.rollbackAsync(UnitOfWork.CallType.SYNC));
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        return this.rollbackAsync(UnitOfWork.CallType.ASYNC);
    }

    private ApiFuture<Void> rollbackAsync(UnitOfWork.CallType callType) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.endCurrentTransactionAsync(callType, this.rollback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiFuture<Void> endCurrentTransactionAsync(UnitOfWork.CallType callType, EndTransactionMethod endTransactionMethod) {
        ApiFuture res;
        ConnectionPreconditions.checkState(!this.isBatchActive(), "This connection has an active batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(this.statementTag == null, "Statement tags are not supported for COMMIT or ROLLBACK");
        try {
            if (this.isTransactionStarted()) {
                res = endTransactionMethod.endAsync(callType, this.getCurrentUnitOfWorkOrStartNewUnitOfWork());
            } else {
                this.currentUnitOfWork = null;
                res = ApiFutures.immediateFuture(null);
            }
        }
        finally {
            this.transactionBeginMarked = false;
            if (this.isAutocommit()) {
                this.inTransaction = false;
            }
            this.setDefaultTransactionOptions();
        }
        return res;
    }

    @Override
    public SavepointSupport getSavepointSupport() {
        return this.savepointSupport;
    }

    @Override
    public void setSavepointSupport(SavepointSupport savepointSupport) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set SavepointSupport while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set SavepointSupport while a transaction is active");
        this.savepointSupport = savepointSupport;
    }

    @Override
    public void savepoint(String name) {
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(this.savepointSupport.isSavepointCreationAllowed(), "This connection does not allow the creation of savepoints. Current value of SavepointSupport: " + (Object)((Object)this.savepointSupport));
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork().savepoint(ConnectionPreconditions.checkValidIdentifier(name), this.getDialect());
    }

    @Override
    public void releaseSavepoint(String name) {
        ConnectionPreconditions.checkState(this.isTransactionStarted(), "This connection has no active transaction");
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork().releaseSavepoint(ConnectionPreconditions.checkValidIdentifier(name));
    }

    @Override
    public void rollbackToSavepoint(String name) {
        ConnectionPreconditions.checkState(this.isTransactionStarted(), "This connection has no active transaction");
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork().rollbackToSavepoint(ConnectionPreconditions.checkValidIdentifier(name), this.savepointSupport);
    }

    @Override
    public StatementResult execute(Statement statement) {
        return this.internalExecute((Statement)Preconditions.checkNotNull((Object)statement), null);
    }

    @Override
    public StatementResult execute(Statement statement, Set<StatementResult.ResultType> allowedResultTypes) {
        return this.internalExecute((Statement)Preconditions.checkNotNull((Object)statement), (Set)Preconditions.checkNotNull(allowedResultTypes));
    }

    private StatementResult internalExecute(Statement statement, @Nullable Set<StatementResult.ResultType> allowedResultTypes) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(statement, this.queryOptions);
        ConnectionImpl.checkResultTypeAllowed(parsedStatement, allowedResultTypes);
        switch (parsedStatement.getType()) {
            case CLIENT_SIDE: {
                return parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement);
            }
            case QUERY: {
                return StatementResultImpl.of(this.internalExecuteQuery(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
            }
            case UPDATE: {
                if (parsedStatement.hasReturningClause()) {
                    return StatementResultImpl.of(this.internalExecuteQuery(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
                }
                return StatementResultImpl.of(SpannerApiFutures.get(this.internalExecuteUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0])));
            }
            case DDL: {
                SpannerApiFutures.get(this.executeDdlAsync(UnitOfWork.CallType.SYNC, parsedStatement));
                return StatementResultImpl.noResult();
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown statement: " + parsedStatement.getSqlWithoutComments());
    }

    @VisibleForTesting
    static void checkResultTypeAllowed(AbstractStatementParser.ParsedStatement parsedStatement, @Nullable Set<StatementResult.ResultType> allowedResultTypes) {
        if (allowedResultTypes == null) {
            return;
        }
        StatementResult.ResultType resultType = ConnectionImpl.getResultType(parsedStatement);
        if (!allowedResultTypes.contains((Object)resultType)) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "This statement returns a result of type " + (Object)((Object)resultType) + ". Only statements that return a result of one of the following types are allowed: " + allowedResultTypes.stream().map(Enum::toString).collect(Collectors.joining(", ")));
        }
    }

    private static StatementResult.ResultType getResultType(AbstractStatementParser.ParsedStatement parsedStatement) {
        switch (parsedStatement.getType()) {
            case CLIENT_SIDE: {
                if (parsedStatement.getClientSideStatement().isQuery()) {
                    return StatementResult.ResultType.RESULT_SET;
                }
                if (parsedStatement.getClientSideStatement().isUpdate()) {
                    return StatementResult.ResultType.UPDATE_COUNT;
                }
                return StatementResult.ResultType.NO_RESULT;
            }
            case QUERY: {
                return StatementResult.ResultType.RESULT_SET;
            }
            case UPDATE: {
                if (parsedStatement.hasReturningClause()) {
                    return StatementResult.ResultType.RESULT_SET;
                }
                return StatementResult.ResultType.UPDATE_COUNT;
            }
            case DDL: {
                return StatementResult.ResultType.NO_RESULT;
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public AsyncStatementResult executeAsync(Statement statement) {
        Preconditions.checkNotNull((Object)statement);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(statement, this.queryOptions);
        switch (parsedStatement.getType()) {
            case CLIENT_SIDE: {
                return AsyncStatementResultImpl.of(parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement), this.spanner.getAsyncExecutorProvider());
            }
            case QUERY: {
                return AsyncStatementResultImpl.of(this.internalExecuteQueryAsync(UnitOfWork.CallType.ASYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
            }
            case UPDATE: {
                if (parsedStatement.hasReturningClause()) {
                    return AsyncStatementResultImpl.of(this.internalExecuteQueryAsync(UnitOfWork.CallType.ASYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
                }
                return AsyncStatementResultImpl.of(this.internalExecuteUpdateAsync(UnitOfWork.CallType.ASYNC, parsedStatement, new Options.UpdateOption[0]));
            }
            case DDL: {
                return AsyncStatementResultImpl.noResult(this.executeDdlAsync(UnitOfWork.CallType.ASYNC, parsedStatement));
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public ResultSet executeQuery(Statement query, Options.QueryOption ... options) {
        return this.parseAndExecuteQuery(UnitOfWork.CallType.SYNC, query, AnalyzeMode.NONE, options);
    }

    @Override
    public AsyncResultSet executeQueryAsync(Statement query, Options.QueryOption ... options) {
        return this.parseAndExecuteQueryAsync(UnitOfWork.CallType.ASYNC, query, AnalyzeMode.NONE, options);
    }

    @Override
    public ResultSet analyzeQuery(Statement query, ReadContext.QueryAnalyzeMode queryMode) {
        Preconditions.checkNotNull((Object)((Object)queryMode));
        return this.parseAndExecuteQuery(UnitOfWork.CallType.SYNC, query, AnalyzeMode.of(queryMode), new Options.QueryOption[0]);
    }

    @Override
    public void setDataBoostEnabled(boolean dataBoostEnabled) {
        this.dataBoostEnabled = dataBoostEnabled;
    }

    @Override
    public boolean isDataBoostEnabled() {
        return this.dataBoostEnabled;
    }

    @Override
    public void setAutoPartitionMode(boolean autoPartitionMode) {
        this.autoPartitionMode = autoPartitionMode;
    }

    @Override
    public boolean isAutoPartitionMode() {
        return this.autoPartitionMode;
    }

    @Override
    public void setMaxPartitions(int maxPartitions) {
        this.maxPartitions = maxPartitions;
    }

    @Override
    public int getMaxPartitions() {
        return this.maxPartitions;
    }

    @Override
    public ResultSet partitionQuery(Statement query, PartitionOptions partitionOptions, Options.QueryOption ... options) {
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(query, this.queryOptions);
        if (parsedStatement.getType() != AbstractStatementParser.StatementType.QUERY) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Only queries can be partitioned. Invalid statement: " + query.getSql());
        }
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        return SpannerApiFutures.get(transaction.partitionQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, this.getEffectivePartitionOptions(partitionOptions), this.mergeDataBoost(this.mergeQueryRequestOptions(parsedStatement, this.mergeQueryStatementTag(options)))));
    }

    private PartitionOptions getEffectivePartitionOptions(PartitionOptions callSpecificPartitionOptions) {
        if (this.maxPartitions == 0) {
            if (callSpecificPartitionOptions == null) {
                return PartitionOptions.newBuilder().build();
            }
            return callSpecificPartitionOptions;
        }
        if (callSpecificPartitionOptions != null && callSpecificPartitionOptions.getMaxPartitions() > 0L) {
            return callSpecificPartitionOptions;
        }
        if (callSpecificPartitionOptions != null && callSpecificPartitionOptions.getPartitionSizeBytes() > 0L) {
            return PartitionOptions.newBuilder().setMaxPartitions(this.maxPartitions).setPartitionSizeBytes(callSpecificPartitionOptions.getPartitionSizeBytes()).build();
        }
        return PartitionOptions.newBuilder().setMaxPartitions(this.maxPartitions).build();
    }

    @Override
    public ResultSet runPartition(String encodedPartitionId) {
        PartitionId id = PartitionId.decodeFromString(encodedPartitionId);
        try (BatchReadOnlyTransaction transaction = this.batchClient.batchReadOnlyTransaction(id.getTransactionId());){
            ResultSet resultSet = transaction.execute(id.getPartition());
            return resultSet;
        }
    }

    @Override
    public void setMaxPartitionedParallelism(int maxThreads) {
        Preconditions.checkArgument((maxThreads >= 0 ? 1 : 0) != 0, (Object)"maxThreads must be >=0");
        this.maxPartitionedParallelism = maxThreads;
    }

    @Override
    public int getMaxPartitionedParallelism() {
        return this.maxPartitionedParallelism;
    }

    @Override
    public PartitionedQueryResultSet runPartitionedQuery(Statement query, PartitionOptions partitionOptions, Options.QueryOption ... options) {
        ArrayList<String> partitionIds = new ArrayList<String>();
        try (ResultSet partitions = this.partitionQuery(query, partitionOptions, options);){
            while (partitions.next()) {
                partitionIds.add(partitions.getString(0));
            }
        }
        return new MergedResultSet(this, partitionIds, this.maxPartitionedParallelism);
    }

    private ResultSet parseAndExecuteQuery(UnitOfWork.CallType callType, Statement query, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)((Object)analyzeMode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(query, this.queryOptions);
        if (parsedStatement.isQuery() || parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case CLIENT_SIDE: {
                    return parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement).getResultSet();
                }
                case QUERY: {
                    return this.internalExecuteQuery(callType, parsedStatement, analyzeMode, options);
                }
                case UPDATE: {
                    if (!parsedStatement.hasReturningClause()) break;
                    if (this.isReadOnly() || this.isInTransaction() && this.getTransactionMode() == TransactionMode.READ_ONLY_TRANSACTION) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DML statement with returning clause cannot be executed in read-only mode: " + parsedStatement.getSqlWithoutComments());
                    }
                    return this.internalExecuteQuery(callType, parsedStatement, analyzeMode, options);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not a query or DML with returning clause: " + parsedStatement.getSqlWithoutComments());
    }

    private AsyncResultSet parseAndExecuteQueryAsync(UnitOfWork.CallType callType, Statement query, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)query);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(query, this.queryOptions);
        if (parsedStatement.isQuery() || parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case CLIENT_SIDE: {
                    return ResultSets.toAsyncResultSet(parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement).getResultSet(), this.spanner.getAsyncExecutorProvider(), options);
                }
                case QUERY: {
                    return this.internalExecuteQueryAsync(callType, parsedStatement, analyzeMode, options);
                }
                case UPDATE: {
                    if (!parsedStatement.hasReturningClause()) break;
                    if (this.isReadOnly() || this.isInTransaction() && this.getTransactionMode() == TransactionMode.READ_ONLY_TRANSACTION) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DML statement with returning clause cannot be executed in read-only mode: " + parsedStatement.getSqlWithoutComments());
                    }
                    return this.internalExecuteQueryAsync(callType, parsedStatement, analyzeMode, options);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not a query or DML with returning clause: " + parsedStatement.getSqlWithoutComments());
    }

    private boolean isInternalMetadataQuery(Options.QueryOption ... options) {
        if (options == null) {
            return false;
        }
        for (Options.QueryOption option : options) {
            if (!(option instanceof Connection.InternalMetadataQuery)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long executeUpdate(Statement update) {
        Preconditions.checkNotNull((Object)update);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(update);
        if (parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    if (parsedStatement.hasReturningClause()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DML statement with returning clause cannot be executed using executeUpdate: " + parsedStatement.getSqlWithoutComments() + ". Please use executeQuery instead.");
                    }
                    return SpannerApiFutures.get(this.internalExecuteUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0]));
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(Statement update) {
        Preconditions.checkNotNull((Object)update);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(update);
        if (parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    if (parsedStatement.hasReturningClause()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DML statement with returning clause cannot be executed using executeUpdateAsync: " + parsedStatement.getSqlWithoutComments() + ". Please use executeQueryAsync instead.");
                    }
                    return this.internalExecuteUpdateAsync(UnitOfWork.CallType.ASYNC, parsedStatement, new Options.UpdateOption[0]);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public ResultSetStats analyzeUpdate(Statement update, ReadContext.QueryAnalyzeMode analyzeMode) {
        Preconditions.checkNotNull((Object)update);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(update);
        if (parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    return SpannerApiFutures.get(this.internalAnalyzeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.of(analyzeMode), new Options.UpdateOption[0])).getStats();
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public ResultSet analyzeUpdateStatement(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        Preconditions.checkNotNull((Object)statement);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(statement);
        switch (parsedStatement.getType()) {
            case UPDATE: {
                return SpannerApiFutures.get(this.internalAnalyzeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.of(analyzeMode), options));
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public long[] executeBatchUpdate(Iterable<Statement> updates) {
        return SpannerApiFutures.get(this.internalExecuteBatchUpdateAsync(UnitOfWork.CallType.SYNC, this.parseUpdateStatements(updates), new Options.UpdateOption[0]));
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<Statement> updates) {
        return this.internalExecuteBatchUpdateAsync(UnitOfWork.CallType.ASYNC, this.parseUpdateStatements(updates), new Options.UpdateOption[0]);
    }

    private List<AbstractStatementParser.ParsedStatement> parseUpdateStatements(Iterable<Statement> updates) {
        Preconditions.checkNotNull(updates);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        LinkedList<AbstractStatementParser.ParsedStatement> parsedStatements = new LinkedList<AbstractStatementParser.ParsedStatement>();
        block3: for (Statement update : updates) {
            AbstractStatementParser.ParsedStatement parsedStatement = this.getStatementParser().parse(update);
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    parsedStatements.add(parsedStatement);
                    continue block3;
                }
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "The batch update list contains a statement that is not an update statement: " + parsedStatement.getSqlWithoutComments());
        }
        return parsedStatements;
    }

    private Options.QueryOption[] mergeDataBoost(Options.QueryOption ... options) {
        if (this.dataBoostEnabled) {
            options = this.appendQueryOption(options, Options.dataBoostEnabled(true));
        }
        return options;
    }

    private Options.QueryOption[] mergeQueryStatementTag(Options.QueryOption ... options) {
        if (this.statementTag != null) {
            options = this.appendQueryOption(options, Options.tag(this.statementTag));
            this.statementTag = null;
        }
        return options;
    }

    private Options.QueryOption[] mergeQueryRequestOptions(AbstractStatementParser.ParsedStatement parsedStatement, Options.QueryOption ... options) {
        if (this.rpcPriority != null) {
            options = this.appendQueryOption(options, Options.priority(this.rpcPriority));
        }
        if (this.directedReadOptions != null && this.currentUnitOfWork != null && this.currentUnitOfWork.supportsDirectedReads(parsedStatement)) {
            options = this.appendQueryOption(options, Options.directedRead(this.directedReadOptions));
        }
        return options;
    }

    private Options.QueryOption[] appendQueryOption(Options.QueryOption[] options, Options.QueryOption append) {
        if (options == null || options.length == 0) {
            options = new Options.QueryOption[]{append};
        } else {
            options = Arrays.copyOf(options, options.length + 1);
            options[options.length - 1] = append;
        }
        return options;
    }

    private Options.UpdateOption[] mergeUpdateStatementTag(Options.UpdateOption ... options) {
        if (this.statementTag != null) {
            if (options == null || options.length == 0) {
                options = new Options.UpdateOption[]{Options.tag(this.statementTag)};
            } else {
                options = Arrays.copyOf(options, options.length + 1);
                options[options.length - 1] = Options.tag(this.statementTag);
            }
            this.statementTag = null;
        }
        return options;
    }

    private Options.UpdateOption[] mergeUpdateRequestOptions(Options.UpdateOption ... options) {
        if (this.rpcPriority != null) {
            if (options == null || options.length == 0) {
                options = new Options.UpdateOption[]{Options.priority(this.rpcPriority)};
            } else {
                options = Arrays.copyOf(options, options.length + 1);
                options[options.length - 1] = Options.priority(this.rpcPriority);
            }
        }
        return options;
    }

    private ResultSet internalExecuteQuery(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((statement.getType() == AbstractStatementParser.StatementType.QUERY || statement.getType() == AbstractStatementParser.StatementType.UPDATE && (analyzeMode != AnalyzeMode.NONE || statement.hasReturningClause()) ? 1 : 0) != 0, (Object)"Statement must either be a query or a DML mode with analyzeMode!=NONE or returning clause");
        boolean isInternalMetadataQuery = this.isInternalMetadataQuery(options);
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork(isInternalMetadataQuery);
        if (this.autoPartitionMode && statement.getType() == AbstractStatementParser.StatementType.QUERY && !isInternalMetadataQuery) {
            return this.runPartitionedQuery(statement.getStatement(), PartitionOptions.getDefaultInstance(), options);
        }
        return SpannerApiFutures.get(transaction.executeQueryAsync(callType, statement, analyzeMode, this.mergeQueryRequestOptions(statement, this.mergeQueryStatementTag(options))));
    }

    private AsyncResultSet internalExecuteQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((statement.getType() == AbstractStatementParser.StatementType.QUERY || statement.getType() == AbstractStatementParser.StatementType.UPDATE && statement.hasReturningClause() ? 1 : 0) != 0, (Object)"Statement must be a query or DML with returning clause.");
        ConnectionPreconditions.checkState(!this.autoPartitionMode || statement.getType() != AbstractStatementParser.StatementType.QUERY, "Partitioned queries cannot be executed asynchronously");
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork(this.isInternalMetadataQuery(options));
        return ResultSets.toAsyncResultSet(transaction.executeQueryAsync(callType, statement, analyzeMode, this.mergeQueryRequestOptions(statement, this.mergeQueryStatementTag(options))), this.spanner.getAsyncExecutorProvider(), options);
    }

    private ApiFuture<Long> internalExecuteUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        Preconditions.checkArgument((update.getType() == AbstractStatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)"Statement must be an update");
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        return transaction.executeUpdateAsync(callType, update, this.mergeUpdateRequestOptions(this.mergeUpdateStatementTag(options)));
    }

    private ApiFuture<ResultSet> internalAnalyzeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        Preconditions.checkArgument((update.getType() == AbstractStatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)"Statement must be an update");
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        return transaction.analyzeUpdateAsync(callType, update, analyzeMode, this.mergeUpdateRequestOptions(this.mergeUpdateStatementTag(options)));
    }

    private ApiFuture<long[]> internalExecuteBatchUpdateAsync(UnitOfWork.CallType callType, List<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        return transaction.executeBatchUpdateAsync(callType, updates, this.mergeUpdateRequestOptions(this.mergeUpdateStatementTag(options)));
    }

    private UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork() {
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork(false);
    }

    @VisibleForTesting
    UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork(boolean isInternalMetadataQuery) {
        if (isInternalMetadataQuery) {
            return this.createNewUnitOfWork(true);
        }
        if (this.currentUnitOfWork == null || !this.currentUnitOfWork.isActive()) {
            this.currentUnitOfWork = this.createNewUnitOfWork(false);
        }
        return this.currentUnitOfWork;
    }

    @VisibleForTesting
    UnitOfWork createNewUnitOfWork(boolean isInternalMetadataQuery) {
        if (isInternalMetadataQuery || this.isAutocommit() && !this.isInTransaction() && !this.isInBatch()) {
            return ((SingleUseTransaction.Builder)((SingleUseTransaction.Builder)SingleUseTransaction.newBuilder().setInternalMetadataQuery(isInternalMetadataQuery).setDdlClient(this.ddlClient).setDatabaseClient(this.dbClient).setBatchClient(this.batchClient).setReadOnly(this.isReadOnly()).setReadOnlyStaleness(this.readOnlyStaleness).setAutocommitDmlMode(this.autocommitDmlMode).setReturnCommitStats(this.returnCommitStats).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).build();
        }
        switch (this.getUnitOfWorkType()) {
            case READ_ONLY_TRANSACTION: {
                return ((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)ReadOnlyTransaction.newBuilder().setDatabaseClient(this.dbClient).setBatchClient(this.batchClient).setReadOnlyStaleness(this.readOnlyStaleness).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setTransactionTag(this.transactionTag)).setRpcPriority(this.rpcPriority)).build();
            }
            case READ_WRITE_TRANSACTION: {
                return ((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)ReadWriteTransaction.newBuilder().setDatabaseClient(this.dbClient).setDelayTransactionStartUntilFirstWrite(this.delayTransactionStartUntilFirstWrite).setRetryAbortsInternally(this.retryAbortsInternally).setSavepointSupport(this.savepointSupport).setReturnCommitStats(this.returnCommitStats).setTransactionRetryListeners(this.transactionRetryListeners).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setTransactionTag(this.transactionTag)).setRpcPriority(this.rpcPriority)).build();
            }
            case DML_BATCH: {
                this.pushCurrentUnitOfWorkToTransactionStack();
                return ((DmlBatch.Builder)((DmlBatch.Builder)((DmlBatch.Builder)DmlBatch.newBuilder().setTransaction(this.currentUnitOfWork).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setStatementTag(this.statementTag).setRpcPriority(this.rpcPriority)).build();
            }
            case DDL_BATCH: {
                return ((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().setDdlClient(this.ddlClient).setDatabaseClient(this.dbClient).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).build();
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "This connection does not have an active transaction and the state of this connection does not allow any new transactions to be started");
    }

    private void pushCurrentUnitOfWorkToTransactionStack() {
        Preconditions.checkState((this.currentUnitOfWork != null ? 1 : 0) != 0, (Object)"There is no current transaction");
        this.transactionStack.push(this.currentUnitOfWork);
    }

    private void popUnitOfWorkFromTransactionStack() {
        Preconditions.checkState((!this.transactionStack.isEmpty() ? 1 : 0) != 0, (Object)"There is no unit of work in the transaction stack");
        this.currentUnitOfWork = this.transactionStack.pop();
    }

    private ApiFuture<Void> executeDdlAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement ddl) {
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork().executeDdlAsync(callType, ddl);
    }

    @Override
    public void write(Mutation mutation) {
        SpannerApiFutures.get(this.writeAsync(Collections.singleton((Mutation)Preconditions.checkNotNull((Object)mutation))));
    }

    @Override
    public ApiFuture<Void> writeAsync(Mutation mutation) {
        return this.writeAsync(Collections.singleton((Mutation)Preconditions.checkNotNull((Object)mutation)));
    }

    @Override
    public void write(Iterable<Mutation> mutations) {
        SpannerApiFutures.get(this.writeAsync((Iterable)Preconditions.checkNotNull(mutations)));
    }

    @Override
    public ApiFuture<Void> writeAsync(Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isAutocommit(), ONLY_ALLOWED_IN_AUTOCOMMIT);
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork().writeAsync(UnitOfWork.CallType.ASYNC, mutations);
    }

    @Override
    public void bufferedWrite(Mutation mutation) {
        this.bufferedWrite((Iterable)Preconditions.checkNotNull(Collections.singleton(mutation)));
    }

    @Override
    public void bufferedWrite(Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isAutocommit(), NOT_ALLOWED_IN_AUTOCOMMIT);
        SpannerApiFutures.get(this.getCurrentUnitOfWorkOrStartNewUnitOfWork().writeAsync(UnitOfWork.CallType.SYNC, mutations));
    }

    @Override
    public void startBatchDdl() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot start a DDL batch when a batch is already active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot start a DDL batch when the connection is in read-only mode");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot start a DDL batch while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot start a DDL batch while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot start a DDL batch when a transaction has begun");
        this.batchMode = BatchMode.DDL;
        this.unitOfWorkType = UnitOfWorkType.DDL_BATCH;
        this.currentUnitOfWork = this.createNewUnitOfWork(false);
    }

    @Override
    public void startBatchDml() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot start a DML batch when a batch is already active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot start a DML batch when the connection is in read-only mode");
        ConnectionPreconditions.checkState(!this.isInTransaction() || this.getTransactionMode() != TransactionMode.READ_ONLY_TRANSACTION, "Cannot start a DML batch when a read-only transaction is in progress");
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        this.batchMode = BatchMode.DML;
        this.unitOfWorkType = UnitOfWorkType.DML_BATCH;
        this.currentUnitOfWork = this.createNewUnitOfWork(false);
    }

    @Override
    public long[] runBatch() {
        return SpannerApiFutures.get(this.runBatchAsync());
    }

    @Override
    public ApiFuture<long[]> runBatchAsync() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isBatchActive(), "This connection has no active batch");
        try {
            if (this.currentUnitOfWork != null) {
                ApiFuture<long[]> apiFuture = this.currentUnitOfWork.runBatchAsync(UnitOfWork.CallType.ASYNC);
                return apiFuture;
            }
            ApiFuture apiFuture = ApiFutures.immediateFuture((Object)new long[0]);
            return apiFuture;
        }
        finally {
            this.batchMode = BatchMode.NONE;
            this.setDefaultTransactionOptions();
        }
    }

    @Override
    public void abortBatch() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isBatchActive(), "This connection has no active batch");
        try {
            if (this.currentUnitOfWork != null) {
                this.currentUnitOfWork.abortBatch();
            }
        }
        finally {
            this.batchMode = BatchMode.NONE;
            this.setDefaultTransactionOptions();
        }
    }

    private boolean isBatchActive() {
        return this.isDdlBatchActive() || this.isDmlBatchActive();
    }

    @Override
    public boolean isDdlBatchActive() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.batchMode == BatchMode.DDL;
    }

    @Override
    public boolean isDmlBatchActive() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.batchMode == BatchMode.DML;
    }

    private static final class Commit
    implements EndTransactionMethod {
        private Commit() {
        }

        @Override
        public ApiFuture<Void> endAsync(UnitOfWork.CallType callType, UnitOfWork t) {
            return t.commitAsync(callType);
        }
    }

    private static final class Rollback
    implements EndTransactionMethod {
        private Rollback() {
        }

        @Override
        public ApiFuture<Void> endAsync(UnitOfWork.CallType callType, UnitOfWork t) {
            return t.rollbackAsync(callType);
        }
    }

    static class LeakedConnectionException
    extends RuntimeException {
        private static final long serialVersionUID = 7119433786832158700L;

        private LeakedConnectionException() {
            super("Connection was opened at " + Instant.now());
        }
    }

    static enum UnitOfWorkType {
        READ_ONLY_TRANSACTION{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_ONLY_TRANSACTION;
            }
        }
        ,
        READ_WRITE_TRANSACTION{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_WRITE_TRANSACTION;
            }
        }
        ,
        DML_BATCH{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_WRITE_TRANSACTION;
            }
        }
        ,
        DDL_BATCH{

            @Override
            TransactionMode getTransactionMode() {
                return null;
            }
        };


        abstract TransactionMode getTransactionMode();

        static UnitOfWorkType of(TransactionMode transactionMode) {
            switch (transactionMode) {
                case READ_ONLY_TRANSACTION: {
                    return READ_ONLY_TRANSACTION;
                }
                case READ_WRITE_TRANSACTION: {
                    return READ_WRITE_TRANSACTION;
                }
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown transaction mode: " + (Object)((Object)transactionMode));
        }
    }

    static enum BatchMode {
        NONE,
        DDL,
        DML;

    }

    private static interface EndTransactionMethod {
        public ApiFuture<Void> endAsync(UnitOfWork.CallType var1, UnitOfWork var2);
    }

    static final class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("connection-rollback-executor");
            t.setDaemon(true);
            return t;
        }
    }
}

