/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SlowTest;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.rpc.Code;
import com.google.spanner.v1.BatchWriteResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={SlowTest.class})
@RunWith(value=JUnit4.class)
public class BenchmarkingUtilityScripts {
    private static final String PROJECT_ID = "";
    private static final String INSTANCE_ID = "";
    private static final String DATABASE_ID = "";
    private static final String SERVER_URL = "https://staging-wrenchworks.sandbox.googleapis.com";
    private static DatabaseClient client;
    private static Spanner spanner;

    @BeforeClass
    public static void beforeClass() {
        SpannerOptions.Builder optionsBuilder = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("")).setAutoThrottleAdministrativeRequests();
        if (!SERVER_URL.isEmpty()) {
            optionsBuilder.setHost(SERVER_URL);
        }
        SpannerOptions options = optionsBuilder.build();
        spanner = (Spanner)options.getService();
        client = spanner.getDatabaseClient(DatabaseId.of((String)"", (String)"", (String)""));
        client.write((Iterable)ImmutableList.of((Object)Mutation.delete((String)"FOO", (KeySet)KeySet.all())));
    }

    @AfterClass
    public static void afterClass() {
        spanner.close();
    }

    @Test
    public void bulkInsertTestData() {
        int key = 0;
        ArrayList<MutationGroup> mutationGroups = new ArrayList<MutationGroup>();
        for (int batch = 0; batch < 100; ++batch) {
            LinkedList<Mutation> mutations = new LinkedList<Mutation>();
            for (int i = 0; i < 10000; ++i) {
                mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("id").to((long)key)).set("BAZ").to(1L)).set("BAR").to(2L)).build());
                ++key;
            }
            mutationGroups.add(MutationGroup.of(mutations));
        }
        ServerStream responses = client.batchWriteAtLeastOnce(mutationGroups, new Options.TransactionOption[0]);
        for (BatchWriteResponse response : responses) {
            if (response.getStatus().getCode() == 0) {
                System.out.printf("Mutation group indexes %s have been applied with commit timestamp %s", response.getIndexesList(), response.getCommitTimestamp());
                continue;
            }
            System.out.printf("Mutation group indexes %s could not be applied with error code %s and error message %s", response.getIndexesList(), Code.forNumber((int)response.getStatus().getCode()), response.getStatus().getMessage());
        }
    }

    public static List<Duration> collectResults(ListeningScheduledExecutorService service, List<ListenableFuture<List<Duration>>> results, int numOperations, Duration timeoutDuration) throws Exception {
        service.shutdown();
        if (!service.awaitTermination(timeoutDuration.toMinutes(), TimeUnit.MINUTES)) {
            throw new TimeoutException();
        }
        ArrayList<Duration> allResults = new ArrayList<Duration>(numOperations);
        for (Future future : results) {
            allResults.addAll((Collection)future.get());
        }
        return allResults;
    }
}

