/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.ExponentialBackOff;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseInfo;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TestEnvConfig;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.rules.ExternalResource;

public class IntegrationTestEnv
extends ExternalResource {
    public static final String TEST_ENV_CONFIG_CLASS_NAME = "spanner.testenv.config.class";
    public static final String CONFIG_CLASS = System.getProperty("spanner.testenv.config.class", null);
    public static final String TEST_INSTANCE_PROPERTY = "spanner.testenv.instance";
    public static final String MAX_CREATE_INSTANCE_ATTEMPTS = "spanner.testenv.max_create_instance_attempts";
    private static final Logger logger = Logger.getLogger(IntegrationTestEnv.class.getName());
    private TestEnvConfig config;
    private InstanceAdminClient instanceAdminClient;
    private DatabaseAdminClient databaseAdminClient;
    private boolean isOwnedInstance;
    private final boolean alwaysCreateNewInstance;
    private RemoteSpannerHelper testHelper;

    public IntegrationTestEnv() {
        this(false);
    }

    public IntegrationTestEnv(boolean alwaysCreateNewInstance) {
        this.alwaysCreateNewInstance = alwaysCreateNewInstance;
    }

    public RemoteSpannerHelper getTestHelper() {
        this.checkInitialized();
        return this.testHelper;
    }

    protected void initializeConfig() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (CONFIG_CLASS == null) {
            throw new NullPointerException("Property spanner.testenv.config.class needs to be set");
        }
        Class<?> configClass = Class.forName(CONFIG_CLASS);
        this.config = (TestEnvConfig)configClass.newInstance();
    }

    protected void before() throws Throwable {
        InstanceId instanceId;
        this.initializeConfig();
        this.config.setUp();
        SpannerOptions options = this.config.spannerOptions();
        String instanceProperty = System.getProperty(TEST_INSTANCE_PROPERTY, "");
        if (!instanceProperty.isEmpty() && !this.alwaysCreateNewInstance) {
            instanceId = InstanceId.of((String)instanceProperty);
            this.isOwnedInstance = false;
            logger.log(Level.INFO, "Using existing test instance: {0}", instanceId);
        } else {
            instanceId = InstanceId.of((String)this.config.spannerOptions().getProjectId(), (String)String.format("test-instance-%08d", new Random().nextInt(100000000)));
            this.isOwnedInstance = true;
        }
        this.testHelper = this.createTestHelper(options, instanceId);
        this.instanceAdminClient = this.testHelper.getClient().getInstanceAdminClient();
        this.databaseAdminClient = this.testHelper.getClient().getDatabaseAdminClient();
        logger.log(Level.FINE, "Test env endpoint is {0}", options.getHost());
        if (this.isOwnedInstance) {
            this.initializeInstance(instanceId);
        } else {
            this.cleanUpOldDatabases(instanceId);
        }
    }

    RemoteSpannerHelper createTestHelper(SpannerOptions options, InstanceId instanceId) throws Throwable {
        return RemoteSpannerHelper.create((SpannerOptions)options, (InstanceId)instanceId);
    }

    protected void after() {
        this.cleanUpInstance();
        this.config.tearDown();
    }

    private void initializeInstance(InstanceId instanceId) throws Exception {
        Instance createdInstance;
        InstanceConfig instanceConfig;
        try {
            instanceConfig = this.instanceAdminClient.getInstanceConfig("regional-us-central1");
        }
        catch (Throwable ignore) {
            instanceConfig = (InstanceConfig)Iterators.get(this.instanceAdminClient.listInstanceConfigs(new Options.ListOption[0]).iterateAll().iterator(), (int)0, null);
        }
        Preconditions.checkState((instanceConfig != null ? 1 : 0) != 0, (Object)"No instance configs found");
        InstanceConfigId configId = instanceConfig.getId();
        logger.log(Level.FINE, "Creating instance using config {0}", configId);
        InstanceInfo instance = InstanceInfo.newBuilder((InstanceId)instanceId).setNodeCount(1).setDisplayName("Test instance").setInstanceConfigId(configId).build();
        OperationFuture op = this.instanceAdminClient.createInstance(instance);
        int maxAttempts = 25;
        try {
            maxAttempts = Integer.parseInt(System.getProperty(MAX_CREATE_INSTANCE_ATTEMPTS, String.valueOf(maxAttempts)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ExponentialBackOff backOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(5000).setMaxIntervalMillis(500000).setMultiplier(2.0).build();
        int attempts = 0;
        while (true) {
            try {
                createdInstance = (Instance)op.get();
            }
            catch (Exception e) {
                SpannerException spannerException;
                SpannerException spannerException2 = spannerException = e instanceof ExecutionException && e.getCause() != null ? SpannerExceptionFactory.asSpannerException((Throwable)e.getCause()) : SpannerExceptionFactory.asSpannerException((Throwable)e);
                if (attempts < maxAttempts && IntegrationTestEnv.isRetryableResourceExhaustedException(spannerException)) {
                    ++attempts;
                    if (spannerException.getRetryDelayInMillis() > 0L) {
                        Thread.sleep(spannerException.getRetryDelayInMillis());
                        continue;
                    }
                    Thread.sleep(Math.max((long)backOff.getMaxIntervalMillis(), backOff.nextBackOffMillis()));
                    continue;
                }
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)spannerException.getErrorCode(), (String)String.format("Could not create test instance and giving up after %d attempts: %s", attempts, e.getMessage()), (Throwable)e);
            }
            break;
        }
        logger.log(Level.INFO, "Created test instance: {0}", createdInstance.getId());
    }

    static boolean isRetryableResourceExhaustedException(SpannerException exception) {
        if (exception.getErrorCode() != ErrorCode.RESOURCE_EXHAUSTED) {
            return false;
        }
        return exception.getMessage().contains("Quota exceeded for quota metric 'Instance create requests' and limit 'Instance create requests per minute'") || exception.getMessage().matches(".*cannot add \\d+ nodes in region.*");
    }

    private void cleanUpOldDatabases(InstanceId instanceId) {
        long OLD_DB_THRESHOLD_SECS = TimeUnit.SECONDS.convert(6L, TimeUnit.HOURS);
        Timestamp currentTimestamp = Timestamp.now();
        int numDropped = 0;
        String TEST_DB_REGEX = "(testdb_(.*)_(.*))|(mysample-(.*))";
        logger.log(Level.INFO, "Dropping old test databases from {0}", instanceId.getName());
        for (Database db : this.databaseAdminClient.listDatabases(instanceId.getInstance(), new Options.ListOption[0]).iterateAll()) {
            try {
                long timeDiff = currentTimestamp.getSeconds() - db.getCreateTime().getSeconds();
                if (!db.getId().getDatabase().matches(TEST_DB_REGEX) || timeDiff <= OLD_DB_THRESHOLD_SECS) continue;
                logger.log(Level.INFO, "Dropping test database {0}", db.getId());
                if (db.isDropProtectionEnabled()) {
                    Database updatedDatabase = this.databaseAdminClient.newDatabaseBuilder(db.getId()).disableDropProtection().build();
                    this.databaseAdminClient.updateDatabase(updatedDatabase, new DatabaseInfo.DatabaseField[]{DatabaseInfo.DatabaseField.DROP_PROTECTION}).get();
                }
                db.drop();
                ++numDropped;
            }
            catch (SpannerException | InterruptedException | ExecutionException e) {
                logger.log(Level.SEVERE, "Failed to drop test database " + db.getId(), e);
            }
        }
        logger.log(Level.INFO, "Dropped {0} test database(s)", numDropped);
    }

    private void cleanUpInstance() {
        try {
            if (this.isOwnedInstance) {
                try {
                    if (!EmulatorSpannerHelper.isUsingEmulator()) {
                        logger.log(Level.FINE, "Deleting backups on test instance {0}", this.testHelper.getInstanceId());
                        for (Backup backup : this.testHelper.getClient().getDatabaseAdminClient().listBackups(this.testHelper.getInstanceId().getInstance(), new Options.ListOption[0]).iterateAll()) {
                            logger.log(Level.FINE, "Deleting backup {0}", backup.getId());
                            backup.delete();
                        }
                    }
                    logger.log(Level.FINE, "Deleting test instance {0}", this.testHelper.getInstanceId());
                    this.instanceAdminClient.deleteInstance(this.testHelper.getInstanceId().getInstance());
                    logger.log(Level.INFO, "Deleted test instance {0}", this.testHelper.getInstanceId());
                }
                catch (SpannerException e) {
                    logger.log(Level.SEVERE, "Failed to delete test instance " + this.testHelper.getInstanceId(), e);
                }
            } else {
                this.testHelper.cleanUp();
            }
        }
        finally {
            this.testHelper.getClient().close();
        }
    }

    void checkInitialized() {
        Preconditions.checkState((this.testHelper != null ? 1 : 0) != 0, (Object)"Setup has not completed successfully");
    }
}

