/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbstractMockServerTest;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.Session;
import io.grpc.Status;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class MultiplexedSessionDatabaseClientMockServerTest
extends AbstractMockServerTest {
    private static final Statement STATEMENT = Statement.of((String)"select * from random");

    @BeforeClass
    public static void setupResults() {
        mockSpanner.putStatementResults(MockSpannerServiceImpl.StatementResult.query(STATEMENT, new RandomResultSetGenerator(1).generate()));
    }

    @Override
    @Before
    public void createSpannerInstance() {
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).setMultiplexedSessionMaintenanceLoopFrequency(java.time.Duration.ofMillis(1L)).setMultiplexedSessionMaintenanceDuration(Duration.ofMillis((long)1L)).setFailOnSessionLeak().build()).build().getService();
    }

    @Test
    public void testMultiUseReadOnlyTransactionUsesSameSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ReadOnlyTransaction transaction = client.readOnlyTransaction();){
            try (ResultSet resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            this.waitForSessionToBeReplaced(client);
            resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);
            try {
                while (resultSet.next()) {
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)requests.get(0).getSession(), (Object)requests.get(1).getSession());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testNewTransactionUsesNewSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        this.waitForSessionToBeReplaced(client);
        resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);
        try {
            while (resultSet.next()) {
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertNotEquals((Object)requests.get(0).getSession(), (Object)requests.get(1).getSession());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)2L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)2L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testMaintainerMaintainsMultipleClients() {
        DatabaseClientImpl client1 = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)("d" + UUID.randomUUID())));
        DatabaseClientImpl client2 = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)("d" + UUID.randomUUID())));
        for (DatabaseClientImpl client : ImmutableList.of((Object)client1, (Object)client2)) {
            try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            this.waitForSessionToBeReplaced(client);
            resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);
            try {
                while (resultSet.next()) {
                }
            }
            finally {
                if (resultSet == null) continue;
                resultSet.close();
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)4L, (long)requests.size());
        Set sessionIds = requests.stream().map(ExecuteSqlRequest::getSession).collect(Collectors.toSet());
        Assert.assertEquals((long)4L, (long)sessionIds.size());
        for (DatabaseClientImpl client : ImmutableList.of((Object)client1, (Object)client2)) {
            Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
            Assert.assertEquals((long)2L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
            Assert.assertEquals((long)2L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
        }
    }

    @Test
    public void testUnimplementedErrorOnCreation_fallsBackToRegularSessions() {
        mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.UNIMPLEMENTED.withDescription("Multiplexed sessions are not implemented").asRuntimeException()));
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        SpannerException spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((MultiplexedSessionDatabaseClient)client.multiplexedSessionDatabaseClient).getCurrentSessionReference());
        Assert.assertEquals((Object)ErrorCode.UNIMPLEMENTED, (Object)spannerException.getErrorCode());
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Session session = mockSpanner.getSession(requests.get(0).getSession());
        Assert.assertNotNull((Object)session);
        Assert.assertFalse((boolean)session.getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)0L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)0L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testUnimplementedErrorOnCreation_firstReceivesError_secondFallsBackToRegularSessions() {
        mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.UNIMPLEMENTED.withDescription("Multiplexed sessions are not implemented").asRuntimeException()));
        mockSpanner.freeze();
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            SpannerException spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)resultSet).next());
            Assert.assertEquals((Object)ErrorCode.UNIMPLEMENTED, (Object)spannerException.getErrorCode());
        }
        resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);
        try {
            while (resultSet.next()) {
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Session session = mockSpanner.getSession(requests.get(0).getSession());
        Assert.assertNotNull((Object)session);
        Assert.assertFalse((boolean)session.getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)0L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)0L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testMaintainerInvalidatesMultiplexedSessionClientIfUnimplemented() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.UNIMPLEMENTED.withDescription("Multiplexed sessions are not implemented").asRuntimeException()));
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (client.multiplexedSessionDatabaseClient.isMultiplexedSessionsSupported() && stopwatch.elapsed().compareTo(java.time.Duration.ofSeconds(5L)) < 0) {
            Thread.yield();
        }
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Session session1 = mockSpanner.getSession(requests.get(0).getSession());
        Assert.assertNotNull((Object)session1);
        Assert.assertTrue((boolean)session1.getMultiplexed());
        Session session2 = mockSpanner.getSession(requests.get(1).getSession());
        Assert.assertNotNull((Object)session2);
        Assert.assertFalse((boolean)session2.getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    private void waitForSessionToBeReplaced(DatabaseClientImpl client) {
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        SessionReference sessionReference = client.multiplexedSessionDatabaseClient.getCurrentSessionReference();
        while (sessionReference == client.multiplexedSessionDatabaseClient.getCurrentSessionReference()) {
            Thread.yield();
        }
    }
}

