/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TraceWrapper;
import com.google.common.truth.Truth;
import io.opencensus.trace.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;

public class MultiplexedSessionPoolTest
extends BaseSessionPoolTest {
    @Mock
    SpannerImpl client;
    @Mock
    SessionClient sessionClient;
    @Mock
    SpannerOptions spannerOptions;
    private final DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    private final TraceWrapper tracer = new TraceWrapper(Tracing.getTracer(), OpenTelemetry.noop().getTracer(""));
    SessionPoolOptions options;
    SessionPool pool;

    private SessionPool createPool() {
        return SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(this), (SessionClient)this.client.getSessionClient(this.db), (TraceWrapper)this.tracer, (OpenTelemetry)OpenTelemetry.noop());
    }

    @BeforeClass
    public static void checkUsesMultiplexedSessionPool() {
        Assume.assumeTrue((String)"Only run if the maintainer in the session pool is used", (boolean)false);
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        SpannerOptions.resetActiveTracingFramework();
        SpannerOptions.enableOpenTelemetryTraces();
        Mockito.when((Object)((SpannerOptions)this.client.getOptions())).thenReturn((Object)this.spannerOptions);
        Mockito.when((Object)this.client.getSessionClient(this.db)).thenReturn((Object)this.sessionClient);
        Mockito.when((Object)this.sessionClient.getSpanner()).thenReturn((Object)this.client);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        Mockito.when((Object)this.spannerOptions.getDatabaseRole()).thenReturn((Object)"role");
        this.options = SessionPoolOptions.newBuilder().setMinSessions(2).setMaxSessions(2).setUseMultiplexedSession(true).build();
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)this.options);
        Assume.assumeTrue((boolean)this.options.getUseMultiplexedSession());
    }

    @Test
    public void testGetMultiplexedSession_whenSessionInitializationSucceeded_assertSessionReturned() {
        this.setupMockMultiplexedSessionCreation();
        this.pool = this.createPool();
        Assert.assertTrue((boolean)this.pool.isValid());
        for (int i = 0; i < 5; ++i) {
            SessionPool.SessionFutureWrapper multiplexedSessionFuture = this.pool.getMultiplexedSessionWithFallback();
            Assert.assertNotNull((Object)multiplexedSessionFuture.get());
        }
        ((SessionClient)Mockito.verify((Object)this.sessionClient, (VerificationMode)Mockito.times((int)1))).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionInitializationConsumer.class));
    }

    @Test
    public void testGetMultiplexedSession_whenClosedPool_assertSessionReturned() {
        this.setupMockMultiplexedSessionCreation();
        this.pool = this.createPool();
        Assert.assertTrue((boolean)this.pool.isValid());
        this.closePoolWithStacktrace();
        SessionPool.MultiplexedSessionFuture multiplexedSessionFuture = (SessionPool.MultiplexedSessionFuture)this.pool.getMultiplexedSessionWithFallback().get();
        Assert.assertNotNull((Object)multiplexedSessionFuture);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.pool.getSession());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerImpl.ClosedException.class);
        StringWriter sw = new StringWriter();
        e.getCause().printStackTrace(new PrintWriter(sw));
        Truth.assertThat((String)sw.toString()).contains((CharSequence)"closePoolWithStacktrace");
    }

    private void closePoolWithStacktrace() {
        this.pool.closeAsync(new SpannerImpl.ClosedException());
    }

    @Test
    public void testGetMultiplexedSession_whenSessionCreationFailed_assertErrorForWaiters() {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            SessionPool.MultiplexedSessionInitializationConsumer consumer = (SessionPool.MultiplexedSessionInitializationConsumer)invocation.getArgument(0, SessionPool.MultiplexedSessionInitializationConsumer.class);
            consumer.onSessionCreateFailure((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)""), 1);
            return null;
        }).when((Object)this.sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionInitializationConsumer.class));
        this.options = this.options.toBuilder().setMinSessions(2).setUseMultiplexedSession(true).setAcquireSessionTimeout(Duration.ofMillis((long)50L)).build();
        this.pool = this.createPool();
        for (int i = 0; i < 5; ++i) {
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.pool.getMultiplexedSessionWithFallback().get().get());
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
        Assert.assertEquals((long)0L, (long)this.pool.getNumWaiterTimeouts());
        Assert.assertEquals((long)0L, (long)this.pool.getNumberOfSessionsInPool());
    }

    private void setupMockMultiplexedSessionCreation() {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            SessionPool.MultiplexedSessionInitializationConsumer consumer = (SessionPool.MultiplexedSessionInitializationConsumer)invocation.getArgument(0, SessionPool.MultiplexedSessionInitializationConsumer.class);
            consumer.onSessionReady(this.mockSession());
            return null;
        }).when((Object)this.sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionInitializationConsumer.class));
    }
}

