/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RetryOnInvalidatedSessionTest {
    private static final ToLongTransformer TO_LONG = new ToLongTransformer();
    @Parameterized.Parameter(value=0)
    public boolean failOnInvalidatedSession;
    private static final ResultSetMetadata READ_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("BAR").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet READ_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(READ_METADATA).build();
    private static final com.google.spanner.v1.ResultSet READ_ROW_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(READ_METADATA).build();
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static final Statement UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    private static final long UPDATE_COUNT = 1L;
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static SpannerClient spannerClient;
    private static Spanner spanner;
    private static DatabaseClient client;
    private static ExecutorService executor;

    @Parameterized.Parameters(name="fail on invalidated session = {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{false});
        params.add(new Object[]{true});
        return params;
    }

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.all(), Collections.singletonList("BAR"), READ_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.singleKey((Key)Key.of((Object[])new Object[0])), Collections.singletonList("BAR"), READ_ROW_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).directExecutor()).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
        SpannerSettings settings = ((SpannerSettings.Builder)((SpannerSettings.Builder)SpannerSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        spannerClient = SpannerClient.create((SpannerSettings)settings);
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        spannerClient.close();
        server.shutdown();
        server.awaitTermination();
        executor.shutdown();
    }

    @Before
    public void setUp() throws InterruptedException {
        mockSpanner.reset();
        if (spanner == null || ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().isFailIfPoolExhausted() != this.failOnInvalidatedSession) {
            if (spanner != null) {
                spanner.close();
            }
            SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder().setFailOnSessionLeak();
            if (this.failOnInvalidatedSession) {
                builder.setFailIfSessionNotFound();
            }
            builder.setMinSessions(1);
            SessionPoolOptions sessionPoolOptions = builder.build();
            spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(sessionPoolOptions).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
            client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        }
    }

    private static void invalidateSessionPool(DatabaseClient client, int minSessions) throws InterruptedException {
        Stopwatch watch = Stopwatch.createStarted();
        while (((DatabaseClientImpl)client).pool.totalSessions() < minSessions) {
            if (watch.elapsed(TimeUnit.SECONDS) > 5L) {
                Assert.fail((String)String.format("Failed to create MinSessions=%d", minSessions));
            }
            Thread.sleep(1L);
        }
        SpannerClient.ListSessionsPagedResponse response = spannerClient.listSessions("projects/[PROJECT]/instances/[INSTANCE]/databases/[DATABASE]");
        for (Session session : response.iterateAll()) {
            spannerClient.deleteSession(session.getName());
        }
    }

    private <T> T assertThrowsSessionNotFoundIfShouldFail(Supplier<T> supplier) {
        if (this.failOnInvalidatedSession) {
            Assert.assertThrows(SessionNotFoundException.class, () -> supplier.get());
            return null;
        }
        return supplier.get();
    }

    @Test
    public void singleUseSelect() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadContext context = client.singleUse();
             ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void singleUseSelectAsync() throws Exception {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(SELECT1AND2, new Options.QueryOption[0]);){
            ApiFuture list = rs.toListAsync((Function)TO_LONG, (Executor)executor);
            this.assertThrowsSessionNotFoundIfShouldFail(() -> (List)SpannerApiFutures.get((ApiFuture)list));
        }
    }

    @Test
    public void singleUseRead() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadContext context = client.singleUse();
             ResultSet rs = context.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void singleUseReadUsingIndex() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadContext context = client.singleUse();
             ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void singleUseReadRow() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadContext context = client.singleUse();){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> context.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR")));
        }
    }

    @Test
    public void singleUseReadRowUsingIndex() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadContext context = client.singleUse();){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR")));
        }
    }

    @Test
    public void singleUseReadOnlyTransactionSelect() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();
             ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void singleUseReadOnlyTransactionRead() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();
             ResultSet rs = context.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void singlUseReadOnlyTransactionReadUsingIndex() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();
             ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void singleUseReadOnlyTransactionReadRow() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> RetryOnInvalidatedSessionTest.lambda$singleUseReadOnlyTransactionReadRow$10((ReadContext)context));
        }
    }

    @Test
    public void singleUseReadOnlyTransactionReadRowUsingIndex() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> RetryOnInvalidatedSessionTest.lambda$singleUseReadOnlyTransactionReadRowUsingIndex$11((ReadContext)context));
        }
    }

    @Test
    public void readOnlyTransactionSelect() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();
             ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void readOnlyTransactionRead() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();
             ResultSet rs = context.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void readOnlyTransactionReadUsingIndex() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();
             ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
        }
    }

    @Test
    public void readOnlyTransactionReadRow() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> RetryOnInvalidatedSessionTest.lambda$readOnlyTransactionReadRow$15((ReadContext)context));
        }
    }

    @Test
    public void readOnlyTransactionReadRowUsingIndex() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> RetryOnInvalidatedSessionTest.lambda$readOnlyTransactionReadRowUsingIndex$16((ReadContext)context));
        }
    }

    @Test
    public void readOnlyTransactionSelectNonRecoverable() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
            }
            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
            try {
                Assert.assertThrows(SessionNotFoundException.class, () -> rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void readOnlyTransactionReadNonRecoverable() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
            }
            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            rs = context.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);
            try {
                Assert.assertThrows(SessionNotFoundException.class, () -> rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void readOnlyTransactionReadUsingIndexNonRecoverable() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
            }
            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);
            try {
                Assert.assertThrows(SessionNotFoundException.class, () -> rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void readOnlyTransactionReadRowNonRecoverable() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> RetryOnInvalidatedSessionTest.lambda$readOnlyTransactionReadRowNonRecoverable$23((ReadContext)context));
            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            Assert.assertThrows(SessionNotFoundException.class, () -> RetryOnInvalidatedSessionTest.lambda$readOnlyTransactionReadRowNonRecoverable$24((ReadContext)context));
        }
    }

    @Test
    public void readOnlyTransactionReadRowUsingIndexNonRecoverable() throws InterruptedException {
        Assume.assumeFalse((String)"Multiplexed session do not throw a SessionNotFound errors. ", (boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            this.assertThrowsSessionNotFoundIfShouldFail(() -> RetryOnInvalidatedSessionTest.lambda$readOnlyTransactionReadRowUsingIndexNonRecoverable$25((ReadContext)context));
            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            Assert.assertThrows(SessionNotFoundException.class, () -> RetryOnInvalidatedSessionTest.lambda$readOnlyTransactionReadRowUsingIndexNonRecoverable$26((ReadContext)context));
        }
    }

    @Test
    public void readWriteTransactionReadOnlySessionInPool() throws InterruptedException {
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                    while (rs.next()) {
                    }
                }
                return null;
            }));
        }
    }

    @Test
    public void readWriteTransactionSelect() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            return null;
        }));
    }

    @Test
    public void readWriteTransactionRead() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                }
            }
            return null;
        }));
    }

    @Test
    public void readWriteTransactionReadWithOptimisticLock() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.optimisticLock()});
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                }
            }
            return null;
        }));
    }

    @Test
    public void readWriteTransactionReadUsingIndex() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                }
            }
            return null;
        }));
    }

    @Test
    public void readWriteTransactionReadRow() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> (Struct)runner.run(transaction -> transaction.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"))));
    }

    @Test
    public void readWriteTransactionReadRowUsingIndex() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> (Struct)runner.run(transaction -> transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"))));
    }

    @Test
    public void readWriteTransactionUpdate() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> (Long)runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])));
    }

    @Test
    public void readWriteTransactionBatchUpdate() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> (long[])runner.run(transaction -> transaction.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[0])));
    }

    @Test
    public void readWriteTransactionBuffer() throws InterruptedException {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("BAR").to(1L)).build());
            return null;
        }));
    }

    @Test
    public void readWriteTransactionSelectInvalidatedDuringTransaction() {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicInteger attempt = new AtomicInteger();
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            attempt.incrementAndGet();
            try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            if (attempt.get() == 1) {
                RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            }
            rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
            try {
                while (rs.next()) {
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            Truth.assertThat((Integer)attempt.get()).isGreaterThan((Comparable)Integer.valueOf(1));
            return null;
        }));
    }

    @Test
    public void readWriteTransactionReadInvalidatedDuringTransaction() {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicInteger attempt = new AtomicInteger();
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            attempt.incrementAndGet();
            try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                }
            }
            if (attempt.get() == 1) {
                RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            }
            rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);
            try {
                while (rs.next()) {
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            Truth.assertThat((Integer)attempt.get()).isGreaterThan((Comparable)Integer.valueOf(1));
            return null;
        }));
    }

    @Test
    public void readWriteTransactionReadUsingIndexInvalidatedDuringTransaction() {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicInteger attempt = new AtomicInteger();
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            attempt.incrementAndGet();
            try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                }
            }
            if (attempt.get() == 1) {
                RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            }
            rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);
            try {
                while (rs.next()) {
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            Truth.assertThat((Integer)attempt.get()).isGreaterThan((Comparable)Integer.valueOf(1));
            return null;
        }));
    }

    @Test
    public void readWriteTransactionReadRowInvalidatedDuringTransaction() {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicInteger attempt = new AtomicInteger();
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            attempt.incrementAndGet();
            Struct row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            if (attempt.get() == 1) {
                RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            }
            transaction.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
            Truth.assertThat((Integer)attempt.get()).isGreaterThan((Comparable)Integer.valueOf(1));
            return null;
        }));
    }

    @Test
    public void readWriteTransactionReadRowUsingIndexInvalidatedDuringTransaction() {
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicInteger attempt = new AtomicInteger();
        this.assertThrowsSessionNotFoundIfShouldFail(() -> runner.run(transaction -> {
            attempt.incrementAndGet();
            Struct row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            if (attempt.get() == 1) {
                RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
            }
            transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
            Truth.assertThat((Integer)attempt.get()).isGreaterThan((Comparable)Integer.valueOf(1));
            return null;
        }));
    }

    @Test
    public void transactionManagerReadOnlySessionInPool() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerSelect() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerRead() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                        this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerReadUsingIndex() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                        this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next());
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerReadRow() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    TransactionContext context = transaction;
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> context.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR")));
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerReadRowUsingIndex() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    TransactionContext context = transaction;
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR")));
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerUpdate() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.commitStats()});){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    TransactionContext context = transaction;
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> context.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerAborted_thenSessionNotFoundOnBeginTransaction() throws InterruptedException {
        int attempt = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    if (++attempt == 1) {
                        mockSpanner.abortNextStatement();
                    }
                    if (attempt == 2) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
                    }
                    TransactionContext context = transaction;
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> context.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
                    manager.commit();
                    Truth.assertThat((Integer)attempt).isAtLeast((Comparable)Integer.valueOf(3));
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerBatchUpdate() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    TransactionContext context = transaction;
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> context.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[0]));
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerBuffer() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("BAR").to(1L)).build());
                try {
                    manager.commit();
                }
                catch (AbortedException e) {
                    if ((transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry())) != null) continue;
                }
                break;
            }
            Truth.assertThat((Comparable)manager.getCommitTimestamp()).isNotNull();
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerSelectInvalidatedDuringTransaction() throws InterruptedException {
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                int attempts = 0;
                TransactionContext transaction = manager.begin();
                while (true) {
                    ++attempts;
                    try {
                        block31: {
                            try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                                while (rs.next()) {
                                }
                            }
                            if (attempts == 1) {
                                RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
                            }
                            rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                            try {
                                if (this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next()) != null) break block31;
                                break;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        manager.commit();
                        Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
                    }
                    catch (AbortedException e) {
                        transaction = this.assertThrowsSessionNotFoundIfShouldFail(() -> manager.resetForRetry());
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Test
    public void transactionManagerReadInvalidatedDuringTransaction() throws InterruptedException {
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                int attempts = 0;
                TransactionContext transaction = manager.begin();
                while (true) {
                    ++attempts;
                    try {
                        block31: {
                            try (ResultSet rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                                while (rs.next()) {
                                }
                            }
                            if (attempts == 1) {
                                RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
                            }
                            rs = transaction.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);
                            try {
                                if (this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next()) != null) break block31;
                                break;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        manager.commit();
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Test
    public void transactionManagerReadUsingIndexInvalidatedDuringTransaction() throws InterruptedException {
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                int attempts = 0;
                TransactionContext transaction = manager.begin();
                while (true) {
                    ++attempts;
                    try {
                        block31: {
                            try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                                while (rs.next()) {
                                }
                            }
                            if (attempts == 1) {
                                RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
                            }
                            rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);
                            try {
                                if (this.assertThrowsSessionNotFoundIfShouldFail(() -> rs.next()) != null) break block31;
                                break;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        manager.commit();
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Test
    public void transactionManagerReadRowInvalidatedDuringTransaction() throws InterruptedException {
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                int attempts = 0;
                TransactionContext transaction = manager.begin();
                while (true) {
                    ++attempts;
                    try {
                        TransactionContext context;
                        Struct row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
                        Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
                        if (attempts == 1) {
                            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
                        }
                        if (this.assertThrowsSessionNotFoundIfShouldFail(() -> RetryOnInvalidatedSessionTest.lambda$transactionManagerReadRowInvalidatedDuringTransaction$80(context = transaction)) == null) {
                        } else {
                            manager.commit();
                        }
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Test
    public void transactionManagerReadRowUsingIndexInvalidatedDuringTransaction() throws InterruptedException {
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                int attempts = 0;
                TransactionContext transaction = manager.begin();
                while (true) {
                    ++attempts;
                    try {
                        TransactionContext context;
                        Struct row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
                        Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
                        if (attempts == 1) {
                            RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
                        }
                        if (this.assertThrowsSessionNotFoundIfShouldFail(() -> RetryOnInvalidatedSessionTest.lambda$transactionManagerReadRowUsingIndexInvalidatedDuringTransaction$81(context = transaction)) == null) {
                        } else {
                            manager.commit();
                        }
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Test
    public void partitionedDml() throws InterruptedException {
        this.assertThrowsSessionNotFoundIfShouldFail(() -> client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
    }

    @Test
    public void write() throws InterruptedException {
        this.assertThrowsSessionNotFoundIfShouldFail(() -> client.write(Collections.singletonList(Mutation.delete((String)"FOO", (KeySet)KeySet.all()))));
    }

    @Test
    public void writeAtLeastOnce() throws InterruptedException {
        this.assertThrowsSessionNotFoundIfShouldFail(() -> client.writeAtLeastOnce(Collections.singletonList(Mutation.delete((String)"FOO", (KeySet)KeySet.all()))));
    }

    @Test
    public void asyncRunnerSelect() throws InterruptedException {
        this.asyncRunner_withReadFunction((Function<TransactionContext, AsyncResultSet>)((Function)input -> input.executeQueryAsync(SELECT1AND2, new Options.QueryOption[0])));
    }

    @Test
    public void asyncRunnerRead() throws InterruptedException {
        this.asyncRunner_withReadFunction((Function<TransactionContext, AsyncResultSet>)((Function)input -> input.readAsync("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0])));
    }

    @Test
    public void asyncRunnerReadUsingIndex() throws InterruptedException {
        this.asyncRunner_withReadFunction((Function<TransactionContext, AsyncResultSet>)((Function)input -> input.readUsingIndexAsync("FOO", "IDX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncRunner_withReadFunction(Function<TransactionContext, AsyncResultSet> readFunction) throws InterruptedException {
        ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
        try {
            AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
            AtomicLong counter = new AtomicLong();
            this.assertThrowsSessionNotFoundIfShouldFail(() -> (Long)SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
                AsyncResultSet rs = (AsyncResultSet)readFunction.apply((Object)txn);
                ApiFuture fut = rs.setCallback((Executor)queryExecutor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case OK: {
                                counter.incrementAndGet();
                                break;
                            }
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                    }
                });
                return ApiFutures.transform((ApiFuture)fut, input -> counter.get(), (Executor)MoreExecutors.directExecutor());
            }, (Executor)executor)));
        }
        finally {
            queryExecutor.shutdown();
        }
    }

    @Test
    public void asyncRunnerReadRow() throws InterruptedException {
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> (Struct)SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> txn.readRowAsync("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR")), (Executor)executor)));
    }

    @Test
    public void asyncRunnerReadRowUsingIndex() throws InterruptedException {
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> (Struct)SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> txn.readRowUsingIndexAsync("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR")), (Executor)executor)));
    }

    @Test
    public void asyncRunnerUpdate() throws InterruptedException {
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> (Long)SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> txn.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]), (Executor)executor)));
    }

    @Test
    public void asyncRunnerBatchUpdate() throws InterruptedException {
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> (long[])SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> txn.batchUpdateAsync(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]), (Executor)executor)));
    }

    @Test
    public void asyncRunnerBuffer() throws InterruptedException {
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        this.assertThrowsSessionNotFoundIfShouldFail(() -> SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("BAR").to(1L)).build());
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor)));
    }

    @Test
    public void asyncTransactionManagerAsyncSelect() throws InterruptedException {
        this.asyncTransactionManager_readAsync((Function<TransactionContext, AsyncResultSet>)((Function)input -> input.executeQueryAsync(SELECT1AND2, new Options.QueryOption[0])));
    }

    @Test
    public void asyncTransactionManagerAsyncRead() throws InterruptedException {
        this.asyncTransactionManager_readAsync((Function<TransactionContext, AsyncResultSet>)((Function)input -> input.readAsync("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0])));
    }

    @Test
    public void asyncTransactionManagerAsyncReadUsingIndex() throws InterruptedException {
        this.asyncTransactionManager_readAsync((Function<TransactionContext, AsyncResultSet>)((Function)input -> input.readUsingIndexAsync("FOO", "idx", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncTransactionManager_readAsync(Function<TransactionContext, AsyncResultSet> fn) throws InterruptedException {
        ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture context = manager.beginAsync();
            while (true) {
                try {
                    AtomicLong counter = new AtomicLong();
                    AsyncTransactionManager.AsyncTransactionStep count = context.then((transaction, ignored) -> {
                        AsyncResultSet rs = (AsyncResultSet)fn.apply((Object)transaction);
                        ApiFuture fut = rs.setCallback((Executor)queryExecutor, resultSet -> {
                            while (true) {
                                switch (resultSet.tryNext()) {
                                    case OK: {
                                        counter.incrementAndGet();
                                        break;
                                    }
                                    case DONE: {
                                        return AsyncResultSet.CallbackResponse.DONE;
                                    }
                                    case NOT_READY: {
                                        return AsyncResultSet.CallbackResponse.CONTINUE;
                                    }
                                }
                            }
                        });
                        return ApiFutures.transform((ApiFuture)fut, input -> counter.get(), (Executor)MoreExecutors.directExecutor());
                    }, (Executor)executor);
                    AsyncTransactionManager.CommitTimestampFuture ts = count.commitAsync();
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> (Timestamp)SpannerApiFutures.get((ApiFuture)ts));
                }
                catch (AbortedException e) {
                    context = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        finally {
            queryExecutor.shutdown();
        }
    }

    @Test
    public void asyncTransactionManagerSelect() throws InterruptedException {
        this.asyncTransactionManager_readSync((Function<TransactionContext, ResultSet>)((Function)input -> input.executeQuery(SELECT1AND2, new Options.QueryOption[0])));
    }

    @Test
    public void asyncTransactionManagerRead() throws InterruptedException {
        this.asyncTransactionManager_readSync((Function<TransactionContext, ResultSet>)((Function)input -> input.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0])));
    }

    @Test
    public void asyncTransactionManagerReadUsingIndex() throws InterruptedException {
        this.asyncTransactionManager_readSync((Function<TransactionContext, ResultSet>)((Function)input -> input.readUsingIndex("FOO", "idx", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncTransactionManager_readSync(Function<TransactionContext, ResultSet> fn) throws InterruptedException {
        ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture context = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep count = context.then((transaction, ignored) -> {
                        long counter = 0L;
                        try (ResultSet rs = (ResultSet)fn.apply((Object)transaction);){
                            while (rs.next()) {
                                ++counter;
                            }
                        }
                        return ApiFutures.immediateFuture((Object)counter);
                    }, (Executor)executor);
                    AsyncTransactionManager.CommitTimestampFuture ts = count.commitAsync();
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> (Timestamp)SpannerApiFutures.get((ApiFuture)ts));
                }
                catch (AbortedException e) {
                    context = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        finally {
            queryExecutor.shutdown();
        }
    }

    @Test
    public void asyncTransactionManagerReadRow() throws InterruptedException {
        this.asyncTransactionManager_readRowFunction((Function<TransactionContext, ApiFuture<Struct>>)((Function)input -> ApiFutures.immediateFuture((Object)input.readRow("FOO", Key.of((Object[])new Object[]{"foo"}), Collections.singletonList("BAR")))));
    }

    @Test
    public void asyncTransactionManagerReadRowUsingIndex() throws InterruptedException {
        this.asyncTransactionManager_readRowFunction((Function<TransactionContext, ApiFuture<Struct>>)((Function)input -> ApiFutures.immediateFuture((Object)input.readRowUsingIndex("FOO", "idx", Key.of((Object[])new Object[]{"foo"}), Collections.singletonList("BAR")))));
    }

    @Test
    public void asyncTransactionManagerReadRowAsync() throws InterruptedException {
        this.asyncTransactionManager_readRowFunction((Function<TransactionContext, ApiFuture<Struct>>)((Function)input -> input.readRowAsync("FOO", Key.of((Object[])new Object[]{"foo"}), Collections.singletonList("BAR"))));
    }

    @Test
    public void asyncTransactionManagerReadRowUsingIndexAsync() throws InterruptedException {
        this.asyncTransactionManager_readRowFunction((Function<TransactionContext, ApiFuture<Struct>>)((Function)input -> input.readRowUsingIndexAsync("FOO", "idx", Key.of((Object[])new Object[]{"foo"}), Collections.singletonList("BAR"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncTransactionManager_readRowFunction(Function<TransactionContext, ApiFuture<Struct>> fn) throws InterruptedException {
        ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture context = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep row = context.then((transaction, ignored) -> (ApiFuture)fn.apply((Object)transaction), (Executor)executor);
                    AsyncTransactionManager.CommitTimestampFuture ts = row.commitAsync();
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> (Timestamp)SpannerApiFutures.get((ApiFuture)ts));
                }
                catch (AbortedException e) {
                    context = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        finally {
            queryExecutor.shutdown();
        }
    }

    @Test
    public void asyncTransactionManagerUpdateAsync() throws InterruptedException {
        this.asyncTransactionManager_updateFunction(input -> input.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]), 1L);
    }

    @Test
    public void asyncTransactionManagerUpdate() throws InterruptedException {
        this.asyncTransactionManager_updateFunction(input -> ApiFutures.immediateFuture((Object)input.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])), 1L);
    }

    @Test
    public void asyncTransactionManagerBatchUpdateAsync() throws InterruptedException {
        this.asyncTransactionManager_updateFunction(input -> input.batchUpdateAsync(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]), new long[]{1L, 1L});
    }

    @Test
    public void asyncTransactionManagerBatchUpdate() throws InterruptedException {
        this.asyncTransactionManager_updateFunction(input -> ApiFutures.immediateFuture((Object)input.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0])), new long[]{1L, 1L});
    }

    private <T> void asyncTransactionManager_updateFunction(Function<TransactionContext, ApiFuture<T>> fn, T expected) throws InterruptedException {
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep res = transaction.then((txn, input) -> (ApiFuture)fn.apply((Object)txn), (Executor)executor);
                    AsyncTransactionManager.CommitTimestampFuture ts = res.commitAsync();
                    this.assertThrowsSessionNotFoundIfShouldFail(() -> (Timestamp)SpannerApiFutures.get((ApiFuture)ts));
                }
                catch (AbortedException e) {
                    transaction = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    private static /* synthetic */ Struct lambda$transactionManagerReadRowUsingIndexInvalidatedDuringTransaction$81(TransactionContext context) {
        return context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ Struct lambda$transactionManagerReadRowInvalidatedDuringTransaction$80(TransactionContext context) {
        return context.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ void lambda$readOnlyTransactionReadRowUsingIndexNonRecoverable$26(ReadContext context) throws Throwable {
        context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ Struct lambda$readOnlyTransactionReadRowUsingIndexNonRecoverable$25(ReadContext context) {
        return context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ void lambda$readOnlyTransactionReadRowNonRecoverable$24(ReadContext context) throws Throwable {
        context.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ Struct lambda$readOnlyTransactionReadRowNonRecoverable$23(ReadContext context) {
        return context.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ Struct lambda$readOnlyTransactionReadRowUsingIndex$16(ReadContext context) {
        return context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ Struct lambda$readOnlyTransactionReadRow$15(ReadContext context) {
        return context.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ Struct lambda$singleUseReadOnlyTransactionReadRowUsingIndex$11(ReadContext context) {
        return context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static /* synthetic */ Struct lambda$singleUseReadOnlyTransactionReadRow$10(ReadContext context) {
        return context.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
    }

    private static final class ToLongTransformer
    implements Function<StructReader, Long> {
        private ToLongTransformer() {
        }

        public Long apply(StructReader input) {
            return input.getLong(0);
        }
    }
}

