/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SingerProto;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AllTypesMockServerTest
extends AbstractMockServerTest {
    @Parameterized.Parameter
    public Dialect dialect;
    private Dialect currentDialect;
    public static final Statement SELECT_STATEMENT = Statement.of((String)"select * from all_types");
    public static final boolean BOOL_VALUE = true;
    public static final long INT64_VALUE = 1L;
    public static final float FLOAT32_VALUE = 3.14f;
    public static final double FLOAT64_VALUE = 3.14;
    public static final BigDecimal NUMERIC_VALUE = new BigDecimal("3.14");
    public static final String PG_NUMERIC_VALUE = "3.14";
    public static final String STRING_VALUE = "test-string";
    public static final String JSON_VALUE = "{\"key1\":\"value1\", \"key2\":\"value2\"}";
    public static final long PG_OID_VALUE = 1L;
    public static final byte[] BYTES_VALUE = "test-bytes".getBytes(StandardCharsets.UTF_8);
    public static final Date DATE_VALUE = Date.fromYearMonthDay((int)2024, (int)3, (int)2);
    public static final Timestamp TIMESTAMP_VALUE = Timestamp.parseTimestamp((String)"2024-03-02T07:07:00.20982735Z");
    public static final List<Boolean> BOOL_ARRAY_VALUE = Arrays.asList(true, null, false);
    public static final List<Long> INT64_ARRAY_VALUE = Arrays.asList(100L, null, 200L, Long.MIN_VALUE, Long.MAX_VALUE);
    public static final List<Float> FLOAT32_ARRAY_VALUE = Arrays.asList(Float.valueOf(-3.14f), null, Float.valueOf(6.626f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_NORMAL), Float.valueOf(Float.NaN));
    public static final List<Double> FLOAT64_ARRAY_VALUE = Arrays.asList(-3.14, null, 6.626, Double.MIN_VALUE, Double.MAX_VALUE, Double.MIN_NORMAL, Double.NaN);
    public static final List<BigDecimal> NUMERIC_ARRAY_VALUE = Arrays.asList(new BigDecimal("-3.14"), null, new BigDecimal("99.99"), BigDecimal.ZERO, new BigDecimal("1e-9"), new BigDecimal("-9.9999999999999999999999999999999999999E+28"), new BigDecimal("9.9999999999999999999999999999999999999E+28"));
    public static final List<String> PG_NUMERIC_ARRAY_VALUE = Arrays.asList("-3.14", null, "99.99", "NaN", "1e-9", "-9.9999999999999999999999999999999999999E+28", "9.9999999999999999999999999999999999999E+28");
    public static final List<String> STRING_ARRAY_VALUE = Arrays.asList("test-string1", null, "test-string2");
    public static final List<String> JSON_ARRAY_VALUE = Arrays.asList("{\"key1\":\"value1.1\", \"key2\":\"value1.2\"}", null, "{\"key1\":\"value3.1\", \"key2\":\"value3.2\"}");
    public static final List<Long> PG_OID_ARRAY_VALUE = Arrays.asList(100L, null, 200L, Long.MIN_VALUE, Long.MAX_VALUE);
    public static final List<ByteArray> BYTES_ARRAY_VALUE = Arrays.asList(ByteArray.copyFrom((String)"test-bytes1"), null, ByteArray.copyFrom((String)"test-bytes2"));
    public static final List<Date> DATE_ARRAY_VALUE = Arrays.asList(Date.fromYearMonthDay((int)2024, (int)3, (int)1), null, Date.fromYearMonthDay((int)2024, (int)3, (int)3), Date.fromYearMonthDay((int)1, (int)1, (int)1), Date.fromYearMonthDay((int)9999, (int)12, (int)31));
    public static final List<Timestamp> TIMESTAMP_ARRAY_VALUE = Arrays.asList(Timestamp.parseTimestamp((String)"2024-03-01T07:07:00.20982735Z"), null, Timestamp.parseTimestamp((String)"2024-03-03T07:07:00Z"), Timestamp.MIN_VALUE, Timestamp.MAX_VALUE);

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @Before
    public void setupDialect() {
        if (this.currentDialect != this.dialect) {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
            this.setupAllTypesResultSet(this.dialect);
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(AllTypesMockServerTest.createInsertStatement(this.dialect), 1L));
            SpannerPool.closeSpannerPool();
            this.currentDialect = this.dialect;
        }
    }

    private void setupAllTypesResultSet(Dialect dialect) {
        ListValue.Builder row1Builder = ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setBoolValue(true)).addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(1L)).build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue((double)3.14f)).addValues(com.google.protobuf.Value.newBuilder().setNumberValue(3.14)).addValues(com.google.protobuf.Value.newBuilder().setStringValue(dialect == Dialect.POSTGRESQL ? PG_NUMERIC_VALUE : NUMERIC_VALUE.toEngineeringString())).addValues(com.google.protobuf.Value.newBuilder().setStringValue(STRING_VALUE)).addValues(com.google.protobuf.Value.newBuilder().setStringValue(JSON_VALUE)).addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString(BYTES_VALUE))).addValues(com.google.protobuf.Value.newBuilder().setStringValue(DATE_VALUE.toString())).addValues(com.google.protobuf.Value.newBuilder().setStringValue(TIMESTAMP_VALUE.toString()));
        if (dialect == Dialect.POSTGRESQL) {
            row1Builder.addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(1L)).build());
        }
        row1Builder.addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)BOOL_ARRAY_VALUE.stream().map(b -> b == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setBoolValue(b.booleanValue()).build()).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)INT64_ARRAY_VALUE.stream().map(l -> l == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(l)).build()).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)FLOAT32_ARRAY_VALUE.stream().map(f -> {
            if (f == null) {
                return com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
            }
            if (Float.isNaN(f.floatValue())) {
                return com.google.protobuf.Value.newBuilder().setStringValue("NaN").build();
            }
            return com.google.protobuf.Value.newBuilder().setNumberValue((double)f.floatValue()).build();
        }).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)FLOAT64_ARRAY_VALUE.stream().map(d -> {
            if (d == null) {
                return com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
            }
            if (Double.isNaN(d)) {
                return com.google.protobuf.Value.newBuilder().setStringValue("NaN").build();
            }
            return com.google.protobuf.Value.newBuilder().setNumberValue(d.doubleValue()).build();
        }).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(dialect == Dialect.POSTGRESQL ? (Iterable)PG_NUMERIC_ARRAY_VALUE.stream().map(string -> string == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(string).build()).collect(Collectors.toList()) : (Iterable)NUMERIC_ARRAY_VALUE.stream().map(bigDecimal -> bigDecimal == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(bigDecimal.toEngineeringString()).build()).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)STRING_ARRAY_VALUE.stream().map(string -> string == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(string).build()).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)JSON_ARRAY_VALUE.stream().map(json -> json == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(json).build()).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)BYTES_ARRAY_VALUE.stream().map(byteArray -> byteArray == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString(byteArray.toByteArray())).build()).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)DATE_ARRAY_VALUE.stream().map(date -> date == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(date.toString()).build()).collect(Collectors.toList())).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)TIMESTAMP_ARRAY_VALUE.stream().map(timestamp -> timestamp == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(timestamp.toString()).build()).collect(Collectors.toList())).build()));
        if (dialect == Dialect.GOOGLE_STANDARD_SQL) {
            row1Builder.addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString(SingerProto.SingerInfo.newBuilder().setSingerId(1L).setNationality("unknown").setBirthDate("1986-09-30").setGenre(SingerProto.Genre.POP).build().toByteArray())).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(1)).build()).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString(SingerProto.SingerInfo.newBuilder().setSingerId(1L).setGenre(SingerProto.Genre.FOLK).setBirthDate("200-01-01").setNationality("no").build().toByteArray())).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE)).addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString(SingerProto.SingerInfo.newBuilder().setSingerId(2L).setGenre(SingerProto.Genre.JAZZ).setBirthDate("200-01-02").setNationality("dk").build().toByteArray())).build()).build()).build()).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(3)).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE)).addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(3)).build()).build()).build());
        }
        if (dialect == Dialect.POSTGRESQL) {
            row1Builder.addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)PG_OID_ARRAY_VALUE.stream().map(l -> l == null ? com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(l)).build()).collect(Collectors.toList())).build()));
        }
        com.google.spanner.v1.ResultSet resultSet = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(RandomResultSetGenerator.generateAllTypesMetadata(RandomResultSetGenerator.generateAllTypes(dialect))).addRows(row1Builder.build()).build();
        mockSpanner.putStatementResults(MockSpannerServiceImpl.StatementResult.query(SELECT_STATEMENT, resultSet));
    }

    public static Statement createInsertStatement(Dialect dialect) {
        Statement.Builder builder = Statement.newBuilder((String)"insert into all_types (");
        builder.append(IntStream.rangeClosed(1, RandomResultSetGenerator.generateAllTypes(dialect).length).mapToObj(col -> "COL" + col).collect(Collectors.joining(", ", "", ") values (")));
        builder.append(IntStream.rangeClosed(1, RandomResultSetGenerator.generateAllTypes(dialect).length).mapToObj(col -> "@p" + col).collect(Collectors.joining(", ", "", ")")));
        int param = 0;
        ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)builder.bind("p" + ++param).to(true)).bind("p" + ++param).to(1L)).bind("p" + ++param).to(3.14f)).bind("p" + ++param).to(3.14)).bind("p" + ++param).to(dialect == Dialect.POSTGRESQL ? Value.pgNumeric((String)PG_NUMERIC_VALUE) : Value.numeric((BigDecimal)NUMERIC_VALUE))).bind("p" + ++param).to(STRING_VALUE)).bind("p" + ++param).to(dialect == Dialect.POSTGRESQL ? Value.pgJsonb((String)JSON_VALUE) : Value.json((String)JSON_VALUE))).bind("p" + ++param).to(ByteArray.copyFrom((byte[])BYTES_VALUE))).bind("p" + ++param).to(DATE_VALUE)).bind("p" + ++param).to(TIMESTAMP_VALUE);
        if (dialect == Dialect.POSTGRESQL) {
            builder.bind("p" + ++param).to(1L);
        }
        ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)builder.bind("p" + ++param).toBoolArray(BOOL_ARRAY_VALUE)).bind("p" + ++param).toInt64Array(INT64_ARRAY_VALUE)).bind("p" + ++param).toFloat32Array(FLOAT32_ARRAY_VALUE)).bind("p" + ++param).toFloat64Array(FLOAT64_ARRAY_VALUE)).bind("p" + ++param).to(dialect == Dialect.POSTGRESQL ? Value.pgNumericArray(PG_NUMERIC_ARRAY_VALUE) : Value.numericArray(NUMERIC_ARRAY_VALUE))).bind("p" + ++param).toStringArray(STRING_ARRAY_VALUE)).bind("p" + ++param).to(dialect == Dialect.POSTGRESQL ? Value.pgJsonbArray(JSON_ARRAY_VALUE) : Value.jsonArray(JSON_ARRAY_VALUE))).bind("p" + ++param).toBytesArray(BYTES_ARRAY_VALUE)).bind("p" + ++param).toDateArray(DATE_ARRAY_VALUE)).bind("p" + ++param).toTimestampArray(TIMESTAMP_ARRAY_VALUE);
        if (dialect == Dialect.POSTGRESQL) {
            builder.bind("p" + ++param).toInt64Array(PG_OID_ARRAY_VALUE);
        }
        return builder.build();
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testSelectAllTypes() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
             ResultSet resultSet = connection.executeQuery(SELECT_STATEMENT, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            int col = -1;
            Assert.assertEquals((Object)true, (Object)resultSet.getBoolean(++col));
            Assert.assertEquals((long)1L, (long)resultSet.getLong(++col));
            Assert.assertEquals((float)3.14f, (float)resultSet.getFloat(++col), (float)0.0f);
            Assert.assertEquals((double)3.14, (double)resultSet.getDouble(++col), (double)0.0);
            if (this.dialect == Dialect.POSTGRESQL) {
                Assert.assertEquals((Object)PG_NUMERIC_VALUE, (Object)resultSet.getString(++col));
            } else {
                Assert.assertEquals((Object)NUMERIC_VALUE, (Object)resultSet.getBigDecimal(++col));
            }
            Assert.assertEquals((Object)STRING_VALUE, (Object)resultSet.getString(++col));
            Assert.assertEquals((Object)JSON_VALUE, (Object)(this.dialect == Dialect.POSTGRESQL ? resultSet.getPgJsonb(++col) : resultSet.getJson(++col)));
            Assert.assertArrayEquals((byte[])BYTES_VALUE, (byte[])resultSet.getBytes(++col).toByteArray());
            Assert.assertEquals((Object)DATE_VALUE, (Object)resultSet.getDate(++col));
            Assert.assertEquals((Object)TIMESTAMP_VALUE, (Object)resultSet.getTimestamp(++col));
            if (this.dialect == Dialect.POSTGRESQL) {
                Assert.assertEquals((long)1L, (long)resultSet.getLong(++col));
            }
            Assert.assertEquals(BOOL_ARRAY_VALUE, (Object)resultSet.getBooleanList(++col));
            Assert.assertEquals(INT64_ARRAY_VALUE, (Object)resultSet.getLongList(++col));
            Assert.assertEquals(FLOAT32_ARRAY_VALUE, (Object)resultSet.getFloatList(++col));
            Assert.assertEquals(FLOAT64_ARRAY_VALUE, (Object)resultSet.getDoubleList(++col));
            if (this.dialect == Dialect.POSTGRESQL) {
                Assert.assertEquals(PG_NUMERIC_ARRAY_VALUE, (Object)resultSet.getStringList(++col));
            } else {
                Assert.assertEquals(NUMERIC_ARRAY_VALUE, (Object)resultSet.getBigDecimalList(++col));
            }
            Assert.assertEquals(STRING_ARRAY_VALUE, (Object)resultSet.getStringList(++col));
            Assert.assertEquals(JSON_ARRAY_VALUE, (Object)(this.dialect == Dialect.POSTGRESQL ? resultSet.getPgJsonbList(++col) : resultSet.getJsonList(++col)));
            Assert.assertEquals(BYTES_ARRAY_VALUE, (Object)resultSet.getBytesList(++col));
            Assert.assertEquals(DATE_ARRAY_VALUE, (Object)resultSet.getDateList(++col));
            Assert.assertEquals(TIMESTAMP_ARRAY_VALUE, (Object)resultSet.getTimestampList(++col));
            if (this.dialect == Dialect.POSTGRESQL) {
                Assert.assertEquals(PG_OID_ARRAY_VALUE, (Object)resultSet.getLongList(++col));
            }
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testInsertAllTypes() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            int col;
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(AllTypesMockServerTest.createInsertStatement(this.dialect)));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Map paramTypes = request.getParamTypesMap();
            Map params = request.getParams().getFieldsMap();
            Assert.assertEquals((long)(this.dialect == Dialect.POSTGRESQL ? 22L : 20L), (long)paramTypes.size());
            Assert.assertEquals((long)(this.dialect == Dialect.POSTGRESQL ? 22L : 20L), (long)params.size());
            ImmutableList expectedTypes = this.dialect == Dialect.POSTGRESQL ? ImmutableList.of((Object)TypeCode.BOOL, (Object)TypeCode.INT64, (Object)TypeCode.FLOAT32, (Object)TypeCode.FLOAT64, (Object)TypeCode.NUMERIC, (Object)TypeCode.STRING, (Object)TypeCode.JSON, (Object)TypeCode.BYTES, (Object)TypeCode.DATE, (Object)TypeCode.TIMESTAMP, (Object)TypeCode.INT64) : ImmutableList.of((Object)TypeCode.BOOL, (Object)TypeCode.INT64, (Object)TypeCode.FLOAT32, (Object)TypeCode.FLOAT64, (Object)TypeCode.NUMERIC, (Object)TypeCode.STRING, (Object)TypeCode.JSON, (Object)TypeCode.BYTES, (Object)TypeCode.DATE, (Object)TypeCode.TIMESTAMP);
            for (col = 0; col < expectedTypes.size(); ++col) {
                Assert.assertEquals((Object)expectedTypes.get(col), (Object)((Type)paramTypes.get("p" + (col + 1))).getCode());
                int arrayCol = col + expectedTypes.size();
                Assert.assertEquals((Object)TypeCode.ARRAY, (Object)((Type)paramTypes.get("p" + (arrayCol + 1))).getCode());
                Assert.assertEquals((Object)expectedTypes.get(col), (Object)((Type)paramTypes.get("p" + (arrayCol + 1))).getArrayElementType().getCode());
            }
            col = 0;
            Assert.assertEquals((Object)true, (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getBoolValue());
            Assert.assertEquals((Object)String.valueOf(1L), (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getStringValue());
            Assert.assertEquals((double)3.14f, (double)((com.google.protobuf.Value)params.get("p" + ++col)).getNumberValue(), (double)0.0);
            Assert.assertEquals((double)3.14, (double)((com.google.protobuf.Value)params.get("p" + ++col)).getNumberValue(), (double)0.0);
            Assert.assertEquals((Object)(this.dialect == Dialect.POSTGRESQL ? PG_NUMERIC_VALUE : NUMERIC_VALUE.toEngineeringString()), (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getStringValue());
            Assert.assertEquals((Object)STRING_VALUE, (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getStringValue());
            Assert.assertEquals((Object)JSON_VALUE, (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getStringValue());
            Assert.assertEquals((Object)Base64.getEncoder().encodeToString(BYTES_VALUE), (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getStringValue());
            Assert.assertEquals((Object)DATE_VALUE.toString(), (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getStringValue());
            Assert.assertEquals((Object)TIMESTAMP_VALUE.toString(), (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getStringValue());
            if (this.dialect == Dialect.POSTGRESQL) {
                Assert.assertEquals((Object)String.valueOf(1L), (Object)((com.google.protobuf.Value)params.get("p" + ++col)).getStringValue());
            }
            Assert.assertEquals(BOOL_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : Boolean.valueOf(value.getBoolValue())).collect(Collectors.toList()));
            Assert.assertEquals(INT64_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : Long.valueOf(value.getStringValue())).collect(Collectors.toList()));
            Assert.assertEquals(FLOAT32_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : Float.valueOf((float)value.getNumberValue())).collect(Collectors.toList()));
            Assert.assertEquals(FLOAT64_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : Double.valueOf(value.getNumberValue())).collect(Collectors.toList()));
            if (this.dialect == Dialect.POSTGRESQL) {
                Assert.assertEquals(PG_NUMERIC_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : value.getStringValue()).collect(Collectors.toList()));
            } else {
                Assert.assertEquals(NUMERIC_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : new BigDecimal(value.getStringValue())).collect(Collectors.toList()));
            }
            Assert.assertEquals(STRING_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : value.getStringValue()).collect(Collectors.toList()));
            Assert.assertEquals(JSON_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : value.getStringValue()).collect(Collectors.toList()));
            Assert.assertEquals(BYTES_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : ByteArray.fromBase64((String)value.getStringValue())).collect(Collectors.toList()));
            Assert.assertEquals(DATE_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : Date.parseDate((String)value.getStringValue())).collect(Collectors.toList()));
            Assert.assertEquals(TIMESTAMP_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : Timestamp.parseTimestamp((String)value.getStringValue())).collect(Collectors.toList()));
            if (this.dialect == Dialect.POSTGRESQL) {
                Assert.assertEquals(PG_OID_ARRAY_VALUE, ((com.google.protobuf.Value)params.get("p" + ++col)).getListValue().getValuesList().stream().map(value -> value.hasNullValue() ? null : Long.valueOf(value.getStringValue())).collect(Collectors.toList()));
            }
        }
    }
}

