/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.DialectNamespaceMapper;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class ConnectionStatementWithNoParametersTest {
    @Parameterized.Parameter
    public Dialect dialect;
    private AbstractStatementParser parser;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @Before
    public void setup() {
        this.parser = AbstractStatementParser.getInstance((Dialect)this.dialect);
    }

    AbstractStatementParser.ParsedStatement parse(String sql) {
        return this.parser.parse(Statement.of((String)sql));
    }

    @Test
    public void testExecuteGetAutocommit() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable autocommit"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowAutocommit()).thenCallRealMethod();
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).isAutocommit();
    }

    @Test
    public void testExecuteGetReadOnly() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)String.format("show variable %sreadonly", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)connection.getDialect()).thenReturn((Object)this.dialect);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).isReadOnly();
    }

    @Test
    public void testExecuteGetAutocommitDmlMode() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)String.format("show variable %sautocommit_dml_mode", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)connection.getDialect()).thenReturn((Object)this.dialect);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        Mockito.when((Object)connection.getAutocommitDmlMode()).thenReturn((Object)AutocommitDmlMode.TRANSACTIONAL);
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getAutocommitDmlMode();
    }

    @Test
    public void testExecuteGetStatementTimeout() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable statement_timeout"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowStatementTimeout()).thenCallRealMethod();
        Mockito.when((Object)connection.hasStatementTimeout()).thenReturn((Object)true);
        Mockito.when((Object)connection.getStatementTimeout(TimeUnit.NANOSECONDS)).thenReturn((Object)1L);
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)2))).getStatementTimeout(TimeUnit.NANOSECONDS);
    }

    @Test
    public void testExecuteGetReadTimestamp() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)String.format("show variable %sread_timestamp", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)connection.getDialect()).thenReturn((Object)this.dialect);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        Mockito.when((Object)connection.getReadTimestampOrNull()).thenReturn((Object)Timestamp.now());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getReadTimestampOrNull();
    }

    @Test
    public void testExecuteGetCommitTimestamp() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)String.format("show variable %scommit_timestamp", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)connection.getDialect()).thenReturn((Object)this.dialect);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        Mockito.when((Object)connection.getCommitTimestampOrNull()).thenReturn((Object)Timestamp.now());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getCommitTimestampOrNull();
    }

    @Test
    public void testExecuteGetReadOnlyStaleness() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)String.format("show variable %sread_only_staleness", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)connection.getDialect()).thenReturn((Object)this.dialect);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        Mockito.when((Object)connection.getReadOnlyStaleness()).thenReturn((Object)TimestampBound.strong());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getReadOnlyStaleness();
    }

    @Test
    public void testExecuteGetOptimizerVersion() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)String.format("show variable %soptimizer_version", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)connection.getDialect()).thenReturn((Object)this.dialect);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        Mockito.when((Object)connection.getOptimizerVersion()).thenReturn((Object)"1");
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getOptimizerVersion();
    }

    @Test
    public void testExecuteGetOptimizerStatisticsPackage() {
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)String.format("show variable %soptimizer_statistics_package", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)connection.getDialect()).thenReturn((Object)this.dialect);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        Mockito.when((Object)connection.getOptimizerStatisticsPackage()).thenReturn((Object)"custom-package");
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getOptimizerStatisticsPackage();
    }

    @Test
    public void testExecuteBegin() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"begin"));
        for (String statement : subject.getClientSideStatement().getExampleStatements()) {
            ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
            ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, this.parse(statement));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).beginTransaction();
        }
    }

    @Test
    public void testExecuteCommit() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"commit"));
        for (String statement : subject.getClientSideStatement().getExampleStatements()) {
            ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
            ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
            Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
            Mockito.when((Object)executor.statementCommit()).thenCallRealMethod();
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, this.parse(statement));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).commit();
        }
    }

    @Test
    public void testExecuteRollback() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"rollback"));
        for (String statement : subject.getClientSideStatement().getExampleStatements()) {
            ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
            ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
            Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
            Mockito.when((Object)executor.statementRollback()).thenCallRealMethod();
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, this.parse(statement));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).rollback();
        }
    }
}

